/* This file generated from tools/Generate-Collation-Data.raku */
struct collation_key {
    MVMuint32 primary :16;
    MVMuint32 tertiary :5;
    MVMuint32 special :1;
    MVMuint32 secondary :9;
};
struct sub_node {
    MVMuint32 codepoint :18;
    MVMuint32 collation_key_link :14;
    MVMuint32 sub_node_link :13;
    MVMuint32 sub_node_elems :13;
    MVMuint32 collation_key_elems :5;
};
typedef struct sub_node sub_node;
#define main_nodes_elems 4849
#define starter_main_nodes_elems 3885
#define codepoint_sequence_no_max 3
#define special_collation_keys_elems 10751
/* Data from PropList.txt */
MVM_STATIC_INLINE MVMuint32 is_unified_ideograph (MVMCodepoint cp) {
    return
       (0x3400  <= cp && cp <= 0x4DBF ) /* 3400..4DBF Unified_Ideograph # Lo [6592] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DBF */
    || (0x4E00  <= cp && cp <= 0x9FFF ) /* 4E00..9FFF Unified_Ideograph # Lo [20992] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FFF */
    || (0xFA0E  <= cp && cp <= 0xFA0F ) /* FA0E..FA0F Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA0E..CJK COMPATIBILITY IDEOGRAPH-FA0F */
    || (0xFA11                   == cp) /* FA11..FA11 Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA11 */
    || (0xFA13  <= cp && cp <= 0xFA14 ) /* FA13..FA14 Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA13..CJK COMPATIBILITY IDEOGRAPH-FA14 */
    || (0xFA1F                   == cp) /* FA1F..FA1F Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA1F */
    || (0xFA21                   == cp) /* FA21..FA21 Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA21 */
    || (0xFA23  <= cp && cp <= 0xFA24 ) /* FA23..FA24 Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA23..CJK COMPATIBILITY IDEOGRAPH-FA24 */
    || (0xFA27  <= cp && cp <= 0xFA29 ) /* FA27..FA29 Unified_Ideograph # Lo   [3] CJK COMPATIBILITY IDEOGRAPH-FA27..CJK COMPATIBILITY IDEOGRAPH-FA29 */
    || (0x20000 <= cp && cp <= 0x2A6DF) /* 20000..2A6DF Unified_Ideograph # Lo [42720] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6DF */
    || (0x2A700 <= cp && cp <= 0x2B81D) /* 2A700..2B81D Unified_Ideograph # Lo [4382] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B81D */
    || (0x2B820 <= cp && cp <= 0x2CEAD) /* 2B820..2CEAD Unified_Ideograph # Lo [5774] CJK UNIFIED IDEOGRAPH-2B820..CJK UNIFIED IDEOGRAPH-2CEAD */
    || (0x2CEB0 <= cp && cp <= 0x2EBE0) /* 2CEB0..2EBE0 Unified_Ideograph # Lo [7473] CJK UNIFIED IDEOGRAPH-2CEB0..CJK UNIFIED IDEOGRAPH-2EBE0 */
    || (0x2EBF0 <= cp && cp <= 0x2EE5D) /* 2EBF0..2EE5D Unified_Ideograph # Lo [622] CJK UNIFIED IDEOGRAPH-2EBF0..CJK UNIFIED IDEOGRAPH-2EE5D */
    || (0x30000 <= cp && cp <= 0x3134A) /* 30000..3134A Unified_Ideograph # Lo [4939] CJK UNIFIED IDEOGRAPH-30000..CJK UNIFIED IDEOGRAPH-3134A */
    || (0x31350 <= cp && cp <= 0x33479) /* 31350..33479 Unified_Ideograph # Lo [8490] CJK UNIFIED IDEOGRAPH-31350..CJK UNIFIED IDEOGRAPH-33479 */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Assigned_Block_Nushu (MVMCodepoint cp) {
    return
       (0x1B170 <= cp && cp <= 0x1B2FF) /* 1B170..1B2FF Nushu                              */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Block_Tangut (MVMCodepoint cp) {
    return
       (0x17000 <= cp && cp <= 0x187FF) /* 17000..187FF Tangut                             */
    || (0x18800 <= cp && cp <= 0x18AFF) /* 18800..18AFF Tangut Components                  */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Block_CJK_Unified_Ideographs_OR_CJK_Compatibility_Ideographs (MVMCodepoint cp) {
    return
       (0x4E00  <= cp && cp <= 0x9FFF ) /* 4E00..9FFF CJK Unified Ideographs             */
    || (0xF900  <= cp && cp <= 0xFAFF ) /* F900..FAFF CJK Compatibility Ideographs       */
    ;
}

sub_node main_nodes[4849] = {
{76,0,3885,1,0},{108,0,3886,1,0},{188,4,0,0,3},{189,7,0,0,3},{190,10,0,0,3},
{192,13,0,0,2},{193,15,0,0,2},{194,17,0,0,2},{195,19,0,0,2},{196,21,0,0,2},{197,
23,0,0,2},{198,25,0,0,3},{199,28,0,0,2},{200,30,0,0,2},{201,32,0,0,2},{202,34,0,
0,2},{203,36,0,0,2},{204,38,0,0,2},{205,40,0,0,2},{206,42,0,0,2},{207,44,0,0,2},
{208,46,0,0,2},{209,48,0,0,2},{210,50,0,0,2},{211,52,0,0,2},{212,54,0,0,2},{213,
56,0,0,2},{214,58,0,0,2},{216,60,0,0,2},{217,62,0,0,2},{218,64,0,0,2},{219,66,0,
0,2},{220,68,0,0,2},{221,70,0,0,2},{223,72,0,0,3},{224,75,0,0,2},{225,77,0,0,2},
{226,79,0,0,2},{227,81,0,0,2},{228,83,0,0,2},{229,85,0,0,2},{230,87,0,0,3},{231,
90,0,0,2},{232,92,0,0,2},{233,94,0,0,2},{234,96,0,0,2},{235,98,0,0,2},{236,100,
0,0,2},{237,102,0,0,2},{238,104,0,0,2},{239,106,0,0,2},{240,108,0,0,2},{241,110,
0,0,2},{242,112,0,0,2},{243,114,0,0,2},{244,116,0,0,2},{245,118,0,0,2},{246,120,
0,0,2},{248,122,0,0,2},{249,124,0,0,2},{250,126,0,0,2},{251,128,0,0,2},{252,130,
0,0,2},{253,132,0,0,2},{255,134,0,0,2},{256,136,0,0,2},{257,138,0,0,2},{258,140,
0,0,2},{259,142,0,0,2},{260,144,0,0,2},{261,146,0,0,2},{262,148,0,0,2},{263,150,
0,0,2},{264,152,0,0,2},{265,154,0,0,2},{266,156,0,0,2},{267,158,0,0,2},{268,160,
0,0,2},{269,162,0,0,2},{270,164,0,0,2},{271,166,0,0,2},{272,168,0,0,2},{273,170,
0,0,2},{274,172,0,0,2},{275,174,0,0,2},{276,176,0,0,2},{277,178,0,0,2},{278,180,
0,0,2},{279,182,0,0,2},{280,184,0,0,2},{281,186,0,0,2},{282,188,0,0,2},{283,190,
0,0,2},{284,192,0,0,2},{285,194,0,0,2},{286,196,0,0,2},{287,198,0,0,2},{288,200,
0,0,2},{289,202,0,0,2},{290,204,0,0,2},{291,206,0,0,2},{292,208,0,0,2},{293,210,
0,0,2},{294,212,0,0,2},{295,214,0,0,2},{296,216,0,0,2},{297,218,0,0,2},{298,220,
0,0,2},{299,222,0,0,2},{300,224,0,0,2},{301,226,0,0,2},{302,228,0,0,2},{303,230,
0,0,2},{304,232,0,0,2},{306,234,0,0,2},{307,236,0,0,2},{308,238,0,0,2},{309,240,
0,0,2},{310,242,0,0,2},{311,244,0,0,2},{313,246,0,0,2},{314,248,0,0,2},{315,250,
0,0,2},{316,252,0,0,2},{317,254,0,0,2},{318,256,0,0,2},{319,258,0,0,2},{320,260,
0,0,2},{321,262,0,0,2},{322,264,0,0,2},{323,266,0,0,2},{324,268,0,0,2},{325,270,
0,0,2},{326,272,0,0,2},{327,274,0,0,2},{328,276,0,0,2},{329,278,0,0,2},{332,280,
0,0,2},{333,282,0,0,2},{334,284,0,0,2},{335,286,0,0,2},{336,288,0,0,2},{337,290,
0,0,2},{338,292,0,0,3},{339,295,0,0,3},{340,298,0,0,2},{341,300,0,0,2},{342,302,
0,0,2},{343,304,0,0,2},{344,306,0,0,2},{345,308,0,0,2},{346,310,0,0,2},{347,312,
0,0,2},{348,314,0,0,2},{349,316,0,0,2},{350,318,0,0,2},{351,320,0,0,2},{352,322,
0,0,2},{353,324,0,0,2},{354,326,0,0,2},{355,328,0,0,2},{356,330,0,0,2},{357,332,
0,0,2},{360,334,0,0,2},{361,336,0,0,2},{362,338,0,0,2},{363,340,0,0,2},{364,342,
0,0,2},{365,344,0,0,2},{366,346,0,0,2},{367,348,0,0,2},{368,350,0,0,2},{369,352,
0,0,2},{370,354,0,0,2},{371,356,0,0,2},{372,358,0,0,2},{373,360,0,0,2},{374,362,
0,0,2},{375,364,0,0,2},{376,366,0,0,2},{377,368,0,0,2},{378,370,0,0,2},{379,372,
0,0,2},{380,374,0,0,2},{381,376,0,0,2},{382,378,0,0,2},{383,380,0,0,2},{397,382,
0,0,2},{416,384,0,0,2},{417,386,0,0,2},{431,388,0,0,2},{432,390,0,0,2},{446,392,
0,0,2},{452,394,0,0,3},{453,397,0,0,3},{454,400,0,0,3},{455,403,0,0,2},{456,405,
0,0,2},{457,407,0,0,2},{458,409,0,0,2},{459,411,0,0,2},{460,413,0,0,2},{461,415,
0,0,2},{462,417,0,0,2},{463,419,0,0,2},{464,421,0,0,2},{465,423,0,0,2},{466,425,
0,0,2},{467,427,0,0,2},{468,429,0,0,2},{469,431,0,0,3},{470,434,0,0,3},{471,437,
0,0,3},{472,440,0,0,3},{473,443,0,0,3},{474,446,0,0,3},{475,449,0,0,3},{476,452,
0,0,3},{478,455,0,0,3},{479,458,0,0,3},{480,461,0,0,3},{481,464,0,0,3},{482,467,
0,0,4},{483,471,0,0,4},{486,475,0,0,2},{487,477,0,0,2},{488,479,0,0,2},{489,481,
0,0,2},{490,483,0,0,2},{491,485,0,0,2},{492,487,0,0,3},{493,490,0,0,3},{494,493,
0,0,2},{495,495,0,0,2},{496,497,0,0,2},{497,499,0,0,2},{498,501,0,0,2},{499,503,
0,0,2},{500,505,0,0,2},{501,507,0,0,2},{504,509,0,0,2},{505,511,0,0,2},{506,513,
0,0,3},{507,516,0,0,3},{508,519,0,0,4},{509,523,0,0,4},{510,527,0,0,3},{511,530,
0,0,3},{512,533,0,0,2},{513,535,0,0,2},{514,537,0,0,2},{515,539,0,0,2},{516,541,
0,0,2},{517,543,0,0,2},{518,545,0,0,2},{519,547,0,0,2},{520,549,0,0,2},{521,551,
0,0,2},{522,553,0,0,2},{523,555,0,0,2},{524,557,0,0,2},{525,559,0,0,2},{526,561,
0,0,2},{527,563,0,0,2},{528,565,0,0,2},{529,567,0,0,2},{530,569,0,0,2},{531,571,
0,0,2},{532,573,0,0,2},{533,575,0,0,2},{534,577,0,0,2},{535,579,0,0,2},{536,581,
0,0,2},{537,583,0,0,2},{538,585,0,0,2},{539,587,0,0,2},{542,589,0,0,2},{543,591,
0,0,2},{550,593,0,0,2},{551,595,0,0,2},{552,597,0,0,2},{553,599,0,0,2},{554,601,
0,0,3},{555,604,0,0,3},{556,607,0,0,3},{557,610,0,0,3},{558,613,0,0,2},{559,615,
0,0,2},{560,617,0,0,3},{561,620,0,0,3},{562,623,0,0,2},{563,625,0,0,2},{568,627,
0,0,2},{569,629,0,0,2},{675,631,0,0,2},{676,633,0,0,2},{677,635,0,0,2},{678,637,
0,0,2},{679,639,0,0,2},{680,641,0,0,2},{681,643,0,0,2},{682,645,0,0,2},{683,647,
0,0,2},{776,0,3887,1,0},{901,651,0,0,2},{902,653,0,0,2},{904,655,0,0,2},{905,
657,0,0,2},{906,659,0,0,2},{908,661,0,0,2},{910,663,0,0,2},{911,665,0,0,2},{912,
667,0,0,3},{938,670,0,0,2},{939,672,0,0,2},{940,674,0,0,2},{941,676,0,0,2},{942,
678,0,0,2},{943,680,0,0,2},{944,682,0,0,3},{970,685,0,0,2},{971,687,0,0,2},{972,
689,0,0,2},{973,691,0,0,2},{974,693,0,0,2},{975,695,0,0,3},{979,698,0,0,2},{980,
700,0,0,2},{983,702,0,0,3},{1024,705,0,0,2},{1025,707,0,0,2},{1027,709,0,0,2},
{1031,711,0,0,2},{1036,713,0,0,2},{1037,715,0,0,2},{1038,717,0,0,2},{1104,719,0,
0,2},{1105,721,0,0,2},{1107,723,0,0,2},{1111,725,0,0,2},{1116,727,0,0,2},{1117,
729,0,0,2},{1118,731,0,0,2},{1142,733,0,0,2},{1143,735,0,0,2},{1168,737,0,0,2},
{1169,739,0,0,2},{1217,741,0,0,2},{1218,743,0,0,2},{1232,745,0,0,2},{1233,747,0,
0,2},{1234,749,0,0,2},{1235,751,0,0,2},{1238,753,0,0,2},{1239,755,0,0,2},{1242,
757,0,0,2},{1243,759,0,0,2},{1244,761,0,0,2},{1245,763,0,0,2},{1246,765,0,0,2},
{1247,767,0,0,2},{1250,769,0,0,2},{1251,771,0,0,2},{1252,773,0,0,2},{1253,775,0,
0,2},{1254,777,0,0,2},{1255,779,0,0,2},{1258,781,0,0,2},{1259,783,0,0,2},{1260,
785,0,0,2},{1261,787,0,0,2},{1262,789,0,0,2},{1263,791,0,0,2},{1264,793,0,0,2},
{1265,795,0,0,2},{1266,797,0,0,2},{1267,799,0,0,2},{1268,801,0,0,2},{1269,803,0,
0,2},{1272,805,0,0,2},{1273,807,0,0,2},{1415,809,0,0,2},{1488,0,3888,3,0},{1489,
0,3891,2,0},{1490,0,3893,1,0},{1491,0,3894,1,0},{1492,0,3895,1,0},{1493,0,3896,
2,0},{1494,0,3898,1,0},{1496,0,3899,1,0},{1497,0,3900,2,0},{1498,0,3902,1,0},
{1499,0,3903,2,0},{1500,0,3905,1,0},{1502,0,3906,1,0},{1504,0,3907,1,0},{1505,0,
3908,1,0},{1507,0,3909,1,0},{1508,0,3910,2,0},{1510,0,3912,1,0},{1511,0,3913,1,
0},{1512,0,3914,1,0},{1513,0,3915,3,0},{1514,0,3920,1,0},{1519,879,0,0,4},{1520,
883,0,0,2},{1521,885,0,0,2},{1522,887,3921,1,2},{1523,892,0,0,2},{1524,894,0,0,
2},{1653,896,0,0,2},{1654,898,0,0,2},{1655,900,0,0,2},{1656,902,0,0,2},{1728,
904,0,0,2},{1730,906,0,0,2},{1747,908,0,0,2},{1789,910,0,0,2},{1790,912,0,0,2},
{1812,914,0,0,2},{1820,916,0,0,2},{1831,918,0,0,2},{1837,920,0,0,2},{1838,922,0,
0,2},{1839,924,0,0,2},{2024,926,0,0,2},{2025,928,0,0,2},{2026,930,0,0,2},{2325,
0,3922,1,0},{2326,0,3923,1,0},{2327,0,3924,1,0},{2332,0,3925,1,0},{2337,0,3926,
1,0},{2338,0,3927,1,0},{2345,944,0,0,2},{2347,0,3928,1,0},{2351,0,3929,1,0},
{2353,950,0,0,2},{2356,952,0,0,2},{2465,0,3930,1,0},{2466,0,3931,1,0},{2479,0,
3932,1,0},{2510,960,0,0,2},{2582,0,3933,1,0},{2583,0,3934,1,0},{2588,0,3935,1,
0},{2603,0,3936,1,0},{2610,0,3937,1,0},{2616,0,3938,1,0},{2849,0,3939,1,0},
{2850,0,3940,1,0},{3164,978,0,0,4},{3165,982,0,0,2},{3292,984,0,0,4},{3293,988,
0,0,2},{3406,990,0,0,2},{3412,992,0,0,2},{3413,994,0,0,2},{3414,996,0,0,2},
{3450,998,0,0,2},{3451,1000,0,0,2},{3452,1002,0,0,2},{3453,1004,0,0,2},{3454,
1006,0,0,2},{3455,1008,0,0,2},{3648,0,3941,46,0},{3649,0,3987,46,0},{3650,0,
4033,46,0},{3651,0,4079,46,0},{3652,0,4125,46,0},{3661,0,4171,1,0},{3776,0,4172,
45,0},{3777,0,4217,45,0},{3778,0,4262,45,0},{3779,0,4307,45,0},{3780,0,4352,45,
0},{3789,0,4397,1,0},{3804,1932,0,0,2},{3805,1934,0,0,2},{3840,1936,0,0,3},
{3904,0,4398,1,0},{3906,0,4399,1,0},{3916,0,4400,1,0},{3921,0,4401,1,0},{3926,0,
4402,1,0},{3931,0,4403,1,0},{3946,1951,0,0,2},{3953,0,4404,3,0},{3984,0,4407,1,
0},{3986,0,4408,1,0},{3996,0,4409,1,0},{4001,0,4410,1,0},{4006,0,4411,1,0},
{4011,0,4412,1,0},{4018,0,4413,2,0},{4019,0,4416,2,0},{4026,1972,0,0,2},{4027,
1974,0,0,2},{4028,1976,0,0,2},{4159,1978,0,0,3},{5793,1981,0,0,2},{5796,1983,0,
0,2},{5797,1985,0,0,2},{5799,1987,0,0,2},{5801,1989,0,0,2},{5804,1991,0,0,2},
{5805,1993,0,0,2},{5806,1995,0,0,2},{5811,1997,0,0,2},{5812,1999,0,0,2},{5813,
2001,0,0,2},{5814,2003,0,0,2},{5819,2005,0,0,2},{5820,2007,0,0,2},{5821,2009,0,
0,2},{5823,2011,0,0,2},{5824,2013,0,0,2},{5826,2015,0,0,2},{5828,2017,0,0,2},
{5830,2019,0,0,2},{5835,2021,0,0,2},{5836,2023,0,0,2},{5837,2025,0,0,2},{5838,
2027,0,0,2},{5840,2029,0,0,2},{5841,2031,0,0,2},{5843,2033,0,0,2},{5844,2035,0,
0,2},{5845,2037,0,0,2},{5848,2039,0,0,2},{5849,2041,0,0,2},{5851,2043,0,0,2},
{5853,2045,0,0,2},{5863,2047,0,0,2},{5864,2049,0,0,2},{5865,2051,0,0,2},{5866,
2053,0,0,2},{5870,2055,0,0,2},{5871,2057,0,0,4},{5872,2061,0,0,2},{6429,2063,0,
0,2},{6430,2065,0,0,2},{6581,0,4419,44,0},{6582,0,4463,44,0},{6583,0,4507,44,0},
{6586,0,4551,44,0},{6622,2419,0,0,2},{6623,2421,0,0,3},{6740,2424,0,0,3},{6860,
2427,0,0,2},{6861,2429,0,0,2},{6862,2431,0,0,2},{6988,2433,0,0,3},{7469,2436,0,
0,3},{7545,2439,0,0,2},{7546,2441,0,0,3},{7582,2444,0,0,2},{7635,2446,0,0,2},
{7636,2448,0,0,3},{7637,2451,0,0,2},{7638,2453,0,0,2},{7639,2455,0,0,2},{7640,
2457,0,0,2},{7641,2459,0,0,2},{7651,2461,0,0,2},{7653,2463,0,0,2},{7661,2465,0,
0,2},{7664,2467,0,0,2},{7666,2469,0,0,2},{7667,2471,0,0,2},{7668,2473,0,0,2},
{7680,2475,0,0,2},{7681,2477,0,0,2},{7682,2479,0,0,2},{7683,2481,0,0,2},{7684,
2483,0,0,2},{7685,2485,0,0,2},{7686,2487,0,0,2},{7687,2489,0,0,2},{7688,2491,0,
0,3},{7689,2494,0,0,3},{7690,2497,0,0,2},{7691,2499,0,0,2},{7692,2501,0,0,2},
{7693,2503,0,0,2},{7694,2505,0,0,2},{7695,2507,0,0,2},{7696,2509,0,0,2},{7697,
2511,0,0,2},{7698,2513,0,0,2},{7699,2515,0,0,2},{7700,2517,0,0,3},{7701,2520,0,
0,3},{7702,2523,0,0,3},{7703,2526,0,0,3},{7704,2529,0,0,2},{7705,2531,0,0,2},
{7706,2533,0,0,2},{7707,2535,0,0,2},{7708,2537,0,0,3},{7709,2540,0,0,3},{7710,
2543,0,0,2},{7711,2545,0,0,2},{7712,2547,0,0,2},{7713,2549,0,0,2},{7714,2551,0,
0,2},{7715,2553,0,0,2},{7716,2555,0,0,2},{7717,2557,0,0,2},{7718,2559,0,0,2},
{7719,2561,0,0,2},{7720,2563,0,0,2},{7721,2565,0,0,2},{7722,2567,0,0,2},{7723,
2569,0,0,2},{7724,2571,0,0,2},{7725,2573,0,0,2},{7726,2575,0,0,3},{7727,2578,0,
0,3},{7728,2581,0,0,2},{7729,2583,0,0,2},{7730,2585,0,0,2},{7731,2587,0,0,2},
{7732,2589,0,0,2},{7733,2591,0,0,2},{7734,2593,0,0,2},{7735,2595,0,0,2},{7736,
2597,0,0,3},{7737,2600,0,0,3},{7738,2603,0,0,2},{7739,2605,0,0,2},{7740,2607,0,
0,2},{7741,2609,0,0,2},{7742,2611,0,0,2},{7743,2613,0,0,2},{7744,2615,0,0,2},
{7745,2617,0,0,2},{7746,2619,0,0,2},{7747,2621,0,0,2},{7748,2623,0,0,2},{7749,
2625,0,0,2},{7750,2627,0,0,2},{7751,2629,0,0,2},{7752,2631,0,0,2},{7753,2633,0,
0,2},{7754,2635,0,0,2},{7755,2637,0,0,2},{7756,2639,0,0,3},{7757,2642,0,0,3},
{7758,2645,0,0,3},{7759,2648,0,0,3},{7760,2651,0,0,3},{7761,2654,0,0,3},{7762,
2657,0,0,3},{7763,2660,0,0,3},{7764,2663,0,0,2},{7765,2665,0,0,2},{7766,2667,0,
0,2},{7767,2669,0,0,2},{7768,2671,0,0,2},{7769,2673,0,0,2},{7770,2675,0,0,2},
{7771,2677,0,0,2},{7772,2679,0,0,3},{7773,2682,0,0,3},{7774,2685,0,0,2},{7775,
2687,0,0,2},{7776,2689,0,0,2},{7777,2691,0,0,2},{7778,2693,0,0,2},{7779,2695,0,
0,2},{7780,2697,0,0,3},{7781,2700,0,0,3},{7782,2703,0,0,3},{7783,2706,0,0,3},
{7784,2709,0,0,3},{7785,2712,0,0,3},{7786,2715,0,0,2},{7787,2717,0,0,2},{7788,
2719,0,0,2},{7789,2721,0,0,2},{7790,2723,0,0,2},{7791,2725,0,0,2},{7792,2727,0,
0,2},{7793,2729,0,0,2},{7794,2731,0,0,2},{7795,2733,0,0,2},{7796,2735,0,0,2},
{7797,2737,0,0,2},{7798,2739,0,0,2},{7799,2741,0,0,2},{7800,2743,0,0,3},{7801,
2746,0,0,3},{7802,2749,0,0,3},{7803,2752,0,0,3},{7804,2755,0,0,2},{7805,2757,0,
0,2},{7806,2759,0,0,2},{7807,2761,0,0,2},{7808,2763,0,0,2},{7809,2765,0,0,2},
{7810,2767,0,0,2},{7811,2769,0,0,2},{7812,2771,0,0,2},{7813,2773,0,0,2},{7814,
2775,0,0,2},{7815,2777,0,0,2},{7816,2779,0,0,2},{7817,2781,0,0,2},{7818,2783,0,
0,2},{7819,2785,0,0,2},{7820,2787,0,0,2},{7821,2789,0,0,2},{7822,2791,0,0,2},
{7823,2793,0,0,2},{7824,2795,0,0,2},{7825,2797,0,0,2},{7826,2799,0,0,2},{7827,
2801,0,0,2},{7828,2803,0,0,2},{7829,2805,0,0,2},{7830,2807,0,0,2},{7831,2809,0,
0,2},{7832,2811,0,0,2},{7833,2813,0,0,2},{7834,2815,0,0,2},{7835,2817,0,0,3},
{7838,2820,0,0,3},{7840,2823,0,0,2},{7841,2825,0,0,2},{7842,2827,0,0,2},{7843,
2829,0,0,2},{7844,2831,0,0,3},{7845,2834,0,0,3},{7846,2837,0,0,3},{7847,2840,0,
0,3},{7848,2843,0,0,3},{7849,2846,0,0,3},{7850,2849,0,0,3},{7851,2852,0,0,3},
{7852,2855,0,0,3},{7853,2858,0,0,3},{7854,2861,0,0,3},{7855,2864,0,0,3},{7856,
2867,0,0,3},{7857,2870,0,0,3},{7858,2873,0,0,3},{7859,2876,0,0,3},{7860,2879,0,
0,3},{7861,2882,0,0,3},{7862,2885,0,0,3},{7863,2888,0,0,3},{7864,2891,0,0,2},
{7865,2893,0,0,2},{7866,2895,0,0,2},{7867,2897,0,0,2},{7868,2899,0,0,2},{7869,
2901,0,0,2},{7870,2903,0,0,3},{7871,2906,0,0,3},{7872,2909,0,0,3},{7873,2912,0,
0,3},{7874,2915,0,0,3},{7875,2918,0,0,3},{7876,2921,0,0,3},{7877,2924,0,0,3},
{7878,2927,0,0,3},{7879,2930,0,0,3},{7880,2933,0,0,2},{7881,2935,0,0,2},{7882,
2937,0,0,2},{7883,2939,0,0,2},{7884,2941,0,0,2},{7885,2943,0,0,2},{7886,2945,0,
0,2},{7887,2947,0,0,2},{7888,2949,0,0,3},{7889,2952,0,0,3},{7890,2955,0,0,3},
{7891,2958,0,0,3},{7892,2961,0,0,3},{7893,2964,0,0,3},{7894,2967,0,0,3},{7895,
2970,0,0,3},{7896,2973,0,0,3},{7897,2976,0,0,3},{7898,2979,0,0,3},{7899,2982,0,
0,3},{7900,2985,0,0,3},{7901,2988,0,0,3},{7902,2991,0,0,3},{7903,2994,0,0,3},
{7904,2997,0,0,3},{7905,3000,0,0,3},{7906,3003,0,0,3},{7907,3006,0,0,3},{7908,
3009,0,0,2},{7909,3011,0,0,2},{7910,3013,0,0,2},{7911,3015,0,0,2},{7912,3017,0,
0,3},{7913,3020,0,0,3},{7914,3023,0,0,3},{7915,3026,0,0,3},{7916,3029,0,0,3},
{7917,3032,0,0,3},{7918,3035,0,0,3},{7919,3038,0,0,3},{7920,3041,0,0,3},{7921,
3044,0,0,3},{7922,3047,0,0,2},{7923,3049,0,0,2},{7924,3051,0,0,2},{7925,3053,0,
0,2},{7926,3055,0,0,2},{7927,3057,0,0,2},{7928,3059,0,0,2},{7929,3061,0,0,2},
{7930,3063,0,0,2},{7931,3065,0,0,2},{7936,3067,0,0,2},{7937,3069,0,0,2},{7938,
3071,0,0,3},{7939,3074,0,0,3},{7940,3077,0,0,3},{7941,3080,0,0,3},{7942,3083,0,
0,3},{7943,3086,0,0,3},{7944,3089,0,0,2},{7945,3091,0,0,2},{7946,3093,0,0,3},
{7947,3096,0,0,3},{7948,3099,0,0,3},{7949,3102,0,0,3},{7950,3105,0,0,3},{7951,
3108,0,0,3},{7952,3111,0,0,2},{7953,3113,0,0,2},{7954,3115,0,0,3},{7955,3118,0,
0,3},{7956,3121,0,0,3},{7957,3124,0,0,3},{7960,3127,0,0,2},{7961,3129,0,0,2},
{7962,3131,0,0,3},{7963,3134,0,0,3},{7964,3137,0,0,3},{7965,3140,0,0,3},{7968,
3143,0,0,2},{7969,3145,0,0,2},{7970,3147,0,0,3},{7971,3150,0,0,3},{7972,3153,0,
0,3},{7973,3156,0,0,3},{7974,3159,0,0,3},{7975,3162,0,0,3},{7976,3165,0,0,2},
{7977,3167,0,0,2},{7978,3169,0,0,3},{7979,3172,0,0,3},{7980,3175,0,0,3},{7981,
3178,0,0,3},{7982,3181,0,0,3},{7983,3184,0,0,3},{7984,3187,0,0,2},{7985,3189,0,
0,2},{7986,3191,0,0,3},{7987,3194,0,0,3},{7988,3197,0,0,3},{7989,3200,0,0,3},
{7990,3203,0,0,3},{7991,3206,0,0,3},{7992,3209,0,0,2},{7993,3211,0,0,2},{7994,
3213,0,0,3},{7995,3216,0,0,3},{7996,3219,0,0,3},{7997,3222,0,0,3},{7998,3225,0,
0,3},{7999,3228,0,0,3},{8000,3231,0,0,2},{8001,3233,0,0,2},{8002,3235,0,0,3},
{8003,3238,0,0,3},{8004,3241,0,0,3},{8005,3244,0,0,3},{8008,3247,0,0,2},{8009,
3249,0,0,2},{8010,3251,0,0,3},{8011,3254,0,0,3},{8012,3257,0,0,3},{8013,3260,0,
0,3},{8016,3263,0,0,2},{8017,3265,0,0,2},{8018,3267,0,0,3},{8019,3270,0,0,3},
{8020,3273,0,0,3},{8021,3276,0,0,3},{8022,3279,0,0,3},{8023,3282,0,0,3},{8025,
3285,0,0,2},{8027,3287,0,0,3},{8029,3290,0,0,3},{8031,3293,0,0,3},{8032,3296,0,
0,2},{8033,3298,0,0,2},{8034,3300,0,0,3},{8035,3303,0,0,3},{8036,3306,0,0,3},
{8037,3309,0,0,3},{8038,3312,0,0,3},{8039,3315,0,0,3},{8040,3318,0,0,2},{8041,
3320,0,0,2},{8042,3322,0,0,3},{8043,3325,0,0,3},{8044,3328,0,0,3},{8045,3331,0,
0,3},{8046,3334,0,0,3},{8047,3337,0,0,3},{8048,3340,0,0,2},{8050,3342,0,0,2},
{8052,3344,0,0,2},{8054,3346,0,0,2},{8056,3348,0,0,2},{8058,3350,0,0,2},{8060,
3352,0,0,2},{8064,3354,0,0,3},{8065,3357,0,0,3},{8066,3360,0,0,4},{8067,3364,0,
0,4},{8068,3368,0,0,4},{8069,3372,0,0,4},{8070,3376,0,0,4},{8071,3380,0,0,4},
{8072,3384,0,0,3},{8073,3387,0,0,3},{8074,3390,0,0,4},{8075,3394,0,0,4},{8076,
3398,0,0,4},{8077,3402,0,0,4},{8078,3406,0,0,4},{8079,3410,0,0,4},{8080,3414,0,
0,3},{8081,3417,0,0,3},{8082,3420,0,0,4},{8083,3424,0,0,4},{8084,3428,0,0,4},
{8085,3432,0,0,4},{8086,3436,0,0,4},{8087,3440,0,0,4},{8088,3444,0,0,3},{8089,
3447,0,0,3},{8090,3450,0,0,4},{8091,3454,0,0,4},{8092,3458,0,0,4},{8093,3462,0,
0,4},{8094,3466,0,0,4},{8095,3470,0,0,4},{8096,3474,0,0,3},{8097,3477,0,0,3},
{8098,3480,0,0,4},{8099,3484,0,0,4},{8100,3488,0,0,4},{8101,3492,0,0,4},{8102,
3496,0,0,4},{8103,3500,0,0,4},{8104,3504,0,0,3},{8105,3507,0,0,3},{8106,3510,0,
0,4},{8107,3514,0,0,4},{8108,3518,0,0,4},{8109,3522,0,0,4},{8110,3526,0,0,4},
{8111,3530,0,0,4},{8112,3534,0,0,2},{8113,3536,0,0,2},{8114,3538,0,0,3},{8115,
3541,0,0,2},{8116,3543,0,0,3},{8118,3546,0,0,2},{8119,3548,0,0,3},{8120,3551,0,
0,2},{8121,3553,0,0,2},{8122,3555,0,0,2},{8124,3557,0,0,2},{8129,3559,0,0,2},
{8130,3561,0,0,3},{8131,3564,0,0,2},{8132,3566,0,0,3},{8134,3569,0,0,2},{8135,
3571,0,0,3},{8136,3574,0,0,2},{8138,3576,0,0,2},{8140,3578,0,0,2},{8141,3580,0,
0,2},{8142,3582,0,0,2},{8143,3584,0,0,2},{8144,3586,0,0,2},{8145,3588,0,0,2},
{8146,3590,0,0,3},{8150,3593,0,0,2},{8151,3595,0,0,3},{8152,3598,0,0,2},{8153,
3600,0,0,2},{8154,3602,0,0,2},{8157,3604,0,0,2},{8158,3606,0,0,2},{8159,3608,0,
0,2},{8160,3610,0,0,2},{8161,3612,0,0,2},{8162,3614,0,0,3},{8164,3617,0,0,2},
{8165,3619,0,0,2},{8166,3621,0,0,2},{8167,3623,0,0,3},{8168,3626,0,0,2},{8169,
3628,0,0,2},{8170,3630,0,0,2},{8172,3632,0,0,2},{8173,3634,0,0,2},{8178,3636,0,
0,3},{8179,3639,0,0,2},{8180,3641,0,0,3},{8182,3644,0,0,2},{8183,3646,0,0,3},
{8184,3649,0,0,2},{8186,3651,0,0,2},{8188,3653,0,0,2},{8216,3655,0,0,2},{8217,
3657,0,0,2},{8218,3659,0,0,2},{8219,3661,0,0,2},{8220,3663,0,0,2},{8221,3665,0,
0,2},{8222,3667,0,0,2},{8223,3669,0,0,2},{8229,3671,0,0,2},{8230,3673,0,0,3},
{8243,3676,0,0,2},{8244,3678,0,0,3},{8246,3681,0,0,2},{8247,3683,0,0,3},{8252,
3686,0,0,2},{8263,3688,0,0,2},{8264,3690,0,0,2},{8265,3692,0,0,2},{8279,3694,0,
0,4},{8359,3698,0,0,3},{8360,3701,0,0,2},{8448,3703,0,0,3},{8449,3706,0,0,3},
{8451,3709,0,0,2},{8453,3711,0,0,3},{8454,3714,0,0,3},{8457,3717,0,0,2},{8463,
3719,0,0,2},{8470,3721,0,0,2},{8480,3723,0,0,2},{8481,3725,0,0,3},{8482,3728,0,
0,2},{8507,3730,0,0,3},{8525,3733,0,0,3},{8528,3736,0,0,3},{8529,3739,0,0,3},
{8530,3742,0,0,4},{8531,3746,0,0,3},{8532,3749,0,0,3},{8533,3752,0,0,3},{8534,
3755,0,0,3},{8535,3758,0,0,3},{8536,3761,0,0,3},{8537,3764,0,0,3},{8538,3767,0,
0,3},{8539,3770,0,0,3},{8540,3773,0,0,3},{8541,3776,0,0,3},{8542,3779,0,0,3},
{8543,3782,0,0,2},{8545,3784,0,0,2},{8546,3786,0,0,3},{8547,3789,0,0,2},{8549,
3791,0,0,2},{8550,3793,0,0,3},{8551,3796,0,0,4},{8552,3800,0,0,2},{8554,3802,0,
0,2},{8555,3804,0,0,3},{8561,3807,0,0,2},{8562,3809,0,0,3},{8563,3812,0,0,2},
{8565,3814,0,0,2},{8566,3816,0,0,3},{8567,3819,0,0,4},{8568,3823,0,0,2},{8570,
3825,0,0,2},{8571,3827,0,0,3},{8585,3830,0,0,3},{8602,3833,0,0,2},{8603,3835,0,
0,2},{8622,3837,0,0,2},{8653,3839,0,0,2},{8654,3841,0,0,2},{8655,3843,0,0,2},
{8708,3845,0,0,2},{8713,3847,0,0,2},{8716,3849,0,0,2},{8740,3851,0,0,2},{8742,
3853,0,0,2},{8748,3855,0,0,2},{8749,3857,0,0,3},{8751,3860,0,0,2},{8752,3862,0,
0,3},{8769,3865,0,0,2},{8772,3867,0,0,2},{8775,3869,0,0,2},{8777,3871,0,0,2},
{8800,3873,0,0,2},{8802,3875,0,0,2},{8813,3877,0,0,2},{8814,3879,0,0,2},{8815,
3881,0,0,2},{8816,3883,0,0,2},{8817,3885,0,0,2},{8820,3887,0,0,2},{8821,3889,0,
0,2},{8824,3891,0,0,2},{8825,3893,0,0,2},{8832,3895,0,0,2},{8833,3897,0,0,2},
{8836,3899,0,0,2},{8837,3901,0,0,2},{8840,3903,0,0,2},{8841,3905,0,0,2},{8876,
3907,0,0,2},{8877,3909,0,0,2},{8878,3911,0,0,2},{8879,3913,0,0,2},{8928,3915,0,
0,2},{8929,3917,0,0,2},{8930,3919,0,0,2},{8931,3921,0,0,2},{8938,3923,0,0,2},
{8939,3925,0,0,2},{8940,3927,0,0,2},{8941,3929,0,0,2},{9321,3931,0,0,2},{9322,
3933,0,0,2},{9323,3935,0,0,2},{9324,3937,0,0,2},{9325,3939,0,0,2},{9326,3941,0,
0,2},{9327,3943,0,0,2},{9328,3945,0,0,2},{9329,3947,0,0,2},{9330,3949,0,0,2},
{9331,3951,0,0,2},{9332,3953,0,0,3},{9333,3956,0,0,3},{9334,3959,0,0,3},{9335,
3962,0,0,3},{9336,3965,0,0,3},{9337,3968,0,0,3},{9338,3971,0,0,3},{9339,3974,0,
0,3},{9340,3977,0,0,3},{9341,3980,0,0,4},{9342,3984,0,0,4},{9343,3988,0,0,4},
{9344,3992,0,0,4},{9345,3996,0,0,4},{9346,4000,0,0,4},{9347,4004,0,0,4},{9348,
4008,0,0,4},{9349,4012,0,0,4},{9350,4016,0,0,4},{9351,4020,0,0,4},{9352,4024,0,
0,2},{9353,4026,0,0,2},{9354,4028,0,0,2},{9355,4030,0,0,2},{9356,4032,0,0,2},
{9357,4034,0,0,2},{9358,4036,0,0,2},{9359,4038,0,0,2},{9360,4040,0,0,2},{9361,
4042,0,0,3},{9362,4045,0,0,3},{9363,4048,0,0,3},{9364,4051,0,0,3},{9365,4054,0,
0,3},{9366,4057,0,0,3},{9367,4060,0,0,3},{9368,4063,0,0,3},{9369,4066,0,0,3},
{9370,4069,0,0,3},{9371,4072,0,0,3},{9372,4075,0,0,3},{9373,4078,0,0,3},{9374,
4081,0,0,3},{9375,4084,0,0,3},{9376,4087,0,0,3},{9377,4090,0,0,3},{9378,4093,0,
0,3},{9379,4096,0,0,3},{9380,4099,0,0,3},{9381,4102,0,0,3},{9382,4105,0,0,3},
{9383,4108,0,0,3},{9384,4111,0,0,3},{9385,4114,0,0,3},{9386,4117,0,0,3},{9387,
4120,0,0,3},{9388,4123,0,0,3},{9389,4126,0,0,3},{9390,4129,0,0,3},{9391,4132,0,
0,3},{9392,4135,0,0,3},{9393,4138,0,0,3},{9394,4141,0,0,3},{9395,4144,0,0,3},
{9396,4147,0,0,3},{9397,4150,0,0,3},{9451,4153,0,0,2},{9452,4155,0,0,2},{9453,
4157,0,0,2},{9454,4159,0,0,2},{9455,4161,0,0,2},{9456,4163,0,0,2},{9457,4165,0,
0,2},{9458,4167,0,0,2},{9459,4169,0,0,2},{9460,4171,0,0,2},{9470,4173,0,0,2},
{10111,4175,0,0,2},{10121,4177,0,0,2},{10131,4179,0,0,2},{10764,4181,0,0,4},
{10868,4185,0,0,3},{10869,4188,0,0,2},{10870,4190,0,0,3},{10973,0,4595,1,0},
{11492,4195,0,0,3},{11765,4198,0,0,2},{11842,4200,0,0,2},{11904,4202,0,0,3},
{11905,4205,0,0,3},{11906,4208,0,0,2},{11907,4210,0,0,2},{11908,4212,0,0,3},
{11909,4215,0,0,2},{11910,4217,0,0,3},{11911,4220,0,0,3},{11912,4223,0,0,3},
{11913,4226,0,0,2},{11914,4228,0,0,3},{11915,4231,0,0,3},{11916,4234,0,0,3},
{11917,4237,0,0,3},{11918,4240,0,0,3},{11919,4243,0,0,2},{11920,4245,0,0,2},
{11921,4247,0,0,3},{11922,4250,0,0,2},{11923,4252,0,0,2},{11924,4254,0,0,2},
{11925,4256,0,0,3},{11926,4259,0,0,2},{11927,4261,0,0,3},{11928,4264,0,0,2},
{11929,4266,0,0,2},{11931,4268,0,0,2},{11932,4270,0,0,3},{11933,4273,0,0,3},
{11934,4276,0,0,3},{11935,4279,0,0,2},{11936,4281,0,0,2},{11937,4283,0,0,2},
{11938,4285,0,0,2},{11939,4287,0,0,2},{11940,4289,0,0,2},{11941,4291,0,0,3},
{11942,4294,0,0,2},{11943,4296,0,0,3},{11944,4299,0,0,2},{11945,4301,0,0,3},
{11946,4304,0,0,3},{11947,4307,0,0,3},{11948,4310,0,0,3},{11949,4313,0,0,2},
{11950,4315,0,0,3},{11951,4318,0,0,2},{11952,4320,0,0,2},{11953,4322,0,0,2},
{11954,4324,0,0,2},{11955,4326,0,0,3},{11956,4329,0,0,3},{11957,4332,0,0,3},
{11958,4335,0,0,3},{11959,4338,0,0,3},{11960,4341,0,0,2},{11961,4343,0,0,2},
{11962,4345,0,0,2},{11963,4347,0,0,3},{11964,4350,0,0,3},{11965,4353,0,0,3},
{11966,4356,0,0,2},{11967,4358,0,0,3},{11968,4361,0,0,3},{11969,4364,0,0,2},
{11970,4366,0,0,2},{11971,4368,0,0,2},{11972,4370,0,0,2},{11973,4372,0,0,2},
{11974,4374,0,0,2},{11975,4376,0,0,3},{11976,4379,0,0,2},{11977,4381,0,0,2},
{11978,4383,0,0,3},{11979,4386,0,0,2},{11980,4388,0,0,2},{11981,4390,0,0,3},
{11982,4393,0,0,3},{11983,4396,0,0,3},{11984,4399,0,0,2},{11985,4401,0,0,2},
{11986,4403,0,0,2},{11987,4405,0,0,2},{11988,4407,0,0,2},{11989,4409,0,0,3},
{11990,4412,0,0,2},{11991,4414,0,0,3},{11992,4417,0,0,2},{11993,4419,0,0,2},
{11994,4421,0,0,2},{11995,4423,0,0,2},{11996,4425,0,0,2},{11997,4427,0,0,2},
{11998,4429,0,0,3},{11999,4432,0,0,2},{12000,4434,0,0,2},{12001,4436,0,0,3},
{12002,4439,0,0,2},{12003,4441,0,0,3},{12004,4444,0,0,3},{12005,4447,0,0,2},
{12006,4449,0,0,2},{12007,4451,0,0,3},{12008,4454,0,0,2},{12009,4456,0,0,2},
{12010,4458,0,0,2},{12011,4460,0,0,3},{12012,4463,0,0,2},{12013,4465,0,0,3},
{12014,4468,0,0,2},{12015,4470,0,0,3},{12016,4473,0,0,2},{12017,4475,0,0,3},
{12018,4478,0,0,3},{12019,4481,0,0,2},{12032,4483,0,0,2},{12033,4485,0,0,2},
{12034,4487,0,0,2},{12035,4489,0,0,2},{12036,4491,0,0,2},{12037,4493,0,0,2},
{12038,4495,0,0,2},{12039,4497,0,0,2},{12040,4499,0,0,2},{12041,4501,0,0,2},
{12042,4503,0,0,2},{12043,4505,0,0,2},{12044,4507,0,0,2},{12045,4509,0,0,2},
{12046,4511,0,0,2},{12047,4513,0,0,2},{12048,4515,0,0,2},{12049,4517,0,0,2},
{12050,4519,0,0,2},{12051,4521,0,0,2},{12052,4523,0,0,2},{12053,4525,0,0,2},
{12054,4527,0,0,2},{12055,4529,0,0,2},{12056,4531,0,0,2},{12057,4533,0,0,2},
{12058,4535,0,0,2},{12059,4537,0,0,2},{12060,4539,0,0,2},{12061,4541,0,0,2},
{12062,4543,0,0,2},{12063,4545,0,0,2},{12064,4547,0,0,2},{12065,4549,0,0,2},
{12066,4551,0,0,2},{12067,4553,0,0,2},{12068,4555,0,0,2},{12069,4557,0,0,2},
{12070,4559,0,0,2},{12071,4561,0,0,2},{12072,4563,0,0,2},{12073,4565,0,0,2},
{12074,4567,0,0,2},{12075,4569,0,0,2},{12076,4571,0,0,2},{12077,4573,0,0,2},
{12078,4575,0,0,2},{12079,4577,0,0,2},{12080,4579,0,0,2},{12081,4581,0,0,2},
{12082,4583,0,0,2},{12083,4585,0,0,2},{12084,4587,0,0,2},{12085,4589,0,0,2},
{12086,4591,0,0,2},{12087,4593,0,0,2},{12088,4595,0,0,2},{12089,4597,0,0,2},
{12090,4599,0,0,2},{12091,4601,0,0,2},{12092,4603,0,0,2},{12093,4605,0,0,2},
{12094,4607,0,0,2},{12095,4609,0,0,2},{12096,4611,0,0,2},{12097,4613,0,0,2},
{12098,4615,0,0,2},{12099,4617,0,0,2},{12100,4619,0,0,2},{12101,4621,0,0,2},
{12102,4623,0,0,2},{12103,4625,0,0,2},{12104,4627,0,0,2},{12105,4629,0,0,2},
{12106,4631,0,0,2},{12107,4633,0,0,2},{12108,4635,0,0,2},{12109,4637,0,0,2},
{12110,4639,0,0,2},{12111,4641,0,0,2},{12112,4643,0,0,2},{12113,4645,0,0,2},
{12114,4647,0,0,2},{12115,4649,0,0,2},{12116,4651,0,0,2},{12117,4653,0,0,2},
{12118,4655,0,0,2},{12119,4657,0,0,2},{12120,4659,0,0,2},{12121,4661,0,0,2},
{12122,4663,0,0,2},{12123,4665,0,0,2},{12124,4667,0,0,2},{12125,4669,0,0,2},
{12126,4671,0,0,2},{12127,4673,0,0,2},{12128,4675,0,0,2},{12129,4677,0,0,2},
{12130,4679,0,0,2},{12131,4681,0,0,2},{12132,4683,0,0,2},{12133,4685,0,0,2},
{12134,4687,0,0,2},{12135,4689,0,0,2},{12136,4691,0,0,2},{12137,4693,0,0,2},
{12138,4695,0,0,2},{12139,4697,0,0,2},{12140,4699,0,0,2},{12141,4701,0,0,2},
{12142,4703,0,0,2},{12143,4705,0,0,2},{12144,4707,0,0,2},{12145,4709,0,0,2},
{12146,4711,0,0,2},{12147,4713,0,0,2},{12148,4715,0,0,2},{12149,4717,0,0,2},
{12150,4719,0,0,2},{12151,4721,0,0,2},{12152,4723,0,0,2},{12153,4725,0,0,2},
{12154,4727,0,0,2},{12155,4729,0,0,2},{12156,4731,0,0,2},{12157,4733,0,0,2},
{12158,4735,0,0,2},{12159,4737,0,0,2},{12160,4739,0,0,2},{12161,4741,0,0,2},
{12162,4743,0,0,2},{12163,4745,0,0,2},{12164,4747,0,0,2},{12165,4749,0,0,2},
{12166,4751,0,0,2},{12167,4753,0,0,2},{12168,4755,0,0,2},{12169,4757,0,0,2},
{12170,4759,0,0,2},{12171,4761,0,0,2},{12172,4763,0,0,2},{12173,4765,0,0,2},
{12174,4767,0,0,2},{12175,4769,0,0,2},{12176,4771,0,0,2},{12177,4773,0,0,2},
{12178,4775,0,0,2},{12179,4777,0,0,2},{12180,4779,0,0,2},{12181,4781,0,0,2},
{12182,4783,0,0,2},{12183,4785,0,0,2},{12184,4787,0,0,2},{12185,4789,0,0,2},
{12186,4791,0,0,2},{12187,4793,0,0,2},{12188,4795,0,0,2},{12189,4797,0,0,2},
{12190,4799,0,0,2},{12191,4801,0,0,2},{12192,4803,0,0,2},{12193,4805,0,0,2},
{12194,4807,0,0,2},{12195,4809,0,0,2},{12196,4811,0,0,2},{12197,4813,0,0,2},
{12198,4815,0,0,2},{12199,4817,0,0,2},{12200,4819,0,0,2},{12201,4821,0,0,2},
{12202,4823,0,0,2},{12203,4825,0,0,2},{12204,4827,0,0,2},{12205,4829,0,0,2},
{12206,4831,0,0,2},{12207,4833,0,0,2},{12208,4835,0,0,2},{12209,4837,0,0,2},
{12210,4839,0,0,2},{12211,4841,0,0,2},{12212,4843,0,0,2},{12213,4845,0,0,2},
{12214,4847,0,0,2},{12215,4849,0,0,2},{12216,4851,0,0,2},{12217,4853,0,0,2},
{12218,4855,0,0,2},{12219,4857,0,0,2},{12220,4859,0,0,2},{12221,4861,0,0,2},
{12222,4863,0,0,2},{12223,4865,0,0,2},{12224,4867,0,0,2},{12225,4869,0,0,2},
{12226,4871,0,0,2},{12227,4873,0,0,2},{12228,4875,0,0,2},{12229,4877,0,0,2},
{12230,4879,0,0,2},{12231,4881,0,0,2},{12232,4883,0,0,2},{12233,4885,0,0,2},
{12234,4887,0,0,2},{12235,4889,0,0,2},{12236,4891,0,0,2},{12237,4893,0,0,2},
{12238,4895,0,0,2},{12239,4897,0,0,2},{12240,4899,0,0,2},{12241,4901,0,0,2},
{12242,4903,0,0,2},{12243,4905,0,0,2},{12244,4907,0,0,2},{12245,4909,0,0,2},
{12294,4911,0,0,2},{12317,4913,0,0,2},{12318,4915,0,0,2},{12319,4917,0,0,2},
{12338,4919,0,0,2},{12340,4921,0,0,2},{12344,4923,0,0,2},{12345,4925,0,0,2},
{12346,4927,0,0,2},{12348,4929,0,0,2},{12364,4931,0,0,2},{12366,4933,0,0,2},
{12368,4935,0,0,2},{12370,4937,0,0,2},{12372,4939,0,0,2},{12374,4941,0,0,2},
{12376,4943,0,0,2},{12378,4945,0,0,2},{12380,4947,0,0,2},{12382,4949,0,0,2},
{12384,4951,0,0,2},{12386,4953,0,0,2},{12389,4955,0,0,2},{12391,4957,0,0,2},
{12393,4959,0,0,2},{12400,4961,0,0,2},{12401,4963,0,0,2},{12403,4965,0,0,2},
{12404,4967,0,0,2},{12406,4969,0,0,2},{12407,4971,0,0,2},{12409,4973,0,0,2},
{12410,4975,0,0,2},{12412,4977,0,0,2},{12413,4979,0,0,2},{12436,4981,0,0,2},
{12446,4983,0,0,2},{12447,4985,0,0,2},{12460,4987,0,0,2},{12462,4989,0,0,2},
{12464,4991,0,0,2},{12466,4993,0,0,2},{12468,4995,0,0,2},{12470,4997,0,0,2},
{12472,4999,0,0,2},{12474,5001,0,0,2},{12476,5003,0,0,2},{12478,5005,0,0,2},
{12480,5007,0,0,2},{12482,5009,0,0,2},{12485,5011,0,0,2},{12487,5013,0,0,2},
{12489,5015,0,0,2},{12496,5017,0,0,2},{12497,5019,0,0,2},{12499,5021,0,0,2},
{12500,5023,0,0,2},{12502,5025,0,0,2},{12503,5027,0,0,2},{12505,5029,0,0,2},
{12506,5031,0,0,2},{12508,5033,0,0,2},{12509,5035,0,0,2},{12532,5037,0,0,2},
{12535,5039,0,0,2},{12536,5041,0,0,2},{12537,5043,0,0,2},{12538,5045,0,0,2},
{12542,5047,0,0,2},{12543,5049,0,0,2},{12690,5051,0,0,2},{12691,5053,0,0,2},
{12692,5055,0,0,2},{12693,5057,0,0,2},{12694,5059,0,0,2},{12695,5061,0,0,2},
{12696,5063,0,0,2},{12697,5065,0,0,2},{12698,5067,0,0,2},{12699,5069,0,0,2},
{12700,5071,0,0,2},{12701,5073,0,0,2},{12702,5075,0,0,2},{12703,5077,0,0,2},
{12704,5079,0,0,2},{12705,5081,0,0,2},{12706,5083,0,0,2},{12707,5085,0,0,2},
{12709,5087,0,0,2},{12711,5089,0,0,2},{12712,5091,0,0,2},{12713,5093,0,0,2},
{12714,5095,0,0,2},{12715,5097,0,0,2},{12718,5099,0,0,2},{12719,5101,0,0,2},
{12723,5103,0,0,2},{12800,5105,0,0,3},{12801,5108,0,0,3},{12802,5111,0,0,3},
{12803,5114,0,0,3},{12804,5117,0,0,3},{12805,5120,0,0,3},{12806,5123,0,0,3},
{12807,5126,0,0,3},{12808,5129,0,0,3},{12809,5132,0,0,3},{12810,5135,0,0,3},
{12811,5138,0,0,3},{12812,5141,0,0,3},{12813,5144,0,0,3},{12814,5147,0,0,4},
{12815,5151,0,0,4},{12816,5155,0,0,4},{12817,5159,0,0,4},{12818,5163,0,0,4},
{12819,5167,0,0,4},{12820,5171,0,0,4},{12821,5175,0,0,4},{12822,5179,0,0,4},
{12823,5183,0,0,4},{12824,5187,0,0,4},{12825,5191,0,0,4},{12826,5195,0,0,4},
{12827,5199,0,0,4},{12828,5203,0,0,4},{12829,5207,0,0,7},{12830,5214,0,0,6},
{12832,5220,0,0,4},{12833,5224,0,0,4},{12834,5228,0,0,4},{12835,5232,0,0,4},
{12836,5236,0,0,4},{12837,5240,0,0,4},{12838,5244,0,0,4},{12839,5248,0,0,4},
{12840,5252,0,0,4},{12841,5256,0,0,4},{12842,5260,0,0,4},{12843,5264,0,0,4},
{12844,5268,0,0,4},{12845,5272,0,0,4},{12846,5276,0,0,4},{12847,5280,0,0,4},
{12848,5284,0,0,4},{12849,5288,0,0,4},{12850,5292,0,0,4},{12851,5296,0,0,4},
{12852,5300,0,0,4},{12853,5304,0,0,4},{12854,5308,0,0,4},{12855,5312,0,0,4},
{12856,5316,0,0,4},{12857,5320,0,0,4},{12858,5324,0,0,4},{12859,5328,0,0,4},
{12860,5332,0,0,4},{12861,5336,0,0,4},{12862,5340,0,0,4},{12863,5344,0,0,4},
{12864,5348,0,0,4},{12865,5352,0,0,4},{12866,5356,0,0,4},{12867,5360,0,0,4},
{12868,5364,0,0,2},{12869,5366,0,0,2},{12870,5368,0,0,2},{12871,5370,0,0,2},
{12872,5372,0,0,2},{12873,5374,0,0,2},{12874,5376,0,0,2},{12875,5378,0,0,2},
{12876,5380,0,0,2},{12877,5382,0,0,2},{12878,5384,0,0,2},{12879,5386,0,0,2},
{12880,5388,0,0,3},{12881,5391,0,0,2},{12882,5393,0,0,2},{12883,5395,0,0,2},
{12884,5397,0,0,2},{12885,5399,0,0,2},{12886,5401,0,0,2},{12887,5403,0,0,2},
{12888,5405,0,0,2},{12889,5407,0,0,2},{12890,5409,0,0,2},{12891,5411,0,0,2},
{12892,5413,0,0,2},{12893,5415,0,0,2},{12894,5417,0,0,2},{12895,5419,0,0,2},
{12910,5421,0,0,2},{12911,5423,0,0,2},{12912,5425,0,0,2},{12913,5427,0,0,2},
{12914,5429,0,0,2},{12915,5431,0,0,2},{12916,5433,0,0,2},{12917,5435,0,0,2},
{12918,5437,0,0,2},{12919,5439,0,0,2},{12920,5441,0,0,2},{12921,5443,0,0,2},
{12922,5445,0,0,2},{12923,5447,0,0,2},{12924,5449,0,0,5},{12925,5454,0,0,4},
{12926,5458,0,0,2},{12928,5460,0,0,2},{12929,5462,0,0,2},{12930,5464,0,0,2},
{12931,5466,0,0,2},{12932,5468,0,0,2},{12933,5470,0,0,2},{12934,5472,0,0,2},
{12935,5474,0,0,2},{12936,5476,0,0,2},{12937,5478,0,0,2},{12938,5480,0,0,2},
{12939,5482,0,0,2},{12940,5484,0,0,2},{12941,5486,0,0,2},{12942,5488,0,0,2},
{12943,5490,0,0,2},{12944,5492,0,0,2},{12945,5494,0,0,2},{12946,5496,0,0,2},
{12947,5498,0,0,2},{12948,5500,0,0,2},{12949,5502,0,0,2},{12950,5504,0,0,2},
{12951,5506,0,0,2},{12952,5508,0,0,2},{12953,5510,0,0,2},{12954,5512,0,0,2},
{12955,5514,0,0,2},{12956,5516,0,0,2},{12957,5518,0,0,2},{12958,5520,0,0,2},
{12959,5522,0,0,2},{12960,5524,0,0,2},{12961,5526,0,0,2},{12962,5528,0,0,2},
{12963,5530,0,0,2},{12964,5532,0,0,2},{12965,5534,0,0,2},{12966,5536,0,0,2},
{12967,5538,0,0,2},{12968,5540,0,0,2},{12969,5542,0,0,2},{12970,5544,0,0,2},
{12971,5546,0,0,2},{12972,5548,0,0,2},{12973,5550,0,0,2},{12974,5552,0,0,2},
{12975,5554,0,0,2},{12976,5556,0,0,2},{12977,5558,0,0,2},{12978,5560,0,0,2},
{12979,5562,0,0,2},{12980,5564,0,0,2},{12981,5566,0,0,2},{12982,5568,0,0,2},
{12983,5570,0,0,2},{12984,5572,0,0,2},{12985,5574,0,0,2},{12986,5576,0,0,2},
{12987,5578,0,0,2},{12988,5580,0,0,2},{12989,5582,0,0,2},{12990,5584,0,0,2},
{12991,5586,0,0,2},{12992,5588,0,0,3},{12993,5591,0,0,3},{12994,5594,0,0,3},
{12995,5597,0,0,3},{12996,5600,0,0,3},{12997,5603,0,0,3},{12998,5606,0,0,3},
{12999,5609,0,0,3},{13000,5612,0,0,3},{13001,5615,0,0,4},{13002,5619,0,0,4},
{13003,5623,0,0,4},{13004,5627,0,0,2},{13005,5629,0,0,3},{13006,5632,0,0,2},
{13007,5634,0,0,3},{13055,5637,0,0,4},{13056,5641,0,0,5},{13057,5646,0,0,4},
{13058,5650,0,0,5},{13059,5655,0,0,3},{13060,5658,0,0,5},{13061,5663,0,0,3},
{13062,5666,0,0,3},{13063,5669,0,0,6},{13064,5675,0,0,4},{13065,5679,0,0,3},
{13066,5682,0,0,3},{13067,5685,0,0,3},{13068,5688,0,0,4},{13069,5692,0,0,4},
{13070,5696,0,0,4},{13071,5700,0,0,4},{13072,5704,0,0,4},{13073,5708,0,0,4},
{13074,5712,0,0,4},{13075,5716,0,0,6},{13076,5722,0,0,2},{13077,5724,0,0,6},
{13078,5730,0,0,6},{13079,5736,0,0,5},{13080,5741,0,0,4},{13081,5745,0,0,6},
{13082,5751,0,0,6},{13083,5757,0,0,4},{13084,5761,0,0,3},{13085,5764,0,0,3},
{13086,5767,0,0,4},{13087,5771,0,0,4},{13088,5775,0,0,5},{13089,5780,0,0,5},
{13090,5785,0,0,3},{13091,5788,0,0,3},{13092,5791,0,0,4},{13093,5795,0,0,3},
{13094,5798,0,0,3},{13095,5801,0,0,2},{13096,5803,0,0,2},{13097,5805,0,0,3},
{13098,5808,0,0,3},{13099,5811,0,0,6},{13100,5817,0,0,4},{13101,5821,0,0,5},
{13102,5826,0,0,6},{13103,5832,0,0,4},{13104,5836,0,0,3},{13105,5839,0,0,3},
{13106,5842,0,0,6},{13107,5848,0,0,4},{13108,5852,0,0,6},{13109,5858,0,0,3},
{13110,5861,0,0,5},{13111,5866,0,0,3},{13112,5869,0,0,4},{13113,5873,0,0,3},
{13114,5876,0,0,4},{13115,5880,0,0,5},{13116,5885,0,0,4},{13117,5889,0,0,5},
{13118,5894,0,0,4},{13119,5898,0,0,2},{13120,5900,0,0,5},{13121,5905,0,0,3},
{13122,5908,0,0,3},{13123,5911,0,0,4},{13124,5915,0,0,3},{13125,5918,0,0,3},
{13126,5921,0,0,3},{13127,5924,0,0,5},{13128,5929,0,0,4},{13129,5933,0,0,2},
{13130,5935,0,0,6},{13131,5941,0,0,3},{13132,5944,0,0,5},{13133,5949,0,0,4},
{13134,5953,0,0,4},{13135,5957,0,0,3},{13136,5960,0,0,3},{13137,5963,0,0,4},
{13138,5967,0,0,2},{13139,5969,0,0,4},{13140,5973,0,0,5},{13141,5978,0,0,2},
{13142,5980,0,0,6},{13143,5986,0,0,3},{13144,5989,0,0,3},{13145,5992,0,0,3},
{13146,5995,0,0,3},{13147,5998,0,0,3},{13148,6001,0,0,3},{13149,6004,0,0,3},
{13150,6007,0,0,3},{13151,6010,0,0,3},{13152,6013,0,0,3},{13153,6016,0,0,3},
{13154,6019,0,0,4},{13155,6023,0,0,4},{13156,6027,0,0,4},{13157,6031,0,0,4},
{13158,6035,0,0,4},{13159,6039,0,0,4},{13160,6043,0,0,4},{13161,6047,0,0,4},
{13162,6051,0,0,4},{13163,6055,0,0,4},{13164,6059,0,0,4},{13165,6063,0,0,4},
{13166,6067,0,0,4},{13167,6071,0,0,4},{13168,6075,0,0,4},{13169,6079,0,0,3},
{13170,6082,0,0,2},{13171,6084,0,0,2},{13172,6086,0,0,3},{13173,6089,0,0,2},
{13174,6091,0,0,2},{13175,6093,0,0,2},{13176,6095,0,0,3},{13177,6098,0,0,3},
{13178,6101,0,0,2},{13179,6103,0,0,4},{13180,6107,0,0,4},{13181,6111,0,0,4},
{13182,6115,0,0,4},{13183,6119,0,0,8},{13184,6127,0,0,2},{13185,6129,0,0,2},
{13186,6131,0,0,2},{13187,6133,0,0,2},{13188,6135,0,0,2},{13189,6137,0,0,2},
{13190,6139,0,0,2},{13191,6141,0,0,2},{13192,6143,0,0,3},{13193,6146,0,0,4},
{13194,6150,0,0,2},{13195,6152,0,0,2},{13196,6154,0,0,2},{13197,6156,0,0,2},
{13198,6158,0,0,2},{13199,6160,0,0,2},{13200,6162,0,0,2},{13201,6164,0,0,3},
{13202,6167,0,0,3},{13203,6170,0,0,3},{13204,6173,0,0,3},{13205,6176,0,0,2},
{13206,6178,0,0,2},{13207,6180,0,0,2},{13208,6182,0,0,2},{13209,6184,0,0,2},
{13210,6186,0,0,2},{13211,6188,0,0,2},{13212,6190,0,0,2},{13213,6192,0,0,2},
{13214,6194,0,0,2},{13215,6196,0,0,3},{13216,6199,0,0,3},{13217,6202,0,0,2},
{13218,6204,0,0,3},{13219,6207,0,0,3},{13220,6210,0,0,3},{13221,6213,0,0,2},
{13222,6215,0,0,3},{13223,6218,0,0,3},{13224,6221,0,0,4},{13225,6225,0,0,2},
{13226,6227,0,0,3},{13227,6230,0,0,3},{13228,6233,0,0,3},{13229,6236,0,0,3},
{13230,6239,0,0,5},{13231,6244,0,0,6},{13232,6250,0,0,2},{13233,6252,0,0,2},
{13234,6254,0,0,2},{13235,6256,0,0,2},{13236,6258,0,0,2},{13237,6260,0,0,2},
{13238,6262,0,0,2},{13239,6264,0,0,2},{13240,6266,0,0,2},{13241,6268,0,0,2},
{13242,6270,0,0,2},{13243,6272,0,0,2},{13244,6274,0,0,2},{13245,6276,0,0,2},
{13246,6278,0,0,2},{13247,6280,0,0,2},{13248,6282,0,0,2},{13249,6284,0,0,2},
{13250,6286,0,0,4},{13251,6290,0,0,2},{13252,6292,0,0,2},{13253,6294,0,0,2},
{13254,6296,0,0,4},{13255,6300,0,0,3},{13256,6303,0,0,2},{13257,6305,0,0,2},
{13258,6307,0,0,2},{13259,6309,0,0,2},{13260,6311,0,0,2},{13261,6313,0,0,2},
{13262,6315,0,0,2},{13263,6317,0,0,2},{13264,6319,0,0,2},{13265,6321,0,0,2},
{13266,6323,0,0,3},{13267,6326,0,0,2},{13268,6328,0,0,2},{13269,6330,0,0,3},
{13270,6333,0,0,3},{13271,6336,0,0,2},{13272,6338,0,0,4},{13273,6342,0,0,3},
{13274,6345,0,0,2},{13275,6347,0,0,2},{13276,6349,0,0,2},{13277,6351,0,0,2},
{13278,6353,0,0,3},{13279,6356,0,0,3},{13280,6359,0,0,3},{13281,6362,0,0,3},
{13282,6365,0,0,3},{13283,6368,0,0,3},{13284,6371,0,0,3},{13285,6374,0,0,3},
{13286,6377,0,0,3},{13287,6380,0,0,3},{13288,6383,0,0,3},{13289,6386,0,0,4},
{13290,6390,0,0,4},{13291,6394,0,0,4},{13292,6398,0,0,4},{13293,6402,0,0,4},
{13294,6406,0,0,4},{13295,6410,0,0,4},{13296,6414,0,0,4},{13297,6418,0,0,4},
{13298,6422,0,0,4},{13299,6426,0,0,4},{13300,6430,0,0,4},{13301,6434,0,0,4},
{13302,6438,0,0,4},{13303,6442,0,0,4},{13304,6446,0,0,4},{13305,6450,0,0,4},
{13306,6454,0,0,4},{13307,6458,0,0,4},{13308,6462,0,0,4},{13309,6466,0,0,4},
{13310,6470,0,0,4},{13311,6474,0,0,3},{13470,6477,0,0,2},{13497,6479,0,0,2},
{13499,6481,0,0,2},{13535,6483,0,0,2},{13589,6485,0,0,2},{14062,6487,0,0,2},
{14076,6489,0,0,2},{14209,6491,0,0,2},{14383,6493,0,0,2},{14434,6495,0,0,2},
{14460,6497,0,0,2},{14535,6499,0,0,2},{14563,6501,0,0,2},{14620,6503,0,0,2},
{14650,6505,0,0,2},{14894,6507,0,0,2},{14956,6509,0,0,2},{15076,6511,0,0,2},
{15112,6513,0,0,2},{15129,6515,0,0,2},{15177,6517,0,0,2},{15261,6519,0,0,2},
{15384,6521,0,0,2},{15438,6523,0,0,2},{15667,6525,0,0,2},{15766,6527,0,0,2},
{16044,6529,0,0,2},{16056,6531,0,0,2},{16155,6533,0,0,2},{16380,6535,0,0,2},
{16392,6537,0,0,2},{16408,6539,0,0,2},{16441,6541,0,0,2},{16454,6543,0,0,2},
{16534,6545,0,0,2},{16611,6547,0,0,2},{16687,6549,0,0,2},{16898,6551,0,0,2},
{16935,6553,0,0,2},{17056,6555,0,0,2},{17153,6557,0,0,2},{17204,6559,0,0,2},
{17241,6561,0,0,2},{17365,6563,0,0,2},{17369,6565,0,0,2},{17419,6567,0,0,2},
{17515,6569,0,0,2},{17707,6571,0,0,2},{17757,6573,0,0,2},{17761,6575,0,0,2},
{17771,6577,0,0,2},{17879,6579,0,0,2},{17913,6581,0,0,2},{17973,6583,0,0,2},
{18110,6585,0,0,2},{18119,6587,0,0,2},{18837,6589,0,0,2},{18918,6591,0,0,2},
{19054,6593,0,0,2},{19062,6595,0,0,2},{19122,6597,0,0,2},{19251,6599,0,0,2},
{19406,6601,0,0,2},{19662,6603,0,0,2},{19693,6605,0,0,2},{19704,6607,0,0,2},
{19798,6609,0,0,2},{19981,6611,0,0,2},{20006,6613,0,0,2},{20018,6615,0,0,2},
{20024,6617,0,0,2},{20025,6619,0,0,2},{20029,6621,0,0,2},{20033,6623,0,0,2},
{20098,6625,0,0,2},{20102,6627,0,0,2},{20142,6629,0,0,2},{20160,6631,0,0,2},
{20172,6633,0,0,2},{20196,6635,0,0,2},{20320,6637,0,0,2},{20352,6639,0,0,2},
{20358,6641,0,0,2},{20363,6643,0,0,2},{20398,6645,0,0,2},{20411,6647,0,0,2},
{20415,6649,0,0,2},{20482,6651,0,0,2},{20523,6653,0,0,2},{20602,6655,0,0,2},
{20633,6657,0,0,2},{20687,6659,0,0,2},{20698,6661,0,0,2},{20711,6663,0,0,2},
{20800,6665,0,0,2},{20805,6667,0,0,2},{20813,6669,0,0,2},{20820,6671,0,0,2},
{20836,6673,0,0,2},{20839,6675,0,0,2},{20840,6677,0,0,2},{20841,6679,0,0,2},
{20845,6681,0,0,2},{20855,6683,0,0,2},{20864,6685,0,0,2},{20877,6687,0,0,2},
{20882,6689,0,0,2},{20885,6691,0,0,2},{20887,6693,0,0,2},{20900,6695,0,0,2},
{20908,6697,0,0,2},{20917,6699,0,0,2},{20919,6701,0,0,2},{20937,6703,0,0,2},
{20940,6705,0,0,2},{20956,6707,0,0,2},{20958,6709,0,0,2},{20981,6711,0,0,2},
{20995,6713,0,0,2},{20999,6715,0,0,2},{21015,6717,0,0,2},{21033,6719,0,0,2},
{21050,6721,0,0,2},{21051,6723,0,0,2},{21062,6725,0,0,2},{21106,6727,0,0,2},
{21111,6729,0,0,2},{21129,6731,0,0,2},{21147,6733,0,0,2},{21155,6735,0,0,2},
{21171,6737,0,0,2},{21191,6739,0,0,2},{21193,6741,0,0,2},{21202,6743,0,0,2},
{21214,6745,0,0,2},{21220,6747,0,0,2},{21237,6749,0,0,2},{21242,6751,0,0,2},
{21253,6753,0,0,2},{21254,6755,0,0,2},{21271,6757,0,0,2},{21311,6759,0,0,2},
{21321,6761,0,0,2},{21329,6763,0,0,2},{21338,6765,0,0,2},{21363,6767,0,0,2},
{21365,6769,0,0,2},{21373,6771,0,0,2},{21375,6773,0,0,2},{21443,6775,0,0,2},
{21450,6777,0,0,2},{21471,6779,0,0,2},{21477,6781,0,0,2},{21483,6783,0,0,2},
{21489,6785,0,0,2},{21510,6787,0,0,2},{21519,6789,0,0,2},{21533,6791,0,0,2},
{21560,6793,0,0,2},{21570,6795,0,0,2},{21576,6797,0,0,2},{21608,6799,0,0,2},
{21662,6801,0,0,2},{21666,6803,0,0,2},{21693,6805,0,0,2},{21750,6807,0,0,2},
{21776,6809,0,0,2},{21843,6811,0,0,2},{21845,6813,0,0,2},{21859,6815,0,0,2},
{21892,6817,0,0,2},{21895,6819,0,0,2},{21913,6821,0,0,2},{21917,6823,0,0,2},
{21931,6825,0,0,2},{21939,6827,0,0,2},{21952,6829,0,0,2},{21954,6831,0,0,2},
{21986,6833,0,0,2},{22022,6835,0,0,2},{22097,6837,0,0,2},{22120,6839,0,0,2},
{22132,6841,0,0,2},{22265,6843,0,0,2},{22294,6845,0,0,2},{22295,6847,0,0,2},
{22411,6849,0,0,2},{22478,6851,0,0,2},{22516,6853,0,0,2},{22541,6855,0,0,2},
{22577,6857,0,0,2},{22578,6859,0,0,2},{22592,6861,0,0,2},{22618,6863,0,0,2},
{22622,6865,0,0,2},{22696,6867,0,0,2},{22700,6869,0,0,2},{22707,6871,0,0,2},
{22744,6873,0,0,2},{22751,6875,0,0,2},{22766,6877,0,0,2},{22770,6879,0,0,2},
{22775,6881,0,0,2},{22790,6883,0,0,2},{22810,6885,0,0,2},{22818,6887,0,0,2},
{22852,6889,0,0,2},{22856,6891,0,0,2},{22865,6893,0,0,2},{22868,6895,0,0,2},
{22882,6897,0,0,2},{22899,6899,0,0,2},{23000,6901,0,0,2},{23020,6903,0,0,2},
{23067,6905,0,0,2},{23079,6907,0,0,2},{23138,6909,0,0,2},{23142,6911,0,0,2},
{23221,6913,0,0,2},{23304,6915,0,0,2},{23336,6917,0,0,2},{23358,6919,0,0,2},
{23429,6921,0,0,2},{23491,6923,0,0,2},{23512,6925,0,0,2},{23527,6927,0,0,2},
{23534,6929,0,0,2},{23539,6931,0,0,2},{23551,6933,0,0,2},{23558,6935,0,0,2},
{23586,6937,0,0,2},{23615,6939,0,0,2},{23648,6941,0,0,2},{23650,6943,0,0,2},
{23652,6945,0,0,2},{23653,6947,0,0,2},{23662,6949,0,0,2},{23693,6951,0,0,2},
{23744,6953,0,0,2},{23833,6955,0,0,2},{23875,6957,0,0,2},{23888,6959,0,0,2},
{23915,6961,0,0,2},{23918,6963,0,0,2},{23932,6965,0,0,2},{23986,6967,0,0,2},
{23994,6969,0,0,2},{24033,6971,0,0,2},{24034,6973,0,0,2},{24061,6975,0,0,2},
{24104,6977,0,0,2},{24125,6979,0,0,2},{24169,6981,0,0,2},{24180,6983,0,0,2},
{24230,6985,0,0,2},{24240,6987,0,0,2},{24243,6989,0,0,2},{24246,6991,0,0,2},
{24265,6993,0,0,2},{24266,6995,0,0,2},{24274,6997,0,0,2},{24275,6999,0,0,2},
{24281,7001,0,0,2},{24300,7003,0,0,2},{24318,7005,0,0,2},{24324,7007,0,0,2},
{24354,7009,0,0,2},{24403,7011,0,0,2},{24418,7013,0,0,2},{24425,7015,0,0,2},
{24427,7017,0,0,2},{24459,7019,0,0,2},{24474,7021,0,0,2},{24489,7023,0,0,2},
{24493,7025,0,0,2},{24525,7027,0,0,2},{24535,7029,0,0,2},{24565,7031,0,0,2},
{24569,7033,0,0,2},{24594,7035,0,0,2},{24604,7037,0,0,2},{24693,7039,0,0,2},
{24705,7041,0,0,2},{24724,7043,0,0,2},{24775,7045,0,0,2},{24792,7047,0,0,2},
{24801,7049,0,0,2},{24840,7051,0,0,2},{24900,7053,0,0,2},{24904,7055,0,0,2},
{24908,7057,0,0,2},{24910,7059,0,0,2},{24928,7061,0,0,2},{24936,7063,0,0,2},
{24954,7065,0,0,2},{24974,7067,0,0,2},{24976,7069,0,0,2},{24996,7071,0,0,2},
{25007,7073,0,0,2},{25010,7075,0,0,2},{25054,7077,0,0,2},{25074,7079,0,0,2},
{25078,7081,0,0,2},{25088,7083,0,0,2},{25104,7085,0,0,2},{25115,7087,0,0,2},
{25134,7089,0,0,2},{25140,7091,0,0,2},{25181,7093,0,0,2},{25265,7095,0,0,2},
{25289,7097,0,0,2},{25295,7099,0,0,2},{25299,7101,0,0,2},{25300,7103,0,0,2},
{25340,7105,0,0,2},{25342,7107,0,0,2},{25405,7109,0,0,2},{25424,7111,0,0,2},
{25448,7113,0,0,2},{25467,7115,0,0,2},{25475,7117,0,0,2},{25504,7119,0,0,2},
{25513,7121,0,0,2},{25540,7123,0,0,2},{25541,7125,0,0,2},{25572,7127,0,0,2},
{25628,7129,0,0,2},{25634,7131,0,0,2},{25682,7133,0,0,2},{25705,7135,0,0,2},
{25719,7137,0,0,2},{25726,7139,0,0,2},{25754,7141,0,0,2},{25757,7143,0,0,2},
{25796,7145,0,0,2},{25935,7147,0,0,2},{25942,7149,0,0,2},{25964,7151,0,0,2},
{25976,7153,0,0,2},{26009,7155,0,0,2},{26053,7157,0,0,2},{26082,7159,0,0,2},
{26083,7161,0,0,2},{26131,7163,0,0,2},{26185,7165,0,0,2},{26228,7167,0,0,2},
{26248,7169,0,0,2},{26257,7171,0,0,2},{26268,7173,0,0,2},{26292,7175,0,0,2},
{26310,7177,0,0,2},{26356,7179,0,0,2},{26360,7181,0,0,2},{26368,7183,0,0,2},
{26391,7185,0,0,2},{26395,7187,0,0,2},{26401,7189,0,0,2},{26446,7191,0,0,2},
{26451,7193,0,0,2},{26454,7195,0,0,2},{26462,7197,0,0,2},{26491,7199,0,0,2},
{26501,7201,0,0,2},{26519,7203,0,0,2},{26611,7205,0,0,2},{26618,7207,0,0,2},
{26647,7209,0,0,2},{26655,7211,0,0,2},{26706,7213,0,0,2},{26753,7215,0,0,2},
{26757,7217,0,0,2},{26766,7219,0,0,2},{26792,7221,0,0,2},{26900,7223,0,0,2},
{26946,7225,0,0,2},{27043,7227,0,0,2},{27114,7229,0,0,2},{27138,7231,0,0,2},
{27155,7233,0,0,2},{27304,7235,0,0,2},{27347,7237,0,0,2},{27355,7239,0,0,2},
{27396,7241,0,0,2},{27425,7243,0,0,2},{27476,7245,0,0,2},{27506,7247,0,0,2},
{27511,7249,0,0,2},{27513,7251,0,0,2},{27551,7253,0,0,2},{27566,7255,0,0,2},
{27578,7257,0,0,2},{27579,7259,0,0,2},{27726,7261,0,0,2},{27751,7263,0,0,2},
{27784,7265,0,0,2},{27839,7267,0,0,2},{27852,7269,0,0,2},{27853,7271,0,0,2},
{27877,7273,0,0,2},{27926,7275,0,0,2},{27931,7277,0,0,2},{27934,7279,0,0,2},
{27956,7281,0,0,2},{27966,7283,0,0,2},{27969,7285,0,0,2},{28009,7287,0,0,2},
{28010,7289,0,0,2},{28023,7291,0,0,2},{28024,7293,0,0,2},{28037,7295,0,0,2},
{28107,7297,0,0,2},{28122,7299,0,0,2},{28138,7301,0,0,2},{28153,7303,0,0,2},
{28186,7305,0,0,2},{28207,7307,0,0,2},{28270,7309,0,0,2},{28316,7311,0,0,2},
{28346,7313,0,0,2},{28359,7315,0,0,2},{28363,7317,0,0,2},{28369,7319,0,0,2},
{28379,7321,0,0,2},{28431,7323,0,0,2},{28450,7325,0,0,2},{28451,7327,0,0,2},
{28526,7329,0,0,2},{28614,7331,0,0,2},{28651,7333,0,0,2},{28670,7335,0,0,2},
{28699,7337,0,0,2},{28702,7339,0,0,2},{28729,7341,0,0,2},{28746,7343,0,0,2},
{28784,7345,0,0,2},{28791,7347,0,0,2},{28797,7349,0,0,2},{28825,7351,0,0,2},
{28845,7353,0,0,2},{28872,7355,0,0,2},{28889,7357,0,0,2},{28997,7359,0,0,2},
{29001,7361,0,0,2},{29038,7363,0,0,2},{29084,7365,0,0,2},{29134,7367,0,0,2},
{29136,7369,0,0,2},{29200,7371,0,0,2},{29211,7373,0,0,2},{29224,7375,0,0,2},
{29227,7377,0,0,2},{29237,7379,0,0,2},{29264,7381,0,0,2},{29282,7383,0,0,2},
{29312,7385,0,0,2},{29333,7387,0,0,2},{29359,7389,0,0,2},{29376,7391,0,0,2},
{29436,7393,0,0,2},{29482,7395,0,0,2},{29557,7397,0,0,2},{29562,7399,0,0,2},
{29575,7401,0,0,2},{29579,7403,0,0,2},{29605,7405,0,0,2},{29618,7407,0,0,2},
{29662,7409,0,0,2},{29702,7411,0,0,2},{29705,7413,0,0,2},{29730,7415,0,0,2},
{29767,7417,0,0,2},{29788,7419,0,0,2},{29801,7421,0,0,2},{29809,7423,0,0,2},
{29829,7425,0,0,2},{29833,7427,0,0,2},{29848,7429,0,0,2},{29898,7431,0,0,2},
{29958,7433,0,0,2},{29988,7435,0,0,2},{30011,7437,0,0,2},{30014,7439,0,0,2},
{30041,7441,0,0,2},{30053,7443,0,0,2},{30064,7445,0,0,2},{30178,7447,0,0,2},
{30224,7449,0,0,2},{30237,7451,0,0,2},{30239,7453,0,0,2},{30274,7455,0,0,2},
{30313,7457,0,0,2},{30410,7459,0,0,2},{30427,7461,0,0,2},{30439,7463,0,0,2},
{30452,7465,0,0,2},{30465,7467,0,0,2},{30494,7469,0,0,2},{30495,7471,0,0,2},
{30528,7473,0,0,2},{30538,7475,0,0,2},{30603,7477,0,0,2},{30631,7479,0,0,2},
{30798,7481,0,0,2},{30827,7483,0,0,2},{30860,7485,0,0,2},{30865,7487,0,0,2},
{30922,7489,0,0,2},{30924,7491,0,0,2},{30971,7493,0,0,2},{31018,7495,0,0,2},
{31036,7497,0,0,2},{31038,7499,0,0,2},{31048,7501,0,0,2},{31049,7503,0,0,2},
{31056,7505,0,0,2},{31062,7507,0,0,2},{31069,7509,0,0,2},{31070,7511,0,0,2},
{31077,7513,0,0,2},{31103,7515,0,0,2},{31117,7517,0,0,2},{31118,7519,0,0,2},
{31119,7521,0,0,2},{31150,7523,0,0,2},{31178,7525,0,0,2},{31211,7527,0,0,2},
{31260,7529,0,0,2},{31296,7531,0,0,2},{31306,7533,0,0,2},{31311,7535,0,0,2},
{31361,7537,0,0,2},{31409,7539,0,0,2},{31435,7541,0,0,2},{31470,7543,0,0,2},
{31520,7545,0,0,2},{31680,7547,0,0,2},{31686,7549,0,0,2},{31689,7551,0,0,2},
{31806,7553,0,0,2},{31840,7555,0,0,2},{31867,7557,0,0,2},{31890,7559,0,0,2},
{31934,7561,0,0,2},{31954,7563,0,0,2},{31958,7565,0,0,2},{31971,7567,0,0,2},
{31975,7569,0,0,2},{31976,7571,0,0,2},{32000,7573,0,0,2},{32016,7575,0,0,2},
{32034,7577,0,0,2},{32047,7579,0,0,2},{32091,7581,0,0,2},{32099,7583,0,0,2},
{32160,7585,0,0,2},{32190,7587,0,0,2},{32199,7589,0,0,2},{32244,7591,0,0,2},
{32258,7593,0,0,2},{32265,7595,0,0,2},{32311,7597,0,0,2},{32321,7599,0,0,2},
{32325,7601,0,0,2},{32574,7603,0,0,2},{32626,7605,0,0,2},{32633,7607,0,0,2},
{32634,7609,0,0,2},{32645,7611,0,0,2},{32661,7613,0,0,2},{32666,7615,0,0,2},
{32701,7617,0,0,2},{32762,7619,0,0,2},{32769,7621,0,0,2},{32773,7623,0,0,2},
{32838,7625,0,0,2},{32864,7627,0,0,2},{32879,7629,0,0,2},{32880,7631,0,0,2},
{32894,7633,0,0,2},{32907,7635,0,0,2},{32941,7637,0,0,2},{32946,7639,0,0,2},
{33027,7641,0,0,2},{33086,7643,0,0,2},{33240,7645,0,0,2},{33256,7647,0,0,2},
{33261,7649,0,0,2},{33281,7651,0,0,2},{33284,7653,0,0,2},{33304,7655,0,0,2},
{33391,7657,0,0,2},{33401,7659,0,0,2},{33419,7661,0,0,2},{33425,7663,0,0,2},
{33437,7665,0,0,2},{33457,7667,0,0,2},{33459,7669,0,0,2},{33469,7671,0,0,2},
{33509,7673,0,0,2},{33510,7675,0,0,2},{33565,7677,0,0,2},{33571,7679,0,0,2},
{33590,7681,0,0,2},{33618,7683,0,0,2},{33619,7685,0,0,2},{33635,7687,0,0,2},
{33709,7689,0,0,2},{33725,7691,0,0,2},{33737,7693,0,0,2},{33738,7695,0,0,2},
{33740,7697,0,0,2},{33756,7699,0,0,2},{33767,7701,0,0,2},{33775,7703,0,0,2},
{33777,7705,0,0,2},{33853,7707,0,0,2},{33865,7709,0,0,2},{33879,7711,0,0,2},
{34030,7713,0,0,2},{34033,7715,0,0,2},{34035,7717,0,0,2},{34044,7719,0,0,2},
{34070,7721,0,0,2},{34148,7723,0,0,2},{34253,7725,0,0,2},{34298,7727,0,0,2},
{34310,7729,0,0,2},{34322,7731,0,0,2},{34349,7733,0,0,2},{34367,7735,0,0,2},
{34384,7737,0,0,2},{34396,7739,0,0,2},{34407,7741,0,0,2},{34409,7743,0,0,2},
{34440,7745,0,0,2},{34473,7747,0,0,2},{34530,7749,0,0,2},{34574,7751,0,0,2},
{34600,7753,0,0,2},{34667,7755,0,0,2},{34681,7757,0,0,2},{34694,7759,0,0,2},
{34746,7761,0,0,2},{34785,7763,0,0,2},{34817,7765,0,0,2},{34847,7767,0,0,2},
{34892,7769,0,0,2},{34912,7771,0,0,2},{34915,7773,0,0,2},{35010,7775,0,0,2},
{35023,7777,0,0,2},{35031,7779,0,0,2},{35038,7781,0,0,2},{35041,7783,0,0,2},
{35064,7785,0,0,2},{35066,7787,0,0,2},{35088,7789,0,0,2},{35137,7791,0,0,2},
{35172,7793,0,0,2},{35206,7795,0,0,2},{35211,7797,0,0,2},{35222,7799,0,0,2},
{35488,7801,0,0,2},{35498,7803,0,0,2},{35519,7805,0,0,2},{35531,7807,0,0,2},
{35538,7809,0,0,2},{35542,7811,0,0,2},{35565,7813,0,0,2},{35576,7815,0,0,2},
{35582,7817,0,0,2},{35585,7819,0,0,2},{35641,7821,0,0,2},{35672,7823,0,0,2},
{35712,7825,0,0,2},{35722,7827,0,0,2},{35912,7829,0,0,2},{35925,7831,0,0,2},
{36011,7833,0,0,2},{36033,7835,0,0,2},{36034,7837,0,0,2},{36040,7839,0,0,2},
{36051,7841,0,0,2},{36104,7843,0,0,2},{36123,7845,0,0,2},{36215,7847,0,0,2},
{36284,7849,0,0,2},{36299,7851,0,0,2},{36335,7853,0,0,2},{36336,7855,0,0,2},
{36554,7857,0,0,2},{36564,7859,0,0,2},{36646,7861,0,0,2},{36650,7863,0,0,2},
{36664,7865,0,0,2},{36667,7867,0,0,2},{36706,7869,0,0,2},{36766,7871,0,0,2},
{36784,7873,0,0,2},{36790,7875,0,0,2},{36899,7877,0,0,2},{36920,7879,0,0,2},
{36978,7881,0,0,2},{36988,7883,0,0,2},{37007,7885,0,0,2},{37012,7887,0,0,2},
{37070,7889,0,0,2},{37086,7891,0,0,2},{37105,7893,0,0,2},{37117,7895,0,0,2},
{37137,7897,0,0,2},{37147,7899,0,0,2},{37226,7901,0,0,2},{37273,7903,0,0,2},
{37300,7905,0,0,2},{37324,7907,0,0,2},{37327,7909,0,0,2},{37329,7911,0,0,2},
{37428,7913,0,0,2},{37432,7915,0,0,2},{37494,7917,0,0,2},{37500,7919,0,0,2},
{37591,7921,0,0,2},{37592,7923,0,0,2},{37636,7925,0,0,2},{37706,7927,0,0,2},
{37881,7929,0,0,2},{37909,7931,0,0,2},{38283,7933,0,0,2},{38317,7935,0,0,2},
{38327,7937,0,0,2},{38446,7939,0,0,2},{38475,7941,0,0,2},{38477,7943,0,0,2},
{38517,7945,0,0,2},{38520,7947,0,0,2},{38524,7949,0,0,2},{38534,7951,0,0,2},
{38563,7953,0,0,2},{38583,7955,0,0,2},{38584,7957,0,0,2},{38595,7959,0,0,2},
{38626,7961,0,0,2},{38627,7963,0,0,2},{38646,7965,0,0,2},{38647,7967,0,0,2},
{38691,7969,0,0,2},{38706,7971,0,0,2},{38728,7973,0,0,2},{38742,7975,0,0,2},
{38875,7977,0,0,2},{38880,7979,0,0,2},{38911,7981,0,0,2},{38923,7983,0,0,2},
{38936,7985,0,0,2},{38953,7987,0,0,2},{38971,7989,0,0,2},{39006,7991,0,0,2},
{39138,7993,0,0,2},{39151,7995,0,0,2},{39164,7997,0,0,2},{39208,7999,0,0,2},
{39209,8001,0,0,2},{39335,8003,0,0,2},{39362,8005,0,0,2},{39409,8007,0,0,2},
{39422,8009,0,0,2},{39530,8011,0,0,2},{39698,8013,0,0,2},{39791,8015,0,0,2},
{40000,8017,0,0,2},{40023,8019,0,0,2},{40189,8021,0,0,2},{40295,8023,0,0,2},
{40372,8025,0,0,2},{40442,8027,0,0,2},{40478,8029,0,0,2},{40575,8031,0,0,2},
{40599,8033,0,0,2},{40607,8035,0,0,2},{40635,8037,0,0,2},{40654,8039,0,0,2},
{40697,8041,0,0,2},{40702,8043,0,0,2},{40709,8045,0,0,2},{40719,8047,0,0,2},
{40726,8049,0,0,2},{40763,8051,0,0,2},{40771,8053,0,0,2},{40845,8055,0,0,2},
{40846,8057,0,0,2},{40860,8059,0,0,2},{42515,8061,0,0,2},{42516,8063,0,0,2},
{42517,8065,0,0,2},{42518,8067,0,0,2},{42519,8069,0,0,2},{42520,8071,0,0,2},
{42521,8073,0,0,2},{42522,8075,0,0,2},{42523,8077,0,0,2},{42524,8079,0,0,2},
{42525,8081,0,0,2},{42526,8083,0,0,2},{42527,8085,0,0,2},{42614,8087,0,0,2},
{42792,8089,0,0,2},{42793,8091,0,0,2},{42802,8093,0,0,2},{42803,8095,0,0,2},
{42804,8097,0,0,2},{42805,8099,0,0,2},{42806,8101,0,0,2},{42807,8103,0,0,2},
{42808,8105,0,0,2},{42809,8107,0,0,2},{42810,8109,0,0,3},{42811,8112,0,0,3},
{42812,8115,0,0,2},{42813,8117,0,0,2},{42830,8119,0,0,2},{42831,8121,0,0,2},
{42842,8123,0,0,2},{42843,8125,0,0,2},{42848,8127,0,0,2},{42849,8129,0,0,2},
{42873,8131,0,0,2},{42874,8133,0,0,2},{42875,8135,0,0,2},{42876,8137,0,0,2},
{42877,8139,0,0,2},{42882,8141,0,0,2},{42883,8143,0,0,2},{42884,8145,0,0,2},
{42885,8147,0,0,2},{42886,8149,0,0,2},{42887,8151,0,0,2},{42906,8153,0,0,2},
{42907,8155,0,0,2},{42908,8157,0,0,2},{42909,8159,0,0,2},{42910,8161,0,0,2},
{42911,8163,0,0,2},{42912,8165,0,0,2},{42913,8167,0,0,2},{42914,8169,0,0,2},
{42915,8171,0,0,2},{42916,8173,0,0,2},{42917,8175,0,0,2},{42918,8177,0,0,2},
{42919,8179,0,0,2},{42920,8181,0,0,2},{42921,8183,0,0,2},{42944,8185,0,0,2},
{42945,8187,0,0,2},{42946,8189,0,0,2},{42947,8191,0,0,2},{42968,8193,0,0,2},
{42969,8195,0,0,2},{43000,8197,0,0,2},{43001,8199,0,0,3},{43701,0,4596,48,0},
{43702,0,4644,48,0},{43705,0,4692,48,0},{43707,0,4740,48,0},{43708,0,4788,48,0},
{43878,8682,0,0,2},{43879,8684,0,0,2},{64014,8686,0,0,2},{64015,8688,0,0,2},
{64017,8690,0,0,2},{64019,8692,0,0,2},{64020,8694,0,0,2},{64031,8696,0,0,2},
{64033,8698,0,0,2},{64035,8700,0,0,2},{64036,8702,0,0,2},{64039,8704,0,0,2},
{64040,8706,0,0,2},{64041,8708,0,0,2},{64256,8710,0,0,2},{64257,8712,0,0,2},
{64258,8714,0,0,2},{64259,8716,0,0,3},{64260,8719,0,0,3},{64261,8722,0,0,3},
{64262,8725,0,0,2},{64275,8727,0,0,2},{64276,8729,0,0,2},{64277,8731,0,0,2},
{64278,8733,0,0,2},{64279,8735,0,0,2},{64335,8737,0,0,2},{64420,8739,0,0,2},
{64421,8741,0,0,2},{64432,8743,0,0,2},{64433,8745,0,0,2},{64477,8747,0,0,2},
{64490,8749,0,0,2},{64491,8751,0,0,2},{64492,8753,0,0,2},{64493,8755,0,0,2},
{64494,8757,0,0,2},{64495,8759,0,0,2},{64496,8761,0,0,2},{64497,8763,0,0,2},
{64498,8765,0,0,2},{64499,8767,0,0,2},{64500,8769,0,0,2},{64501,8771,0,0,2},
{64502,8773,0,0,2},{64503,8775,0,0,2},{64504,8777,0,0,2},{64505,8779,0,0,2},
{64506,8781,0,0,2},{64507,8783,0,0,2},{64512,8785,0,0,2},{64513,8787,0,0,2},
{64514,8789,0,0,2},{64515,8791,0,0,2},{64516,8793,0,0,2},{64517,8795,0,0,2},
{64518,8797,0,0,2},{64519,8799,0,0,2},{64520,8801,0,0,2},{64521,8803,0,0,2},
{64522,8805,0,0,2},{64523,8807,0,0,2},{64524,8809,0,0,2},{64525,8811,0,0,2},
{64526,8813,0,0,2},{64527,8815,0,0,2},{64528,8817,0,0,2},{64529,8819,0,0,2},
{64530,8821,0,0,2},{64531,8823,0,0,2},{64532,8825,0,0,2},{64533,8827,0,0,2},
{64534,8829,0,0,2},{64535,8831,0,0,2},{64536,8833,0,0,2},{64537,8835,0,0,2},
{64538,8837,0,0,2},{64539,8839,0,0,2},{64540,8841,0,0,2},{64541,8843,0,0,2},
{64542,8845,0,0,2},{64543,8847,0,0,2},{64544,8849,0,0,2},{64545,8851,0,0,2},
{64546,8853,0,0,2},{64547,8855,0,0,2},{64548,8857,0,0,2},{64549,8859,0,0,2},
{64550,8861,0,0,2},{64551,8863,0,0,2},{64552,8865,0,0,2},{64553,8867,0,0,2},
{64554,8869,0,0,2},{64555,8871,0,0,2},{64556,8873,0,0,2},{64557,8875,0,0,2},
{64558,8877,0,0,2},{64559,8879,0,0,2},{64560,8881,0,0,2},{64561,8883,0,0,2},
{64562,8885,0,0,2},{64563,8887,0,0,2},{64564,8889,0,0,2},{64565,8891,0,0,2},
{64566,8893,0,0,2},{64567,8895,0,0,2},{64568,8897,0,0,2},{64569,8899,0,0,2},
{64570,8901,0,0,2},{64571,8903,0,0,2},{64572,8905,0,0,2},{64573,8907,0,0,2},
{64574,8909,0,0,2},{64575,8911,0,0,2},{64576,8913,0,0,2},{64577,8915,0,0,2},
{64578,8917,0,0,2},{64579,8919,0,0,2},{64580,8921,0,0,2},{64581,8923,0,0,2},
{64582,8925,0,0,2},{64583,8927,0,0,2},{64584,8929,0,0,2},{64585,8931,0,0,2},
{64586,8933,0,0,2},{64587,8935,0,0,2},{64588,8937,0,0,2},{64589,8939,0,0,2},
{64590,8941,0,0,2},{64591,8943,0,0,2},{64592,8945,0,0,2},{64593,8947,0,0,2},
{64594,8949,0,0,2},{64595,8951,0,0,2},{64596,8953,0,0,2},{64597,8955,0,0,2},
{64598,8957,0,0,2},{64599,8959,0,0,2},{64600,8961,0,0,2},{64601,8963,0,0,2},
{64602,8965,0,0,2},{64603,8967,0,0,2},{64604,8969,0,0,2},{64605,8971,0,0,2},
{64606,8973,0,0,2},{64607,8975,0,0,2},{64608,8977,0,0,2},{64609,8979,0,0,2},
{64610,8981,0,0,2},{64611,8983,0,0,2},{64612,8985,0,0,2},{64613,8987,0,0,2},
{64614,8989,0,0,2},{64615,8991,0,0,2},{64616,8993,0,0,2},{64617,8995,0,0,2},
{64618,8997,0,0,2},{64619,8999,0,0,2},{64620,9001,0,0,2},{64621,9003,0,0,2},
{64622,9005,0,0,2},{64623,9007,0,0,2},{64624,9009,0,0,2},{64625,9011,0,0,2},
{64626,9013,0,0,2},{64627,9015,0,0,2},{64628,9017,0,0,2},{64629,9019,0,0,2},
{64630,9021,0,0,2},{64631,9023,0,0,2},{64632,9025,0,0,2},{64633,9027,0,0,2},
{64634,9029,0,0,2},{64635,9031,0,0,2},{64636,9033,0,0,2},{64637,9035,0,0,2},
{64638,9037,0,0,2},{64639,9039,0,0,2},{64640,9041,0,0,2},{64641,9043,0,0,2},
{64642,9045,0,0,2},{64643,9047,0,0,2},{64644,9049,0,0,2},{64645,9051,0,0,2},
{64646,9053,0,0,2},{64647,9055,0,0,2},{64648,9057,0,0,2},{64649,9059,0,0,2},
{64650,9061,0,0,2},{64651,9063,0,0,2},{64652,9065,0,0,2},{64653,9067,0,0,2},
{64654,9069,0,0,2},{64655,9071,0,0,2},{64656,9073,0,0,2},{64657,9075,0,0,2},
{64658,9077,0,0,2},{64659,9079,0,0,2},{64660,9081,0,0,2},{64661,9083,0,0,2},
{64662,9085,0,0,2},{64663,9087,0,0,2},{64664,9089,0,0,2},{64665,9091,0,0,2},
{64666,9093,0,0,2},{64667,9095,0,0,2},{64668,9097,0,0,2},{64669,9099,0,0,2},
{64670,9101,0,0,2},{64671,9103,0,0,2},{64672,9105,0,0,2},{64673,9107,0,0,2},
{64674,9109,0,0,2},{64675,9111,0,0,2},{64676,9113,0,0,2},{64677,9115,0,0,2},
{64678,9117,0,0,2},{64679,9119,0,0,2},{64680,9121,0,0,2},{64681,9123,0,0,2},
{64682,9125,0,0,2},{64683,9127,0,0,2},{64684,9129,0,0,2},{64685,9131,0,0,2},
{64686,9133,0,0,2},{64687,9135,0,0,2},{64688,9137,0,0,2},{64689,9139,0,0,2},
{64690,9141,0,0,2},{64691,9143,0,0,2},{64692,9145,0,0,2},{64693,9147,0,0,2},
{64694,9149,0,0,2},{64695,9151,0,0,2},{64696,9153,0,0,2},{64697,9155,0,0,2},
{64698,9157,0,0,2},{64699,9159,0,0,2},{64700,9161,0,0,2},{64701,9163,0,0,2},
{64702,9165,0,0,2},{64703,9167,0,0,2},{64704,9169,0,0,2},{64705,9171,0,0,2},
{64706,9173,0,0,2},{64707,9175,0,0,2},{64708,9177,0,0,2},{64709,9179,0,0,2},
{64710,9181,0,0,2},{64711,9183,0,0,2},{64712,9185,0,0,2},{64713,9187,0,0,2},
{64714,9189,0,0,2},{64715,9191,0,0,2},{64716,9193,0,0,2},{64717,9195,0,0,2},
{64718,9197,0,0,2},{64719,9199,0,0,2},{64720,9201,0,0,2},{64721,9203,0,0,2},
{64722,9205,0,0,2},{64723,9207,0,0,2},{64724,9209,0,0,2},{64725,9211,0,0,2},
{64726,9213,0,0,2},{64727,9215,0,0,2},{64728,9217,0,0,2},{64729,9219,0,0,2},
{64730,9221,0,0,2},{64731,9223,0,0,2},{64732,9225,0,0,2},{64733,9227,0,0,2},
{64734,9229,0,0,2},{64735,9231,0,0,2},{64736,9233,0,0,2},{64737,9235,0,0,2},
{64738,9237,0,0,2},{64739,9239,0,0,2},{64740,9241,0,0,2},{64741,9243,0,0,2},
{64742,9245,0,0,2},{64743,9247,0,0,2},{64744,9249,0,0,2},{64745,9251,0,0,2},
{64746,9253,0,0,2},{64747,9255,0,0,2},{64748,9257,0,0,2},{64749,9259,0,0,2},
{64750,9261,0,0,2},{64751,9263,0,0,2},{64752,9265,0,0,2},{64753,9267,0,0,2},
{64754,9269,0,0,2},{64755,9271,0,0,2},{64756,9273,0,0,2},{64757,9275,0,0,2},
{64758,9277,0,0,2},{64759,9279,0,0,2},{64760,9281,0,0,2},{64761,9283,0,0,2},
{64762,9285,0,0,2},{64763,9287,0,0,2},{64764,9289,0,0,2},{64765,9291,0,0,2},
{64766,9293,0,0,2},{64767,9295,0,0,2},{64768,9297,0,0,2},{64769,9299,0,0,2},
{64770,9301,0,0,2},{64771,9303,0,0,2},{64772,9305,0,0,2},{64773,9307,0,0,2},
{64774,9309,0,0,2},{64775,9311,0,0,2},{64776,9313,0,0,2},{64777,9315,0,0,2},
{64778,9317,0,0,2},{64779,9319,0,0,2},{64780,9321,0,0,2},{64781,9323,0,0,2},
{64782,9325,0,0,2},{64783,9327,0,0,2},{64784,9329,0,0,2},{64785,9331,0,0,2},
{64786,9333,0,0,2},{64787,9335,0,0,2},{64788,9337,0,0,2},{64789,9339,0,0,2},
{64790,9341,0,0,2},{64791,9343,0,0,2},{64792,9345,0,0,2},{64793,9347,0,0,2},
{64794,9349,0,0,2},{64795,9351,0,0,2},{64796,9353,0,0,2},{64797,9355,0,0,2},
{64798,9357,0,0,2},{64799,9359,0,0,2},{64800,9361,0,0,2},{64801,9363,0,0,2},
{64802,9365,0,0,2},{64803,9367,0,0,2},{64804,9369,0,0,2},{64805,9371,0,0,2},
{64806,9373,0,0,2},{64807,9375,0,0,2},{64808,9377,0,0,2},{64809,9379,0,0,2},
{64810,9381,0,0,2},{64811,9383,0,0,2},{64812,9385,0,0,2},{64813,9387,0,0,2},
{64814,9389,0,0,2},{64815,9391,0,0,2},{64816,9393,0,0,2},{64817,9395,0,0,2},
{64818,9397,0,0,2},{64819,9399,0,0,2},{64820,9401,0,0,2},{64821,9403,0,0,2},
{64822,9405,0,0,2},{64823,9407,0,0,2},{64824,9409,0,0,2},{64825,9411,0,0,2},
{64826,9413,0,0,2},{64827,9415,0,0,2},{64828,9417,0,0,2},{64829,9419,0,0,2},
{64848,9421,0,0,3},{64849,9424,0,0,3},{64850,9427,0,0,3},{64851,9430,0,0,3},
{64852,9433,0,0,3},{64853,9436,0,0,3},{64854,9439,0,0,3},{64855,9442,0,0,3},
{64856,9445,0,0,3},{64857,9448,0,0,3},{64858,9451,0,0,3},{64859,9454,0,0,3},
{64860,9457,0,0,3},{64861,9460,0,0,3},{64862,9463,0,0,3},{64863,9466,0,0,3},
{64864,9469,0,0,3},{64865,9472,0,0,3},{64866,9475,0,0,3},{64867,9478,0,0,3},
{64868,9481,0,0,3},{64869,9484,0,0,3},{64870,9487,0,0,3},{64871,9490,0,0,3},
{64872,9493,0,0,3},{64873,9496,0,0,3},{64874,9499,0,0,3},{64875,9502,0,0,3},
{64876,9505,0,0,3},{64877,9508,0,0,3},{64878,9511,0,0,3},{64879,9514,0,0,3},
{64880,9517,0,0,3},{64881,9520,0,0,3},{64882,9523,0,0,3},{64883,9526,0,0,3},
{64884,9529,0,0,3},{64885,9532,0,0,3},{64886,9535,0,0,3},{64887,9538,0,0,3},
{64888,9541,0,0,3},{64889,9544,0,0,3},{64890,9547,0,0,3},{64891,9550,0,0,3},
{64892,9553,0,0,3},{64893,9556,0,0,3},{64894,9559,0,0,3},{64895,9562,0,0,3},
{64896,9565,0,0,3},{64897,9568,0,0,3},{64898,9571,0,0,3},{64899,9574,0,0,3},
{64900,9577,0,0,3},{64901,9580,0,0,3},{64902,9583,0,0,3},{64903,9586,0,0,3},
{64904,9589,0,0,3},{64905,9592,0,0,3},{64906,9595,0,0,3},{64907,9598,0,0,3},
{64908,9601,0,0,3},{64909,9604,0,0,3},{64910,9607,0,0,3},{64911,9610,0,0,3},
{64914,9613,0,0,3},{64915,9616,0,0,3},{64916,9619,0,0,3},{64917,9622,0,0,3},
{64918,9625,0,0,3},{64919,9628,0,0,3},{64920,9631,0,0,3},{64921,9634,0,0,3},
{64922,9637,0,0,3},{64923,9640,0,0,3},{64924,9643,0,0,3},{64925,9646,0,0,3},
{64926,9649,0,0,3},{64927,9652,0,0,3},{64928,9655,0,0,3},{64929,9658,0,0,3},
{64930,9661,0,0,3},{64931,9664,0,0,3},{64932,9667,0,0,3},{64933,9670,0,0,3},
{64934,9673,0,0,3},{64935,9676,0,0,3},{64936,9679,0,0,3},{64937,9682,0,0,3},
{64938,9685,0,0,3},{64939,9688,0,0,3},{64940,9691,0,0,3},{64941,9694,0,0,3},
{64942,9697,0,0,3},{64943,9700,0,0,3},{64944,9703,0,0,3},{64945,9706,0,0,3},
{64946,9709,0,0,3},{64947,9712,0,0,3},{64948,9715,0,0,3},{64949,9718,0,0,3},
{64950,9721,0,0,3},{64951,9724,0,0,3},{64952,9727,0,0,3},{64953,9730,0,0,3},
{64954,9733,0,0,3},{64955,9736,0,0,3},{64956,9739,0,0,3},{64957,9742,0,0,3},
{64958,9745,0,0,3},{64959,9748,0,0,3},{64960,9751,0,0,3},{64961,9754,0,0,3},
{64962,9757,0,0,3},{64963,9760,0,0,3},{64964,9763,0,0,3},{64965,9766,0,0,3},
{64966,9769,0,0,3},{64967,9772,0,0,3},{65008,9775,0,0,3},{65009,9778,0,0,3},
{65010,9781,0,0,4},{65011,9785,0,0,4},{65012,9789,0,0,4},{65013,9793,0,0,4},
{65014,9797,0,0,4},{65015,9801,0,0,4},{65016,9805,0,0,4},{65017,9809,0,0,3},
{65018,9812,0,0,18},{65019,9830,0,0,8},{65020,9838,0,0,4},{65049,9842,0,0,3},
{65072,9845,0,0,2},{65269,9847,0,0,2},{65270,9849,0,0,2},{65271,9851,0,0,2},
{65272,9853,0,0,2},{65273,9855,0,0,2},{65274,9857,0,0,2},{65275,9859,0,0,2},
{65276,9861,0,0,2},{67456,9863,0,0,2},{67459,9865,0,0,3},{67463,9868,0,0,2},
{67464,9870,0,0,2},{67465,9872,0,0,2},{67466,9874,0,0,2},{67472,9876,0,0,2},
{67477,9878,0,0,2},{67481,9880,0,0,2},{67482,9882,0,0,2},{67490,9884,0,0,2},
{67499,9886,0,0,2},{67500,9888,0,0,2},{67501,9890,0,0,2},{67502,9892,0,0,2},
{67968,9894,0,0,2},{67969,9896,0,0,2},{67970,9898,0,0,2},{67971,9900,0,0,2},
{67972,9902,0,0,2},{67973,9904,0,0,2},{67974,9906,0,0,2},{67975,9908,0,0,2},
{67976,9910,0,0,2},{67977,9912,0,0,2},{67978,9914,0,0,2},{67979,9916,0,0,2},
{67980,9918,0,0,2},{67981,9920,0,0,2},{67982,9922,0,0,2},{67983,9924,0,0,2},
{67984,9926,0,0,2},{67985,9928,0,0,2},{67986,9930,0,0,2},{67987,9932,0,0,2},
{67988,9934,0,0,2},{67989,9936,0,0,2},{67990,9938,0,0,2},{67991,9940,0,0,2},
{67992,9942,0,0,2},{67993,9944,0,0,2},{67994,9946,0,0,2},{67995,9948,0,0,2},
{67996,9950,0,0,2},{67997,9952,0,0,2},{68016,9954,0,0,2},{68296,9956,0,0,2},
{68398,9958,0,0,2},{68609,9960,0,0,2},{68612,9962,0,0,2},{68616,9964,0,0,2},
{68618,9966,0,0,2},{68620,9968,0,0,2},{68622,9970,0,0,2},{68624,9972,0,0,2},
{68626,9974,0,0,2},{68629,9976,0,0,2},{68631,9978,0,0,2},{68633,9980,0,0,2},
{68635,9982,0,0,2},{68637,9984,0,0,2},{68639,9986,0,0,2},{68645,9988,0,0,2},
{68647,9990,0,0,2},{68649,9992,0,0,2},{68651,9994,0,0,2},{68654,9996,0,0,2},
{68659,9998,0,0,2},{68661,10000,0,0,2},{68663,10002,0,0,2},{68665,10004,0,0,2},
{68667,10006,0,0,2},{68672,10008,0,0,2},{68674,10010,0,0,2},{68676,10012,0,0,2},
{68678,10014,0,0,2},{68737,10016,0,0,2},{68746,10018,0,0,2},{68747,10020,0,0,2},
{68753,10022,0,0,2},{68764,10024,0,0,2},{68766,10026,0,0,2},{68767,10028,0,0,2},
{68771,10030,0,0,2},{68779,10032,0,0,2},{68781,10034,0,0,2},{68801,10036,0,0,2},
{68810,10038,0,0,2},{68811,10040,0,0,2},{68817,10042,0,0,2},{68828,10044,0,0,2},
{68830,10046,0,0,2},{68831,10048,0,0,2},{68835,10050,0,0,2},{68843,10052,0,0,2},
{68845,10054,0,0,2},{69318,10056,0,0,2},{69392,10058,0,0,2},{69395,10060,0,0,2},
{69399,10062,0,0,2},{69404,10064,0,0,2},{69415,10066,0,0,2},{69445,10068,0,0,2},
{69622,10070,0,0,2},{69786,10072,0,0,2},{69788,10074,0,0,2},{69803,10076,0,0,2},
{71128,10078,0,0,2},{71129,10080,0,0,2},{71130,10082,0,0,2},{71131,10084,0,0,2},
{71132,10086,0,0,2},{71133,10088,0,0,2},{71429,10090,0,0,2},{71446,10092,0,0,2},
{71450,10094,0,0,2},{93844,10096,0,0,2},{93845,10098,0,0,2},{93846,10100,0,0,2},
{94194,10102,0,0,2},{94195,10104,0,0,2},{119127,0,4836,1,0},{119128,0,4837,1,0},
{119225,0,4843,1,0},{119226,0,4846,1,0},{122624,10141,0,0,3},{122642,10144,0,0,
2},{122647,10146,0,0,2},{122649,10148,0,0,2},{122652,10150,0,0,2},{122983,10152,
0,0,2},{126129,10154,0,0,2},{126130,10156,0,0,2},{126255,10158,0,0,2},{126256,
10160,0,0,2},{126257,10162,0,0,2},{126258,10164,0,0,2},{126259,10166,0,0,2},
{126260,10168,0,0,2},{126261,10170,0,0,2},{126262,10172,0,0,2},{127232,10174,0,
0,2},{127233,10176,0,0,2},{127234,10178,0,0,2},{127235,10180,0,0,2},{127236,
10182,0,0,2},{127237,10184,0,0,2},{127238,10186,0,0,2},{127239,10188,0,0,2},
{127240,10190,0,0,2},{127241,10192,0,0,2},{127242,10194,0,0,2},{127248,10196,0,
0,3},{127249,10199,0,0,3},{127250,10202,0,0,3},{127251,10205,0,0,3},{127252,
10208,0,0,3},{127253,10211,0,0,3},{127254,10214,0,0,3},{127255,10217,0,0,3},
{127256,10220,0,0,3},{127257,10223,0,0,3},{127258,10226,0,0,3},{127259,10229,0,
0,3},{127260,10232,0,0,3},{127261,10235,0,0,3},{127262,10238,0,0,3},{127263,
10241,0,0,3},{127264,10244,0,0,3},{127265,10247,0,0,3},{127266,10250,0,0,3},
{127267,10253,0,0,3},{127268,10256,0,0,3},{127269,10259,0,0,3},{127270,10262,0,
0,3},{127271,10265,0,0,3},{127272,10268,0,0,3},{127273,10271,0,0,3},{127274,
10274,0,0,3},{127277,10277,0,0,2},{127278,10279,0,0,2},{127306,10281,0,0,2},
{127307,10283,0,0,2},{127308,10285,0,0,2},{127309,10287,0,0,2},{127310,10289,0,
0,3},{127311,10292,0,0,2},{127338,10294,0,0,2},{127339,10296,0,0,2},{127340,
10298,0,0,2},{127371,10300,0,0,2},{127372,10302,0,0,2},{127373,10304,0,0,2},
{127374,10306,0,0,2},{127375,10308,0,0,2},{127376,10310,0,0,2},{127377,10312,0,
0,2},{127378,10314,0,0,4},{127379,10318,0,0,4},{127380,10322,0,0,2},{127381,
10324,0,0,3},{127382,10327,0,0,2},{127383,10329,0,0,2},{127384,10331,0,0,3},
{127385,10334,0,0,3},{127386,10337,0,0,2},{127387,10339,0,0,2},{127388,10341,0,
0,7},{127389,10348,0,0,2},{127390,10350,0,0,2},{127391,10352,0,0,2},{127392,
10354,0,0,3},{127393,10357,0,0,3},{127394,10360,0,0,4},{127395,10364,0,0,3},
{127396,10367,0,0,4},{127398,10371,0,0,2},{127399,10373,0,0,3},{127400,10376,0,
0,6},{127401,10382,0,0,8},{127402,10390,0,0,3},{127403,10393,0,0,3},{127404,
10396,0,0,3},{127488,10399,0,0,2},{127489,10401,0,0,2},{127504,10403,0,0,2},
{127505,10405,0,0,2},{127506,10407,0,0,2},{127507,10409,0,0,2},{127508,10411,0,
0,2},{127509,10413,0,0,2},{127510,10415,0,0,2},{127511,10417,0,0,2},{127512,
10419,0,0,2},{127513,10421,0,0,2},{127514,10423,0,0,2},{127515,10425,0,0,2},
{127516,10427,0,0,2},{127517,10429,0,0,2},{127518,10431,0,0,2},{127519,10433,0,
0,2},{127520,10435,0,0,2},{127521,10437,0,0,2},{127522,10439,0,0,2},{127523,
10441,0,0,2},{127524,10443,0,0,2},{127525,10445,0,0,2},{127526,10447,0,0,2},
{127527,10449,0,0,2},{127528,10451,0,0,2},{127529,10453,0,0,2},{127530,10455,0,
0,2},{127531,10457,0,0,2},{127532,10459,0,0,2},{127533,10461,0,0,2},{127534,
10463,0,0,2},{127535,10465,0,0,2},{127536,10467,0,0,2},{127537,10469,0,0,2},
{127538,10471,0,0,2},{127539,10473,0,0,2},{127540,10475,0,0,2},{127541,10477,0,
0,2},{127542,10479,0,0,2},{127543,10481,0,0,2},{127544,10483,0,0,2},{127545,
10485,0,0,2},{127546,10487,0,0,2},{127547,10489,0,0,2},{127552,10491,0,0,4},
{127553,10495,0,0,4},{127554,10499,0,0,4},{127555,10503,0,0,4},{127556,10507,0,
0,4},{127557,10511,0,0,4},{127558,10515,0,0,4},{127559,10519,0,0,4},{127560,
10523,0,0,4},{127568,10527,0,0,2},{127569,10529,0,0,2},{131362,10531,0,0,2},
{132380,10533,0,0,2},{132389,10535,0,0,2},{132427,10537,0,0,2},{132666,10539,0,
0,2},{133124,10541,0,0,2},{133342,10543,0,0,2},{133676,10545,0,0,2},{133987,
10547,0,0,2},{136420,10549,0,0,2},{136872,10551,0,0,2},{136938,10553,0,0,2},
{137672,10555,0,0,2},{138008,10557,0,0,2},{138507,10559,0,0,2},{138724,10561,0,
0,2},{138726,10563,0,0,2},{139651,10565,0,0,2},{139679,10567,0,0,2},{140081,
10569,0,0,2},{141012,10571,0,0,2},{141380,10573,0,0,2},{141386,10575,0,0,2},
{142092,10577,0,0,2},{142321,10579,0,0,2},{143370,10581,0,0,2},{144056,10583,0,
0,2},{144223,10585,0,0,2},{144275,10587,0,0,2},{144284,10589,0,0,2},{144323,
10591,0,0,2},{144341,10593,0,0,2},{144493,10595,0,0,2},{145059,10597,0,0,2},
{145575,10599,0,0,2},{146061,10601,0,0,2},{146170,10603,0,0,2},{146620,10605,0,
0,2},{146718,10607,0,0,2},{147153,10609,0,0,2},{147294,10611,0,0,2},{147342,
10613,0,0,2},{148067,10615,0,0,2},{148206,10617,0,0,2},{148395,10619,0,0,2},
{149000,10621,0,0,2},{149301,10623,0,0,2},{149524,10625,0,0,2},{150582,10627,0,
0,2},{150674,10629,0,0,2},{151457,10631,0,0,2},{151480,10633,0,0,2},{151620,
10635,0,0,2},{151794,10637,0,0,2},{151795,10639,0,0,2},{151833,10641,0,0,2},
{151859,10643,0,0,2},{152137,10645,0,0,2},{152605,10647,0,0,2},{153126,10649,0,
0,2},{153242,10651,0,0,2},{153285,10653,0,0,2},{153980,10655,0,0,2},{154279,
10657,0,0,2},{154539,10659,0,0,2},{154752,10661,0,0,2},{154832,10663,0,0,2},
{155526,10665,0,0,2},{156122,10667,0,0,2},{156200,10669,0,0,2},{156231,10671,0,
0,2},{156377,10673,0,0,2},{156478,10675,0,0,2},{156890,10677,0,0,2},{156963,
10679,0,0,2},{157096,10681,0,0,2},{157607,10683,0,0,2},{157621,10685,0,0,2},
{158524,10687,0,0,2},{158774,10689,0,0,2},{158933,10691,0,0,2},{159083,10693,0,
0,2},{159532,10695,0,0,2},{159665,10697,0,0,2},{159954,10699,0,0,2},{160714,
10701,0,0,2},{161383,10703,0,0,2},{161966,10705,0,0,2},{162150,10707,0,0,2},
{162984,10709,0,0,2},{163539,10711,0,0,2},{163631,10713,0,0,2},{165330,10715,0,
0,2},{165357,10717,0,0,2},{165678,10719,0,0,2},{166906,10721,0,0,2},{167287,
10723,0,0,2},{168261,10725,0,0,2},{168415,10727,0,0,2},{168474,10729,0,0,2},
{168970,10731,0,0,2},{169110,10733,0,0,2},{169398,10735,0,0,2},{170800,10737,0,
0,2},{172238,10739,0,0,2},{172293,10741,0,0,2},{172558,10743,0,0,2},{172689,
10745,0,0,2},{172946,10747,0,0,2},{173568,10749,0,0,2},{183,0,0,0,2},{183,2,0,0,
2},{769,649,0,0,2},{1463,811,0,0,2},{1464,813,0,0,2},{1468,815,0,0,2},{1468,817,
0,0,2},{1471,819,0,0,2},{1468,821,0,0,2},{1468,823,0,0,2},{1468,825,0,0,2},
{1465,827,0,0,2},{1468,829,0,0,2},{1468,831,0,0,2},{1468,833,0,0,2},{1460,835,0,
0,2},{1468,837,0,0,2},{1468,839,0,0,2},{1468,841,0,0,2},{1471,843,0,0,2},{1468,
845,0,0,2},{1468,847,0,0,2},{1468,849,0,0,2},{1468,851,0,0,2},{1468,853,0,0,2},
{1468,855,0,0,2},{1471,857,0,0,2},{1468,859,0,0,2},{1468,861,0,0,2},{1468,863,0,
0,2},{1468,865,3916,2,2},{1473,867,0,0,3},{1474,870,0,0,3},{1473,873,0,0,2},
{1474,875,0,0,2},{1468,877,0,0,2},{1463,889,0,0,3},{2364,932,0,0,2},{2364,934,0,
0,2},{2364,936,0,0,2},{2364,938,0,0,2},{2364,940,0,0,2},{2364,942,0,0,2},{2364,
946,0,0,2},{2364,948,0,0,2},{2492,954,0,0,2},{2492,956,0,0,2},{2492,958,0,0,2},
{2620,962,0,0,2},{2620,964,0,0,2},{2620,966,0,0,2},{2620,968,0,0,2},{2620,970,0,
0,2},{2620,972,0,0,2},{2876,974,0,0,2},{2876,976,0,0,2},{3585,1010,0,0,2},{3586,
1012,0,0,2},{3587,1014,0,0,2},{3588,1016,0,0,2},{3589,1018,0,0,2},{3590,1020,0,
0,2},{3591,1022,0,0,2},{3592,1024,0,0,2},{3593,1026,0,0,2},{3594,1028,0,0,2},
{3595,1030,0,0,2},{3596,1032,0,0,2},{3597,1034,0,0,2},{3598,1036,0,0,2},{3599,
1038,0,0,2},{3600,1040,0,0,2},{3601,1042,0,0,2},{3602,1044,0,0,2},{3603,1046,0,
0,2},{3604,1048,0,0,2},{3605,1050,0,0,2},{3606,1052,0,0,2},{3607,1054,0,0,2},
{3608,1056,0,0,2},{3609,1058,0,0,2},{3610,1060,0,0,2},{3611,1062,0,0,2},{3612,
1064,0,0,2},{3613,1066,0,0,2},{3614,1068,0,0,2},{3615,1070,0,0,2},{3616,1072,0,
0,2},{3617,1074,0,0,2},{3618,1076,0,0,2},{3619,1078,0,0,2},{3620,1080,0,0,2},
{3621,1082,0,0,2},{3622,1084,0,0,2},{3623,1086,0,0,2},{3624,1088,0,0,2},{3625,
1090,0,0,2},{3626,1092,0,0,2},{3627,1094,0,0,2},{3628,1096,0,0,2},{3629,1098,0,
0,2},{3630,1100,0,0,2},{3585,1102,0,0,2},{3586,1104,0,0,2},{3587,1106,0,0,2},
{3588,1108,0,0,2},{3589,1110,0,0,2},{3590,1112,0,0,2},{3591,1114,0,0,2},{3592,
1116,0,0,2},{3593,1118,0,0,2},{3594,1120,0,0,2},{3595,1122,0,0,2},{3596,1124,0,
0,2},{3597,1126,0,0,2},{3598,1128,0,0,2},{3599,1130,0,0,2},{3600,1132,0,0,2},
{3601,1134,0,0,2},{3602,1136,0,0,2},{3603,1138,0,0,2},{3604,1140,0,0,2},{3605,
1142,0,0,2},{3606,1144,0,0,2},{3607,1146,0,0,2},{3608,1148,0,0,2},{3609,1150,0,
0,2},{3610,1152,0,0,2},{3611,1154,0,0,2},{3612,1156,0,0,2},{3613,1158,0,0,2},
{3614,1160,0,0,2},{3615,1162,0,0,2},{3616,1164,0,0,2},{3617,1166,0,0,2},{3618,
1168,0,0,2},{3619,1170,0,0,2},{3620,1172,0,0,2},{3621,1174,0,0,2},{3622,1176,0,
0,2},{3623,1178,0,0,2},{3624,1180,0,0,2},{3625,1182,0,0,2},{3626,1184,0,0,2},
{3627,1186,0,0,2},{3628,1188,0,0,2},{3629,1190,0,0,2},{3630,1192,0,0,2},{3585,
1194,0,0,2},{3586,1196,0,0,2},{3587,1198,0,0,2},{3588,1200,0,0,2},{3589,1202,0,
0,2},{3590,1204,0,0,2},{3591,1206,0,0,2},{3592,1208,0,0,2},{3593,1210,0,0,2},
{3594,1212,0,0,2},{3595,1214,0,0,2},{3596,1216,0,0,2},{3597,1218,0,0,2},{3598,
1220,0,0,2},{3599,1222,0,0,2},{3600,1224,0,0,2},{3601,1226,0,0,2},{3602,1228,0,
0,2},{3603,1230,0,0,2},{3604,1232,0,0,2},{3605,1234,0,0,2},{3606,1236,0,0,2},
{3607,1238,0,0,2},{3608,1240,0,0,2},{3609,1242,0,0,2},{3610,1244,0,0,2},{3611,
1246,0,0,2},{3612,1248,0,0,2},{3613,1250,0,0,2},{3614,1252,0,0,2},{3615,1254,0,
0,2},{3616,1256,0,0,2},{3617,1258,0,0,2},{3618,1260,0,0,2},{3619,1262,0,0,2},
{3620,1264,0,0,2},{3621,1266,0,0,2},{3622,1268,0,0,2},{3623,1270,0,0,2},{3624,
1272,0,0,2},{3625,1274,0,0,2},{3626,1276,0,0,2},{3627,1278,0,0,2},{3628,1280,0,
0,2},{3629,1282,0,0,2},{3630,1284,0,0,2},{3585,1286,0,0,2},{3586,1288,0,0,2},
{3587,1290,0,0,2},{3588,1292,0,0,2},{3589,1294,0,0,2},{3590,1296,0,0,2},{3591,
1298,0,0,2},{3592,1300,0,0,2},{3593,1302,0,0,2},{3594,1304,0,0,2},{3595,1306,0,
0,2},{3596,1308,0,0,2},{3597,1310,0,0,2},{3598,1312,0,0,2},{3599,1314,0,0,2},
{3600,1316,0,0,2},{3601,1318,0,0,2},{3602,1320,0,0,2},{3603,1322,0,0,2},{3604,
1324,0,0,2},{3605,1326,0,0,2},{3606,1328,0,0,2},{3607,1330,0,0,2},{3608,1332,0,
0,2},{3609,1334,0,0,2},{3610,1336,0,0,2},{3611,1338,0,0,2},{3612,1340,0,0,2},
{3613,1342,0,0,2},{3614,1344,0,0,2},{3615,1346,0,0,2},{3616,1348,0,0,2},{3617,
1350,0,0,2},{3618,1352,0,0,2},{3619,1354,0,0,2},{3620,1356,0,0,2},{3621,1358,0,
0,2},{3622,1360,0,0,2},{3623,1362,0,0,2},{3624,1364,0,0,2},{3625,1366,0,0,2},
{3626,1368,0,0,2},{3627,1370,0,0,2},{3628,1372,0,0,2},{3629,1374,0,0,2},{3630,
1376,0,0,2},{3585,1378,0,0,2},{3586,1380,0,0,2},{3587,1382,0,0,2},{3588,1384,0,
0,2},{3589,1386,0,0,2},{3590,1388,0,0,2},{3591,1390,0,0,2},{3592,1392,0,0,2},
{3593,1394,0,0,2},{3594,1396,0,0,2},{3595,1398,0,0,2},{3596,1400,0,0,2},{3597,
1402,0,0,2},{3598,1404,0,0,2},{3599,1406,0,0,2},{3600,1408,0,0,2},{3601,1410,0,
0,2},{3602,1412,0,0,2},{3603,1414,0,0,2},{3604,1416,0,0,2},{3605,1418,0,0,2},
{3606,1420,0,0,2},{3607,1422,0,0,2},{3608,1424,0,0,2},{3609,1426,0,0,2},{3610,
1428,0,0,2},{3611,1430,0,0,2},{3612,1432,0,0,2},{3613,1434,0,0,2},{3614,1436,0,
0,2},{3615,1438,0,0,2},{3616,1440,0,0,2},{3617,1442,0,0,2},{3618,1444,0,0,2},
{3619,1446,0,0,2},{3620,1448,0,0,2},{3621,1450,0,0,2},{3622,1452,0,0,2},{3623,
1454,0,0,2},{3624,1456,0,0,2},{3625,1458,0,0,2},{3626,1460,0,0,2},{3627,1462,0,
0,2},{3628,1464,0,0,2},{3629,1466,0,0,2},{3630,1468,0,0,2},{3634,1470,0,0,1},
{3713,1471,0,0,2},{3714,1473,0,0,2},{3716,1475,0,0,2},{3718,1477,0,0,2},{3719,
1479,0,0,2},{3720,1481,0,0,2},{3721,1483,0,0,2},{3722,1485,0,0,2},{3724,1487,0,
0,2},{3725,1489,0,0,2},{3726,1491,0,0,2},{3727,1493,0,0,2},{3728,1495,0,0,2},
{3729,1497,0,0,2},{3730,1499,0,0,2},{3731,1501,0,0,2},{3732,1503,0,0,2},{3733,
1505,0,0,2},{3734,1507,0,0,2},{3735,1509,0,0,2},{3736,1511,0,0,2},{3737,1513,0,
0,2},{3738,1515,0,0,2},{3739,1517,0,0,2},{3740,1519,0,0,2},{3741,1521,0,0,2},
{3742,1523,0,0,2},{3743,1525,0,0,2},{3744,1527,0,0,2},{3745,1529,0,0,2},{3746,
1531,0,0,2},{3747,1533,0,0,2},{3749,1535,0,0,2},{3751,1537,0,0,2},{3752,1539,0,
0,2},{3753,1541,0,0,2},{3754,1543,0,0,2},{3755,1545,0,0,2},{3756,1547,0,0,2},
{3757,1549,0,0,2},{3758,1551,0,0,2},{3804,1553,0,0,3},{3805,1556,0,0,3},{3806,
1559,0,0,2},{3807,1561,0,0,2},{3713,1563,0,0,2},{3714,1565,0,0,2},{3716,1567,0,
0,2},{3718,1569,0,0,2},{3719,1571,0,0,2},{3720,1573,0,0,2},{3721,1575,0,0,2},
{3722,1577,0,0,2},{3724,1579,0,0,2},{3725,1581,0,0,2},{3726,1583,0,0,2},{3727,
1585,0,0,2},{3728,1587,0,0,2},{3729,1589,0,0,2},{3730,1591,0,0,2},{3731,1593,0,
0,2},{3732,1595,0,0,2},{3733,1597,0,0,2},{3734,1599,0,0,2},{3735,1601,0,0,2},
{3736,1603,0,0,2},{3737,1605,0,0,2},{3738,1607,0,0,2},{3739,1609,0,0,2},{3740,
1611,0,0,2},{3741,1613,0,0,2},{3742,1615,0,0,2},{3743,1617,0,0,2},{3744,1619,0,
0,2},{3745,1621,0,0,2},{3746,1623,0,0,2},{3747,1625,0,0,2},{3749,1627,0,0,2},
{3751,1629,0,0,2},{3752,1631,0,0,2},{3753,1633,0,0,2},{3754,1635,0,0,2},{3755,
1637,0,0,2},{3756,1639,0,0,2},{3757,1641,0,0,2},{3758,1643,0,0,2},{3804,1645,0,
0,3},{3805,1648,0,0,3},{3806,1651,0,0,2},{3807,1653,0,0,2},{3713,1655,0,0,2},
{3714,1657,0,0,2},{3716,1659,0,0,2},{3718,1661,0,0,2},{3719,1663,0,0,2},{3720,
1665,0,0,2},{3721,1667,0,0,2},{3722,1669,0,0,2},{3724,1671,0,0,2},{3725,1673,0,
0,2},{3726,1675,0,0,2},{3727,1677,0,0,2},{3728,1679,0,0,2},{3729,1681,0,0,2},
{3730,1683,0,0,2},{3731,1685,0,0,2},{3732,1687,0,0,2},{3733,1689,0,0,2},{3734,
1691,0,0,2},{3735,1693,0,0,2},{3736,1695,0,0,2},{3737,1697,0,0,2},{3738,1699,0,
0,2},{3739,1701,0,0,2},{3740,1703,0,0,2},{3741,1705,0,0,2},{3742,1707,0,0,2},
{3743,1709,0,0,2},{3744,1711,0,0,2},{3745,1713,0,0,2},{3746,1715,0,0,2},{3747,
1717,0,0,2},{3749,1719,0,0,2},{3751,1721,0,0,2},{3752,1723,0,0,2},{3753,1725,0,
0,2},{3754,1727,0,0,2},{3755,1729,0,0,2},{3756,1731,0,0,2},{3757,1733,0,0,2},
{3758,1735,0,0,2},{3804,1737,0,0,3},{3805,1740,0,0,3},{3806,1743,0,0,2},{3807,
1745,0,0,2},{3713,1747,0,0,2},{3714,1749,0,0,2},{3716,1751,0,0,2},{3718,1753,0,
0,2},{3719,1755,0,0,2},{3720,1757,0,0,2},{3721,1759,0,0,2},{3722,1761,0,0,2},
{3724,1763,0,0,2},{3725,1765,0,0,2},{3726,1767,0,0,2},{3727,1769,0,0,2},{3728,
1771,0,0,2},{3729,1773,0,0,2},{3730,1775,0,0,2},{3731,1777,0,0,2},{3732,1779,0,
0,2},{3733,1781,0,0,2},{3734,1783,0,0,2},{3735,1785,0,0,2},{3736,1787,0,0,2},
{3737,1789,0,0,2},{3738,1791,0,0,2},{3739,1793,0,0,2},{3740,1795,0,0,2},{3741,
1797,0,0,2},{3742,1799,0,0,2},{3743,1801,0,0,2},{3744,1803,0,0,2},{3745,1805,0,
0,2},{3746,1807,0,0,2},{3747,1809,0,0,2},{3749,1811,0,0,2},{3751,1813,0,0,2},
{3752,1815,0,0,2},{3753,1817,0,0,2},{3754,1819,0,0,2},{3755,1821,0,0,2},{3756,
1823,0,0,2},{3757,1825,0,0,2},{3758,1827,0,0,2},{3804,1829,0,0,3},{3805,1832,0,
0,3},{3806,1835,0,0,2},{3807,1837,0,0,2},{3713,1839,0,0,2},{3714,1841,0,0,2},
{3716,1843,0,0,2},{3718,1845,0,0,2},{3719,1847,0,0,2},{3720,1849,0,0,2},{3721,
1851,0,0,2},{3722,1853,0,0,2},{3724,1855,0,0,2},{3725,1857,0,0,2},{3726,1859,0,
0,2},{3727,1861,0,0,2},{3728,1863,0,0,2},{3729,1865,0,0,2},{3730,1867,0,0,2},
{3731,1869,0,0,2},{3732,1871,0,0,2},{3733,1873,0,0,2},{3734,1875,0,0,2},{3735,
1877,0,0,2},{3736,1879,0,0,2},{3737,1881,0,0,2},{3738,1883,0,0,2},{3739,1885,0,
0,2},{3740,1887,0,0,2},{3741,1889,0,0,2},{3742,1891,0,0,2},{3743,1893,0,0,2},
{3744,1895,0,0,2},{3745,1897,0,0,2},{3746,1899,0,0,2},{3747,1901,0,0,2},{3749,
1903,0,0,2},{3751,1905,0,0,2},{3752,1907,0,0,2},{3753,1909,0,0,2},{3754,1911,0,
0,2},{3755,1913,0,0,2},{3756,1915,0,0,2},{3757,1917,0,0,2},{3758,1919,0,0,2},
{3804,1921,0,0,3},{3805,1924,0,0,3},{3806,1927,0,0,2},{3807,1929,0,0,2},{3762,
1931,0,0,1},{4021,1939,0,0,2},{4023,1941,0,0,2},{4023,1943,0,0,2},{4023,1945,0,
0,2},{4023,1947,0,0,2},{4023,1949,0,0,2},{3954,1953,0,0,1},{3956,1954,0,0,1},
{3968,1955,0,0,1},{4021,1956,0,0,2},{4023,1958,0,0,2},{4023,1960,0,0,2},{4023,
1962,0,0,2},{4023,1964,0,0,2},{4023,1966,0,0,2},{3953,0,4414,1,0},{3968,1968,0,
0,1},{3968,1969,0,0,1},{3953,0,4417,1,0},{3968,1970,0,0,1},{3968,1971,0,0,1},
{6528,2067,0,0,2},{6529,2069,0,0,2},{6530,2071,0,0,2},{6531,2073,0,0,2},{6532,
2075,0,0,2},{6533,2077,0,0,2},{6534,2079,0,0,2},{6535,2081,0,0,2},{6536,2083,0,
0,2},{6537,2085,0,0,2},{6538,2087,0,0,2},{6539,2089,0,0,2},{6540,2091,0,0,2},
{6541,2093,0,0,2},{6542,2095,0,0,2},{6543,2097,0,0,2},{6544,2099,0,0,2},{6545,
2101,0,0,2},{6546,2103,0,0,2},{6547,2105,0,0,2},{6548,2107,0,0,2},{6549,2109,0,
0,2},{6550,2111,0,0,2},{6551,2113,0,0,2},{6552,2115,0,0,2},{6553,2117,0,0,2},
{6554,2119,0,0,2},{6555,2121,0,0,2},{6556,2123,0,0,2},{6557,2125,0,0,2},{6558,
2127,0,0,2},{6559,2129,0,0,2},{6560,2131,0,0,2},{6561,2133,0,0,2},{6562,2135,0,
0,2},{6563,2137,0,0,2},{6564,2139,0,0,2},{6565,2141,0,0,2},{6566,2143,0,0,2},
{6567,2145,0,0,2},{6568,2147,0,0,2},{6569,2149,0,0,2},{6570,2151,0,0,2},{6571,
2153,0,0,2},{6528,2155,0,0,2},{6529,2157,0,0,2},{6530,2159,0,0,2},{6531,2161,0,
0,2},{6532,2163,0,0,2},{6533,2165,0,0,2},{6534,2167,0,0,2},{6535,2169,0,0,2},
{6536,2171,0,0,2},{6537,2173,0,0,2},{6538,2175,0,0,2},{6539,2177,0,0,2},{6540,
2179,0,0,2},{6541,2181,0,0,2},{6542,2183,0,0,2},{6543,2185,0,0,2},{6544,2187,0,
0,2},{6545,2189,0,0,2},{6546,2191,0,0,2},{6547,2193,0,0,2},{6548,2195,0,0,2},
{6549,2197,0,0,2},{6550,2199,0,0,2},{6551,2201,0,0,2},{6552,2203,0,0,2},{6553,
2205,0,0,2},{6554,2207,0,0,2},{6555,2209,0,0,2},{6556,2211,0,0,2},{6557,2213,0,
0,2},{6558,2215,0,0,2},{6559,2217,0,0,2},{6560,2219,0,0,2},{6561,2221,0,0,2},
{6562,2223,0,0,2},{6563,2225,0,0,2},{6564,2227,0,0,2},{6565,2229,0,0,2},{6566,
2231,0,0,2},{6567,2233,0,0,2},{6568,2235,0,0,2},{6569,2237,0,0,2},{6570,2239,0,
0,2},{6571,2241,0,0,2},{6528,2243,0,0,2},{6529,2245,0,0,2},{6530,2247,0,0,2},
{6531,2249,0,0,2},{6532,2251,0,0,2},{6533,2253,0,0,2},{6534,2255,0,0,2},{6535,
2257,0,0,2},{6536,2259,0,0,2},{6537,2261,0,0,2},{6538,2263,0,0,2},{6539,2265,0,
0,2},{6540,2267,0,0,2},{6541,2269,0,0,2},{6542,2271,0,0,2},{6543,2273,0,0,2},
{6544,2275,0,0,2},{6545,2277,0,0,2},{6546,2279,0,0,2},{6547,2281,0,0,2},{6548,
2283,0,0,2},{6549,2285,0,0,2},{6550,2287,0,0,2},{6551,2289,0,0,2},{6552,2291,0,
0,2},{6553,2293,0,0,2},{6554,2295,0,0,2},{6555,2297,0,0,2},{6556,2299,0,0,2},
{6557,2301,0,0,2},{6558,2303,0,0,2},{6559,2305,0,0,2},{6560,2307,0,0,2},{6561,
2309,0,0,2},{6562,2311,0,0,2},{6563,2313,0,0,2},{6564,2315,0,0,2},{6565,2317,0,
0,2},{6566,2319,0,0,2},{6567,2321,0,0,2},{6568,2323,0,0,2},{6569,2325,0,0,2},
{6570,2327,0,0,2},{6571,2329,0,0,2},{6528,2331,0,0,2},{6529,2333,0,0,2},{6530,
2335,0,0,2},{6531,2337,0,0,2},{6532,2339,0,0,2},{6533,2341,0,0,2},{6534,2343,0,
0,2},{6535,2345,0,0,2},{6536,2347,0,0,2},{6537,2349,0,0,2},{6538,2351,0,0,2},
{6539,2353,0,0,2},{6540,2355,0,0,2},{6541,2357,0,0,2},{6542,2359,0,0,2},{6543,
2361,0,0,2},{6544,2363,0,0,2},{6545,2365,0,0,2},{6546,2367,0,0,2},{6547,2369,0,
0,2},{6548,2371,0,0,2},{6549,2373,0,0,2},{6550,2375,0,0,2},{6551,2377,0,0,2},
{6552,2379,0,0,2},{6553,2381,0,0,2},{6554,2383,0,0,2},{6555,2385,0,0,2},{6556,
2387,0,0,2},{6557,2389,0,0,2},{6558,2391,0,0,2},{6559,2393,0,0,2},{6560,2395,0,
0,2},{6561,2397,0,0,2},{6562,2399,0,0,2},{6563,2401,0,0,2},{6564,2403,0,0,2},
{6565,2405,0,0,2},{6566,2407,0,0,2},{6567,2409,0,0,2},{6568,2411,0,0,2},{6569,
2413,0,0,2},{6570,2415,0,0,2},{6571,2417,0,0,2},{824,4193,0,0,2},{43648,8202,0,
0,2},{43649,8204,0,0,2},{43650,8206,0,0,2},{43651,8208,0,0,2},{43652,8210,0,0,
2},{43653,8212,0,0,2},{43654,8214,0,0,2},{43655,8216,0,0,2},{43656,8218,0,0,2},
{43657,8220,0,0,2},{43658,8222,0,0,2},{43659,8224,0,0,2},{43660,8226,0,0,2},
{43661,8228,0,0,2},{43662,8230,0,0,2},{43663,8232,0,0,2},{43664,8234,0,0,2},
{43665,8236,0,0,2},{43666,8238,0,0,2},{43667,8240,0,0,2},{43668,8242,0,0,2},
{43669,8244,0,0,2},{43670,8246,0,0,2},{43671,8248,0,0,2},{43672,8250,0,0,2},
{43673,8252,0,0,2},{43674,8254,0,0,2},{43675,8256,0,0,2},{43676,8258,0,0,2},
{43677,8260,0,0,2},{43678,8262,0,0,2},{43679,8264,0,0,2},{43680,8266,0,0,2},
{43681,8268,0,0,2},{43682,8270,0,0,2},{43683,8272,0,0,2},{43684,8274,0,0,2},
{43685,8276,0,0,2},{43686,8278,0,0,2},{43687,8280,0,0,2},{43688,8282,0,0,2},
{43689,8284,0,0,2},{43690,8286,0,0,2},{43691,8288,0,0,2},{43692,8290,0,0,2},
{43693,8292,0,0,2},{43694,8294,0,0,2},{43695,8296,0,0,2},{43648,8298,0,0,2},
{43649,8300,0,0,2},{43650,8302,0,0,2},{43651,8304,0,0,2},{43652,8306,0,0,2},
{43653,8308,0,0,2},{43654,8310,0,0,2},{43655,8312,0,0,2},{43656,8314,0,0,2},
{43657,8316,0,0,2},{43658,8318,0,0,2},{43659,8320,0,0,2},{43660,8322,0,0,2},
{43661,8324,0,0,2},{43662,8326,0,0,2},{43663,8328,0,0,2},{43664,8330,0,0,2},
{43665,8332,0,0,2},{43666,8334,0,0,2},{43667,8336,0,0,2},{43668,8338,0,0,2},
{43669,8340,0,0,2},{43670,8342,0,0,2},{43671,8344,0,0,2},{43672,8346,0,0,2},
{43673,8348,0,0,2},{43674,8350,0,0,2},{43675,8352,0,0,2},{43676,8354,0,0,2},
{43677,8356,0,0,2},{43678,8358,0,0,2},{43679,8360,0,0,2},{43680,8362,0,0,2},
{43681,8364,0,0,2},{43682,8366,0,0,2},{43683,8368,0,0,2},{43684,8370,0,0,2},
{43685,8372,0,0,2},{43686,8374,0,0,2},{43687,8376,0,0,2},{43688,8378,0,0,2},
{43689,8380,0,0,2},{43690,8382,0,0,2},{43691,8384,0,0,2},{43692,8386,0,0,2},
{43693,8388,0,0,2},{43694,8390,0,0,2},{43695,8392,0,0,2},{43648,8394,0,0,2},
{43649,8396,0,0,2},{43650,8398,0,0,2},{43651,8400,0,0,2},{43652,8402,0,0,2},
{43653,8404,0,0,2},{43654,8406,0,0,2},{43655,8408,0,0,2},{43656,8410,0,0,2},
{43657,8412,0,0,2},{43658,8414,0,0,2},{43659,8416,0,0,2},{43660,8418,0,0,2},
{43661,8420,0,0,2},{43662,8422,0,0,2},{43663,8424,0,0,2},{43664,8426,0,0,2},
{43665,8428,0,0,2},{43666,8430,0,0,2},{43667,8432,0,0,2},{43668,8434,0,0,2},
{43669,8436,0,0,2},{43670,8438,0,0,2},{43671,8440,0,0,2},{43672,8442,0,0,2},
{43673,8444,0,0,2},{43674,8446,0,0,2},{43675,8448,0,0,2},{43676,8450,0,0,2},
{43677,8452,0,0,2},{43678,8454,0,0,2},{43679,8456,0,0,2},{43680,8458,0,0,2},
{43681,8460,0,0,2},{43682,8462,0,0,2},{43683,8464,0,0,2},{43684,8466,0,0,2},
{43685,8468,0,0,2},{43686,8470,0,0,2},{43687,8472,0,0,2},{43688,8474,0,0,2},
{43689,8476,0,0,2},{43690,8478,0,0,2},{43691,8480,0,0,2},{43692,8482,0,0,2},
{43693,8484,0,0,2},{43694,8486,0,0,2},{43695,8488,0,0,2},{43648,8490,0,0,2},
{43649,8492,0,0,2},{43650,8494,0,0,2},{43651,8496,0,0,2},{43652,8498,0,0,2},
{43653,8500,0,0,2},{43654,8502,0,0,2},{43655,8504,0,0,2},{43656,8506,0,0,2},
{43657,8508,0,0,2},{43658,8510,0,0,2},{43659,8512,0,0,2},{43660,8514,0,0,2},
{43661,8516,0,0,2},{43662,8518,0,0,2},{43663,8520,0,0,2},{43664,8522,0,0,2},
{43665,8524,0,0,2},{43666,8526,0,0,2},{43667,8528,0,0,2},{43668,8530,0,0,2},
{43669,8532,0,0,2},{43670,8534,0,0,2},{43671,8536,0,0,2},{43672,8538,0,0,2},
{43673,8540,0,0,2},{43674,8542,0,0,2},{43675,8544,0,0,2},{43676,8546,0,0,2},
{43677,8548,0,0,2},{43678,8550,0,0,2},{43679,8552,0,0,2},{43680,8554,0,0,2},
{43681,8556,0,0,2},{43682,8558,0,0,2},{43683,8560,0,0,2},{43684,8562,0,0,2},
{43685,8564,0,0,2},{43686,8566,0,0,2},{43687,8568,0,0,2},{43688,8570,0,0,2},
{43689,8572,0,0,2},{43690,8574,0,0,2},{43691,8576,0,0,2},{43692,8578,0,0,2},
{43693,8580,0,0,2},{43694,8582,0,0,2},{43695,8584,0,0,2},{43648,8586,0,0,2},
{43649,8588,0,0,2},{43650,8590,0,0,2},{43651,8592,0,0,2},{43652,8594,0,0,2},
{43653,8596,0,0,2},{43654,8598,0,0,2},{43655,8600,0,0,2},{43656,8602,0,0,2},
{43657,8604,0,0,2},{43658,8606,0,0,2},{43659,8608,0,0,2},{43660,8610,0,0,2},
{43661,8612,0,0,2},{43662,8614,0,0,2},{43663,8616,0,0,2},{43664,8618,0,0,2},
{43665,8620,0,0,2},{43666,8622,0,0,2},{43667,8624,0,0,2},{43668,8626,0,0,2},
{43669,8628,0,0,2},{43670,8630,0,0,2},{43671,8632,0,0,2},{43672,8634,0,0,2},
{43673,8636,0,0,2},{43674,8638,0,0,2},{43675,8640,0,0,2},{43676,8642,0,0,2},
{43677,8644,0,0,2},{43678,8646,0,0,2},{43679,8648,0,0,2},{43680,8650,0,0,2},
{43681,8652,0,0,2},{43682,8654,0,0,2},{43683,8656,0,0,2},{43684,8658,0,0,2},
{43685,8660,0,0,2},{43686,8662,0,0,2},{43687,8664,0,0,2},{43688,8666,0,0,2},
{43689,8668,0,0,2},{43690,8670,0,0,2},{43691,8672,0,0,2},{43692,8674,0,0,2},
{43693,8676,0,0,2},{43694,8678,0,0,2},{43695,8680,0,0,2},{119141,10106,0,0,2},
{119141,10108,4838,5,2},{119150,10110,0,0,3},{119151,10113,0,0,3},{119152,10116,
0,0,3},{119153,10119,0,0,3},{119154,10122,0,0,3},{119141,10125,4844,2,2},
{119150,10127,0,0,3},{119151,10130,0,0,3},{119141,10133,4847,2,2},{119150,10135,
0,0,3},{119151,10138,0,0,3}};

struct collation_key special_collation_keys[10751] = {
{9512,8,0,32},{0,2,0,287},{9512,2,0,32},{0,2,0,287},{8679,30,0,32},{1768,30,1,
32},{8682,30,0,32},{8679,30,0,32},{1768,30,1,32},{8680,30,0,32},{8681,30,0,32},
{1768,30,1,32},{8682,30,0,32},{9196,8,0,32},{0,2,0,37},{9196,8,0,32},{0,2,0,36},
{9196,8,0,32},{0,2,0,39},{9196,8,0,32},{0,2,0,45},{9196,8,0,32},{0,2,0,43},
{9196,8,0,32},{0,2,0,41},{9196,10,0,32},{0,4,0,287},{9299,10,0,32},{9248,8,0,
32},{0,2,0,48},{9299,8,0,32},{0,2,0,37},{9299,8,0,32},{0,2,0,36},{9299,8,0,32},
{0,2,0,39},{9299,8,0,32},{0,2,0,43},{9439,8,0,32},{0,2,0,37},{9439,8,0,32},{0,2,
0,36},{9439,8,0,32},{0,2,0,39},{9439,8,0,32},{0,2,0,43},{9270,10,0,32},{0,4,0,
287},{9585,8,0,32},{0,2,0,45},{9624,8,0,32},{0,2,0,37},{9624,8,0,32},{0,2,0,36},
{9624,8,0,32},{0,2,0,39},{9624,8,0,32},{0,2,0,45},{9624,8,0,32},{0,2,0,43},
{9624,8,0,32},{0,2,0,47},{9856,8,0,32},{0,2,0,37},{9856,8,0,32},{0,2,0,36},
{9856,8,0,32},{0,2,0,39},{9856,8,0,32},{0,2,0,43},{9944,8,0,32},{0,2,0,36},
{9778,4,0,32},{0,4,0,287},{9778,4,0,32},{9196,2,0,32},{0,2,0,37},{9196,2,0,32},
{0,2,0,36},{9196,2,0,32},{0,2,0,39},{9196,2,0,32},{0,2,0,45},{9196,2,0,32},{0,2,
0,43},{9196,2,0,32},{0,2,0,41},{9196,4,0,32},{0,4,0,287},{9299,4,0,32},{9248,2,
0,32},{0,2,0,48},{9299,2,0,32},{0,2,0,37},{9299,2,0,32},{0,2,0,36},{9299,2,0,
32},{0,2,0,39},{9299,2,0,32},{0,2,0,43},{9439,2,0,32},{0,2,0,37},{9439,2,0,32},
{0,2,0,36},{9439,2,0,32},{0,2,0,39},{9439,2,0,32},{0,2,0,43},{9270,4,0,32},{0,4,
0,287},{9585,2,0,32},{0,2,0,45},{9624,2,0,32},{0,2,0,37},{9624,2,0,32},{0,2,0,
36},{9624,2,0,32},{0,2,0,39},{9624,2,0,32},{0,2,0,45},{9624,2,0,32},{0,2,0,43},
{9624,2,0,32},{0,2,0,47},{9856,2,0,32},{0,2,0,37},{9856,2,0,32},{0,2,0,36},
{9856,2,0,32},{0,2,0,39},{9856,2,0,32},{0,2,0,43},{9944,2,0,32},{0,2,0,36},
{9944,2,0,32},{0,2,0,43},{9196,8,0,32},{0,2,0,50},{9196,2,0,32},{0,2,0,50},
{9196,8,0,32},{0,2,0,38},{9196,2,0,32},{0,2,0,38},{9196,8,0,32},{0,2,0,49},
{9196,2,0,32},{0,2,0,49},{9248,8,0,32},{0,2,0,36},{9248,2,0,32},{0,2,0,36},
{9248,8,0,32},{0,2,0,39},{9248,2,0,32},{0,2,0,39},{9248,8,0,32},{0,2,0,46},
{9248,2,0,32},{0,2,0,46},{9248,8,0,32},{0,2,0,40},{9248,2,0,32},{0,2,0,40},
{9270,8,0,32},{0,2,0,40},{9270,2,0,32},{0,2,0,40},{9270,8,0,32},{0,2,0,57},
{9270,2,0,32},{0,2,0,57},{9299,8,0,32},{0,2,0,50},{9299,2,0,32},{0,2,0,50},
{9299,8,0,32},{0,2,0,38},{9299,2,0,32},{0,2,0,38},{9299,8,0,32},{0,2,0,46},
{9299,2,0,32},{0,2,0,46},{9299,8,0,32},{0,2,0,49},{9299,2,0,32},{0,2,0,49},
{9299,8,0,32},{0,2,0,40},{9299,2,0,32},{0,2,0,40},{9373,8,0,32},{0,2,0,39},
{9373,2,0,32},{0,2,0,39},{9373,8,0,32},{0,2,0,38},{9373,2,0,32},{0,2,0,38},
{9373,8,0,32},{0,2,0,46},{9373,2,0,32},{0,2,0,46},{9373,8,0,32},{0,2,0,48},
{9373,2,0,32},{0,2,0,48},{9412,8,0,32},{0,2,0,39},{9412,2,0,32},{0,2,0,39},
{9412,8,0,32},{0,2,0,57},{9412,2,0,32},{0,2,0,57},{9439,8,0,32},{0,2,0,45},
{9439,2,0,32},{0,2,0,45},{9439,8,0,32},{0,2,0,50},{9439,2,0,32},{0,2,0,50},
{9439,8,0,32},{0,2,0,38},{9439,2,0,32},{0,2,0,38},{9439,8,0,32},{0,2,0,49},
{9439,2,0,32},{0,2,0,49},{9439,8,0,32},{0,2,0,46},{9439,10,0,32},{9467,10,0,32},
{9439,4,0,32},{9467,4,0,32},{9467,8,0,32},{0,2,0,39},{9467,2,0,32},{0,2,0,39},
{9492,8,0,32},{0,2,0,48},{9492,2,0,32},{0,2,0,48},{9512,8,0,32},{0,2,0,36},
{9512,2,0,32},{0,2,0,36},{9512,8,0,32},{0,2,0,48},{9512,2,0,32},{0,2,0,48},
{9512,8,0,32},{0,2,0,40},{9512,2,0,32},{0,2,0,40},{9512,8,0,32},{0,2,0,287},
{9512,2,0,32},{0,2,0,287},{9512,8,0,32},{0,2,0,57},{9512,2,0,32},{0,2,0,57},
{9585,8,0,32},{0,2,0,36},{9585,2,0,32},{0,2,0,36},{9585,8,0,32},{0,2,0,48},
{9585,2,0,32},{0,2,0,48},{9585,8,0,32},{0,2,0,40},{9585,2,0,32},{0,2,0,40},
{10062,4,0,32},{9585,4,0,32},{9624,8,0,32},{0,2,0,50},{9624,2,0,32},{0,2,0,50},
{9624,8,0,32},{0,2,0,38},{9624,2,0,32},{0,2,0,38},{9624,8,0,32},{0,2,0,44},
{9624,2,0,32},{0,2,0,44},{9624,10,0,32},{0,4,0,287},{9299,10,0,32},{9624,4,0,
32},{0,4,0,287},{9299,4,0,32},{9712,8,0,32},{0,2,0,36},{9712,2,0,32},{0,2,0,36},
{9712,8,0,32},{0,2,0,48},{9712,2,0,32},{0,2,0,48},{9712,8,0,32},{0,2,0,40},
{9712,2,0,32},{0,2,0,40},{9778,8,0,32},{0,2,0,36},{9778,2,0,32},{0,2,0,36},
{9778,8,0,32},{0,2,0,39},{9778,2,0,32},{0,2,0,39},{9778,8,0,32},{0,2,0,48},
{9778,2,0,32},{0,2,0,48},{9778,8,0,32},{0,2,0,40},{9778,2,0,32},{0,2,0,40},
{9821,8,0,32},{0,2,0,48},{9821,2,0,32},{0,2,0,48},{9821,8,0,32},{0,2,0,40},
{9821,2,0,32},{0,2,0,40},{9856,8,0,32},{0,2,0,45},{9856,2,0,32},{0,2,0,45},
{9856,8,0,32},{0,2,0,50},{9856,2,0,32},{0,2,0,50},{9856,8,0,32},{0,2,0,38},
{9856,2,0,32},{0,2,0,38},{9856,8,0,32},{0,2,0,41},{9856,2,0,32},{0,2,0,41},
{9856,8,0,32},{0,2,0,44},{9856,2,0,32},{0,2,0,44},{9856,8,0,32},{0,2,0,49},
{9856,2,0,32},{0,2,0,49},{9922,8,0,32},{0,2,0,39},{9922,2,0,32},{0,2,0,39},
{9944,8,0,32},{0,2,0,39},{9944,2,0,32},{0,2,0,39},{9944,8,0,32},{0,2,0,43},
{9966,8,0,32},{0,2,0,36},{9966,2,0,32},{0,2,0,36},{9966,8,0,32},{0,2,0,46},
{9966,2,0,32},{0,2,0,46},{9966,8,0,32},{0,2,0,40},{9966,2,0,32},{0,2,0,40},
{9778,4,0,32},{0,4,0,288},{9966,4,0,32},{9922,4,0,32},{9624,8,0,32},{0,2,0,63},
{9624,2,0,32},{0,2,0,63},{9856,8,0,32},{0,2,0,63},{9856,2,0,32},{0,2,0,63},
{9821,4,0,32},{9778,4,0,32},{9270,10,0,32},{9966,10,0,32},{0,4,0,40},{9270,10,0,
32},{9966,4,0,32},{0,4,0,40},{9270,4,0,32},{9966,4,0,32},{0,4,0,40},{9512,10,0,
32},{9467,10,0,32},{9512,10,0,32},{9467,4,0,32},{9512,4,0,32},{9467,4,0,32},
{9585,10,0,32},{9467,10,0,32},{9585,10,0,32},{9467,4,0,32},{9585,4,0,32},{9467,
4,0,32},{9196,8,0,32},{0,2,0,40},{9196,2,0,32},{0,2,0,40},{9439,8,0,32},{0,2,0,
40},{9439,2,0,32},{0,2,0,40},{9624,8,0,32},{0,2,0,40},{9624,2,0,32},{0,2,0,40},
{9856,8,0,32},{0,2,0,40},{9856,2,0,32},{0,2,0,40},{9856,8,0,32},{0,2,0,43},{0,2,
0,50},{9856,2,0,32},{0,2,0,43},{0,2,0,50},{9856,8,0,32},{0,2,0,43},{0,2,0,36},
{9856,2,0,32},{0,2,0,43},{0,2,0,36},{9856,8,0,32},{0,2,0,43},{0,2,0,40},{9856,2,
0,32},{0,2,0,43},{0,2,0,40},{9856,8,0,32},{0,2,0,43},{0,2,0,37},{9856,2,0,32},
{0,2,0,43},{0,2,0,37},{9196,8,0,32},{0,2,0,43},{0,2,0,50},{9196,2,0,32},{0,2,0,
43},{0,2,0,50},{9196,8,0,32},{0,2,0,46},{0,2,0,50},{9196,2,0,32},{0,2,0,46},{0,
2,0,50},{9196,10,0,32},{0,4,0,287},{9299,10,0,32},{0,2,0,50},{9196,4,0,32},{0,4,
0,287},{9299,4,0,32},{0,2,0,50},{9373,8,0,32},{0,2,0,40},{9373,2,0,32},{0,2,0,
40},{9492,8,0,32},{0,2,0,40},{9492,2,0,32},{0,2,0,40},{9624,8,0,32},{0,2,0,49},
{9624,2,0,32},{0,2,0,49},{9624,8,0,32},{0,2,0,49},{0,2,0,50},{9624,2,0,32},{0,2,
0,49},{0,2,0,50},{9995,8,0,32},{0,2,0,40},{9995,2,0,32},{0,2,0,40},{9467,2,0,
32},{0,2,0,40},{9270,10,0,32},{9966,10,0,32},{9270,10,0,32},{9966,4,0,32},{9270,
4,0,32},{9966,4,0,32},{9373,8,0,32},{0,2,0,36},{9373,2,0,32},{0,2,0,36},{9585,8,
0,32},{0,2,0,37},{9585,2,0,32},{0,2,0,37},{9196,8,0,32},{0,2,0,41},{0,2,0,36},
{9196,2,0,32},{0,2,0,41},{0,2,0,36},{9196,10,0,32},{0,4,0,287},{9299,10,0,32},
{0,2,0,36},{9196,4,0,32},{0,4,0,287},{9299,4,0,32},{0,2,0,36},{9624,8,0,32},{0,
2,0,47},{0,2,0,36},{9624,2,0,32},{0,2,0,47},{0,2,0,36},{9196,8,0,32},{0,2,0,60},
{9196,2,0,32},{0,2,0,60},{9196,8,0,32},{0,2,0,62},{9196,2,0,32},{0,2,0,62},
{9299,8,0,32},{0,2,0,60},{9299,2,0,32},{0,2,0,60},{9299,8,0,32},{0,2,0,62},
{9299,2,0,32},{0,2,0,62},{9439,8,0,32},{0,2,0,60},{9439,2,0,32},{0,2,0,60},
{9439,8,0,32},{0,2,0,62},{9439,2,0,32},{0,2,0,62},{9624,8,0,32},{0,2,0,60},
{9624,2,0,32},{0,2,0,60},{9624,8,0,32},{0,2,0,62},{9624,2,0,32},{0,2,0,62},
{9712,8,0,32},{0,2,0,60},{9712,2,0,32},{0,2,0,60},{9712,8,0,32},{0,2,0,62},
{9712,2,0,32},{0,2,0,62},{9856,8,0,32},{0,2,0,60},{9856,2,0,32},{0,2,0,60},
{9856,8,0,32},{0,2,0,62},{9856,2,0,32},{0,2,0,62},{9778,8,0,32},{0,2,0,69},
{9778,2,0,32},{0,2,0,69},{9821,8,0,32},{0,2,0,69},{9821,2,0,32},{0,2,0,69},
{9412,8,0,32},{0,2,0,40},{9412,2,0,32},{0,2,0,40},{9196,8,0,32},{0,2,0,46},
{9196,2,0,32},{0,2,0,46},{9299,8,0,32},{0,2,0,48},{9299,2,0,32},{0,2,0,48},
{9624,8,0,32},{0,2,0,43},{0,2,0,50},{9624,2,0,32},{0,2,0,43},{0,2,0,50},{9624,8,
0,32},{0,2,0,45},{0,2,0,50},{9624,2,0,32},{0,2,0,45},{0,2,0,50},{9624,8,0,32},
{0,2,0,46},{9624,2,0,32},{0,2,0,46},{9624,8,0,32},{0,2,0,46},{0,2,0,50},{9624,2,
0,32},{0,2,0,46},{0,2,0,50},{9944,8,0,32},{0,2,0,50},{9944,2,0,32},{0,2,0,50},
{9270,4,0,32},{9222,4,0,32},{9693,4,0,32},{9672,4,0,32},{9270,4,0,32},{9966,4,0,
32},{9270,4,0,32},{9995,4,0,32},{9270,4,0,32},{9985,4,0,32},{9821,4,0,32},{9778,
4,0,32},{9821,4,0,32},{9800,4,0,32},{9821,4,0,32},{9264,4,0,32},{9358,4,0,32},
{9617,4,0,32},{9512,4,0,32},{9778,4,0,32},{9512,4,0,32},{9966,4,0,32},{0,2,0,
43},{0,2,0,36},{1256,2,1,32},{0,2,0,36},{10125,8,0,32},{0,2,0,36},{10130,8,0,
32},{0,2,0,36},{10136,8,0,32},{0,2,0,36},{10138,8,0,32},{0,2,0,36},{10146,8,0,
32},{0,2,0,36},{10160,8,0,32},{0,2,0,36},{10165,8,0,32},{0,2,0,36},{10138,2,0,
32},{0,2,0,43},{0,2,0,36},{10138,8,0,32},{0,2,0,43},{10160,8,0,32},{0,2,0,43},
{10125,2,0,32},{0,2,0,36},{10130,2,0,32},{0,2,0,36},{10136,2,0,32},{0,2,0,36},
{10138,2,0,32},{0,2,0,36},{10160,2,0,32},{0,2,0,43},{0,2,0,36},{10138,2,0,32},
{0,2,0,43},{10160,2,0,32},{0,2,0,43},{10146,2,0,32},{0,2,0,36},{10160,2,0,32},
{0,2,0,36},{10165,2,0,32},{0,2,0,36},{10140,10,0,32},{10125,4,0,32},{10138,4,0,
32},{10160,10,0,32},{0,2,0,36},{10160,10,0,32},{0,2,0,43},{10140,4,0,32},{10125,
4,0,32},{10138,4,0,32},{10286,8,0,32},{0,2,0,37},{10286,8,0,32},{0,2,0,43},
{10250,8,0,32},{0,2,0,36},{10332,8,0,32},{0,2,0,43},{10346,8,0,32},{0,2,0,36},
{10324,8,0,32},{0,2,0,37},{10482,8,0,32},{0,2,0,38},{10286,2,0,32},{0,2,0,37},
{10286,2,0,32},{0,2,0,43},{10250,2,0,32},{0,2,0,36},{10332,2,0,32},{0,2,0,43},
{10346,2,0,32},{0,2,0,36},{10324,2,0,32},{0,2,0,37},{10482,2,0,32},{0,2,0,38},
{10668,8,0,32},{0,2,0,60},{10668,2,0,32},{0,2,0,60},{10250,10,0,32},{0,4,0,288},
{10250,4,0,32},{0,4,0,288},{10294,8,0,32},{0,2,0,38},{10294,2,0,32},{0,2,0,38},
{10230,8,0,32},{0,2,0,38},{10230,2,0,32},{0,2,0,38},{10230,8,0,32},{0,2,0,43},
{10230,2,0,32},{0,2,0,43},{10286,8,0,32},{0,2,0,38},{10286,2,0,32},{0,2,0,38},
{10234,8,0,32},{0,2,0,43},{10234,2,0,32},{0,2,0,43},{10294,8,0,32},{0,2,0,43},
{10294,2,0,32},{0,2,0,43},{10304,8,0,32},{0,2,0,43},{10304,2,0,32},{0,2,0,43},
{10324,8,0,32},{0,2,0,50},{10324,2,0,32},{0,2,0,50},{10324,8,0,32},{0,2,0,43},
{10324,2,0,32},{0,2,0,43},{10427,8,0,32},{0,2,0,43},{10427,2,0,32},{0,2,0,43},
{10431,8,0,32},{0,2,0,43},{10431,2,0,32},{0,2,0,43},{10618,8,0,32},{0,2,0,43},
{10618,2,0,32},{0,2,0,43},{10482,8,0,32},{0,2,0,50},{10482,2,0,32},{0,2,0,50},
{10482,8,0,32},{0,2,0,43},{10482,2,0,32},{0,2,0,43},{10482,8,0,32},{0,2,0,44},
{10482,2,0,32},{0,2,0,44},{10553,8,0,32},{0,2,0,43},{10553,2,0,32},{0,2,0,43},
{10601,8,0,32},{0,2,0,43},{10601,2,0,32},{0,2,0,43},{10859,4,0,32},{10889,4,0,
32},{10895,2,0,32},{0,2,0,89},{10895,2,0,32},{0,2,0,90},{10895,2,0,32},{0,2,0,
95},{10896,2,0,32},{0,2,0,95},{10896,2,0,32},{0,2,0,96},{10897,2,0,32},{0,2,0,
95},{10898,2,0,32},{0,2,0,95},{10899,2,0,32},{0,2,0,95},{10900,2,0,32},{0,2,0,
91},{10900,2,0,32},{0,2,0,95},{10901,2,0,32},{0,2,0,95},{10903,2,0,32},{0,2,0,
95},{10904,2,0,32},{0,2,0,86},{10904,2,0,32},{0,2,0,95},{10905,25,0,32},{0,2,0,
95},{10905,2,0,32},{0,2,0,95},{10905,2,0,32},{0,2,0,96},{10906,2,0,32},{0,2,0,
95},{10907,2,0,32},{0,2,0,95},{10908,2,0,32},{0,2,0,95},{10909,2,0,32},{0,2,0,
95},{10911,25,0,32},{0,2,0,95},{10911,2,0,32},{0,2,0,95},{10911,2,0,32},{0,2,0,
96},{10912,2,0,32},{0,2,0,95},{10913,2,0,32},{0,2,0,95},{10914,2,0,32},{0,2,0,
95},{10915,2,0,32},{0,2,0,95},{10915,2,0,32},{0,2,0,95},{0,2,0,94},{10915,2,0,
32},{0,2,0,95},{0,2,0,93},{10915,2,0,32},{0,2,0,94},{10915,2,0,32},{0,2,0,93},
{10916,2,0,32},{0,2,0,95},{10904,4,0,32},{10899,4,0,32},{10900,4,0,32},{10899,4,
0,32},{10900,4,0,32},{10900,4,0,32},{10900,4,0,32},{10904,4,0,32},{10904,4,0,
32},{10904,4,0,32},{10904,4,0,32},{10904,4,0,32},{0,2,0,89},{824,4,1,32},{0,4,0,
295},{827,4,1,32},{0,4,0,295},{10965,4,0,32},{10979,4,0,32},{10965,4,0,32},
{11172,4,0,32},{10965,4,0,32},{11176,4,0,32},{10965,4,0,32},{11187,4,0,32},
{11171,2,0,32},{0,2,0,131},{11168,2,0,32},{0,2,0,131},{11202,2,0,32},{0,2,0,
131},{10965,4,0,32},{0,4,0,288},{11150,4,0,32},{0,4,0,288},{11208,4,0,32},{0,4,
0,288},{11216,4,0,32},{0,4,0,288},{11226,4,0,32},{0,4,0,288},{11207,4,0,32},{0,
4,0,289},{11208,4,0,32},{0,4,0,289},{11210,4,0,32},{0,4,0,289},{11331,4,0,32},
{0,4,0,287},{11332,4,0,32},{0,4,0,287},{11334,4,0,32},{0,4,0,287},{11917,2,0,
32},{0,2,0,195},{11918,2,0,32},{0,2,0,195},{11919,2,0,32},{0,2,0,195},{11925,2,
0,32},{0,2,0,195},{11933,2,0,32},{0,2,0,195},{11935,2,0,32},{0,2,0,195},{11941,
2,0,32},{0,2,0,195},{11943,2,0,32},{0,2,0,195},{11948,2,0,32},{0,2,0,195},
{11950,2,0,32},{0,2,0,195},{11952,2,0,32},{0,2,0,195},{12018,2,0,32},{0,2,0,
195},{12019,2,0,32},{0,2,0,195},{12031,2,0,32},{0,2,0,195},{12021,4,0,32},
{12054,4,0,32},{12074,2,0,32},{0,2,0,195},{12075,2,0,32},{0,2,0,195},{12080,2,0,
32},{0,2,0,195},{12094,2,0,32},{0,2,0,195},{12101,2,0,32},{0,2,0,195},{12070,2,
0,32},{0,2,0,195},{12209,2,0,32},{0,2,0,195},{12210,2,0,32},{0,2,0,195},{12348,
4,0,32},{12371,4,0,32},{12344,4,0,32},{12358,4,0,32},{12337,4,0,32},{12371,4,0,
32},{12420,4,0,32},{12445,4,0,32},{12416,4,0,32},{12432,4,0,32},{12409,4,0,32},
{12445,4,0,32},{12492,4,0,32},{12521,4,0,32},{12490,4,0,32},{12521,4,0,32},
{12491,4,0,32},{12521,4,0,32},{12500,4,0,32},{12521,4,0,32},{12479,4,0,32},
{12521,4,0,32},{12484,4,0,32},{12521,4,0,32},{12492,4,0,32},{12521,4,0,32},
{12493,4,0,32},{12521,4,0,32},{12499,4,0,32},{12521,4,0,32},{12465,4,0,32},
{12521,4,0,32},{14139,2,0,32},{14197,2,0,32},{14140,2,0,32},{14197,2,0,32},
{14141,2,0,32},{14197,2,0,32},{14142,2,0,32},{14197,2,0,32},{14143,2,0,32},
{14197,2,0,32},{14144,2,0,32},{14197,2,0,32},{14145,2,0,32},{14197,2,0,32},
{14146,2,0,32},{14197,2,0,32},{14147,2,0,32},{14197,2,0,32},{14148,2,0,32},
{14197,2,0,32},{14149,2,0,32},{14197,2,0,32},{14150,2,0,32},{14197,2,0,32},
{14151,2,0,32},{14197,2,0,32},{14152,2,0,32},{14197,2,0,32},{14153,2,0,32},
{14197,2,0,32},{14154,2,0,32},{14197,2,0,32},{14155,2,0,32},{14197,2,0,32},
{14156,2,0,32},{14197,2,0,32},{14157,2,0,32},{14197,2,0,32},{14158,2,0,32},
{14197,2,0,32},{14159,2,0,32},{14197,2,0,32},{14160,2,0,32},{14197,2,0,32},
{14161,2,0,32},{14197,2,0,32},{14162,2,0,32},{14197,2,0,32},{14163,2,0,32},
{14197,2,0,32},{14164,2,0,32},{14197,2,0,32},{14165,2,0,32},{14197,2,0,32},
{14166,2,0,32},{14197,2,0,32},{14167,2,0,32},{14197,2,0,32},{14168,2,0,32},
{14197,2,0,32},{14169,2,0,32},{14197,2,0,32},{14170,2,0,32},{14197,2,0,32},
{14171,2,0,32},{14197,2,0,32},{14172,2,0,32},{14197,2,0,32},{14173,2,0,32},
{14197,2,0,32},{14174,2,0,32},{14197,2,0,32},{14175,2,0,32},{14197,2,0,32},
{14176,2,0,32},{14197,2,0,32},{14177,2,0,32},{14197,2,0,32},{14178,2,0,32},
{14197,2,0,32},{14179,2,0,32},{14197,2,0,32},{14180,2,0,32},{14197,2,0,32},
{14181,2,0,32},{14197,2,0,32},{14182,2,0,32},{14197,2,0,32},{14183,2,0,32},
{14197,2,0,32},{14184,2,0,32},{14197,2,0,32},{14139,2,0,32},{14198,2,0,32},
{14140,2,0,32},{14198,2,0,32},{14141,2,0,32},{14198,2,0,32},{14142,2,0,32},
{14198,2,0,32},{14143,2,0,32},{14198,2,0,32},{14144,2,0,32},{14198,2,0,32},
{14145,2,0,32},{14198,2,0,32},{14146,2,0,32},{14198,2,0,32},{14147,2,0,32},
{14198,2,0,32},{14148,2,0,32},{14198,2,0,32},{14149,2,0,32},{14198,2,0,32},
{14150,2,0,32},{14198,2,0,32},{14151,2,0,32},{14198,2,0,32},{14152,2,0,32},
{14198,2,0,32},{14153,2,0,32},{14198,2,0,32},{14154,2,0,32},{14198,2,0,32},
{14155,2,0,32},{14198,2,0,32},{14156,2,0,32},{14198,2,0,32},{14157,2,0,32},
{14198,2,0,32},{14158,2,0,32},{14198,2,0,32},{14159,2,0,32},{14198,2,0,32},
{14160,2,0,32},{14198,2,0,32},{14161,2,0,32},{14198,2,0,32},{14162,2,0,32},
{14198,2,0,32},{14163,2,0,32},{14198,2,0,32},{14164,2,0,32},{14198,2,0,32},
{14165,2,0,32},{14198,2,0,32},{14166,2,0,32},{14198,2,0,32},{14167,2,0,32},
{14198,2,0,32},{14168,2,0,32},{14198,2,0,32},{14169,2,0,32},{14198,2,0,32},
{14170,2,0,32},{14198,2,0,32},{14171,2,0,32},{14198,2,0,32},{14172,2,0,32},
{14198,2,0,32},{14173,2,0,32},{14198,2,0,32},{14174,2,0,32},{14198,2,0,32},
{14175,2,0,32},{14198,2,0,32},{14176,2,0,32},{14198,2,0,32},{14177,2,0,32},
{14198,2,0,32},{14178,2,0,32},{14198,2,0,32},{14179,2,0,32},{14198,2,0,32},
{14180,2,0,32},{14198,2,0,32},{14181,2,0,32},{14198,2,0,32},{14182,2,0,32},
{14198,2,0,32},{14183,2,0,32},{14198,2,0,32},{14184,2,0,32},{14198,2,0,32},
{14139,2,0,32},{14199,2,0,32},{14140,2,0,32},{14199,2,0,32},{14141,2,0,32},
{14199,2,0,32},{14142,2,0,32},{14199,2,0,32},{14143,2,0,32},{14199,2,0,32},
{14144,2,0,32},{14199,2,0,32},{14145,2,0,32},{14199,2,0,32},{14146,2,0,32},
{14199,2,0,32},{14147,2,0,32},{14199,2,0,32},{14148,2,0,32},{14199,2,0,32},
{14149,2,0,32},{14199,2,0,32},{14150,2,0,32},{14199,2,0,32},{14151,2,0,32},
{14199,2,0,32},{14152,2,0,32},{14199,2,0,32},{14153,2,0,32},{14199,2,0,32},
{14154,2,0,32},{14199,2,0,32},{14155,2,0,32},{14199,2,0,32},{14156,2,0,32},
{14199,2,0,32},{14157,2,0,32},{14199,2,0,32},{14158,2,0,32},{14199,2,0,32},
{14159,2,0,32},{14199,2,0,32},{14160,2,0,32},{14199,2,0,32},{14161,2,0,32},
{14199,2,0,32},{14162,2,0,32},{14199,2,0,32},{14163,2,0,32},{14199,2,0,32},
{14164,2,0,32},{14199,2,0,32},{14165,2,0,32},{14199,2,0,32},{14166,2,0,32},
{14199,2,0,32},{14167,2,0,32},{14199,2,0,32},{14168,2,0,32},{14199,2,0,32},
{14169,2,0,32},{14199,2,0,32},{14170,2,0,32},{14199,2,0,32},{14171,2,0,32},
{14199,2,0,32},{14172,2,0,32},{14199,2,0,32},{14173,2,0,32},{14199,2,0,32},
{14174,2,0,32},{14199,2,0,32},{14175,2,0,32},{14199,2,0,32},{14176,2,0,32},
{14199,2,0,32},{14177,2,0,32},{14199,2,0,32},{14178,2,0,32},{14199,2,0,32},
{14179,2,0,32},{14199,2,0,32},{14180,2,0,32},{14199,2,0,32},{14181,2,0,32},
{14199,2,0,32},{14182,2,0,32},{14199,2,0,32},{14183,2,0,32},{14199,2,0,32},
{14184,2,0,32},{14199,2,0,32},{14139,2,0,32},{14200,2,0,32},{14140,2,0,32},
{14200,2,0,32},{14141,2,0,32},{14200,2,0,32},{14142,2,0,32},{14200,2,0,32},
{14143,2,0,32},{14200,2,0,32},{14144,2,0,32},{14200,2,0,32},{14145,2,0,32},
{14200,2,0,32},{14146,2,0,32},{14200,2,0,32},{14147,2,0,32},{14200,2,0,32},
{14148,2,0,32},{14200,2,0,32},{14149,2,0,32},{14200,2,0,32},{14150,2,0,32},
{14200,2,0,32},{14151,2,0,32},{14200,2,0,32},{14152,2,0,32},{14200,2,0,32},
{14153,2,0,32},{14200,2,0,32},{14154,2,0,32},{14200,2,0,32},{14155,2,0,32},
{14200,2,0,32},{14156,2,0,32},{14200,2,0,32},{14157,2,0,32},{14200,2,0,32},
{14158,2,0,32},{14200,2,0,32},{14159,2,0,32},{14200,2,0,32},{14160,2,0,32},
{14200,2,0,32},{14161,2,0,32},{14200,2,0,32},{14162,2,0,32},{14200,2,0,32},
{14163,2,0,32},{14200,2,0,32},{14164,2,0,32},{14200,2,0,32},{14165,2,0,32},
{14200,2,0,32},{14166,2,0,32},{14200,2,0,32},{14167,2,0,32},{14200,2,0,32},
{14168,2,0,32},{14200,2,0,32},{14169,2,0,32},{14200,2,0,32},{14170,2,0,32},
{14200,2,0,32},{14171,2,0,32},{14200,2,0,32},{14172,2,0,32},{14200,2,0,32},
{14173,2,0,32},{14200,2,0,32},{14174,2,0,32},{14200,2,0,32},{14175,2,0,32},
{14200,2,0,32},{14176,2,0,32},{14200,2,0,32},{14177,2,0,32},{14200,2,0,32},
{14178,2,0,32},{14200,2,0,32},{14179,2,0,32},{14200,2,0,32},{14180,2,0,32},
{14200,2,0,32},{14181,2,0,32},{14200,2,0,32},{14182,2,0,32},{14200,2,0,32},
{14183,2,0,32},{14200,2,0,32},{14184,2,0,32},{14200,2,0,32},{14139,2,0,32},
{14201,2,0,32},{14140,2,0,32},{14201,2,0,32},{14141,2,0,32},{14201,2,0,32},
{14142,2,0,32},{14201,2,0,32},{14143,2,0,32},{14201,2,0,32},{14144,2,0,32},
{14201,2,0,32},{14145,2,0,32},{14201,2,0,32},{14146,2,0,32},{14201,2,0,32},
{14147,2,0,32},{14201,2,0,32},{14148,2,0,32},{14201,2,0,32},{14149,2,0,32},
{14201,2,0,32},{14150,2,0,32},{14201,2,0,32},{14151,2,0,32},{14201,2,0,32},
{14152,2,0,32},{14201,2,0,32},{14153,2,0,32},{14201,2,0,32},{14154,2,0,32},
{14201,2,0,32},{14155,2,0,32},{14201,2,0,32},{14156,2,0,32},{14201,2,0,32},
{14157,2,0,32},{14201,2,0,32},{14158,2,0,32},{14201,2,0,32},{14159,2,0,32},
{14201,2,0,32},{14160,2,0,32},{14201,2,0,32},{14161,2,0,32},{14201,2,0,32},
{14162,2,0,32},{14201,2,0,32},{14163,2,0,32},{14201,2,0,32},{14164,2,0,32},
{14201,2,0,32},{14165,2,0,32},{14201,2,0,32},{14166,2,0,32},{14201,2,0,32},
{14167,2,0,32},{14201,2,0,32},{14168,2,0,32},{14201,2,0,32},{14169,2,0,32},
{14201,2,0,32},{14170,2,0,32},{14201,2,0,32},{14171,2,0,32},{14201,2,0,32},
{14172,2,0,32},{14201,2,0,32},{14173,2,0,32},{14201,2,0,32},{14174,2,0,32},
{14201,2,0,32},{14175,2,0,32},{14201,2,0,32},{14176,2,0,32},{14201,2,0,32},
{14177,2,0,32},{14201,2,0,32},{14178,2,0,32},{14201,2,0,32},{14179,2,0,32},
{14201,2,0,32},{14180,2,0,32},{14201,2,0,32},{14181,2,0,32},{14201,2,0,32},
{14182,2,0,32},{14201,2,0,32},{14183,2,0,32},{14201,2,0,32},{14184,2,0,32},
{14201,2,0,32},{14189,2,0,32},{14204,2,0,32},{14261,2,0,32},{14205,2,0,32},
{14261,2,0,32},{14206,2,0,32},{14261,2,0,32},{14207,2,0,32},{14261,2,0,32},
{14208,2,0,32},{14261,2,0,32},{14209,2,0,32},{14261,2,0,32},{14210,2,0,32},
{14261,2,0,32},{14212,2,0,32},{14261,2,0,32},{14213,2,0,32},{14261,2,0,32},
{14216,2,0,32},{14261,2,0,32},{14214,2,0,32},{14261,2,0,32},{14217,2,0,32},
{14261,2,0,32},{14218,2,0,32},{14261,2,0,32},{14219,2,0,32},{14261,2,0,32},
{14220,2,0,32},{14261,2,0,32},{14221,2,0,32},{14261,2,0,32},{14222,2,0,32},
{14261,2,0,32},{14223,2,0,32},{14261,2,0,32},{14224,2,0,32},{14261,2,0,32},
{14225,2,0,32},{14261,2,0,32},{14226,2,0,32},{14261,2,0,32},{14227,2,0,32},
{14261,2,0,32},{14228,2,0,32},{14261,2,0,32},{14229,2,0,32},{14261,2,0,32},
{14230,2,0,32},{14261,2,0,32},{14231,2,0,32},{14261,2,0,32},{14232,2,0,32},
{14261,2,0,32},{14233,2,0,32},{14261,2,0,32},{14234,2,0,32},{14261,2,0,32},
{14235,2,0,32},{14261,2,0,32},{14236,2,0,32},{14261,2,0,32},{14237,2,0,32},
{14261,2,0,32},{14238,2,0,32},{14261,2,0,32},{14239,2,0,32},{14261,2,0,32},
{14240,2,0,32},{14261,2,0,32},{14241,2,0,32},{14261,2,0,32},{14211,2,0,32},
{14261,2,0,32},{14242,2,0,32},{14261,2,0,32},{14243,2,0,32},{14261,2,0,32},
{14244,2,0,32},{14261,2,0,32},{14245,2,0,32},{14261,2,0,32},{14242,4,0,32},
{14227,4,0,32},{14261,2,0,32},{14242,4,0,32},{14235,4,0,32},{14261,2,0,32},
{14203,2,0,32},{14261,2,0,32},{14215,2,0,32},{14261,2,0,32},{14204,2,0,32},
{14262,2,0,32},{14205,2,0,32},{14262,2,0,32},{14206,2,0,32},{14262,2,0,32},
{14207,2,0,32},{14262,2,0,32},{14208,2,0,32},{14262,2,0,32},{14209,2,0,32},
{14262,2,0,32},{14210,2,0,32},{14262,2,0,32},{14212,2,0,32},{14262,2,0,32},
{14213,2,0,32},{14262,2,0,32},{14216,2,0,32},{14262,2,0,32},{14214,2,0,32},
{14262,2,0,32},{14217,2,0,32},{14262,2,0,32},{14218,2,0,32},{14262,2,0,32},
{14219,2,0,32},{14262,2,0,32},{14220,2,0,32},{14262,2,0,32},{14221,2,0,32},
{14262,2,0,32},{14222,2,0,32},{14262,2,0,32},{14223,2,0,32},{14262,2,0,32},
{14224,2,0,32},{14262,2,0,32},{14225,2,0,32},{14262,2,0,32},{14226,2,0,32},
{14262,2,0,32},{14227,2,0,32},{14262,2,0,32},{14228,2,0,32},{14262,2,0,32},
{14229,2,0,32},{14262,2,0,32},{14230,2,0,32},{14262,2,0,32},{14231,2,0,32},
{14262,2,0,32},{14232,2,0,32},{14262,2,0,32},{14233,2,0,32},{14262,2,0,32},
{14234,2,0,32},{14262,2,0,32},{14235,2,0,32},{14262,2,0,32},{14236,2,0,32},
{14262,2,0,32},{14237,2,0,32},{14262,2,0,32},{14238,2,0,32},{14262,2,0,32},
{14239,2,0,32},{14262,2,0,32},{14240,2,0,32},{14262,2,0,32},{14241,2,0,32},
{14262,2,0,32},{14211,2,0,32},{14262,2,0,32},{14242,2,0,32},{14262,2,0,32},
{14243,2,0,32},{14262,2,0,32},{14244,2,0,32},{14262,2,0,32},{14245,2,0,32},
{14262,2,0,32},{14242,4,0,32},{14227,4,0,32},{14262,2,0,32},{14242,4,0,32},
{14235,4,0,32},{14262,2,0,32},{14203,2,0,32},{14262,2,0,32},{14215,2,0,32},
{14262,2,0,32},{14204,2,0,32},{14263,2,0,32},{14205,2,0,32},{14263,2,0,32},
{14206,2,0,32},{14263,2,0,32},{14207,2,0,32},{14263,2,0,32},{14208,2,0,32},
{14263,2,0,32},{14209,2,0,32},{14263,2,0,32},{14210,2,0,32},{14263,2,0,32},
{14212,2,0,32},{14263,2,0,32},{14213,2,0,32},{14263,2,0,32},{14216,2,0,32},
{14263,2,0,32},{14214,2,0,32},{14263,2,0,32},{14217,2,0,32},{14263,2,0,32},
{14218,2,0,32},{14263,2,0,32},{14219,2,0,32},{14263,2,0,32},{14220,2,0,32},
{14263,2,0,32},{14221,2,0,32},{14263,2,0,32},{14222,2,0,32},{14263,2,0,32},
{14223,2,0,32},{14263,2,0,32},{14224,2,0,32},{14263,2,0,32},{14225,2,0,32},
{14263,2,0,32},{14226,2,0,32},{14263,2,0,32},{14227,2,0,32},{14263,2,0,32},
{14228,2,0,32},{14263,2,0,32},{14229,2,0,32},{14263,2,0,32},{14230,2,0,32},
{14263,2,0,32},{14231,2,0,32},{14263,2,0,32},{14232,2,0,32},{14263,2,0,32},
{14233,2,0,32},{14263,2,0,32},{14234,2,0,32},{14263,2,0,32},{14235,2,0,32},
{14263,2,0,32},{14236,2,0,32},{14263,2,0,32},{14237,2,0,32},{14263,2,0,32},
{14238,2,0,32},{14263,2,0,32},{14239,2,0,32},{14263,2,0,32},{14240,2,0,32},
{14263,2,0,32},{14241,2,0,32},{14263,2,0,32},{14211,2,0,32},{14263,2,0,32},
{14242,2,0,32},{14263,2,0,32},{14243,2,0,32},{14263,2,0,32},{14244,2,0,32},
{14263,2,0,32},{14245,2,0,32},{14263,2,0,32},{14242,4,0,32},{14227,4,0,32},
{14263,2,0,32},{14242,4,0,32},{14235,4,0,32},{14263,2,0,32},{14203,2,0,32},
{14263,2,0,32},{14215,2,0,32},{14263,2,0,32},{14204,2,0,32},{14264,2,0,32},
{14205,2,0,32},{14264,2,0,32},{14206,2,0,32},{14264,2,0,32},{14207,2,0,32},
{14264,2,0,32},{14208,2,0,32},{14264,2,0,32},{14209,2,0,32},{14264,2,0,32},
{14210,2,0,32},{14264,2,0,32},{14212,2,0,32},{14264,2,0,32},{14213,2,0,32},
{14264,2,0,32},{14216,2,0,32},{14264,2,0,32},{14214,2,0,32},{14264,2,0,32},
{14217,2,0,32},{14264,2,0,32},{14218,2,0,32},{14264,2,0,32},{14219,2,0,32},
{14264,2,0,32},{14220,2,0,32},{14264,2,0,32},{14221,2,0,32},{14264,2,0,32},
{14222,2,0,32},{14264,2,0,32},{14223,2,0,32},{14264,2,0,32},{14224,2,0,32},
{14264,2,0,32},{14225,2,0,32},{14264,2,0,32},{14226,2,0,32},{14264,2,0,32},
{14227,2,0,32},{14264,2,0,32},{14228,2,0,32},{14264,2,0,32},{14229,2,0,32},
{14264,2,0,32},{14230,2,0,32},{14264,2,0,32},{14231,2,0,32},{14264,2,0,32},
{14232,2,0,32},{14264,2,0,32},{14233,2,0,32},{14264,2,0,32},{14234,2,0,32},
{14264,2,0,32},{14235,2,0,32},{14264,2,0,32},{14236,2,0,32},{14264,2,0,32},
{14237,2,0,32},{14264,2,0,32},{14238,2,0,32},{14264,2,0,32},{14239,2,0,32},
{14264,2,0,32},{14240,2,0,32},{14264,2,0,32},{14241,2,0,32},{14264,2,0,32},
{14211,2,0,32},{14264,2,0,32},{14242,2,0,32},{14264,2,0,32},{14243,2,0,32},
{14264,2,0,32},{14244,2,0,32},{14264,2,0,32},{14245,2,0,32},{14264,2,0,32},
{14242,4,0,32},{14227,4,0,32},{14264,2,0,32},{14242,4,0,32},{14235,4,0,32},
{14264,2,0,32},{14203,2,0,32},{14264,2,0,32},{14215,2,0,32},{14264,2,0,32},
{14204,2,0,32},{14265,2,0,32},{14205,2,0,32},{14265,2,0,32},{14206,2,0,32},
{14265,2,0,32},{14207,2,0,32},{14265,2,0,32},{14208,2,0,32},{14265,2,0,32},
{14209,2,0,32},{14265,2,0,32},{14210,2,0,32},{14265,2,0,32},{14212,2,0,32},
{14265,2,0,32},{14213,2,0,32},{14265,2,0,32},{14216,2,0,32},{14265,2,0,32},
{14214,2,0,32},{14265,2,0,32},{14217,2,0,32},{14265,2,0,32},{14218,2,0,32},
{14265,2,0,32},{14219,2,0,32},{14265,2,0,32},{14220,2,0,32},{14265,2,0,32},
{14221,2,0,32},{14265,2,0,32},{14222,2,0,32},{14265,2,0,32},{14223,2,0,32},
{14265,2,0,32},{14224,2,0,32},{14265,2,0,32},{14225,2,0,32},{14265,2,0,32},
{14226,2,0,32},{14265,2,0,32},{14227,2,0,32},{14265,2,0,32},{14228,2,0,32},
{14265,2,0,32},{14229,2,0,32},{14265,2,0,32},{14230,2,0,32},{14265,2,0,32},
{14231,2,0,32},{14265,2,0,32},{14232,2,0,32},{14265,2,0,32},{14233,2,0,32},
{14265,2,0,32},{14234,2,0,32},{14265,2,0,32},{14235,2,0,32},{14265,2,0,32},
{14236,2,0,32},{14265,2,0,32},{14237,2,0,32},{14265,2,0,32},{14238,2,0,32},
{14265,2,0,32},{14239,2,0,32},{14265,2,0,32},{14240,2,0,32},{14265,2,0,32},
{14241,2,0,32},{14265,2,0,32},{14211,2,0,32},{14265,2,0,32},{14242,2,0,32},
{14265,2,0,32},{14243,2,0,32},{14265,2,0,32},{14244,2,0,32},{14265,2,0,32},
{14245,2,0,32},{14265,2,0,32},{14242,4,0,32},{14227,4,0,32},{14265,2,0,32},
{14242,4,0,32},{14235,4,0,32},{14265,2,0,32},{14203,2,0,32},{14265,2,0,32},
{14215,2,0,32},{14265,2,0,32},{14250,2,0,32},{14242,4,0,32},{14227,4,0,32},
{14242,4,0,32},{14235,4,0,32},{14403,4,0,32},{14426,4,0,32},{0,4,0,197},{14333,
2,0,32},{14398,2,0,32},{14338,2,0,32},{14402,2,0,32},{14354,2,0,32},{14402,2,0,
32},{14362,2,0,32},{14402,2,0,32},{14370,2,0,32},{14402,2,0,32},{14378,2,0,32},
{14402,2,0,32},{14390,4,0,32},{0,4,0,288},{14415,2,0,32},{14419,2,0,32},{14417,
2,0,32},{14334,2,0,32},{14398,2,0,32},{14339,2,0,32},{14402,2,0,32},{14355,2,0,
32},{14402,2,0,32},{14363,2,0,32},{14402,2,0,32},{14371,2,0,32},{14402,2,0,32},
{14379,2,0,32},{14402,2,0,32},{14421,2,0,32},{14420,2,0,32},{14423,2,0,32},
{14422,2,0,32},{14381,4,0,32},{0,4,0,288},{14389,4,0,32},{0,4,0,288},{14391,4,0,
32},{0,4,0,288},{15088,4,0,32},{15145,4,0,32},{15088,4,0,32},{16893,4,0,32},{0,
4,0,287},{16894,4,0,32},{0,4,0,287},{16894,4,0,32},{0,4,0,288},{16895,4,0,32},
{0,4,0,287},{16896,4,0,32},{0,4,0,287},{16896,4,0,32},{0,4,0,288},{16896,4,0,
32},{0,4,0,289},{16896,4,0,32},{0,4,0,290},{16901,4,0,32},{0,4,0,287},{16901,4,
0,32},{0,4,0,288},{16901,4,0,32},{0,4,0,289},{16901,4,0,32},{0,4,0,290},{16905,
4,0,32},{0,4,0,287},{16905,4,0,32},{0,4,0,288},{16905,4,0,32},{0,4,0,289},
{16906,4,0,32},{0,4,0,287},{16906,4,0,32},{0,4,0,288},{16907,4,0,32},{0,4,0,
287},{16909,4,0,32},{0,4,0,287},{16910,4,0,32},{0,4,0,287},{16914,4,0,32},{0,4,
0,287},{16914,4,0,32},{0,4,0,289},{16914,4,0,32},{0,4,0,290},{16914,4,0,32},{0,
4,0,291},{16916,4,0,32},{0,4,0,287},{16916,4,0,32},{0,4,0,288},{16917,4,0,32},
{0,4,0,287},{16917,4,0,32},{0,4,0,288},{16912,4,0,32},{0,4,0,287},{16920,4,0,
32},{0,4,0,287},{16920,4,0,32},{0,4,0,288},{16921,4,0,32},{0,4,0,287},{16922,4,
0,32},{0,4,0,287},{16938,4,0,32},{0,4,0,287},{16938,4,0,32},{0,4,0,288},{16904,
4,0,32},{0,4,0,287},{16914,4,0,32},{0,4,0,288},{16910,4,0,32},{16921,4,0,32},
{16920,4,0,32},{0,4,0,287},{16920,4,0,32},{0,4,0,287},{16895,4,0,32},{16895,4,0,
32},{14720,4,0,32},{14750,4,0,32},{14723,4,0,32},{14751,4,0,32},{15365,2,0,32},
{15414,2,0,32},{15366,2,0,32},{15414,2,0,32},{15367,2,0,32},{15414,2,0,32},
{15368,2,0,32},{15414,2,0,32},{15369,2,0,32},{15414,2,0,32},{15370,2,0,32},
{15414,2,0,32},{15371,2,0,32},{15414,2,0,32},{15372,2,0,32},{15414,2,0,32},
{15373,2,0,32},{15414,2,0,32},{15374,2,0,32},{15414,2,0,32},{15375,2,0,32},
{15414,2,0,32},{15376,2,0,32},{15414,2,0,32},{15377,2,0,32},{15414,2,0,32},
{15378,2,0,32},{15414,2,0,32},{15379,2,0,32},{15414,2,0,32},{15380,2,0,32},
{15414,2,0,32},{15381,2,0,32},{15414,2,0,32},{15382,2,0,32},{15414,2,0,32},
{15383,2,0,32},{15414,2,0,32},{15384,2,0,32},{15414,2,0,32},{15385,2,0,32},
{15414,2,0,32},{15386,2,0,32},{15414,2,0,32},{15387,2,0,32},{15414,2,0,32},
{15388,2,0,32},{15414,2,0,32},{15389,2,0,32},{15414,2,0,32},{15390,2,0,32},
{15414,2,0,32},{15391,2,0,32},{15414,2,0,32},{15392,2,0,32},{15414,2,0,32},
{15393,2,0,32},{15414,2,0,32},{15394,2,0,32},{15414,2,0,32},{15395,2,0,32},
{15414,2,0,32},{15396,2,0,32},{15414,2,0,32},{15397,2,0,32},{15414,2,0,32},
{15398,2,0,32},{15414,2,0,32},{15399,2,0,32},{15414,2,0,32},{15400,2,0,32},
{15414,2,0,32},{15401,2,0,32},{15414,2,0,32},{15402,2,0,32},{15414,2,0,32},
{15403,2,0,32},{15414,2,0,32},{15404,2,0,32},{15414,2,0,32},{15405,2,0,32},
{15414,2,0,32},{15406,2,0,32},{15414,2,0,32},{15407,2,0,32},{15414,2,0,32},
{15408,2,0,32},{15414,2,0,32},{15365,2,0,32},{15415,2,0,32},{15366,2,0,32},
{15415,2,0,32},{15367,2,0,32},{15415,2,0,32},{15368,2,0,32},{15415,2,0,32},
{15369,2,0,32},{15415,2,0,32},{15370,2,0,32},{15415,2,0,32},{15371,2,0,32},
{15415,2,0,32},{15372,2,0,32},{15415,2,0,32},{15373,2,0,32},{15415,2,0,32},
{15374,2,0,32},{15415,2,0,32},{15375,2,0,32},{15415,2,0,32},{15376,2,0,32},
{15415,2,0,32},{15377,2,0,32},{15415,2,0,32},{15378,2,0,32},{15415,2,0,32},
{15379,2,0,32},{15415,2,0,32},{15380,2,0,32},{15415,2,0,32},{15381,2,0,32},
{15415,2,0,32},{15382,2,0,32},{15415,2,0,32},{15383,2,0,32},{15415,2,0,32},
{15384,2,0,32},{15415,2,0,32},{15385,2,0,32},{15415,2,0,32},{15386,2,0,32},
{15415,2,0,32},{15387,2,0,32},{15415,2,0,32},{15388,2,0,32},{15415,2,0,32},
{15389,2,0,32},{15415,2,0,32},{15390,2,0,32},{15415,2,0,32},{15391,2,0,32},
{15415,2,0,32},{15392,2,0,32},{15415,2,0,32},{15393,2,0,32},{15415,2,0,32},
{15394,2,0,32},{15415,2,0,32},{15395,2,0,32},{15415,2,0,32},{15396,2,0,32},
{15415,2,0,32},{15397,2,0,32},{15415,2,0,32},{15398,2,0,32},{15415,2,0,32},
{15399,2,0,32},{15415,2,0,32},{15400,2,0,32},{15415,2,0,32},{15401,2,0,32},
{15415,2,0,32},{15402,2,0,32},{15415,2,0,32},{15403,2,0,32},{15415,2,0,32},
{15404,2,0,32},{15415,2,0,32},{15405,2,0,32},{15415,2,0,32},{15406,2,0,32},
{15415,2,0,32},{15407,2,0,32},{15415,2,0,32},{15408,2,0,32},{15415,2,0,32},
{15365,2,0,32},{15416,2,0,32},{15366,2,0,32},{15416,2,0,32},{15367,2,0,32},
{15416,2,0,32},{15368,2,0,32},{15416,2,0,32},{15369,2,0,32},{15416,2,0,32},
{15370,2,0,32},{15416,2,0,32},{15371,2,0,32},{15416,2,0,32},{15372,2,0,32},
{15416,2,0,32},{15373,2,0,32},{15416,2,0,32},{15374,2,0,32},{15416,2,0,32},
{15375,2,0,32},{15416,2,0,32},{15376,2,0,32},{15416,2,0,32},{15377,2,0,32},
{15416,2,0,32},{15378,2,0,32},{15416,2,0,32},{15379,2,0,32},{15416,2,0,32},
{15380,2,0,32},{15416,2,0,32},{15381,2,0,32},{15416,2,0,32},{15382,2,0,32},
{15416,2,0,32},{15383,2,0,32},{15416,2,0,32},{15384,2,0,32},{15416,2,0,32},
{15385,2,0,32},{15416,2,0,32},{15386,2,0,32},{15416,2,0,32},{15387,2,0,32},
{15416,2,0,32},{15388,2,0,32},{15416,2,0,32},{15389,2,0,32},{15416,2,0,32},
{15390,2,0,32},{15416,2,0,32},{15391,2,0,32},{15416,2,0,32},{15392,2,0,32},
{15416,2,0,32},{15393,2,0,32},{15416,2,0,32},{15394,2,0,32},{15416,2,0,32},
{15395,2,0,32},{15416,2,0,32},{15396,2,0,32},{15416,2,0,32},{15397,2,0,32},
{15416,2,0,32},{15398,2,0,32},{15416,2,0,32},{15399,2,0,32},{15416,2,0,32},
{15400,2,0,32},{15416,2,0,32},{15401,2,0,32},{15416,2,0,32},{15402,2,0,32},
{15416,2,0,32},{15403,2,0,32},{15416,2,0,32},{15404,2,0,32},{15416,2,0,32},
{15405,2,0,32},{15416,2,0,32},{15406,2,0,32},{15416,2,0,32},{15407,2,0,32},
{15416,2,0,32},{15408,2,0,32},{15416,2,0,32},{15365,2,0,32},{15419,2,0,32},
{15366,2,0,32},{15419,2,0,32},{15367,2,0,32},{15419,2,0,32},{15368,2,0,32},
{15419,2,0,32},{15369,2,0,32},{15419,2,0,32},{15370,2,0,32},{15419,2,0,32},
{15371,2,0,32},{15419,2,0,32},{15372,2,0,32},{15419,2,0,32},{15373,2,0,32},
{15419,2,0,32},{15374,2,0,32},{15419,2,0,32},{15375,2,0,32},{15419,2,0,32},
{15376,2,0,32},{15419,2,0,32},{15377,2,0,32},{15419,2,0,32},{15378,2,0,32},
{15419,2,0,32},{15379,2,0,32},{15419,2,0,32},{15380,2,0,32},{15419,2,0,32},
{15381,2,0,32},{15419,2,0,32},{15382,2,0,32},{15419,2,0,32},{15383,2,0,32},
{15419,2,0,32},{15384,2,0,32},{15419,2,0,32},{15385,2,0,32},{15419,2,0,32},
{15386,2,0,32},{15419,2,0,32},{15387,2,0,32},{15419,2,0,32},{15388,2,0,32},
{15419,2,0,32},{15389,2,0,32},{15419,2,0,32},{15390,2,0,32},{15419,2,0,32},
{15391,2,0,32},{15419,2,0,32},{15392,2,0,32},{15419,2,0,32},{15393,2,0,32},
{15419,2,0,32},{15394,2,0,32},{15419,2,0,32},{15395,2,0,32},{15419,2,0,32},
{15396,2,0,32},{15419,2,0,32},{15397,2,0,32},{15419,2,0,32},{15398,2,0,32},
{15419,2,0,32},{15399,2,0,32},{15419,2,0,32},{15400,2,0,32},{15419,2,0,32},
{15401,2,0,32},{15419,2,0,32},{15402,2,0,32},{15419,2,0,32},{15403,2,0,32},
{15419,2,0,32},{15404,2,0,32},{15419,2,0,32},{15405,2,0,32},{15419,2,0,32},
{15406,2,0,32},{15419,2,0,32},{15407,2,0,32},{15419,2,0,32},{15408,2,0,32},
{15419,2,0,32},{15393,4,0,32},{15415,4,0,32},{15393,4,0,32},{15415,4,0,32},
{15426,4,0,32},{15473,4,0,32},{15511,4,0,32},{15473,4,0,32},{9373,4,0,32},{0,4,
0,288},{9712,4,0,32},{0,4,0,288},{9821,4,0,32},{0,4,0,288},{15658,4,0,32},
{15704,4,0,32},{15660,4,0,32},{9196,20,0,32},{0,20,0,287},{9299,20,0,32},{9373,
4,0,32},{0,4,0,288},{9821,4,0,32},{0,4,0,287},{9412,4,0,32},{9270,20,0,32},{0,
20,0,287},{9196,4,0,32},{0,4,0,287},{9196,4,0,32},{0,4,0,287},{9299,4,0,32},
{9196,4,0,32},{9624,4,0,32},{9196,4,0,32},{9904,4,0,32},{9248,4,0,32},{0,4,0,
48},{9270,4,0,32},{0,4,0,288},{9270,4,0,32},{0,4,0,287},{9712,4,0,32},{0,4,0,
289},{9778,4,0,32},{0,4,0,288},{9624,4,0,32},{0,4,0,52},{9856,4,0,32},{0,4,0,
52},{9196,4,0,32},{0,4,0,43},{9624,4,0,32},{0,4,0,43},{9856,4,0,32},{0,4,0,43},
{9196,8,0,32},{0,2,0,68},{9196,2,0,32},{0,2,0,68},{9222,8,0,32},{0,2,0,46},
{9222,2,0,32},{0,2,0,46},{9222,8,0,32},{0,2,0,66},{9222,2,0,32},{0,2,0,66},
{9222,8,0,32},{0,2,0,73},{9222,2,0,32},{0,2,0,73},{9248,8,0,32},{0,2,0,48},{0,2,
0,36},{9248,2,0,32},{0,2,0,48},{0,2,0,36},{9270,8,0,32},{0,2,0,46},{9270,2,0,
32},{0,2,0,46},{9270,8,0,32},{0,2,0,66},{9270,2,0,32},{0,2,0,66},{9270,8,0,32},
{0,2,0,73},{9270,2,0,32},{0,2,0,73},{9270,8,0,32},{0,2,0,48},{9270,2,0,32},{0,2,
0,48},{9270,8,0,32},{0,2,0,70},{9270,2,0,32},{0,2,0,70},{9299,8,0,32},{0,2,0,
50},{0,2,0,37},{9299,2,0,32},{0,2,0,50},{0,2,0,37},{9299,8,0,32},{0,2,0,50},{0,
2,0,36},{9299,2,0,32},{0,2,0,50},{0,2,0,36},{9299,8,0,32},{0,2,0,70},{9299,2,0,
32},{0,2,0,70},{9299,8,0,32},{0,2,0,72},{9299,2,0,32},{0,2,0,72},{9299,8,0,32},
{0,2,0,48},{0,2,0,38},{9299,2,0,32},{0,2,0,48},{0,2,0,38},{9358,8,0,32},{0,2,0,
46},{9358,2,0,32},{0,2,0,46},{9373,8,0,32},{0,2,0,50},{9373,2,0,32},{0,2,0,50},
{9412,8,0,32},{0,2,0,46},{9412,2,0,32},{0,2,0,46},{9412,8,0,32},{0,2,0,66},
{9412,2,0,32},{0,2,0,66},{9412,8,0,32},{0,2,0,43},{9412,2,0,32},{0,2,0,43},
{9412,8,0,32},{0,2,0,48},{9412,2,0,32},{0,2,0,48},{9412,8,0,32},{0,2,0,71},
{9412,2,0,32},{0,2,0,71},{9439,8,0,32},{0,2,0,72},{9439,2,0,32},{0,2,0,72},
{9439,8,0,32},{0,2,0,43},{0,2,0,36},{9439,2,0,32},{0,2,0,43},{0,2,0,36},{9492,8,
0,32},{0,2,0,36},{9492,2,0,32},{0,2,0,36},{9492,8,0,32},{0,2,0,66},{9492,2,0,
32},{0,2,0,66},{9492,8,0,32},{0,2,0,73},{9492,2,0,32},{0,2,0,73},{9512,8,0,32},
{0,2,0,66},{9512,2,0,32},{0,2,0,66},{9512,8,0,32},{0,2,0,66},{0,2,0,50},{9512,2,
0,32},{0,2,0,66},{0,2,0,50},{9512,8,0,32},{0,2,0,73},{9512,2,0,32},{0,2,0,73},
{9512,8,0,32},{0,2,0,70},{9512,2,0,32},{0,2,0,70},{9570,8,0,32},{0,2,0,36},
{9570,2,0,32},{0,2,0,36},{9570,8,0,32},{0,2,0,46},{9570,2,0,32},{0,2,0,46},
{9570,8,0,32},{0,2,0,66},{9570,2,0,32},{0,2,0,66},{9585,8,0,32},{0,2,0,46},
{9585,2,0,32},{0,2,0,46},{9585,8,0,32},{0,2,0,66},{9585,2,0,32},{0,2,0,66},
{9585,8,0,32},{0,2,0,73},{9585,2,0,32},{0,2,0,73},{9585,8,0,32},{0,2,0,70},
{9585,2,0,32},{0,2,0,70},{9624,8,0,32},{0,2,0,45},{0,2,0,36},{9624,2,0,32},{0,2,
0,45},{0,2,0,36},{9624,8,0,32},{0,2,0,45},{0,2,0,43},{9624,2,0,32},{0,2,0,45},
{0,2,0,43},{9624,8,0,32},{0,2,0,50},{0,2,0,37},{9624,2,0,32},{0,2,0,50},{0,2,0,
37},{9624,8,0,32},{0,2,0,50},{0,2,0,36},{9624,2,0,32},{0,2,0,50},{0,2,0,36},
{9672,8,0,32},{0,2,0,36},{9672,2,0,32},{0,2,0,36},{9672,8,0,32},{0,2,0,46},
{9672,2,0,32},{0,2,0,46},{9712,8,0,32},{0,2,0,46},{9712,2,0,32},{0,2,0,46},
{9712,8,0,32},{0,2,0,66},{9712,2,0,32},{0,2,0,66},{9712,8,0,32},{0,2,0,66},{0,2,
0,50},{9712,2,0,32},{0,2,0,66},{0,2,0,50},{9712,8,0,32},{0,2,0,73},{9712,2,0,
32},{0,2,0,73},{9778,8,0,32},{0,2,0,46},{9778,2,0,32},{0,2,0,46},{9778,8,0,32},
{0,2,0,66},{9778,2,0,32},{0,2,0,66},{9778,8,0,32},{0,2,0,36},{0,2,0,46},{9778,2,
0,32},{0,2,0,36},{0,2,0,46},{9778,8,0,32},{0,2,0,40},{0,2,0,46},{9778,2,0,32},
{0,2,0,40},{0,2,0,46},{9778,8,0,32},{0,2,0,66},{0,2,0,46},{9778,2,0,32},{0,2,0,
66},{0,2,0,46},{9821,8,0,32},{0,2,0,46},{9821,2,0,32},{0,2,0,46},{9821,8,0,32},
{0,2,0,66},{9821,2,0,32},{0,2,0,66},{9821,8,0,32},{0,2,0,73},{9821,2,0,32},{0,2,
0,73},{9821,8,0,32},{0,2,0,70},{9821,2,0,32},{0,2,0,70},{9856,8,0,32},{0,2,0,
67},{9856,2,0,32},{0,2,0,67},{9856,8,0,32},{0,2,0,72},{9856,2,0,32},{0,2,0,72},
{9856,8,0,32},{0,2,0,70},{9856,2,0,32},{0,2,0,70},{9856,8,0,32},{0,2,0,45},{0,2,
0,36},{9856,2,0,32},{0,2,0,45},{0,2,0,36},{9856,8,0,32},{0,2,0,50},{0,2,0,43},
{9856,2,0,32},{0,2,0,50},{0,2,0,43},{9904,8,0,32},{0,2,0,45},{9904,2,0,32},{0,2,
0,45},{9904,8,0,32},{0,2,0,66},{9904,2,0,32},{0,2,0,66},{9922,8,0,32},{0,2,0,
37},{9922,2,0,32},{0,2,0,37},{9922,8,0,32},{0,2,0,36},{9922,2,0,32},{0,2,0,36},
{9922,8,0,32},{0,2,0,43},{9922,2,0,32},{0,2,0,43},{9922,8,0,32},{0,2,0,46},
{9922,2,0,32},{0,2,0,46},{9922,8,0,32},{0,2,0,66},{9922,2,0,32},{0,2,0,66},
{9932,8,0,32},{0,2,0,46},{9932,2,0,32},{0,2,0,46},{9932,8,0,32},{0,2,0,43},
{9932,2,0,32},{0,2,0,43},{9944,8,0,32},{0,2,0,46},{9944,2,0,32},{0,2,0,46},
{9966,8,0,32},{0,2,0,39},{9966,2,0,32},{0,2,0,39},{9966,8,0,32},{0,2,0,66},
{9966,2,0,32},{0,2,0,66},{9966,8,0,32},{0,2,0,73},{9966,2,0,32},{0,2,0,73},
{9412,2,0,32},{0,2,0,73},{9821,2,0,32},{0,2,0,43},{9922,2,0,32},{0,2,0,41},
{9944,2,0,32},{0,2,0,41},{9196,4,0,32},{10064,4,0,32},{9778,4,0,32},{0,4,0,288},
{0,2,0,46},{9778,10,0,32},{0,4,0,287},{9778,10,0,32},{9196,8,0,32},{0,2,0,66},
{9196,2,0,32},{0,2,0,66},{9196,8,0,32},{0,2,0,59},{9196,2,0,32},{0,2,0,59},
{9196,8,0,32},{0,2,0,39},{0,2,0,36},{9196,2,0,32},{0,2,0,39},{0,2,0,36},{9196,8,
0,32},{0,2,0,39},{0,2,0,37},{9196,2,0,32},{0,2,0,39},{0,2,0,37},{9196,8,0,32},
{0,2,0,39},{0,2,0,59},{9196,2,0,32},{0,2,0,39},{0,2,0,59},{9196,8,0,32},{0,2,0,
39},{0,2,0,45},{9196,2,0,32},{0,2,0,39},{0,2,0,45},{9196,8,0,32},{0,2,0,66},{0,
2,0,39},{9196,2,0,32},{0,2,0,66},{0,2,0,39},{9196,8,0,32},{0,2,0,38},{0,2,0,36},
{9196,2,0,32},{0,2,0,38},{0,2,0,36},{9196,8,0,32},{0,2,0,38},{0,2,0,37},{9196,2,
0,32},{0,2,0,38},{0,2,0,37},{9196,8,0,32},{0,2,0,38},{0,2,0,59},{9196,2,0,32},
{0,2,0,38},{0,2,0,59},{9196,8,0,32},{0,2,0,38},{0,2,0,45},{9196,2,0,32},{0,2,0,
38},{0,2,0,45},{9196,8,0,32},{0,2,0,66},{0,2,0,38},{9196,2,0,32},{0,2,0,66},{0,
2,0,38},{9299,8,0,32},{0,2,0,66},{9299,2,0,32},{0,2,0,66},{9299,8,0,32},{0,2,0,
59},{9299,2,0,32},{0,2,0,59},{9299,8,0,32},{0,2,0,45},{9299,2,0,32},{0,2,0,45},
{9299,8,0,32},{0,2,0,39},{0,2,0,36},{9299,2,0,32},{0,2,0,39},{0,2,0,36},{9299,8,
0,32},{0,2,0,39},{0,2,0,37},{9299,2,0,32},{0,2,0,39},{0,2,0,37},{9299,8,0,32},
{0,2,0,39},{0,2,0,59},{9299,2,0,32},{0,2,0,39},{0,2,0,59},{9299,8,0,32},{0,2,0,
39},{0,2,0,45},{9299,2,0,32},{0,2,0,39},{0,2,0,45},{9299,8,0,32},{0,2,0,66},{0,
2,0,39},{9299,2,0,32},{0,2,0,66},{0,2,0,39},{9439,8,0,32},{0,2,0,59},{9439,2,0,
32},{0,2,0,59},{9439,8,0,32},{0,2,0,66},{9439,2,0,32},{0,2,0,66},{9624,8,0,32},
{0,2,0,66},{9624,2,0,32},{0,2,0,66},{9624,8,0,32},{0,2,0,59},{9624,2,0,32},{0,2,
0,59},{9624,8,0,32},{0,2,0,39},{0,2,0,36},{9624,2,0,32},{0,2,0,39},{0,2,0,36},
{9624,8,0,32},{0,2,0,39},{0,2,0,37},{9624,2,0,32},{0,2,0,39},{0,2,0,37},{9624,8,
0,32},{0,2,0,39},{0,2,0,59},{9624,2,0,32},{0,2,0,39},{0,2,0,59},{9624,8,0,32},
{0,2,0,39},{0,2,0,45},{9624,2,0,32},{0,2,0,39},{0,2,0,45},{9624,8,0,32},{0,2,0,
66},{0,2,0,39},{9624,2,0,32},{0,2,0,66},{0,2,0,39},{9624,8,0,32},{0,2,0,63},{0,
2,0,36},{9624,2,0,32},{0,2,0,63},{0,2,0,36},{9624,8,0,32},{0,2,0,63},{0,2,0,37},
{9624,2,0,32},{0,2,0,63},{0,2,0,37},{9624,8,0,32},{0,2,0,63},{0,2,0,59},{9624,2,
0,32},{0,2,0,63},{0,2,0,59},{9624,8,0,32},{0,2,0,63},{0,2,0,45},{9624,2,0,32},
{0,2,0,63},{0,2,0,45},{9624,8,0,32},{0,2,0,63},{0,2,0,66},{9624,2,0,32},{0,2,0,
63},{0,2,0,66},{9856,8,0,32},{0,2,0,66},{9856,2,0,32},{0,2,0,66},{9856,8,0,32},
{0,2,0,59},{9856,2,0,32},{0,2,0,59},{9856,8,0,32},{0,2,0,63},{0,2,0,36},{9856,2,
0,32},{0,2,0,63},{0,2,0,36},{9856,8,0,32},{0,2,0,63},{0,2,0,37},{9856,2,0,32},
{0,2,0,63},{0,2,0,37},{9856,8,0,32},{0,2,0,63},{0,2,0,59},{9856,2,0,32},{0,2,0,
63},{0,2,0,59},{9856,8,0,32},{0,2,0,63},{0,2,0,45},{9856,2,0,32},{0,2,0,63},{0,
2,0,45},{9856,8,0,32},{0,2,0,63},{0,2,0,66},{9856,2,0,32},{0,2,0,63},{0,2,0,66},
{9944,8,0,32},{0,2,0,37},{9944,2,0,32},{0,2,0,37},{9944,8,0,32},{0,2,0,66},
{9944,2,0,32},{0,2,0,66},{9944,8,0,32},{0,2,0,59},{9944,2,0,32},{0,2,0,59},
{9944,8,0,32},{0,2,0,45},{9944,2,0,32},{0,2,0,45},{9512,10,0,32},{9512,10,0,32},
{9512,4,0,32},{9512,4,0,32},{10125,2,0,32},{0,2,0,34},{10125,2,0,32},{0,2,0,35},
{10125,2,0,32},{0,2,0,34},{0,2,0,37},{10125,2,0,32},{0,2,0,35},{0,2,0,37},
{10125,2,0,32},{0,2,0,34},{0,2,0,36},{10125,2,0,32},{0,2,0,35},{0,2,0,36},
{10125,2,0,32},{0,2,0,34},{0,2,0,42},{10125,2,0,32},{0,2,0,35},{0,2,0,42},
{10125,8,0,32},{0,2,0,34},{10125,8,0,32},{0,2,0,35},{10125,8,0,32},{0,2,0,34},
{0,2,0,37},{10125,8,0,32},{0,2,0,35},{0,2,0,37},{10125,8,0,32},{0,2,0,34},{0,2,
0,36},{10125,8,0,32},{0,2,0,35},{0,2,0,36},{10125,8,0,32},{0,2,0,34},{0,2,0,42},
{10125,8,0,32},{0,2,0,35},{0,2,0,42},{10130,2,0,32},{0,2,0,34},{10130,2,0,32},
{0,2,0,35},{10130,2,0,32},{0,2,0,34},{0,2,0,37},{10130,2,0,32},{0,2,0,35},{0,2,
0,37},{10130,2,0,32},{0,2,0,34},{0,2,0,36},{10130,2,0,32},{0,2,0,35},{0,2,0,36},
{10130,8,0,32},{0,2,0,34},{10130,8,0,32},{0,2,0,35},{10130,8,0,32},{0,2,0,34},
{0,2,0,37},{10130,8,0,32},{0,2,0,35},{0,2,0,37},{10130,8,0,32},{0,2,0,34},{0,2,
0,36},{10130,8,0,32},{0,2,0,35},{0,2,0,36},{10136,2,0,32},{0,2,0,34},{10136,2,0,
32},{0,2,0,35},{10136,2,0,32},{0,2,0,34},{0,2,0,37},{10136,2,0,32},{0,2,0,35},
{0,2,0,37},{10136,2,0,32},{0,2,0,34},{0,2,0,36},{10136,2,0,32},{0,2,0,35},{0,2,
0,36},{10136,2,0,32},{0,2,0,34},{0,2,0,42},{10136,2,0,32},{0,2,0,35},{0,2,0,42},
{10136,8,0,32},{0,2,0,34},{10136,8,0,32},{0,2,0,35},{10136,8,0,32},{0,2,0,34},
{0,2,0,37},{10136,8,0,32},{0,2,0,35},{0,2,0,37},{10136,8,0,32},{0,2,0,34},{0,2,
0,36},{10136,8,0,32},{0,2,0,35},{0,2,0,36},{10136,8,0,32},{0,2,0,34},{0,2,0,42},
{10136,8,0,32},{0,2,0,35},{0,2,0,42},{10138,2,0,32},{0,2,0,34},{10138,2,0,32},
{0,2,0,35},{10138,2,0,32},{0,2,0,34},{0,2,0,37},{10138,2,0,32},{0,2,0,35},{0,2,
0,37},{10138,2,0,32},{0,2,0,34},{0,2,0,36},{10138,2,0,32},{0,2,0,35},{0,2,0,36},
{10138,2,0,32},{0,2,0,34},{0,2,0,42},{10138,2,0,32},{0,2,0,35},{0,2,0,42},
{10138,8,0,32},{0,2,0,34},{10138,8,0,32},{0,2,0,35},{10138,8,0,32},{0,2,0,34},
{0,2,0,37},{10138,8,0,32},{0,2,0,35},{0,2,0,37},{10138,8,0,32},{0,2,0,34},{0,2,
0,36},{10138,8,0,32},{0,2,0,35},{0,2,0,36},{10138,8,0,32},{0,2,0,34},{0,2,0,42},
{10138,8,0,32},{0,2,0,35},{0,2,0,42},{10146,2,0,32},{0,2,0,34},{10146,2,0,32},
{0,2,0,35},{10146,2,0,32},{0,2,0,34},{0,2,0,37},{10146,2,0,32},{0,2,0,35},{0,2,
0,37},{10146,2,0,32},{0,2,0,34},{0,2,0,36},{10146,2,0,32},{0,2,0,35},{0,2,0,36},
{10146,8,0,32},{0,2,0,34},{10146,8,0,32},{0,2,0,35},{10146,8,0,32},{0,2,0,34},
{0,2,0,37},{10146,8,0,32},{0,2,0,35},{0,2,0,37},{10146,8,0,32},{0,2,0,34},{0,2,
0,36},{10146,8,0,32},{0,2,0,35},{0,2,0,36},{10160,2,0,32},{0,2,0,34},{10160,2,0,
32},{0,2,0,35},{10160,2,0,32},{0,2,0,34},{0,2,0,37},{10160,2,0,32},{0,2,0,35},
{0,2,0,37},{10160,2,0,32},{0,2,0,34},{0,2,0,36},{10160,2,0,32},{0,2,0,35},{0,2,
0,36},{10160,2,0,32},{0,2,0,34},{0,2,0,42},{10160,2,0,32},{0,2,0,35},{0,2,0,42},
{10160,8,0,32},{0,2,0,35},{10160,8,0,32},{0,2,0,35},{0,2,0,37},{10160,8,0,32},
{0,2,0,35},{0,2,0,36},{10160,8,0,32},{0,2,0,35},{0,2,0,42},{10165,2,0,32},{0,2,
0,34},{10165,2,0,32},{0,2,0,35},{10165,2,0,32},{0,2,0,34},{0,2,0,37},{10165,2,0,
32},{0,2,0,35},{0,2,0,37},{10165,2,0,32},{0,2,0,34},{0,2,0,36},{10165,2,0,32},
{0,2,0,35},{0,2,0,36},{10165,2,0,32},{0,2,0,34},{0,2,0,42},{10165,2,0,32},{0,2,
0,35},{0,2,0,42},{10165,8,0,32},{0,2,0,34},{10165,8,0,32},{0,2,0,35},{10165,8,0,
32},{0,2,0,34},{0,2,0,37},{10165,8,0,32},{0,2,0,35},{0,2,0,37},{10165,8,0,32},
{0,2,0,34},{0,2,0,36},{10165,8,0,32},{0,2,0,35},{0,2,0,36},{10165,8,0,32},{0,2,
0,34},{0,2,0,42},{10165,8,0,32},{0,2,0,35},{0,2,0,42},{10125,2,0,32},{0,2,0,37},
{10130,2,0,32},{0,2,0,37},{10136,2,0,32},{0,2,0,37},{10138,2,0,32},{0,2,0,37},
{10146,2,0,32},{0,2,0,37},{10160,2,0,32},{0,2,0,37},{10165,2,0,32},{0,2,0,37},
{10125,2,0,32},{0,2,0,34},{0,2,0,76},{10125,2,0,32},{0,2,0,35},{0,2,0,76},
{10125,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{10125,2,0,32},{0,2,0,35},{0,2,
0,37},{0,2,0,76},{10125,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{10125,2,0,32},
{0,2,0,35},{0,2,0,36},{0,2,0,76},{10125,2,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,
76},{10125,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{10125,8,0,32},{0,2,0,34},
{0,2,0,76},{10125,8,0,32},{0,2,0,35},{0,2,0,76},{10125,8,0,32},{0,2,0,34},{0,2,
0,37},{0,2,0,76},{10125,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{10125,8,0,32},
{0,2,0,34},{0,2,0,36},{0,2,0,76},{10125,8,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,
76},{10125,8,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{10125,8,0,32},{0,2,0,35},
{0,2,0,42},{0,2,0,76},{10136,2,0,32},{0,2,0,34},{0,2,0,76},{10136,2,0,32},{0,2,
0,35},{0,2,0,76},{10136,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{10136,2,0,32},
{0,2,0,35},{0,2,0,37},{0,2,0,76},{10136,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,
76},{10136,2,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{10136,2,0,32},{0,2,0,34},
{0,2,0,42},{0,2,0,76},{10136,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{10136,8,
0,32},{0,2,0,34},{0,2,0,76},{10136,8,0,32},{0,2,0,35},{0,2,0,76},{10136,8,0,32},
{0,2,0,34},{0,2,0,37},{0,2,0,76},{10136,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,
76},{10136,8,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{10136,8,0,32},{0,2,0,35},
{0,2,0,36},{0,2,0,76},{10136,8,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{10136,8,
0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{10165,2,0,32},{0,2,0,34},{0,2,0,76},
{10165,2,0,32},{0,2,0,35},{0,2,0,76},{10165,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,
0,76},{10165,2,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{10165,2,0,32},{0,2,0,34},
{0,2,0,36},{0,2,0,76},{10165,2,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{10165,2,
0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{10165,2,0,32},{0,2,0,35},{0,2,0,42},{0,
2,0,76},{10165,8,0,32},{0,2,0,34},{0,2,0,76},{10165,8,0,32},{0,2,0,35},{0,2,0,
76},{10165,8,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{10165,8,0,32},{0,2,0,35},
{0,2,0,37},{0,2,0,76},{10165,8,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{10165,8,
0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{10165,8,0,32},{0,2,0,34},{0,2,0,42},{0,
2,0,76},{10165,8,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{10125,2,0,32},{0,2,0,
38},{10125,2,0,32},{0,2,0,50},{10125,2,0,32},{0,2,0,37},{0,2,0,76},{10125,2,0,
32},{0,2,0,76},{10125,2,0,32},{0,2,0,36},{0,2,0,76},{10125,2,0,32},{0,2,0,42},
{10125,2,0,32},{0,2,0,42},{0,2,0,76},{10125,8,0,32},{0,2,0,38},{10125,8,0,32},
{0,2,0,50},{10125,8,0,32},{0,2,0,37},{10125,8,0,32},{0,2,0,76},{1256,2,1,32},{0,
2,0,42},{10136,2,0,32},{0,2,0,37},{0,2,0,76},{10136,2,0,32},{0,2,0,76},{10136,2,
0,32},{0,2,0,36},{0,2,0,76},{10136,2,0,32},{0,2,0,42},{10136,2,0,32},{0,2,0,42},
{0,2,0,76},{10130,8,0,32},{0,2,0,37},{10136,8,0,32},{0,2,0,37},{10136,8,0,32},
{0,2,0,76},{1261,2,1,32},{0,2,0,37},{1261,2,1,32},{0,2,0,36},{1261,2,1,32},{0,2,
0,42},{10138,2,0,32},{0,2,0,38},{10138,2,0,32},{0,2,0,50},{10138,2,0,32},{0,2,0,
43},{0,2,0,37},{10138,2,0,32},{0,2,0,42},{10138,2,0,32},{0,2,0,43},{0,2,0,42},
{10138,8,0,32},{0,2,0,38},{10138,8,0,32},{0,2,0,50},{10138,8,0,32},{0,2,0,37},
{1262,2,1,32},{0,2,0,37},{1262,2,1,32},{0,2,0,36},{1262,2,1,32},{0,2,0,42},
{10160,2,0,32},{0,2,0,38},{10160,2,0,32},{0,2,0,50},{10160,2,0,32},{0,2,0,43},
{0,2,0,37},{10152,2,0,32},{0,2,0,34},{10152,2,0,32},{0,2,0,35},{10160,2,0,32},
{0,2,0,42},{10160,2,0,32},{0,2,0,43},{0,2,0,42},{10160,8,0,32},{0,2,0,38},
{10160,8,0,32},{0,2,0,50},{10160,8,0,32},{0,2,0,37},{10152,8,0,32},{0,2,0,35},
{1256,2,1,32},{0,2,0,37},{10165,2,0,32},{0,2,0,37},{0,2,0,76},{10165,2,0,32},{0,
2,0,76},{10165,2,0,32},{0,2,0,36},{0,2,0,76},{10165,2,0,32},{0,2,0,42},{10165,2,
0,32},{0,2,0,42},{0,2,0,76},{10146,8,0,32},{0,2,0,37},{10165,8,0,32},{0,2,0,37},
{10165,8,0,32},{0,2,0,76},{824,4,1,32},{0,4,0,287},{824,4,1,32},{0,4,0,288},
{824,4,1,32},{0,4,0,289},{824,4,1,32},{0,4,0,290},{827,4,1,32},{0,4,0,287},{827,
4,1,32},{0,4,0,288},{827,4,1,32},{0,4,0,289},{827,4,1,32},{0,4,0,290},{642,4,1,
32},{642,4,1,32},{642,4,1,32},{642,4,1,32},{642,4,1,32},{989,4,1,32},{989,4,1,
32},{989,4,1,32},{989,4,1,32},{989,4,1,32},{990,4,1,32},{990,4,1,32},{990,4,1,
32},{990,4,1,32},{990,4,1,32},{617,4,1,32},{617,4,1,32},{624,4,1,32},{624,4,1,
32},{624,4,1,32},{617,4,1,32},{617,4,1,32},{624,4,1,32},{989,4,1,32},{989,4,1,
32},{989,4,1,32},{989,4,1,32},{9672,10,0,32},{9821,4,0,32},{9778,4,0,32},{9712,
10,0,32},{9778,4,0,32},{9196,4,0,32},{964,4,1,32},{9248,4,0,32},{9196,4,0,32},
{964,4,1,32},{9778,4,0,32},{1380,4,1,32},{9248,10,0,32},{9248,4,0,32},{964,4,1,
32},{9624,4,0,32},{9248,4,0,32},{964,4,1,32},{9856,4,0,32},{1380,4,1,32},{9358,
10,0,32},{9412,2,0,32},{0,2,0,57},{9585,10,0,32},{9624,4,0,32},{9778,20,0,32},
{9570,20,0,32},{9821,10,0,32},{9299,10,0,32},{9512,10,0,32},{9821,20,0,32},
{9570,20,0,32},{9358,10,0,32},{9196,10,0,32},{9932,10,0,32},{9196,10,0,32},{964,
4,1,32},{9778,10,0,32},{8679,30,0,32},{1768,30,1,32},{8685,30,0,32},{8679,30,0,
32},{1768,30,1,32},{8687,30,0,32},{8679,30,0,32},{1768,30,1,32},{8679,30,0,32},
{8678,30,0,32},{8679,30,0,32},{1768,30,1,32},{8681,30,0,32},{8680,30,0,32},
{1768,30,1,32},{8681,30,0,32},{8679,30,0,32},{1768,30,1,32},{8683,30,0,32},
{8680,30,0,32},{1768,30,1,32},{8683,30,0,32},{8681,30,0,32},{1768,30,1,32},
{8683,30,0,32},{8682,30,0,32},{1768,30,1,32},{8683,30,0,32},{8679,30,0,32},
{1768,30,1,32},{8684,30,0,32},{8683,30,0,32},{1768,30,1,32},{8684,30,0,32},
{8679,30,0,32},{1768,30,1,32},{8686,30,0,32},{8681,30,0,32},{1768,30,1,32},
{8686,30,0,32},{8683,30,0,32},{1768,30,1,32},{8686,30,0,32},{8685,30,0,32},
{1768,30,1,32},{8686,30,0,32},{8679,30,0,32},{1768,30,1,32},{9439,10,0,32},
{9439,10,0,32},{9439,10,0,32},{9439,10,0,32},{9439,10,0,32},{9439,10,0,32},
{9904,10,0,32},{9904,10,0,32},{9439,10,0,32},{9904,10,0,32},{9439,10,0,32},
{9439,10,0,32},{9904,10,0,32},{9439,10,0,32},{9439,10,0,32},{9439,10,0,32},
{9439,10,0,32},{9932,10,0,32},{9932,10,0,32},{9439,10,0,32},{9932,10,0,32},
{9439,10,0,32},{9439,10,0,32},{9439,4,0,32},{9439,4,0,32},{9439,4,0,32},{9439,4,
0,32},{9439,4,0,32},{9439,4,0,32},{9904,4,0,32},{9904,4,0,32},{9439,4,0,32},
{9904,4,0,32},{9439,4,0,32},{9439,4,0,32},{9904,4,0,32},{9439,4,0,32},{9439,4,0,
32},{9439,4,0,32},{9439,4,0,32},{9932,4,0,32},{9932,4,0,32},{9439,4,0,32},{9932,
4,0,32},{9439,4,0,32},{9439,4,0,32},{8678,30,0,32},{1768,30,1,32},{8681,30,0,
32},{1628,2,1,32},{0,2,0,47},{1629,2,1,32},{0,2,0,47},{1632,2,1,32},{0,2,0,47},
{1686,2,1,32},{0,2,0,47},{1690,2,1,32},{0,2,0,47},{1688,2,1,32},{0,2,0,47},
{1737,2,1,32},{0,2,0,47},{1741,2,1,32},{0,2,0,47},{1743,2,1,32},{0,2,0,47},
{1784,2,1,32},{0,2,0,47},{1785,2,1,32},{0,2,0,47},{1790,4,1,32},{1790,4,1,32},
{1790,4,1,32},{1790,4,1,32},{1790,4,1,32},{1791,4,1,32},{1791,4,1,32},{1791,4,1,
32},{1791,4,1,32},{1791,4,1,32},{1803,2,1,32},{0,2,0,47},{1809,2,1,32},{0,2,0,
47},{1810,2,1,32},{0,2,0,47},{1812,2,1,32},{0,2,0,47},{1756,2,1,32},{0,2,0,47},
{1835,2,1,32},{0,2,0,47},{1816,2,1,32},{0,2,0,47},{1755,2,1,32},{0,2,0,47},
{1757,2,1,32},{0,2,0,47},{1837,2,1,32},{0,2,0,47},{1838,2,1,32},{0,2,0,47},
{1846,2,1,32},{0,2,0,47},{1847,2,1,32},{0,2,0,47},{1848,2,1,32},{0,2,0,47},
{1849,2,1,32},{0,2,0,47},{1850,2,1,32},{0,2,0,47},{1851,2,1,32},{0,2,0,47},
{1856,2,1,32},{0,2,0,47},{1857,2,1,32},{0,2,0,47},{1858,2,1,32},{0,2,0,47},
{1859,2,1,32},{0,2,0,47},{1884,2,1,32},{0,2,0,47},{1890,2,1,32},{0,2,0,47},
{1891,2,1,32},{0,2,0,47},{1893,2,1,32},{0,2,0,47},{1852,2,1,32},{0,2,0,47},
{1853,2,1,32},{0,2,0,47},{1867,2,1,32},{0,2,0,47},{1868,2,1,32},{0,2,0,47},
{1896,2,1,32},{0,2,0,47},{1897,2,1,32},{0,2,0,47},{1898,2,1,32},{0,2,0,47},
{1899,2,1,32},{0,2,0,47},{8679,6,0,32},{8678,6,0,32},{8679,6,0,32},{8679,6,0,
32},{8679,6,0,32},{8680,6,0,32},{8679,6,0,32},{8681,6,0,32},{8679,6,0,32},{8682,
6,0,32},{8679,6,0,32},{8683,6,0,32},{8679,6,0,32},{8684,6,0,32},{8679,6,0,32},
{8685,6,0,32},{8679,6,0,32},{8686,6,0,32},{8679,6,0,32},{8687,6,0,32},{8680,6,0,
32},{8678,6,0,32},{830,4,1,32},{8679,4,0,32},{831,4,1,32},{830,4,1,32},{8680,4,
0,32},{831,4,1,32},{830,4,1,32},{8681,4,0,32},{831,4,1,32},{830,4,1,32},{8682,4,
0,32},{831,4,1,32},{830,4,1,32},{8683,4,0,32},{831,4,1,32},{830,4,1,32},{8684,4,
0,32},{831,4,1,32},{830,4,1,32},{8685,4,0,32},{831,4,1,32},{830,4,1,32},{8686,4,
0,32},{831,4,1,32},{830,4,1,32},{8687,4,0,32},{831,4,1,32},{830,4,1,32},{8679,4,
0,32},{8678,4,0,32},{831,4,1,32},{830,4,1,32},{8679,4,0,32},{8679,4,0,32},{831,
4,1,32},{830,4,1,32},{8679,4,0,32},{8680,4,0,32},{831,4,1,32},{830,4,1,32},
{8679,4,0,32},{8681,4,0,32},{831,4,1,32},{830,4,1,32},{8679,4,0,32},{8682,4,0,
32},{831,4,1,32},{830,4,1,32},{8679,4,0,32},{8683,4,0,32},{831,4,1,32},{830,4,1,
32},{8679,4,0,32},{8684,4,0,32},{831,4,1,32},{830,4,1,32},{8679,4,0,32},{8685,4,
0,32},{831,4,1,32},{830,4,1,32},{8679,4,0,32},{8686,4,0,32},{831,4,1,32},{830,4,
1,32},{8679,4,0,32},{8687,4,0,32},{831,4,1,32},{830,4,1,32},{8680,4,0,32},{8678,
4,0,32},{831,4,1,32},{8679,4,0,32},{642,4,1,32},{8680,4,0,32},{642,4,1,32},
{8681,4,0,32},{642,4,1,32},{8682,4,0,32},{642,4,1,32},{8683,4,0,32},{642,4,1,
32},{8684,4,0,32},{642,4,1,32},{8685,4,0,32},{642,4,1,32},{8686,4,0,32},{642,4,
1,32},{8687,4,0,32},{642,4,1,32},{8679,4,0,32},{8678,4,0,32},{642,4,1,32},{8679,
4,0,32},{8679,4,0,32},{642,4,1,32},{8679,4,0,32},{8680,4,0,32},{642,4,1,32},
{8679,4,0,32},{8681,4,0,32},{642,4,1,32},{8679,4,0,32},{8682,4,0,32},{642,4,1,
32},{8679,4,0,32},{8683,4,0,32},{642,4,1,32},{8679,4,0,32},{8684,4,0,32},{642,4,
1,32},{8679,4,0,32},{8685,4,0,32},{642,4,1,32},{8679,4,0,32},{8686,4,0,32},{642,
4,1,32},{8679,4,0,32},{8687,4,0,32},{642,4,1,32},{8680,4,0,32},{8678,4,0,32},
{642,4,1,32},{830,4,1,32},{9196,4,0,32},{831,4,1,32},{830,4,1,32},{9222,4,0,32},
{831,4,1,32},{830,4,1,32},{9248,4,0,32},{831,4,1,32},{830,4,1,32},{9270,4,0,32},
{831,4,1,32},{830,4,1,32},{9299,4,0,32},{831,4,1,32},{830,4,1,32},{9358,4,0,32},
{831,4,1,32},{830,4,1,32},{9373,4,0,32},{831,4,1,32},{830,4,1,32},{9412,4,0,32},
{831,4,1,32},{830,4,1,32},{9439,4,0,32},{831,4,1,32},{830,4,1,32},{9467,4,0,32},
{831,4,1,32},{830,4,1,32},{9492,4,0,32},{831,4,1,32},{830,4,1,32},{9512,4,0,32},
{831,4,1,32},{830,4,1,32},{9570,4,0,32},{831,4,1,32},{830,4,1,32},{9585,4,0,32},
{831,4,1,32},{830,4,1,32},{9624,4,0,32},{831,4,1,32},{830,4,1,32},{9672,4,0,32},
{831,4,1,32},{830,4,1,32},{9693,4,0,32},{831,4,1,32},{830,4,1,32},{9712,4,0,32},
{831,4,1,32},{830,4,1,32},{9778,4,0,32},{831,4,1,32},{830,4,1,32},{9821,4,0,32},
{831,4,1,32},{830,4,1,32},{9856,4,0,32},{831,4,1,32},{830,4,1,32},{9904,4,0,32},
{831,4,1,32},{830,4,1,32},{9922,4,0,32},{831,4,1,32},{830,4,1,32},{9932,4,0,32},
{831,4,1,32},{830,4,1,32},{9944,4,0,32},{831,4,1,32},{830,4,1,32},{9966,4,0,32},
{831,4,1,32},{8679,6,0,32},{8679,6,0,32},{8679,6,0,32},{8680,6,0,32},{8679,6,0,
32},{8681,6,0,32},{8679,6,0,32},{8682,6,0,32},{8679,6,0,32},{8683,6,0,32},{8679,
6,0,32},{8684,6,0,32},{8679,6,0,32},{8685,6,0,32},{8679,6,0,32},{8686,6,0,32},
{8679,6,0,32},{8687,6,0,32},{8680,6,0,32},{8678,6,0,32},{8679,6,0,32},{8678,6,0,
32},{8679,6,0,32},{8678,6,0,32},{8679,6,0,32},{8678,6,0,32},{8679,6,0,32},{8678,
6,0,32},{1790,4,1,32},{1790,4,1,32},{1790,4,1,32},{1790,4,1,32},{578,4,1,32},
{578,4,1,32},{1756,4,1,32},{1756,4,1,32},{1756,4,1,32},{1756,4,1,32},{1756,4,1,
32},{1756,4,1,32},{4370,2,1,32},{0,2,0,47},{10181,4,0,32},{10170,4,0,32},{10180,
4,0,32},{10457,4,0,32},{10466,4,0,32},{827,4,1,32},{0,4,0,291},{64320,4,0,32},
{52790,0,0,0},{0,4,0,287},{64320,4,0,32},{54146,0,0,0},{0,4,0,287},{64320,4,0,
32},{52827,0,0,0},{64320,4,0,32},{52826,0,0,0},{64320,4,0,32},{52825,0,0,0},{0,
4,0,287},{64320,4,0,32},{52923,0,0,0},{64320,4,0,32},{53634,0,0,0},{0,4,0,287},
{64320,4,0,32},{53728,0,0,0},{0,4,0,287},{64320,4,0,32},{53760,0,0,0},{0,4,0,
287},{64320,4,0,32},{53762,0,0,0},{64320,4,0,32},{54108,0,0,0},{0,4,0,287},
{64320,4,0,32},{54121,0,0,0},{0,4,0,287},{64320,4,0,32},{56335,0,0,0},{0,4,0,
287},{64320,4,0,32},{56335,0,0,0},{0,4,0,288},{64320,4,0,32},{56354,0,0,0},{0,4,
0,287},{64320,4,0,32},{56355,0,0,0},{64320,4,0,32},{56354,0,0,0},{64320,4,0,32},
{56355,0,0,0},{0,4,0,287},{64320,4,0,32},{56819,0,0,0},{64320,4,0,32},{56954,0,
0,0},{64320,4,0,32},{57169,0,0,0},{64320,4,0,32},{57168,0,0,0},{0,4,0,287},
{64320,4,0,32},{57284,0,0,0},{64320,4,0,32},{57283,0,0,0},{0,4,0,287},{64320,4,
0,32},{57932,0,0,0},{64320,4,0,32},{58677,0,0,0},{64320,4,0,32},{58849,0,0,0},
{64320,4,0,32},{58853,0,0,0},{0,4,0,287},{64320,4,0,32},{59144,0,0,0},{0,4,0,
287},{64320,4,0,32},{60282,0,0,0},{0,4,0,287},{64320,4,0,32},{60365,0,0,0},
{64320,4,0,32},{60433,0,0,0},{64320,4,0,32},{60469,0,0,0},{64320,4,0,32},{60474,
0,0,0},{64320,4,0,32},{61548,0,0,0},{64320,4,0,32},{61995,0,0,0},{64320,4,0,32},
{61995,0,0,0},{0,4,0,287},{64320,4,0,32},{52780,0,0,0},{64320,4,0,32},{62043,0,
0,0},{0,4,0,287},{64320,4,0,32},{62125,0,0,0},{64320,4,0,32},{62347,0,0,0},{0,4,
0,287},{64320,4,0,32},{62859,0,0,0},{0,4,0,287},{64320,4,0,32},{63214,0,0,0},{0,
4,0,287},{64320,4,0,32},{63802,0,0,0},{0,4,0,287},{64320,4,0,32},{63803,0,0,0},
{64320,4,0,32},{64249,0,0,0},{0,4,0,287},{64320,4,0,32},{64761,0,0,0},{64320,4,
0,32},{65183,0,0,0},{64320,4,0,32},{65363,0,0,0},{64320,4,0,32},{65362,0,0,0},
{64320,4,0,32},{65363,0,0,0},{0,4,0,287},{64320,4,0,32},{65363,0,0,0},{0,4,0,
288},{64320,4,0,32},{65362,0,0,0},{0,4,0,287},{64320,4,0,32},{65418,0,0,0},{0,4,
0,287},{64320,4,0,32},{65418,0,0,0},{0,4,0,288},{64320,4,0,32},{65419,0,0,0},
{64321,4,0,32},{32770,0,0,0},{64321,4,0,32},{32896,0,0,0},{64321,4,0,32},{32895,
0,0,0},{0,4,0,287},{64321,4,0,32},{32905,0,0,0},{0,4,0,287},{64321,4,0,32},
{33276,0,0,0},{0,4,0,287},{64321,4,0,32},{33401,0,0,0},{64321,4,0,32},{33401,0,
0,0},{0,4,0,287},{64321,4,0,32},{33401,0,0,0},{0,4,0,288},{64321,4,0,32},{34382,
0,0,0},{64321,4,0,32},{34916,0,0,0},{64321,4,0,32},{35200,0,0,0},{64321,4,0,32},
{35199,0,0,0},{64321,4,0,32},{35265,0,0,0},{64321,4,0,32},{35282,0,0,0},{64321,
4,0,32},{35282,0,0,0},{0,4,0,287},{64321,4,0,32},{35744,0,0,0},{64321,4,0,32},
{36125,0,0,0},{64321,4,0,32},{36275,0,0,0},{0,4,0,287},{64321,4,0,32},{36710,0,
0,0},{64321,4,0,32},{36790,0,0,0},{64321,4,0,32},{36790,0,0,0},{0,4,0,287},
{64321,4,0,32},{36790,0,0,0},{0,4,0,288},{64321,4,0,32},{37009,0,0,0},{0,4,0,
287},{64321,4,0,32},{38021,0,0,0},{64321,4,0,32},{38263,0,0,0},{64321,4,0,32},
{38264,0,0,0},{64321,4,0,32},{38271,0,0,0},{64321,4,0,32},{38376,0,0,0},{64321,
4,0,32},{38428,0,0,0},{0,4,0,287},{64321,4,0,32},{38429,0,0,0},{64321,4,0,32},
{38632,0,0,0},{0,4,0,287},{64321,4,0,32},{38738,0,0,0},{64321,4,0,32},{38886,0,
0,0},{64321,4,0,32},{39029,0,0,0},{64321,4,0,32},{39118,0,0,0},{64321,4,0,32},
{39134,0,0,0},{64321,4,0,32},{39135,0,0,0},{64321,4,0,32},{39136,0,0,0},{0,4,0,
287},{64321,4,0,32},{39136,0,0,0},{64321,4,0,32},{39267,0,0,0},{64321,4,0,32},
{39318,0,0,0},{0,4,0,287},{64321,4,0,32},{39532,0,0,0},{64321,4,0,32},{39592,0,
0,0},{0,4,0,287},{64321,4,0,32},{39740,0,0,0},{0,4,0,287},{64321,4,0,32},{40060,
0,0,0},{64321,4,0,32},{40479,0,0,0},{64321,4,0,32},{40565,0,0,0},{0,4,0,287},
{64321,4,0,32},{40614,0,0,0},{64321,4,0,32},{40644,0,0,0},{64321,4,0,32},{40702,
0,0,0},{64321,4,0,32},{40778,0,0,0},{0,4,0,287},{64321,4,0,32},{40784,0,0,0},
{64321,4,0,32},{40786,0,0,0},{0,4,0,287},{64321,4,0,32},{40831,0,0,0},{64321,4,
0,32},{40845,0,0,0},{0,4,0,287},{64321,4,0,32},{40857,0,0,0},{64321,4,0,32},
{40860,0,0,0},{0,4,0,287},{64321,4,0,32},{40860,0,0,0},{0,4,0,288},{64321,4,0,
32},{40863,0,0,0},{64320,4,0,32},{52736,0,0,0},{64320,4,0,32},{52776,0,0,0},
{64320,4,0,32},{52790,0,0,0},{64320,4,0,32},{52799,0,0,0},{64320,4,0,32},{52825,
0,0,0},{64320,4,0,32},{52869,0,0,0},{64320,4,0,32},{52876,0,0,0},{64320,4,0,32},
{52896,0,0,0},{64320,4,0,32},{52922,0,0,0},{64320,4,0,32},{53567,0,0,0},{64320,
4,0,32},{53605,0,0,0},{64320,4,0,32},{53611,0,0,0},{64320,4,0,32},{53634,0,0,0},
{64320,4,0,32},{53654,0,0,0},{64320,4,0,32},{53675,0,0,0},{64320,4,0,32},{53728,
0,0,0},{64320,4,0,32},{53749,0,0,0},{64320,4,0,32},{53760,0,0,0},{64320,4,0,32},
{53915,0,0,0},{64320,4,0,32},{54009,0,0,0},{64320,4,0,32},{54037,0,0,0},{64320,
4,0,32},{54042,0,0,0},{64320,4,0,32},{54072,0,0,0},{64320,4,0,32},{54081,0,0,0},
{64320,4,0,32},{54108,0,0,0},{64320,4,0,32},{54121,0,0,0},{64320,4,0,32},{54146,
0,0,0},{64320,4,0,32},{54198,0,0,0},{64320,4,0,32},{54216,0,0,0},{64320,4,0,32},
{54243,0,0,0},{64320,4,0,32},{54999,0,0,0},{64320,4,0,32},{55071,0,0,0},{64320,
4,0,32},{55531,0,0,0},{64320,4,0,32},{55554,0,0,0},{64320,4,0,32},{55562,0,0,0},
{64320,4,0,32},{55573,0,0,0},{64320,4,0,32},{55591,0,0,0},{64320,4,0,32},{55667,
0,0,0},{64320,4,0,32},{56144,0,0,0},{64320,4,0,32},{56192,0,0,0},{64320,4,0,32},
{56312,0,0,0},{64320,4,0,32},{56335,0,0,0},{64320,4,0,32},{56354,0,0,0},{64320,
4,0,32},{56376,0,0,0},{64320,4,0,32},{56430,0,0,0},{64320,4,0,32},{56433,0,0,0},
{64320,4,0,32},{56795,0,0,0},{64320,4,0,32},{56805,0,0,0},{64320,4,0,32},{56817,
0,0,0},{64320,4,0,32},{56830,0,0,0},{64320,4,0,32},{56946,0,0,0},{64320,4,0,32},
{56954,0,0,0},{64320,4,0,32},{56959,0,0,0},{64320,4,0,32},{57076,0,0,0},{64320,
4,0,32},{57086,0,0,0},{64320,4,0,32},{57099,0,0,0},{64320,4,0,32},{57107,0,0,0},
{64320,4,0,32},{57168,0,0,0},{64320,4,0,32},{57185,0,0,0},{64320,4,0,32},{57203,
0,0,0},{64320,4,0,32},{57283,0,0,0},{64320,4,0,32},{57864,0,0,0},{64320,4,0,32},
{57910,0,0,0},{64320,4,0,32},{57931,0,0,0},{64320,4,0,32},{58671,0,0,0},{64320,
4,0,32},{58676,0,0,0},{64320,4,0,32},{58759,0,0,0},{64320,4,0,32},{58775,0,0,0},
{64320,4,0,32},{58788,0,0,0},{64320,4,0,32},{58809,0,0,0},{64320,4,0,32},{58848,
0,0,0},{64320,4,0,32},{58853,0,0,0},{64320,4,0,32},{59120,0,0,0},{64320,4,0,32},
{59144,0,0,0},{64320,4,0,32},{59176,0,0,0},{64320,4,0,32},{60192,0,0,0},{64320,
4,0,32},{60258,0,0,0},{64320,4,0,32},{60281,0,0,0},{64320,4,0,32},{60339,0,0,0},
{64320,4,0,32},{60363,0,0,0},{64320,4,0,32},{60372,0,0,0},{64320,4,0,32},{60379,
0,0,0},{64320,4,0,32},{60431,0,0,0},{64320,4,0,32},{60436,0,0,0},{64320,4,0,32},
{60468,0,0,0},{64320,4,0,32},{61547,0,0,0},{64320,4,0,32},{61994,0,0,0},{64320,
4,0,32},{62006,0,0,0},{64320,4,0,32},{62011,0,0,0},{64320,4,0,32},{62015,0,0,0},
{64320,4,0,32},{62023,0,0,0},{64320,4,0,32},{62041,0,0,0},{64320,4,0,32},{62043,
0,0,0},{64320,4,0,32},{62124,0,0,0},{64320,4,0,32},{62340,0,0,0},{64320,4,0,32},
{62345,0,0,0},{64320,4,0,32},{62684,0,0,0},{64320,4,0,32},{62694,0,0,0},{64320,
4,0,32},{62744,0,0,0},{64320,4,0,32},{62751,0,0,0},{64320,4,0,32},{62760,0,0,0},
{64320,4,0,32},{62768,0,0,0},{64320,4,0,32},{62859,0,0,0},{64320,4,0,32},{62866,
0,0,0},{64320,4,0,32},{63094,0,0,0},{64320,4,0,32},{63101,0,0,0},{64320,4,0,32},
{63150,0,0,0},{64320,4,0,32},{63167,0,0,0},{64320,4,0,32},{63214,0,0,0},{64320,
4,0,32},{63451,0,0,0},{64320,4,0,32},{63458,0,0,0},{64320,4,0,32},{63475,0,0,0},
{64320,4,0,32},{63802,0,0,0},{64320,4,0,32},{63928,0,0,0},{64320,4,0,32},{63934,
0,0,0},{64320,4,0,32},{64116,0,0,0},{64320,4,0,32},{64203,0,0,0},{64320,4,0,32},
{64249,0,0,0},{64320,4,0,32},{64627,0,0,0},{64320,4,0,32},{64760,0,0,0},{64320,
4,0,32},{65334,0,0,0},{64320,4,0,32},{65361,0,0,0},{64320,4,0,32},{65418,0,0,0},
{64320,4,0,32},{65469,0,0,0},{64321,4,0,32},{32769,0,0,0},{64321,4,0,32},{32780,
0,0,0},{64321,4,0,32},{32786,0,0,0},{64321,4,0,32},{32819,0,0,0},{64321,4,0,32},
{32895,0,0,0},{64321,4,0,32},{32905,0,0,0},{64321,4,0,32},{33251,0,0,0},{64321,
4,0,32},{33258,0,0,0},{64321,4,0,32},{33267,0,0,0},{64321,4,0,32},{33276,0,0,0},
{64321,4,0,32},{33292,0,0,0},{64321,4,0,32},{33307,0,0,0},{64321,4,0,32},{33311,
0,0,0},{64321,4,0,32},{33390,0,0,0},{64321,4,0,32},{33394,0,0,0},{64321,4,0,32},
{33400,0,0,0},{64321,4,0,32},{34381,0,0,0},{64321,4,0,32},{34411,0,0,0},{64321,
4,0,32},{34880,0,0,0},{64321,4,0,32},{34892,0,0,0},{64321,4,0,32},{34915,0,0,0},
{64321,4,0,32},{35198,0,0,0},{64321,4,0,32},{35211,0,0,0},{64321,4,0,32},{35282,
0,0,0},{64321,4,0,32},{35328,0,0,0},{64321,4,0,32},{35895,0,0,0},{64321,4,0,32},
{35910,0,0,0},{64321,4,0,32},{35925,0,0,0},{64321,4,0,32},{35960,0,0,0},{64321,
4,0,32},{35997,0,0,0},{64321,4,0,32},{36196,0,0,0},{64321,4,0,32},{36208,0,0,0},
{64321,4,0,32},{36275,0,0,0},{64321,4,0,32},{36523,0,0,0},{64321,4,0,32},{36554,
0,0,0},{64321,4,0,32},{36763,0,0,0},{64321,4,0,32},{36784,0,0,0},{64321,4,0,32},
{36789,0,0,0},{64321,4,0,32},{37009,0,0,0},{64321,4,0,32},{37193,0,0,0},{64321,
4,0,32},{37318,0,0,0},{64321,4,0,32},{37324,0,0,0},{64321,4,0,32},{37329,0,0,0},
{64321,4,0,32},{38263,0,0,0},{64321,4,0,32},{38272,0,0,0},{64321,4,0,32},{38428,
0,0,0},{64321,4,0,32},{38582,0,0,0},{64321,4,0,32},{38585,0,0,0},{64321,4,0,32},
{38632,0,0,0},{64321,4,0,32},{38737,0,0,0},{64321,4,0,32},{38750,0,0,0},{64321,
4,0,32},{38754,0,0,0},{64321,4,0,32},{38761,0,0,0},{64321,4,0,32},{38859,0,0,0},
{64321,4,0,32},{38893,0,0,0},{64321,4,0,32},{38899,0,0,0},{64321,4,0,32},{38913,
0,0,0},{64321,4,0,32},{39080,0,0,0},{64321,4,0,32},{39131,0,0,0},{64321,4,0,32},
{39135,0,0,0},{64321,4,0,32},{39318,0,0,0},{64321,4,0,32},{39321,0,0,0},{64321,
4,0,32},{39340,0,0,0},{64321,4,0,32},{39592,0,0,0},{64321,4,0,32},{39640,0,0,0},
{64321,4,0,32},{39647,0,0,0},{64321,4,0,32},{39717,0,0,0},{64321,4,0,32},{39727,
0,0,0},{64321,4,0,32},{39730,0,0,0},{64321,4,0,32},{39740,0,0,0},{64321,4,0,32},
{39770,0,0,0},{64321,4,0,32},{40165,0,0,0},{64321,4,0,32},{40565,0,0,0},{64321,
4,0,32},{40575,0,0,0},{64321,4,0,32},{40613,0,0,0},{64321,4,0,32},{40635,0,0,0},
{64321,4,0,32},{40643,0,0,0},{64321,4,0,32},{40653,0,0,0},{64321,4,0,32},{40657,
0,0,0},{64321,4,0,32},{40697,0,0,0},{64321,4,0,32},{40701,0,0,0},{64321,4,0,32},
{40718,0,0,0},{64321,4,0,32},{40723,0,0,0},{64321,4,0,32},{40736,0,0,0},{64321,
4,0,32},{40763,0,0,0},{64321,4,0,32},{40778,0,0,0},{64321,4,0,32},{40786,0,0,0},
{64321,4,0,32},{40845,0,0,0},{64321,4,0,32},{40860,0,0,0},{64321,4,0,32},{40864,
0,0,0},{18658,4,0,32},{18680,4,0,32},{827,4,1,32},{0,4,0,292},{827,4,1,32},{0,4,
0,293},{827,4,1,32},{0,4,0,294},{8617,2,0,32},{0,2,0,55},{8618,2,0,32},{0,2,0,
55},{64320,4,0,32},{54081,0,0,0},{64320,4,0,32},{54084,0,0,0},{64320,4,0,32},
{54085,0,0,0},{18677,4,0,32},{18659,4,0,32},{18652,14,0,32},{0,2,0,55},{18653,
14,0,32},{0,2,0,55},{18654,14,0,32},{0,2,0,55},{18655,14,0,32},{0,2,0,55},
{18656,14,0,32},{0,2,0,55},{18657,14,0,32},{0,2,0,55},{18658,14,0,32},{0,2,0,
55},{18659,14,0,32},{0,2,0,55},{18660,14,0,32},{0,2,0,55},{18661,14,0,32},{0,2,
0,55},{18662,14,0,32},{0,2,0,55},{18663,14,0,32},{0,2,0,55},{18664,14,0,32},{0,
2,0,55},{18665,14,0,32},{0,2,0,55},{18666,14,0,32},{0,2,0,55},{18672,14,0,32},
{0,2,0,55},{18672,14,0,32},{0,2,0,56},{18673,14,0,32},{0,2,0,55},{18673,14,0,
32},{0,2,0,56},{18674,14,0,32},{0,2,0,55},{18674,14,0,32},{0,2,0,56},{18675,14,
0,32},{0,2,0,55},{18675,14,0,32},{0,2,0,56},{18676,14,0,32},{0,2,0,55},{18676,
14,0,32},{0,2,0,56},{18648,14,0,32},{0,2,0,55},{8620,2,0,32},{0,2,0,55},{18686,
22,0,32},{18688,22,0,32},{18652,17,0,32},{0,2,0,55},{18653,17,0,32},{0,2,0,55},
{18654,17,0,32},{0,2,0,55},{18655,17,0,32},{0,2,0,55},{18656,17,0,32},{0,2,0,
55},{18657,17,0,32},{0,2,0,55},{18658,17,0,32},{0,2,0,55},{18659,17,0,32},{0,2,
0,55},{18660,17,0,32},{0,2,0,55},{18661,17,0,32},{0,2,0,55},{18662,17,0,32},{0,
2,0,55},{18663,17,0,32},{0,2,0,55},{18664,17,0,32},{0,2,0,55},{18665,17,0,32},
{0,2,0,55},{18666,17,0,32},{0,2,0,55},{18672,17,0,32},{0,2,0,55},{18672,17,0,
32},{0,2,0,56},{18673,17,0,32},{0,2,0,55},{18673,17,0,32},{0,2,0,56},{18674,17,
0,32},{0,2,0,55},{18674,17,0,32},{0,2,0,56},{18675,17,0,32},{0,2,0,55},{18675,
17,0,32},{0,2,0,56},{18676,17,0,32},{0,2,0,55},{18676,17,0,32},{0,2,0,56},
{18648,17,0,32},{0,2,0,55},{18692,17,0,32},{0,2,0,55},{18693,17,0,32},{0,2,0,
55},{18695,17,0,32},{0,2,0,55},{18696,17,0,32},{0,2,0,55},{8622,2,0,32},{0,2,0,
55},{18656,22,0,32},{18666,22,0,32},{64320,20,0,32},{52736,0,0,0},{64320,20,0,
32},{52876,0,0,0},{64320,20,0,32},{52745,0,0,0},{64320,20,0,32},{55003,0,0,0},
{64320,20,0,32},{52746,0,0,0},{64320,20,0,32},{52781,0,0,0},{64320,20,0,32},
{52747,0,0,0},{64320,20,0,32},{62770,0,0,0},{64320,20,0,32},{52825,0,0,0},
{64320,20,0,32},{52761,0,0,0},{64320,20,0,32},{52737,0,0,0},{64320,20,0,32},
{55593,0,0,0},{64320,20,0,32},{55088,0,0,0},{64320,20,0,32},{52922,0,0,0},
{18984,4,0,32},{0,4,0,288},{19010,4,0,32},{0,4,0,288},{19000,4,0,32},{0,4,0,
288},{18995,4,0,32},{0,4,0,288},{19021,4,0,32},{0,4,0,288},{19017,4,0,32},{0,4,
0,288},{19035,4,0,32},{0,4,0,289},{19016,4,0,32},{0,4,0,288},{19034,4,0,32},{0,
4,0,288},{19035,4,0,32},{0,4,0,288},{19022,4,0,32},{0,4,0,288},{19024,4,0,32},
{0,4,0,288},{19034,22,0,32},{0,22,0,288},{830,4,1,32},{18289,4,0,32},{831,4,1,
32},{830,4,1,32},{18291,4,0,32},{831,4,1,32},{830,4,1,32},{18292,4,0,32},{831,4,
1,32},{830,4,1,32},{18294,4,0,32},{831,4,1,32},{830,4,1,32},{18295,4,0,32},{831,
4,1,32},{830,4,1,32},{18296,4,0,32},{831,4,1,32},{830,4,1,32},{18298,4,0,32},
{831,4,1,32},{830,4,1,32},{18300,4,0,32},{831,4,1,32},{830,4,1,32},{18301,4,0,
32},{831,4,1,32},{830,4,1,32},{18303,4,0,32},{831,4,1,32},{830,4,1,32},{18304,4,
0,32},{831,4,1,32},{830,4,1,32},{18305,4,0,32},{831,4,1,32},{830,4,1,32},{18306,
4,0,32},{831,4,1,32},{830,4,1,32},{18307,4,0,32},{831,4,1,32},{830,4,1,32},
{18289,4,0,32},{18415,4,0,32},{831,4,1,32},{830,4,1,32},{18291,4,0,32},{18415,4,
0,32},{831,4,1,32},{830,4,1,32},{18292,4,0,32},{18415,4,0,32},{831,4,1,32},{830,
4,1,32},{18294,4,0,32},{18415,4,0,32},{831,4,1,32},{830,4,1,32},{18295,4,0,32},
{18415,4,0,32},{831,4,1,32},{830,4,1,32},{18296,4,0,32},{18415,4,0,32},{831,4,1,
32},{830,4,1,32},{18298,4,0,32},{18415,4,0,32},{831,4,1,32},{830,4,1,32},{18300,
4,0,32},{18415,4,0,32},{831,4,1,32},{830,4,1,32},{18301,4,0,32},{18415,4,0,32},
{831,4,1,32},{830,4,1,32},{18303,4,0,32},{18415,4,0,32},{831,4,1,32},{830,4,1,
32},{18304,4,0,32},{18415,4,0,32},{831,4,1,32},{830,4,1,32},{18305,4,0,32},
{18415,4,0,32},{831,4,1,32},{830,4,1,32},{18306,4,0,32},{18415,4,0,32},{831,4,1,
32},{830,4,1,32},{18307,4,0,32},{18415,4,0,32},{831,4,1,32},{830,4,1,32},{18301,
4,0,32},{18428,4,0,32},{831,4,1,32},{830,4,1,32},{18300,4,0,32},{18423,4,0,32},
{18301,4,0,32},{18419,4,0,32},{18512,4,0,32},{831,4,1,32},{830,4,1,32},{18300,4,
0,32},{18423,4,0,32},{18307,4,0,32},{18428,4,0,32},{831,4,1,32},{830,4,1,32},
{64320,4,0,32},{52736,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},{52876,0,
0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},{52745,0,0,0},{831,4,1,32},{830,4,
1,32},{64320,4,0,32},{55003,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},
{52884,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},{53613,0,0,0},{831,4,1,
32},{830,4,1,32},{64320,4,0,32},{52739,0,0,0},{831,4,1,32},{830,4,1,32},{64320,
4,0,32},{53611,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},{52829,0,0,0},
{831,4,1,32},{830,4,1,32},{64320,4,0,32},{54081,0,0,0},{831,4,1,32},{830,4,1,
32},{64320,4,0,32},{59144,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},
{61547,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},{60468,0,0,0},{831,4,1,
32},{830,4,1,32},{64320,4,0,32},{59176,0,0,0},{831,4,1,32},{830,4,1,32},{64321,
4,0,32},{37329,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},{55071,0,0,0},
{831,4,1,32},{830,4,1,32},{64320,4,0,32},{58853,0,0,0},{831,4,1,32},{830,4,1,
32},{64320,4,0,32},{59434,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},
{59145,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},{63806,0,0,0},{831,4,1,
32},{830,4,1,32},{64320,4,0,32},{54285,0,0,0},{831,4,1,32},{830,4,1,32},{64320,
4,0,32},{62073,0,0,0},{831,4,1,32},{830,4,1,32},{64321,4,0,32},{36001,0,0,0},
{831,4,1,32},{830,4,1,32},{64320,4,0,32},{63837,0,0,0},{831,4,1,32},{830,4,1,
32},{64320,4,0,32},{53940,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},
{52963,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},{54396,0,0,0},{831,4,1,
32},{830,4,1,32},{64320,4,0,32},{56166,0,0,0},{831,4,1,32},{830,4,1,32},{64320,
4,0,32},{63203,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},{52993,0,0,0},
{831,4,1,32},{830,4,1,32},{64321,4,0,32},{36039,0,0,0},{831,4,1,32},{830,4,1,
32},{64320,4,0,32},{54100,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},
{63853,0,0,0},{831,4,1,32},{830,4,1,32},{64320,4,0,32},{53009,0,0,0},{831,4,1,
32},{830,4,1,32},{64321,4,0,32},{33258,0,0,0},{831,4,1,32},{830,4,1,32},{64321,
4,0,32},{33267,0,0,0},{831,4,1,32},{64320,6,0,32},{54607,0,0,0},{64320,6,0,32},
{56956,0,0,0},{64320,6,0,32},{58759,0,0,0},{64320,6,0,32},{64399,0,0,0},{8679,6,
0,32},{8678,6,0,32},{8680,6,0,32},{8678,6,0,32},{8681,6,0,32},{8678,6,0,32},
{8682,6,0,32},{8678,6,0,32},{8683,6,0,32},{8678,6,0,32},{8684,6,0,32},{8678,6,0,
32},{8685,6,0,32},{8678,6,0,32},{8686,6,0,32},{8678,6,0,32},{9672,29,0,32},
{9821,29,0,32},{9299,29,0,32},{8680,6,0,32},{8679,6,0,32},{8680,6,0,32},{8680,6,
0,32},{8680,6,0,32},{8681,6,0,32},{8680,6,0,32},{8682,6,0,32},{8680,6,0,32},
{8683,6,0,32},{8680,6,0,32},{8684,6,0,32},{8680,6,0,32},{8685,6,0,32},{8680,6,0,
32},{8686,6,0,32},{8680,6,0,32},{8687,6,0,32},{8681,6,0,32},{8678,6,0,32},{8681,
6,0,32},{8679,6,0,32},{8681,6,0,32},{8680,6,0,32},{8681,6,0,32},{8681,6,0,32},
{8681,6,0,32},{8682,6,0,32},{8681,6,0,32},{8683,6,0,32},{18289,6,0,32},{18415,6,
0,32},{18291,6,0,32},{18415,6,0,32},{18292,6,0,32},{18415,6,0,32},{18294,6,0,
32},{18415,6,0,32},{18295,6,0,32},{18415,6,0,32},{18296,6,0,32},{18415,6,0,32},
{18298,6,0,32},{18415,6,0,32},{18300,6,0,32},{18415,6,0,32},{18301,6,0,32},
{18415,6,0,32},{18303,6,0,32},{18415,6,0,32},{18304,6,0,32},{18415,6,0,32},
{18305,6,0,32},{18415,6,0,32},{18306,6,0,32},{18415,6,0,32},{18307,6,0,32},
{18415,6,0,32},{18303,6,0,32},{18415,6,0,32},{18524,6,0,32},{18289,6,0,32},
{18423,6,0,32},{18301,6,0,32},{18428,6,0,32},{18300,6,0,32},{18434,6,0,32},
{18300,6,0,32},{18428,6,0,32},{64320,6,0,32},{52736,0,0,0},{64320,6,0,32},
{52876,0,0,0},{64320,6,0,32},{52745,0,0,0},{64320,6,0,32},{55003,0,0,0},{64320,
6,0,32},{52884,0,0,0},{64320,6,0,32},{53613,0,0,0},{64320,6,0,32},{52739,0,0,0},
{64320,6,0,32},{53611,0,0,0},{64320,6,0,32},{52829,0,0,0},{64320,6,0,32},{54081,
0,0,0},{64320,6,0,32},{59144,0,0,0},{64320,6,0,32},{61547,0,0,0},{64320,6,0,32},
{60468,0,0,0},{64320,6,0,32},{59176,0,0,0},{64321,6,0,32},{37329,0,0,0},{64320,
6,0,32},{55071,0,0,0},{64320,6,0,32},{58853,0,0,0},{64320,6,0,32},{59434,0,0,0},
{64320,6,0,32},{59145,0,0,0},{64320,6,0,32},{63806,0,0,0},{64320,6,0,32},{54285,
0,0,0},{64320,6,0,32},{62073,0,0,0},{64321,6,0,32},{36001,0,0,0},{64320,6,0,32},
{63837,0,0,0},{64320,6,0,32},{53940,0,0,0},{64320,6,0,32},{63960,0,0,0},{64320,
6,0,32},{62775,0,0,0},{64320,6,0,32},{55667,0,0,0},{64321,6,0,32},{36969,0,0,0},
{64320,6,0,32},{53546,0,0,0},{64320,6,0,32},{54128,0,0,0},{64320,6,0,32},{60648,
0,0,0},{64321,6,0,32},{38917,0,0,0},{64320,6,0,32},{53009,0,0,0},{64320,6,0,32},
{53657,0,0,0},{64320,6,0,32},{60259,0,0,0},{64320,6,0,32},{52746,0,0,0},{64320,
6,0,32},{52781,0,0,0},{64320,6,0,32},{52747,0,0,0},{64320,6,0,32},{56806,0,0,0},
{64320,6,0,32},{54259,0,0,0},{64320,6,0,32},{54075,0,0,0},{64320,6,0,32},{56215,
0,0,0},{64320,6,0,32},{56166,0,0,0},{64320,6,0,32},{63203,0,0,0},{64320,6,0,32},
{52993,0,0,0},{64321,6,0,32},{36039,0,0,0},{64320,6,0,32},{54100,0,0,0},{64320,
6,0,32},{55580,0,0,0},{8681,6,0,32},{8684,6,0,32},{8681,6,0,32},{8685,6,0,32},
{8681,6,0,32},{8686,6,0,32},{8681,6,0,32},{8687,6,0,32},{8682,6,0,32},{8678,6,0,
32},{8682,6,0,32},{8679,6,0,32},{8682,6,0,32},{8680,6,0,32},{8682,6,0,32},{8681,
6,0,32},{8682,6,0,32},{8682,6,0,32},{8682,6,0,32},{8683,6,0,32},{8682,6,0,32},
{8684,6,0,32},{8682,6,0,32},{8685,6,0,32},{8682,6,0,32},{8686,6,0,32},{8682,6,0,
32},{8687,6,0,32},{8683,6,0,32},{8678,6,0,32},{8679,4,0,32},{64320,4,0,32},
{59144,0,0,0},{8680,4,0,32},{64320,4,0,32},{59144,0,0,0},{8681,4,0,32},{64320,4,
0,32},{59144,0,0,0},{8682,4,0,32},{64320,4,0,32},{59144,0,0,0},{8683,4,0,32},
{64320,4,0,32},{59144,0,0,0},{8684,4,0,32},{64320,4,0,32},{59144,0,0,0},{8685,4,
0,32},{64320,4,0,32},{59144,0,0,0},{8686,4,0,32},{64320,4,0,32},{59144,0,0,0},
{8687,4,0,32},{64320,4,0,32},{59144,0,0,0},{8679,4,0,32},{8678,4,0,32},{64320,4,
0,32},{59144,0,0,0},{8679,4,0,32},{8679,4,0,32},{64320,4,0,32},{59144,0,0,0},
{8679,4,0,32},{8680,4,0,32},{64320,4,0,32},{59144,0,0,0},{9412,29,0,32},{9373,
28,0,32},{9299,28,0,32},{9712,28,0,32},{9373,28,0,32},{9299,28,0,32},{9904,29,0,
32},{9512,29,0,32},{9821,29,0,32},{9270,29,0,32},{64320,28,0,32},{52964,0,0,0},
{64320,28,0,32},{54412,0,0,0},{18646,28,0,32},{18672,28,0,32},{0,28,0,56},{8621,
28,0,32},{18666,28,0,32},{18646,28,0,32},{18689,28,0,32},{18674,28,0,32},{18646,
28,0,32},{18646,28,0,32},{18697,28,0,32},{18675,28,0,32},{0,28,0,56},{18646,28,
0,32},{18646,28,0,32},{8621,28,0,32},{18689,28,0,32},{18647,28,0,32},{18668,28,
0,32},{18697,28,0,32},{18654,28,0,32},{0,28,0,55},{18647,28,0,32},{18697,28,0,
32},{18663,28,0,32},{18648,28,0,32},{18651,28,0,32},{18697,28,0,32},{18650,28,0,
32},{18659,28,0,32},{18654,28,0,32},{8621,28,0,32},{18666,28,0,32},{0,28,0,55},
{18650,28,0,32},{8621,28,0,32},{18652,28,0,32},{8621,28,0,32},{18651,28,0,32},
{18697,28,0,32},{18659,28,0,32},{18651,28,0,32},{8621,28,0,32},{18679,28,0,32},
{18652,28,0,32},{18647,28,0,32},{18688,28,0,32},{18652,28,0,32},{18687,28,0,32},
{18664,28,0,32},{18666,28,0,32},{18652,28,0,32},{18691,28,0,32},{18688,28,0,32},
{8621,28,0,32},{18652,28,0,32},{0,28,0,55},{18691,28,0,32},{18697,28,0,32},
{18652,28,0,32},{0,28,0,55},{18697,28,0,32},{18677,28,0,32},{18653,28,0,32},{0,
28,0,55},{18652,28,0,32},{0,28,0,55},{18653,28,0,32},{0,28,0,55},{18668,28,0,
32},{8621,28,0,32},{18653,28,0,32},{18684,28,0,32},{18688,28,0,32},{8621,28,0,
32},{18653,28,0,32},{0,28,0,55},{18689,28,0,32},{18662,28,0,32},{0,28,0,55},
{8621,28,0,32},{18653,28,0,32},{18691,28,0,32},{18653,28,0,32},{18691,28,0,32},
{18654,28,0,32},{0,28,0,55},{18687,28,0,32},{18679,28,0,32},{18653,28,0,32},
{18691,28,0,32},{18680,28,0,32},{8621,28,0,32},{18666,28,0,32},{18689,28,0,32},
{18653,28,0,32},{18691,28,0,32},{18692,28,0,32},{18664,28,0,32},{18666,28,0,32},
{18654,28,0,32},{0,28,0,55},{18687,28,0,32},{18679,28,0,32},{18654,28,0,32},{0,
28,0,55},{18687,28,0,32},{18679,28,0,32},{18666,28,0,32},{18697,28,0,32},{18654,
28,0,32},{18689,28,0,32},{18660,28,0,32},{0,28,0,55},{18647,28,0,32},{18691,28,
0,32},{18654,28,0,32},{18691,28,0,32},{8621,28,0,32},{18670,28,0,32},{18655,28,
0,32},{8621,28,0,32},{18659,28,0,32},{18656,28,0,32},{18689,28,0,32},{18667,28,
0,32},{18656,28,0,32},{8621,28,0,32},{18676,28,0,32},{0,28,0,56},{18657,28,0,
32},{18647,28,0,32},{18654,28,0,32},{18689,28,0,32},{18657,28,0,32},{18697,28,0,
32},{18663,28,0,32},{8621,28,0,32},{18679,28,0,32},{18658,28,0,32},{18688,28,0,
32},{18697,28,0,32},{18654,28,0,32},{0,28,0,55},{18660,28,0,32},{18697,28,0,32},
{18663,28,0,32},{18660,28,0,32},{18697,28,0,32},{18666,28,0,32},{18662,28,0,32},
{0,28,0,55},{8621,28,0,32},{18659,28,0,32},{18665,28,0,32},{0,28,0,55},{18658,
28,0,32},{18666,28,0,32},{0,28,0,55},{18689,28,0,32},{18666,28,0,32},{18697,28,
0,32},{18667,28,0,32},{18671,28,0,32},{18671,28,0,32},{18664,28,0,32},{18666,28,
0,32},{18672,28,0,32},{18647,28,0,32},{18664,28,0,32},{18672,28,0,32},{0,28,0,
56},{8621,28,0,32},{18660,28,0,32},{18697,28,0,32},{18666,28,0,32},{18672,28,0,
32},{0,28,0,56},{8621,28,0,32},{18664,28,0,32},{18672,28,0,32},{0,28,0,55},
{8621,28,0,32},{18690,28,0,32},{18689,28,0,32},{18673,28,0,32},{0,28,0,56},
{18646,28,0,32},{18659,28,0,32},{18666,28,0,32},{18689,28,0,32},{18673,28,0,32},
{0,28,0,56},{18654,28,0,32},{18689,28,0,32},{18673,28,0,32},{0,28,0,56},{18656,
28,0,32},{18673,28,0,32},{0,28,0,55},{18689,28,0,32},{18674,28,0,32},{18646,28,
0,32},{18687,28,0,32},{18664,28,0,32},{18666,28,0,32},{0,28,0,55},{18674,28,0,
32},{18647,28,0,32},{8621,28,0,32},{18666,28,0,32},{18674,28,0,32},{0,28,0,55},
{18664,28,0,32},{18658,28,0,32},{18650,28,0,32},{18689,28,0,32},{18674,28,0,32},
{18687,28,0,32},{18697,28,0,32},{18675,28,0,32},{18654,28,0,32},{18662,28,0,32},
{8621,28,0,32},{18689,28,0,32},{18675,28,0,32},{0,28,0,56},{18661,28,0,32},
{18675,28,0,32},{0,28,0,56},{18668,28,0,32},{18673,28,0,32},{18675,28,0,32},
{18689,28,0,32},{18664,28,0,32},{18675,28,0,32},{0,28,0,56},{18697,28,0,32},
{18659,28,0,32},{18675,28,0,32},{0,28,0,56},{8621,28,0,32},{18658,28,0,32},{0,
28,0,55},{18675,28,0,32},{0,28,0,55},{8621,28,0,32},{18662,28,0,32},{18676,28,0,
32},{0,28,0,56},{18647,28,0,32},{18697,28,0,32},{18666,28,0,32},{18676,28,0,32},
{0,28,0,55},{18689,28,0,32},{18666,28,0,32},{18676,28,0,32},{18697,28,0,32},
{18676,28,0,32},{0,28,0,56},{18697,28,0,32},{18666,28,0,32},{0,28,0,55},{18676,
28,0,32},{8621,28,0,32},{18689,28,0,32},{18676,28,0,32},{8621,28,0,32},{18697,
28,0,32},{18677,28,0,32},{18647,28,0,32},{18654,28,0,32},{18691,28,0,32},{18677,
28,0,32},{18647,28,0,32},{18689,28,0,32},{18677,28,0,32},{18664,28,0,32},{18672,
28,0,32},{18677,28,0,32},{18689,28,0,32},{18654,28,0,32},{18677,28,0,32},{18697,
28,0,32},{18658,28,0,32},{18686,28,0,32},{18697,28,0,32},{18678,28,0,32},{18654,
28,0,32},{18691,28,0,32},{18697,28,0,32},{18678,28,0,32},{18688,28,0,32},{18678,
28,0,32},{18688,28,0,32},{18672,28,0,32},{0,28,0,55},{8621,28,0,32},{18689,28,0,
32},{18680,28,0,32},{18652,28,0,32},{0,28,0,55},{18680,28,0,32},{18652,28,0,32},
{0,28,0,55},{18666,28,0,32},{18697,28,0,32},{18680,28,0,32},{8621,28,0,32},
{18666,28,0,32},{18689,28,0,32},{18682,28,0,32},{8621,28,0,32},{18666,28,0,32},
{0,28,0,55},{18682,28,0,32},{8621,28,0,32},{18689,28,0,32},{18684,28,0,32},
{18646,28,0,32},{18697,28,0,32},{18688,28,0,32},{18664,28,0,32},{18666,28,0,32},
{18689,28,0,32},{18688,28,0,32},{18687,28,0,32},{18689,28,0,32},{18673,28,0,32},
{0,28,0,56},{8621,28,0,32},{18689,28,0,32},{8621,28,0,32},{18674,28,0,32},{0,28,
0,55},{18689,28,0,32},{18690,28,0,32},{18679,28,0,32},{18690,28,0,32},{18697,28,
0,32},{18666,28,0,32},{18655,28,0,32},{0,28,0,55},{18697,28,0,32},{18692,28,0,
32},{18664,28,0,32},{18666,28,0,32},{8678,4,0,32},{64320,4,0,32},{61625,0,0,0},
{8679,4,0,32},{64320,4,0,32},{61625,0,0,0},{8680,4,0,32},{64320,4,0,32},{61625,
0,0,0},{8681,4,0,32},{64320,4,0,32},{61625,0,0,0},{8682,4,0,32},{64320,4,0,32},
{61625,0,0,0},{8683,4,0,32},{64320,4,0,32},{61625,0,0,0},{8684,4,0,32},{64320,4,
0,32},{61625,0,0,0},{8685,4,0,32},{64320,4,0,32},{61625,0,0,0},{8686,4,0,32},
{64320,4,0,32},{61625,0,0,0},{8687,4,0,32},{64320,4,0,32},{61625,0,0,0},{8679,4,
0,32},{8678,4,0,32},{64320,4,0,32},{61625,0,0,0},{8679,4,0,32},{8679,4,0,32},
{64320,4,0,32},{61625,0,0,0},{8679,4,0,32},{8680,4,0,32},{64320,4,0,32},{61625,
0,0,0},{8679,4,0,32},{8681,4,0,32},{64320,4,0,32},{61625,0,0,0},{8679,4,0,32},
{8682,4,0,32},{64320,4,0,32},{61625,0,0,0},{8679,4,0,32},{8683,4,0,32},{64320,4,
0,32},{61625,0,0,0},{8679,4,0,32},{8684,4,0,32},{64320,4,0,32},{61625,0,0,0},
{8679,4,0,32},{8685,4,0,32},{64320,4,0,32},{61625,0,0,0},{8679,4,0,32},{8686,4,
0,32},{64320,4,0,32},{61625,0,0,0},{8679,4,0,32},{8687,4,0,32},{64320,4,0,32},
{61625,0,0,0},{8680,4,0,32},{8678,4,0,32},{64320,4,0,32},{61625,0,0,0},{8680,4,
0,32},{8679,4,0,32},{64320,4,0,32},{61625,0,0,0},{8680,4,0,32},{8680,4,0,32},
{64320,4,0,32},{61625,0,0,0},{8680,4,0,32},{8681,4,0,32},{64320,4,0,32},{61625,
0,0,0},{8680,4,0,32},{8682,4,0,32},{64320,4,0,32},{61625,0,0,0},{9412,28,0,32},
{9672,29,0,32},{9196,28,0,32},{9270,28,0,32},{9196,28,0,32},{9196,29,0,32},
{9856,29,0,32},{9222,28,0,32},{9196,28,0,32},{9712,28,0,32},{9624,28,0,32},
{9904,29,0,32},{9672,28,0,32},{9248,28,0,32},{9270,28,0,32},{9570,28,0,32},
{9270,28,0,32},{9570,28,0,32},{8680,28,0,32},{9270,28,0,32},{9570,28,0,32},
{8681,28,0,32},{9439,29,0,32},{9856,29,0,32},{64320,28,0,32},{56947,0,0,0},
{64320,28,0,32},{57872,0,0,0},{64320,28,0,32},{58925,0,0,0},{64320,28,0,32},
{54412,0,0,0},{64320,28,0,32},{55591,0,0,0},{64320,28,0,32},{60259,0,0,0},
{64320,28,0,32},{58894,0,0,0},{64320,28,0,32},{60603,0,0,0},{64320,28,0,32},
{59434,0,0,0},{64320,28,0,32},{57103,0,0,0},{64320,28,0,32},{53018,0,0,0},
{64320,28,0,32},{63806,0,0,0},{9672,28,0,32},{9196,29,0,32},{9585,28,0,32},
{9196,29,0,32},{10143,28,0,32},{9196,29,0,32},{9570,28,0,32},{9196,29,0,32},
{9492,28,0,32},{9196,29,0,32},{9492,29,0,32},{9222,29,0,32},{9570,29,0,32},
{9222,29,0,32},{9373,29,0,32},{9222,29,0,32},{9248,28,0,32},{9196,28,0,32},
{9512,28,0,32},{9492,28,0,32},{9248,28,0,32},{9196,28,0,32},{9512,28,0,32},
{9672,28,0,32},{9358,29,0,32},{9585,28,0,32},{9358,29,0,32},{10143,28,0,32},
{9358,29,0,32},{10143,28,0,32},{9373,28,0,32},{9570,28,0,32},{9373,28,0,32},
{9492,28,0,32},{9373,28,0,32},{9412,29,0,32},{9966,28,0,32},{9492,28,0,32},
{9412,29,0,32},{9966,28,0,32},{9570,29,0,32},{9412,29,0,32},{9966,28,0,32},
{9373,29,0,32},{9412,29,0,32},{9966,28,0,32},{9821,29,0,32},{9412,29,0,32},
{9966,28,0,32},{10143,28,0,32},{9512,28,0,32},{9570,28,0,32},{9512,28,0,32},
{9270,28,0,32},{9512,28,0,32},{9492,28,0,32},{9512,28,0,32},{9358,28,0,32},
{9570,28,0,32},{9585,28,0,32},{9570,28,0,32},{10143,28,0,32},{9570,28,0,32},
{9570,28,0,32},{9570,28,0,32},{9248,28,0,32},{9570,28,0,32},{9492,28,0,32},
{9570,28,0,32},{9570,28,0,32},{9570,28,0,32},{8680,28,0,32},{9248,28,0,32},
{9570,28,0,32},{8680,28,0,32},{9570,28,0,32},{8680,28,0,32},{9492,28,0,32},
{9570,28,0,32},{8680,28,0,32},{9570,28,0,32},{9570,28,0,32},{8681,28,0,32},
{9248,28,0,32},{9570,28,0,32},{8681,28,0,32},{9570,28,0,32},{8681,28,0,32},
{9492,28,0,32},{9570,28,0,32},{8681,28,0,32},{9570,28,0,32},{1767,28,1,32},
{9778,28,0,32},{9570,28,0,32},{1767,28,1,32},{9778,28,0,32},{8680,28,0,32},
{9672,29,0,32},{9196,28,0,32},{9492,28,0,32},{9672,29,0,32},{9196,28,0,32},
{9570,29,0,32},{9672,29,0,32},{9196,28,0,32},{9373,29,0,32},{9672,29,0,32},
{9196,28,0,32},{9712,28,0,32},{9196,28,0,32},{9270,28,0,32},{9712,28,0,32},
{9196,28,0,32},{9270,28,0,32},{1767,28,1,32},{9778,28,0,32},{9712,28,0,32},
{9196,28,0,32},{9270,28,0,32},{1767,28,1,32},{9778,28,0,32},{8680,28,0,32},
{9672,28,0,32},{9778,28,0,32},{9585,28,0,32},{9778,28,0,32},{10143,28,0,32},
{9778,28,0,32},{9570,28,0,32},{9778,28,0,32},{9672,28,0,32},{9904,29,0,32},
{9585,28,0,32},{9904,29,0,32},{10143,28,0,32},{9904,29,0,32},{9570,28,0,32},
{9904,29,0,32},{9492,28,0,32},{9904,29,0,32},{9570,29,0,32},{9904,29,0,32},
{9672,28,0,32},{9922,29,0,32},{9585,28,0,32},{9922,29,0,32},{10143,28,0,32},
{9922,29,0,32},{9570,28,0,32},{9922,29,0,32},{9492,28,0,32},{9922,29,0,32},
{9570,29,0,32},{9922,29,0,32},{9492,28,0,32},{10165,29,0,32},{9570,29,0,32},
{10165,29,0,32},{9196,28,0,32},{642,28,1,32},{9570,28,0,32},{642,28,1,32},{9222,
29,0,32},{9693,28,0,32},{9248,28,0,32},{9248,28,0,32},{9248,28,0,32},{9270,28,0,
32},{9248,29,0,32},{1767,28,1,32},{9492,28,0,32},{9373,28,0,32},{9248,29,0,32},
{9624,28,0,32},{642,28,1,32},{9270,28,0,32},{9222,29,0,32},{9373,29,0,32},{9944,
28,0,32},{9412,28,0,32},{9196,28,0,32},{9412,29,0,32},{9672,29,0,32},{9439,28,0,
32},{9585,28,0,32},{9492,29,0,32},{9492,29,0,32},{9492,29,0,32},{9570,29,0,32},
{9492,28,0,32},{9821,28,0,32},{9512,28,0,32},{9570,28,0,32},{9512,28,0,32},
{9585,28,0,32},{9512,28,0,32},{9624,28,0,32},{9373,28,0,32},{9512,28,0,32},
{9932,28,0,32},{9570,28,0,32},{9222,28,0,32},{9570,28,0,32},{9439,28,0,32},
{9512,28,0,32},{9570,28,0,32},{9624,28,0,32},{9512,28,0,32},{9672,29,0,32},
{9412,29,0,32},{9672,28,0,32},{642,28,1,32},{9570,28,0,32},{642,28,1,32},{9672,
29,0,32},{9672,29,0,32},{9570,29,0,32},{9672,29,0,32},{9712,29,0,32},{9778,28,0,
32},{9712,28,0,32},{9778,29,0,32},{9904,28,0,32},{9922,29,0,32},{9222,28,0,32},
{9904,29,0,32},{1767,28,1,32},{9570,28,0,32},{9196,29,0,32},{1767,28,1,32},
{9570,28,0,32},{8679,4,0,32},{64320,4,0,32},{58853,0,0,0},{8680,4,0,32},{64320,
4,0,32},{58853,0,0,0},{8681,4,0,32},{64320,4,0,32},{58853,0,0,0},{8682,4,0,32},
{64320,4,0,32},{58853,0,0,0},{8683,4,0,32},{64320,4,0,32},{58853,0,0,0},{8684,4,
0,32},{64320,4,0,32},{58853,0,0,0},{8685,4,0,32},{64320,4,0,32},{58853,0,0,0},
{8686,4,0,32},{64320,4,0,32},{58853,0,0,0},{8687,4,0,32},{64320,4,0,32},{58853,
0,0,0},{8679,4,0,32},{8678,4,0,32},{64320,4,0,32},{58853,0,0,0},{8679,4,0,32},
{8679,4,0,32},{64320,4,0,32},{58853,0,0,0},{8679,4,0,32},{8680,4,0,32},{64320,4,
0,32},{58853,0,0,0},{8679,4,0,32},{8681,4,0,32},{64320,4,0,32},{58853,0,0,0},
{8679,4,0,32},{8682,4,0,32},{64320,4,0,32},{58853,0,0,0},{8679,4,0,32},{8683,4,
0,32},{64320,4,0,32},{58853,0,0,0},{8679,4,0,32},{8684,4,0,32},{64320,4,0,32},
{58853,0,0,0},{8679,4,0,32},{8685,4,0,32},{64320,4,0,32},{58853,0,0,0},{8679,4,
0,32},{8686,4,0,32},{64320,4,0,32},{58853,0,0,0},{8679,4,0,32},{8687,4,0,32},
{64320,4,0,32},{58853,0,0,0},{8680,4,0,32},{8678,4,0,32},{64320,4,0,32},{58853,
0,0,0},{8680,4,0,32},{8679,4,0,32},{64320,4,0,32},{58853,0,0,0},{8680,4,0,32},
{8680,4,0,32},{64320,4,0,32},{58853,0,0,0},{8680,4,0,32},{8681,4,0,32},{64320,4,
0,32},{58853,0,0,0},{8680,4,0,32},{8682,4,0,32},{64320,4,0,32},{58853,0,0,0},
{8680,4,0,32},{8683,4,0,32},{64320,4,0,32},{58853,0,0,0},{8680,4,0,32},{8684,4,
0,32},{64320,4,0,32},{58853,0,0,0},{8680,4,0,32},{8685,4,0,32},{64320,4,0,32},
{58853,0,0,0},{8680,4,0,32},{8686,4,0,32},{64320,4,0,32},{58853,0,0,0},{8680,4,
0,32},{8687,4,0,32},{64320,4,0,32},{58853,0,0,0},{8681,4,0,32},{8678,4,0,32},
{64320,4,0,32},{58853,0,0,0},{8681,4,0,32},{8679,4,0,32},{64320,4,0,32},{58853,
0,0,0},{9373,28,0,32},{9196,28,0,32},{9512,28,0,32},{64384,2,0,32},{46238,0,0,
0},{64384,2,0,32},{46265,0,0,0},{64384,2,0,32},{46267,0,0,0},{64384,2,0,32},
{46303,0,0,0},{64384,2,0,32},{46357,0,0,0},{64384,2,0,32},{46830,0,0,0},{64384,
2,0,32},{46844,0,0,0},{64384,2,0,32},{46977,0,0,0},{64384,2,0,32},{47151,0,0,0},
{64384,2,0,32},{47202,0,0,0},{64384,2,0,32},{47228,0,0,0},{64384,2,0,32},{47303,
0,0,0},{64384,2,0,32},{47331,0,0,0},{64384,2,0,32},{47388,0,0,0},{64384,2,0,32},
{47418,0,0,0},{64384,2,0,32},{47662,0,0,0},{64384,2,0,32},{47724,0,0,0},{64384,
2,0,32},{47844,0,0,0},{64384,2,0,32},{47880,0,0,0},{64384,2,0,32},{47897,0,0,0},
{64384,2,0,32},{47945,0,0,0},{64384,2,0,32},{48029,0,0,0},{64384,2,0,32},{48152,
0,0,0},{64384,2,0,32},{48206,0,0,0},{64384,2,0,32},{48435,0,0,0},{64384,2,0,32},
{48534,0,0,0},{64384,2,0,32},{48812,0,0,0},{64384,2,0,32},{48824,0,0,0},{64384,
2,0,32},{48923,0,0,0},{64384,2,0,32},{49148,0,0,0},{64384,2,0,32},{49160,0,0,0},
{64384,2,0,32},{49176,0,0,0},{64384,2,0,32},{49209,0,0,0},{64384,2,0,32},{49222,
0,0,0},{64384,2,0,32},{49302,0,0,0},{64384,2,0,32},{49379,0,0,0},{64384,2,0,32},
{49455,0,0,0},{64384,2,0,32},{49666,0,0,0},{64384,2,0,32},{49703,0,0,0},{64384,
2,0,32},{49824,0,0,0},{64384,2,0,32},{49921,0,0,0},{64384,2,0,32},{49972,0,0,0},
{64384,2,0,32},{50009,0,0,0},{64384,2,0,32},{50133,0,0,0},{64384,2,0,32},{50137,
0,0,0},{64384,2,0,32},{50187,0,0,0},{64384,2,0,32},{50283,0,0,0},{64384,2,0,32},
{50475,0,0,0},{64384,2,0,32},{50525,0,0,0},{64384,2,0,32},{50529,0,0,0},{64384,
2,0,32},{50539,0,0,0},{64384,2,0,32},{50647,0,0,0},{64384,2,0,32},{50681,0,0,0},
{64384,2,0,32},{50741,0,0,0},{64384,2,0,32},{50878,0,0,0},{64384,2,0,32},{50887,
0,0,0},{64384,2,0,32},{51605,0,0,0},{64384,2,0,32},{51686,0,0,0},{64384,2,0,32},
{51822,0,0,0},{64384,2,0,32},{51830,0,0,0},{64384,2,0,32},{51890,0,0,0},{64384,
2,0,32},{52019,0,0,0},{64384,2,0,32},{52174,0,0,0},{64384,2,0,32},{52430,0,0,0},
{64384,2,0,32},{52461,0,0,0},{64384,2,0,32},{52472,0,0,0},{64384,2,0,32},{52566,
0,0,0},{64320,2,0,32},{52749,0,0,0},{64320,2,0,32},{52774,0,0,0},{64320,2,0,32},
{52786,0,0,0},{64320,2,0,32},{52792,0,0,0},{64320,2,0,32},{52793,0,0,0},{64320,
2,0,32},{52797,0,0,0},{64320,2,0,32},{52801,0,0,0},{64320,2,0,32},{52866,0,0,0},
{64320,2,0,32},{52870,0,0,0},{64320,2,0,32},{52910,0,0,0},{64320,2,0,32},{52928,
0,0,0},{64320,2,0,32},{52940,0,0,0},{64320,2,0,32},{52964,0,0,0},{64320,2,0,32},
{53088,0,0,0},{64320,2,0,32},{53120,0,0,0},{64320,2,0,32},{53126,0,0,0},{64320,
2,0,32},{53131,0,0,0},{64320,2,0,32},{53166,0,0,0},{64320,2,0,32},{53179,0,0,0},
{64320,2,0,32},{53183,0,0,0},{64320,2,0,32},{53250,0,0,0},{64320,2,0,32},{53291,
0,0,0},{64320,2,0,32},{53370,0,0,0},{64320,2,0,32},{53401,0,0,0},{64320,2,0,32},
{53455,0,0,0},{64320,2,0,32},{53466,0,0,0},{64320,2,0,32},{53479,0,0,0},{64320,
2,0,32},{53568,0,0,0},{64320,2,0,32},{53573,0,0,0},{64320,2,0,32},{53581,0,0,0},
{64320,2,0,32},{53588,0,0,0},{64320,2,0,32},{53604,0,0,0},{64320,2,0,32},{53607,
0,0,0},{64320,2,0,32},{53608,0,0,0},{64320,2,0,32},{53609,0,0,0},{64320,2,0,32},
{53613,0,0,0},{64320,2,0,32},{53623,0,0,0},{64320,2,0,32},{53632,0,0,0},{64320,
2,0,32},{53645,0,0,0},{64320,2,0,32},{53650,0,0,0},{64320,2,0,32},{53653,0,0,0},
{64320,2,0,32},{53655,0,0,0},{64320,2,0,32},{53668,0,0,0},{64320,2,0,32},{53676,
0,0,0},{64320,2,0,32},{53685,0,0,0},{64320,2,0,32},{53687,0,0,0},{64320,2,0,32},
{53705,0,0,0},{64320,2,0,32},{53708,0,0,0},{64320,2,0,32},{53724,0,0,0},{64320,
2,0,32},{53726,0,0,0},{64320,2,0,32},{53749,0,0,0},{64320,2,0,32},{53763,0,0,0},
{64320,2,0,32},{53767,0,0,0},{64320,2,0,32},{53783,0,0,0},{64320,2,0,32},{53801,
0,0,0},{64320,2,0,32},{53818,0,0,0},{64320,2,0,32},{53819,0,0,0},{64320,2,0,32},
{53830,0,0,0},{64320,2,0,32},{53874,0,0,0},{64320,2,0,32},{53879,0,0,0},{64320,
2,0,32},{53897,0,0,0},{64320,2,0,32},{53915,0,0,0},{64320,2,0,32},{53923,0,0,0},
{64320,2,0,32},{53939,0,0,0},{64320,2,0,32},{53959,0,0,0},{64320,2,0,32},{53961,
0,0,0},{64320,2,0,32},{53970,0,0,0},{64320,2,0,32},{53982,0,0,0},{64320,2,0,32},
{53988,0,0,0},{64320,2,0,32},{54005,0,0,0},{64320,2,0,32},{54010,0,0,0},{64320,
2,0,32},{54021,0,0,0},{64320,2,0,32},{54022,0,0,0},{64320,2,0,32},{54039,0,0,0},
{64320,2,0,32},{54079,0,0,0},{64320,2,0,32},{54089,0,0,0},{64320,2,0,32},{54097,
0,0,0},{64320,2,0,32},{54106,0,0,0},{64320,2,0,32},{54131,0,0,0},{64320,2,0,32},
{54133,0,0,0},{64320,2,0,32},{54141,0,0,0},{64320,2,0,32},{54143,0,0,0},{64320,
2,0,32},{54211,0,0,0},{64320,2,0,32},{54218,0,0,0},{64320,2,0,32},{54239,0,0,0},
{64320,2,0,32},{54245,0,0,0},{64320,2,0,32},{54251,0,0,0},{64320,2,0,32},{54257,
0,0,0},{64320,2,0,32},{54278,0,0,0},{64320,2,0,32},{54287,0,0,0},{64320,2,0,32},
{54301,0,0,0},{64320,2,0,32},{54328,0,0,0},{64320,2,0,32},{54338,0,0,0},{64320,
2,0,32},{54344,0,0,0},{64320,2,0,32},{54376,0,0,0},{64320,2,0,32},{54430,0,0,0},
{64320,2,0,32},{54434,0,0,0},{64320,2,0,32},{54461,0,0,0},{64320,2,0,32},{54518,
0,0,0},{64320,2,0,32},{54544,0,0,0},{64320,2,0,32},{54611,0,0,0},{64320,2,0,32},
{54613,0,0,0},{64320,2,0,32},{54627,0,0,0},{64320,2,0,32},{54660,0,0,0},{64320,
2,0,32},{54663,0,0,0},{64320,2,0,32},{54681,0,0,0},{64320,2,0,32},{54685,0,0,0},
{64320,2,0,32},{54699,0,0,0},{64320,2,0,32},{54707,0,0,0},{64320,2,0,32},{54720,
0,0,0},{64320,2,0,32},{54722,0,0,0},{64320,2,0,32},{54754,0,0,0},{64320,2,0,32},
{54790,0,0,0},{64320,2,0,32},{54865,0,0,0},{64320,2,0,32},{54888,0,0,0},{64320,
2,0,32},{54900,0,0,0},{64320,2,0,32},{55033,0,0,0},{64320,2,0,32},{55062,0,0,0},
{64320,2,0,32},{55063,0,0,0},{64320,2,0,32},{55179,0,0,0},{64320,2,0,32},{55246,
0,0,0},{64320,2,0,32},{55284,0,0,0},{64320,2,0,32},{55309,0,0,0},{64320,2,0,32},
{55345,0,0,0},{64320,2,0,32},{55346,0,0,0},{64320,2,0,32},{55360,0,0,0},{64320,
2,0,32},{55386,0,0,0},{64320,2,0,32},{55390,0,0,0},{64320,2,0,32},{55464,0,0,0},
{64320,2,0,32},{55468,0,0,0},{64320,2,0,32},{55475,0,0,0},{64320,2,0,32},{55512,
0,0,0},{64320,2,0,32},{55519,0,0,0},{64320,2,0,32},{55534,0,0,0},{64320,2,0,32},
{55538,0,0,0},{64320,2,0,32},{55543,0,0,0},{64320,2,0,32},{55558,0,0,0},{64320,
2,0,32},{55578,0,0,0},{64320,2,0,32},{55586,0,0,0},{64320,2,0,32},{55620,0,0,0},
{64320,2,0,32},{55624,0,0,0},{64320,2,0,32},{55633,0,0,0},{64320,2,0,32},{55636,
0,0,0},{64320,2,0,32},{55650,0,0,0},{64320,2,0,32},{55667,0,0,0},{64320,2,0,32},
{55768,0,0,0},{64320,2,0,32},{55788,0,0,0},{64320,2,0,32},{55835,0,0,0},{64320,
2,0,32},{55847,0,0,0},{64320,2,0,32},{55906,0,0,0},{64320,2,0,32},{55910,0,0,0},
{64320,2,0,32},{55989,0,0,0},{64320,2,0,32},{56072,0,0,0},{64320,2,0,32},{56104,
0,0,0},{64320,2,0,32},{56126,0,0,0},{64320,2,0,32},{56197,0,0,0},{64320,2,0,32},
{56259,0,0,0},{64320,2,0,32},{56280,0,0,0},{64320,2,0,32},{56295,0,0,0},{64320,
2,0,32},{56302,0,0,0},{64320,2,0,32},{56307,0,0,0},{64320,2,0,32},{56319,0,0,0},
{64320,2,0,32},{56326,0,0,0},{64320,2,0,32},{56354,0,0,0},{64320,2,0,32},{56383,
0,0,0},{64320,2,0,32},{56416,0,0,0},{64320,2,0,32},{56418,0,0,0},{64320,2,0,32},
{56420,0,0,0},{64320,2,0,32},{56421,0,0,0},{64320,2,0,32},{56430,0,0,0},{64320,
2,0,32},{56461,0,0,0},{64320,2,0,32},{56512,0,0,0},{64320,2,0,32},{56601,0,0,0},
{64320,2,0,32},{56643,0,0,0},{64320,2,0,32},{56656,0,0,0},{64320,2,0,32},{56683,
0,0,0},{64320,2,0,32},{56686,0,0,0},{64320,2,0,32},{56700,0,0,0},{64320,2,0,32},
{56754,0,0,0},{64320,2,0,32},{56762,0,0,0},{64320,2,0,32},{56801,0,0,0},{64320,
2,0,32},{56802,0,0,0},{64320,2,0,32},{56829,0,0,0},{64320,2,0,32},{56872,0,0,0},
{64320,2,0,32},{56893,0,0,0},{64320,2,0,32},{56937,0,0,0},{64320,2,0,32},{56948,
0,0,0},{64320,2,0,32},{56998,0,0,0},{64320,2,0,32},{57008,0,0,0},{64320,2,0,32},
{57011,0,0,0},{64320,2,0,32},{57014,0,0,0},{64320,2,0,32},{57033,0,0,0},{64320,
2,0,32},{57034,0,0,0},{64320,2,0,32},{57042,0,0,0},{64320,2,0,32},{57043,0,0,0},
{64320,2,0,32},{57049,0,0,0},{64320,2,0,32},{57068,0,0,0},{64320,2,0,32},{57086,
0,0,0},{64320,2,0,32},{57092,0,0,0},{64320,2,0,32},{57122,0,0,0},{64320,2,0,32},
{57171,0,0,0},{64320,2,0,32},{57186,0,0,0},{64320,2,0,32},{57193,0,0,0},{64320,
2,0,32},{57195,0,0,0},{64320,2,0,32},{57227,0,0,0},{64320,2,0,32},{57242,0,0,0},
{64320,2,0,32},{57257,0,0,0},{64320,2,0,32},{57261,0,0,0},{64320,2,0,32},{57293,
0,0,0},{64320,2,0,32},{57303,0,0,0},{64320,2,0,32},{57333,0,0,0},{64320,2,0,32},
{57337,0,0,0},{64320,2,0,32},{57362,0,0,0},{64320,2,0,32},{57372,0,0,0},{64320,
2,0,32},{57461,0,0,0},{64320,2,0,32},{57473,0,0,0},{64320,2,0,32},{57492,0,0,0},
{64320,2,0,32},{57543,0,0,0},{64320,2,0,32},{57560,0,0,0},{64320,2,0,32},{57569,
0,0,0},{64320,2,0,32},{57608,0,0,0},{64320,2,0,32},{57668,0,0,0},{64320,2,0,32},
{57672,0,0,0},{64320,2,0,32},{57676,0,0,0},{64320,2,0,32},{57678,0,0,0},{64320,
2,0,32},{57696,0,0,0},{64320,2,0,32},{57704,0,0,0},{64320,2,0,32},{57722,0,0,0},
{64320,2,0,32},{57742,0,0,0},{64320,2,0,32},{57744,0,0,0},{64320,2,0,32},{57764,
0,0,0},{64320,2,0,32},{57775,0,0,0},{64320,2,0,32},{57778,0,0,0},{64320,2,0,32},
{57822,0,0,0},{64320,2,0,32},{57842,0,0,0},{64320,2,0,32},{57846,0,0,0},{64320,
2,0,32},{57856,0,0,0},{64320,2,0,32},{57872,0,0,0},{64320,2,0,32},{57883,0,0,0},
{64320,2,0,32},{57902,0,0,0},{64320,2,0,32},{57908,0,0,0},{64320,2,0,32},{57949,
0,0,0},{64320,2,0,32},{58033,0,0,0},{64320,2,0,32},{58057,0,0,0},{64320,2,0,32},
{58063,0,0,0},{64320,2,0,32},{58067,0,0,0},{64320,2,0,32},{58068,0,0,0},{64320,
2,0,32},{58108,0,0,0},{64320,2,0,32},{58110,0,0,0},{64320,2,0,32},{58173,0,0,0},
{64320,2,0,32},{58192,0,0,0},{64320,2,0,32},{58216,0,0,0},{64320,2,0,32},{58235,
0,0,0},{64320,2,0,32},{58243,0,0,0},{64320,2,0,32},{58272,0,0,0},{64320,2,0,32},
{58281,0,0,0},{64320,2,0,32},{58308,0,0,0},{64320,2,0,32},{58309,0,0,0},{64320,
2,0,32},{58340,0,0,0},{64320,2,0,32},{58396,0,0,0},{64320,2,0,32},{58402,0,0,0},
{64320,2,0,32},{58450,0,0,0},{64320,2,0,32},{58473,0,0,0},{64320,2,0,32},{58487,
0,0,0},{64320,2,0,32},{58494,0,0,0},{64320,2,0,32},{58522,0,0,0},{64320,2,0,32},
{58525,0,0,0},{64320,2,0,32},{58564,0,0,0},{64320,2,0,32},{58703,0,0,0},{64320,
2,0,32},{58710,0,0,0},{64320,2,0,32},{58732,0,0,0},{64320,2,0,32},{58744,0,0,0},
{64320,2,0,32},{58777,0,0,0},{64320,2,0,32},{58821,0,0,0},{64320,2,0,32},{58850,
0,0,0},{64320,2,0,32},{58851,0,0,0},{64320,2,0,32},{58899,0,0,0},{64320,2,0,32},
{58953,0,0,0},{64320,2,0,32},{58996,0,0,0},{64320,2,0,32},{59016,0,0,0},{64320,
2,0,32},{59025,0,0,0},{64320,2,0,32},{59036,0,0,0},{64320,2,0,32},{59060,0,0,0},
{64320,2,0,32},{59078,0,0,0},{64320,2,0,32},{59124,0,0,0},{64320,2,0,32},{59128,
0,0,0},{64320,2,0,32},{59136,0,0,0},{64320,2,0,32},{59159,0,0,0},{64320,2,0,32},
{59163,0,0,0},{64320,2,0,32},{59169,0,0,0},{64320,2,0,32},{59214,0,0,0},{64320,
2,0,32},{59219,0,0,0},{64320,2,0,32},{59222,0,0,0},{64320,2,0,32},{59230,0,0,0},
{64320,2,0,32},{59259,0,0,0},{64320,2,0,32},{59269,0,0,0},{64320,2,0,32},{59287,
0,0,0},{64320,2,0,32},{59379,0,0,0},{64320,2,0,32},{59386,0,0,0},{64320,2,0,32},
{59415,0,0,0},{64320,2,0,32},{59423,0,0,0},{64320,2,0,32},{59474,0,0,0},{64320,
2,0,32},{59521,0,0,0},{64320,2,0,32},{59525,0,0,0},{64320,2,0,32},{59534,0,0,0},
{64320,2,0,32},{59560,0,0,0},{64320,2,0,32},{59668,0,0,0},{64320,2,0,32},{59714,
0,0,0},{64320,2,0,32},{59811,0,0,0},{64320,2,0,32},{59882,0,0,0},{64320,2,0,32},
{59906,0,0,0},{64320,2,0,32},{59923,0,0,0},{64320,2,0,32},{60072,0,0,0},{64320,
2,0,32},{60115,0,0,0},{64320,2,0,32},{60123,0,0,0},{64320,2,0,32},{60164,0,0,0},
{64320,2,0,32},{60193,0,0,0},{64320,2,0,32},{60244,0,0,0},{64320,2,0,32},{60274,
0,0,0},{64320,2,0,32},{60279,0,0,0},{64320,2,0,32},{60281,0,0,0},{64320,2,0,32},
{60319,0,0,0},{64320,2,0,32},{60334,0,0,0},{64320,2,0,32},{60346,0,0,0},{64320,
2,0,32},{60347,0,0,0},{64320,2,0,32},{60494,0,0,0},{64320,2,0,32},{60519,0,0,0},
{64320,2,0,32},{60552,0,0,0},{64320,2,0,32},{60607,0,0,0},{64320,2,0,32},{60620,
0,0,0},{64320,2,0,32},{60621,0,0,0},{64320,2,0,32},{60645,0,0,0},{64320,2,0,32},
{60694,0,0,0},{64320,2,0,32},{60699,0,0,0},{64320,2,0,32},{60702,0,0,0},{64320,
2,0,32},{60724,0,0,0},{64320,2,0,32},{60734,0,0,0},{64320,2,0,32},{60737,0,0,0},
{64320,2,0,32},{60777,0,0,0},{64320,2,0,32},{60778,0,0,0},{64320,2,0,32},{60791,
0,0,0},{64320,2,0,32},{60792,0,0,0},{64320,2,0,32},{60805,0,0,0},{64320,2,0,32},
{60875,0,0,0},{64320,2,0,32},{60890,0,0,0},{64320,2,0,32},{60906,0,0,0},{64320,
2,0,32},{60921,0,0,0},{64320,2,0,32},{60954,0,0,0},{64320,2,0,32},{60975,0,0,0},
{64320,2,0,32},{61038,0,0,0},{64320,2,0,32},{61084,0,0,0},{64320,2,0,32},{61114,
0,0,0},{64320,2,0,32},{61127,0,0,0},{64320,2,0,32},{61131,0,0,0},{64320,2,0,32},
{61137,0,0,0},{64320,2,0,32},{61147,0,0,0},{64320,2,0,32},{61199,0,0,0},{64320,
2,0,32},{61218,0,0,0},{64320,2,0,32},{61219,0,0,0},{64320,2,0,32},{61294,0,0,0},
{64320,2,0,32},{61382,0,0,0},{64320,2,0,32},{61419,0,0,0},{64320,2,0,32},{61438,
0,0,0},{64320,2,0,32},{61467,0,0,0},{64320,2,0,32},{61470,0,0,0},{64320,2,0,32},
{61497,0,0,0},{64320,2,0,32},{61514,0,0,0},{64320,2,0,32},{61552,0,0,0},{64320,
2,0,32},{61559,0,0,0},{64320,2,0,32},{61565,0,0,0},{64320,2,0,32},{61593,0,0,0},
{64320,2,0,32},{61613,0,0,0},{64320,2,0,32},{61640,0,0,0},{64320,2,0,32},{61657,
0,0,0},{64320,2,0,32},{61765,0,0,0},{64320,2,0,32},{61769,0,0,0},{64320,2,0,32},
{61806,0,0,0},{64320,2,0,32},{61852,0,0,0},{64320,2,0,32},{61902,0,0,0},{64320,
2,0,32},{61904,0,0,0},{64320,2,0,32},{61968,0,0,0},{64320,2,0,32},{61979,0,0,0},
{64320,2,0,32},{61992,0,0,0},{64320,2,0,32},{61995,0,0,0},{64320,2,0,32},{62005,
0,0,0},{64320,2,0,32},{62032,0,0,0},{64320,2,0,32},{62050,0,0,0},{64320,2,0,32},
{62080,0,0,0},{64320,2,0,32},{62101,0,0,0},{64320,2,0,32},{62127,0,0,0},{64320,
2,0,32},{62144,0,0,0},{64320,2,0,32},{62204,0,0,0},{64320,2,0,32},{62250,0,0,0},
{64320,2,0,32},{62325,0,0,0},{64320,2,0,32},{62330,0,0,0},{64320,2,0,32},{62343,
0,0,0},{64320,2,0,32},{62347,0,0,0},{64320,2,0,32},{62373,0,0,0},{64320,2,0,32},
{62386,0,0,0},{64320,2,0,32},{62430,0,0,0},{64320,2,0,32},{62470,0,0,0},{64320,
2,0,32},{62473,0,0,0},{64320,2,0,32},{62498,0,0,0},{64320,2,0,32},{62535,0,0,0},
{64320,2,0,32},{62556,0,0,0},{64320,2,0,32},{62569,0,0,0},{64320,2,0,32},{62577,
0,0,0},{64320,2,0,32},{62597,0,0,0},{64320,2,0,32},{62601,0,0,0},{64320,2,0,32},
{62616,0,0,0},{64320,2,0,32},{62666,0,0,0},{64320,2,0,32},{62726,0,0,0},{64320,
2,0,32},{62756,0,0,0},{64320,2,0,32},{62779,0,0,0},{64320,2,0,32},{62782,0,0,0},
{64320,2,0,32},{62809,0,0,0},{64320,2,0,32},{62821,0,0,0},{64320,2,0,32},{62832,
0,0,0},{64320,2,0,32},{62946,0,0,0},{64320,2,0,32},{62992,0,0,0},{64320,2,0,32},
{63005,0,0,0},{64320,2,0,32},{63007,0,0,0},{64320,2,0,32},{63042,0,0,0},{64320,
2,0,32},{63081,0,0,0},{64320,2,0,32},{63178,0,0,0},{64320,2,0,32},{63195,0,0,0},
{64320,2,0,32},{63207,0,0,0},{64320,2,0,32},{63220,0,0,0},{64320,2,0,32},{63233,
0,0,0},{64320,2,0,32},{63262,0,0,0},{64320,2,0,32},{63263,0,0,0},{64320,2,0,32},
{63296,0,0,0},{64320,2,0,32},{63306,0,0,0},{64320,2,0,32},{63371,0,0,0},{64320,
2,0,32},{63399,0,0,0},{64320,2,0,32},{63566,0,0,0},{64320,2,0,32},{63595,0,0,0},
{64320,2,0,32},{63628,0,0,0},{64320,2,0,32},{63633,0,0,0},{64320,2,0,32},{63690,
0,0,0},{64320,2,0,32},{63692,0,0,0},{64320,2,0,32},{63739,0,0,0},{64320,2,0,32},
{63786,0,0,0},{64320,2,0,32},{63804,0,0,0},{64320,2,0,32},{63806,0,0,0},{64320,
2,0,32},{63816,0,0,0},{64320,2,0,32},{63817,0,0,0},{64320,2,0,32},{63824,0,0,0},
{64320,2,0,32},{63830,0,0,0},{64320,2,0,32},{63837,0,0,0},{64320,2,0,32},{63838,
0,0,0},{64320,2,0,32},{63845,0,0,0},{64320,2,0,32},{63871,0,0,0},{64320,2,0,32},
{63885,0,0,0},{64320,2,0,32},{63886,0,0,0},{64320,2,0,32},{63887,0,0,0},{64320,
2,0,32},{63918,0,0,0},{64320,2,0,32},{63946,0,0,0},{64320,2,0,32},{63979,0,0,0},
{64320,2,0,32},{64028,0,0,0},{64320,2,0,32},{64064,0,0,0},{64320,2,0,32},{64074,
0,0,0},{64320,2,0,32},{64079,0,0,0},{64320,2,0,32},{64129,0,0,0},{64320,2,0,32},
{64177,0,0,0},{64320,2,0,32},{64203,0,0,0},{64320,2,0,32},{64238,0,0,0},{64320,
2,0,32},{64288,0,0,0},{64320,2,0,32},{64448,0,0,0},{64320,2,0,32},{64454,0,0,0},
{64320,2,0,32},{64457,0,0,0},{64320,2,0,32},{64574,0,0,0},{64320,2,0,32},{64608,
0,0,0},{64320,2,0,32},{64635,0,0,0},{64320,2,0,32},{64658,0,0,0},{64320,2,0,32},
{64702,0,0,0},{64320,2,0,32},{64722,0,0,0},{64320,2,0,32},{64726,0,0,0},{64320,
2,0,32},{64739,0,0,0},{64320,2,0,32},{64743,0,0,0},{64320,2,0,32},{64744,0,0,0},
{64320,2,0,32},{64768,0,0,0},{64320,2,0,32},{64784,0,0,0},{64320,2,0,32},{64802,
0,0,0},{64320,2,0,32},{64815,0,0,0},{64320,2,0,32},{64859,0,0,0},{64320,2,0,32},
{64867,0,0,0},{64320,2,0,32},{64928,0,0,0},{64320,2,0,32},{64958,0,0,0},{64320,
2,0,32},{64967,0,0,0},{64320,2,0,32},{65012,0,0,0},{64320,2,0,32},{65026,0,0,0},
{64320,2,0,32},{65033,0,0,0},{64320,2,0,32},{65079,0,0,0},{64320,2,0,32},{65089,
0,0,0},{64320,2,0,32},{65093,0,0,0},{64320,2,0,32},{65342,0,0,0},{64320,2,0,32},
{65394,0,0,0},{64320,2,0,32},{65401,0,0,0},{64320,2,0,32},{65402,0,0,0},{64320,
2,0,32},{65413,0,0,0},{64320,2,0,32},{65429,0,0,0},{64320,2,0,32},{65434,0,0,0},
{64320,2,0,32},{65469,0,0,0},{64320,2,0,32},{65530,0,0,0},{64321,2,0,32},{32769,
0,0,0},{64321,2,0,32},{32773,0,0,0},{64321,2,0,32},{32838,0,0,0},{64321,2,0,32},
{32864,0,0,0},{64321,2,0,32},{32879,0,0,0},{64321,2,0,32},{32880,0,0,0},{64321,
2,0,32},{32894,0,0,0},{64321,2,0,32},{32907,0,0,0},{64321,2,0,32},{32941,0,0,0},
{64321,2,0,32},{32946,0,0,0},{64321,2,0,32},{33027,0,0,0},{64321,2,0,32},{33086,
0,0,0},{64321,2,0,32},{33240,0,0,0},{64321,2,0,32},{33256,0,0,0},{64321,2,0,32},
{33261,0,0,0},{64321,2,0,32},{33281,0,0,0},{64321,2,0,32},{33284,0,0,0},{64321,
2,0,32},{33304,0,0,0},{64321,2,0,32},{33391,0,0,0},{64321,2,0,32},{33401,0,0,0},
{64321,2,0,32},{33419,0,0,0},{64321,2,0,32},{33425,0,0,0},{64321,2,0,32},{33437,
0,0,0},{64321,2,0,32},{33457,0,0,0},{64321,2,0,32},{33459,0,0,0},{64321,2,0,32},
{33469,0,0,0},{64321,2,0,32},{33509,0,0,0},{64321,2,0,32},{33510,0,0,0},{64321,
2,0,32},{33565,0,0,0},{64321,2,0,32},{33571,0,0,0},{64321,2,0,32},{33590,0,0,0},
{64321,2,0,32},{33618,0,0,0},{64321,2,0,32},{33619,0,0,0},{64321,2,0,32},{33635,
0,0,0},{64321,2,0,32},{33709,0,0,0},{64321,2,0,32},{33725,0,0,0},{64321,2,0,32},
{33737,0,0,0},{64321,2,0,32},{33738,0,0,0},{64321,2,0,32},{33740,0,0,0},{64321,
2,0,32},{33756,0,0,0},{64321,2,0,32},{33767,0,0,0},{64321,2,0,32},{33775,0,0,0},
{64321,2,0,32},{33777,0,0,0},{64321,2,0,32},{33853,0,0,0},{64321,2,0,32},{33865,
0,0,0},{64321,2,0,32},{33879,0,0,0},{64321,2,0,32},{34030,0,0,0},{64321,2,0,32},
{34033,0,0,0},{64321,2,0,32},{34035,0,0,0},{64321,2,0,32},{34044,0,0,0},{64321,
2,0,32},{34070,0,0,0},{64321,2,0,32},{34148,0,0,0},{64321,2,0,32},{34253,0,0,0},
{64321,2,0,32},{34298,0,0,0},{64321,2,0,32},{34310,0,0,0},{64321,2,0,32},{34322,
0,0,0},{64321,2,0,32},{34349,0,0,0},{64321,2,0,32},{34367,0,0,0},{64321,2,0,32},
{34384,0,0,0},{64321,2,0,32},{34396,0,0,0},{64321,2,0,32},{34407,0,0,0},{64321,
2,0,32},{34409,0,0,0},{64321,2,0,32},{34440,0,0,0},{64321,2,0,32},{34473,0,0,0},
{64321,2,0,32},{34530,0,0,0},{64321,2,0,32},{34574,0,0,0},{64321,2,0,32},{34600,
0,0,0},{64321,2,0,32},{34667,0,0,0},{64321,2,0,32},{34681,0,0,0},{64321,2,0,32},
{34694,0,0,0},{64321,2,0,32},{34746,0,0,0},{64321,2,0,32},{34785,0,0,0},{64321,
2,0,32},{34817,0,0,0},{64321,2,0,32},{34847,0,0,0},{64321,2,0,32},{34892,0,0,0},
{64321,2,0,32},{34912,0,0,0},{64321,2,0,32},{34915,0,0,0},{64321,2,0,32},{35010,
0,0,0},{64321,2,0,32},{35023,0,0,0},{64321,2,0,32},{35031,0,0,0},{64321,2,0,32},
{35038,0,0,0},{64321,2,0,32},{35041,0,0,0},{64321,2,0,32},{35064,0,0,0},{64321,
2,0,32},{35066,0,0,0},{64321,2,0,32},{35088,0,0,0},{64321,2,0,32},{35137,0,0,0},
{64321,2,0,32},{35172,0,0,0},{64321,2,0,32},{35206,0,0,0},{64321,2,0,32},{35211,
0,0,0},{64321,2,0,32},{35222,0,0,0},{64321,2,0,32},{35488,0,0,0},{64321,2,0,32},
{35498,0,0,0},{64321,2,0,32},{35519,0,0,0},{64321,2,0,32},{35531,0,0,0},{64321,
2,0,32},{35538,0,0,0},{64321,2,0,32},{35542,0,0,0},{64321,2,0,32},{35565,0,0,0},
{64321,2,0,32},{35576,0,0,0},{64321,2,0,32},{35582,0,0,0},{64321,2,0,32},{35585,
0,0,0},{64321,2,0,32},{35641,0,0,0},{64321,2,0,32},{35672,0,0,0},{64321,2,0,32},
{35712,0,0,0},{64321,2,0,32},{35722,0,0,0},{64321,2,0,32},{35912,0,0,0},{64321,
2,0,32},{35925,0,0,0},{64321,2,0,32},{36011,0,0,0},{64321,2,0,32},{36033,0,0,0},
{64321,2,0,32},{36034,0,0,0},{64321,2,0,32},{36040,0,0,0},{64321,2,0,32},{36051,
0,0,0},{64321,2,0,32},{36104,0,0,0},{64321,2,0,32},{36123,0,0,0},{64321,2,0,32},
{36215,0,0,0},{64321,2,0,32},{36284,0,0,0},{64321,2,0,32},{36299,0,0,0},{64321,
2,0,32},{36335,0,0,0},{64321,2,0,32},{36336,0,0,0},{64321,2,0,32},{36554,0,0,0},
{64321,2,0,32},{36564,0,0,0},{64321,2,0,32},{36646,0,0,0},{64321,2,0,32},{36650,
0,0,0},{64321,2,0,32},{36664,0,0,0},{64321,2,0,32},{36667,0,0,0},{64321,2,0,32},
{36706,0,0,0},{64321,2,0,32},{36766,0,0,0},{64321,2,0,32},{36784,0,0,0},{64321,
2,0,32},{36790,0,0,0},{64321,2,0,32},{36899,0,0,0},{64321,2,0,32},{36920,0,0,0},
{64321,2,0,32},{36978,0,0,0},{64321,2,0,32},{36988,0,0,0},{64321,2,0,32},{37007,
0,0,0},{64321,2,0,32},{37012,0,0,0},{64321,2,0,32},{37070,0,0,0},{64321,2,0,32},
{37086,0,0,0},{64321,2,0,32},{37105,0,0,0},{64321,2,0,32},{37117,0,0,0},{64321,
2,0,32},{37137,0,0,0},{64321,2,0,32},{37147,0,0,0},{64321,2,0,32},{37226,0,0,0},
{64321,2,0,32},{37273,0,0,0},{64321,2,0,32},{37300,0,0,0},{64321,2,0,32},{37324,
0,0,0},{64321,2,0,32},{37327,0,0,0},{64321,2,0,32},{37329,0,0,0},{64321,2,0,32},
{37428,0,0,0},{64321,2,0,32},{37432,0,0,0},{64321,2,0,32},{37494,0,0,0},{64321,
2,0,32},{37500,0,0,0},{64321,2,0,32},{37591,0,0,0},{64321,2,0,32},{37592,0,0,0},
{64321,2,0,32},{37636,0,0,0},{64321,2,0,32},{37706,0,0,0},{64321,2,0,32},{37881,
0,0,0},{64321,2,0,32},{37909,0,0,0},{64321,2,0,32},{38283,0,0,0},{64321,2,0,32},
{38317,0,0,0},{64321,2,0,32},{38327,0,0,0},{64321,2,0,32},{38446,0,0,0},{64321,
2,0,32},{38475,0,0,0},{64321,2,0,32},{38477,0,0,0},{64321,2,0,32},{38517,0,0,0},
{64321,2,0,32},{38520,0,0,0},{64321,2,0,32},{38524,0,0,0},{64321,2,0,32},{38534,
0,0,0},{64321,2,0,32},{38563,0,0,0},{64321,2,0,32},{38583,0,0,0},{64321,2,0,32},
{38584,0,0,0},{64321,2,0,32},{38595,0,0,0},{64321,2,0,32},{38626,0,0,0},{64321,
2,0,32},{38627,0,0,0},{64321,2,0,32},{38646,0,0,0},{64321,2,0,32},{38647,0,0,0},
{64321,2,0,32},{38691,0,0,0},{64321,2,0,32},{38706,0,0,0},{64321,2,0,32},{38728,
0,0,0},{64321,2,0,32},{38742,0,0,0},{64321,2,0,32},{38875,0,0,0},{64321,2,0,32},
{38880,0,0,0},{64321,2,0,32},{38911,0,0,0},{64321,2,0,32},{38923,0,0,0},{64321,
2,0,32},{38936,0,0,0},{64321,2,0,32},{38953,0,0,0},{64321,2,0,32},{38971,0,0,0},
{64321,2,0,32},{39006,0,0,0},{64321,2,0,32},{39138,0,0,0},{64321,2,0,32},{39151,
0,0,0},{64321,2,0,32},{39164,0,0,0},{64321,2,0,32},{39208,0,0,0},{64321,2,0,32},
{39209,0,0,0},{64321,2,0,32},{39335,0,0,0},{64321,2,0,32},{39362,0,0,0},{64321,
2,0,32},{39409,0,0,0},{64321,2,0,32},{39422,0,0,0},{64321,2,0,32},{39530,0,0,0},
{64321,2,0,32},{39698,0,0,0},{64321,2,0,32},{39791,0,0,0},{64321,2,0,32},{40000,
0,0,0},{64321,2,0,32},{40023,0,0,0},{64321,2,0,32},{40189,0,0,0},{64321,2,0,32},
{40295,0,0,0},{64321,2,0,32},{40372,0,0,0},{64321,2,0,32},{40442,0,0,0},{64321,
2,0,32},{40478,0,0,0},{64321,2,0,32},{40575,0,0,0},{64321,2,0,32},{40599,0,0,0},
{64321,2,0,32},{40607,0,0,0},{64321,2,0,32},{40635,0,0,0},{64321,2,0,32},{40654,
0,0,0},{64321,2,0,32},{40697,0,0,0},{64321,2,0,32},{40702,0,0,0},{64321,2,0,32},
{40709,0,0,0},{64321,2,0,32},{40719,0,0,0},{64321,2,0,32},{40726,0,0,0},{64321,
2,0,32},{40763,0,0,0},{64321,2,0,32},{40771,0,0,0},{64321,2,0,32},{40845,0,0,0},
{64321,2,0,32},{40846,0,0,0},{64321,2,0,32},{40860,0,0,0},{17037,4,0,32},{17292,
4,0,32},{17055,4,0,32},{17292,4,0,32},{17076,4,0,32},{17292,4,0,32},{17096,4,0,
32},{17293,4,0,32},{17107,4,0,32},{17292,4,0,32},{17113,4,0,32},{17293,4,0,32},
{17115,4,0,32},{17293,4,0,32},{17121,4,0,32},{17292,4,0,32},{17158,4,0,32},
{17292,4,0,32},{17205,4,0,32},{17292,4,0,32},{17228,4,0,32},{17292,4,0,32},
{17234,4,0,32},{17293,4,0,32},{17241,4,0,32},{17292,4,0,32},{10332,4,0,32},{0,4,
0,43},{9821,10,0,32},{9966,4,0,32},{9821,4,0,32},{9966,4,0,32},{9196,10,0,32},
{9196,10,0,32},{9196,4,0,32},{9196,4,0,32},{9196,10,0,32},{9624,10,0,32},{9196,
4,0,32},{9624,4,0,32},{9196,10,0,32},{9856,10,0,32},{9196,4,0,32},{9856,4,0,32},
{9196,10,0,32},{9904,10,0,32},{9196,4,0,32},{9904,4,0,32},{9196,10,0,32},{0,4,0,
287},{9904,10,0,32},{9196,4,0,32},{0,4,0,287},{9904,4,0,32},{9196,10,0,32},
{9944,10,0,32},{9196,4,0,32},{9944,4,0,32},{9624,10,0,32},{9624,10,0,32},{9624,
4,0,32},{9624,4,0,32},{9712,10,0,32},{0,4,0,289},{9712,4,0,32},{0,4,0,289},
{9904,10,0,32},{9944,10,0,32},{9904,4,0,32},{9944,4,0,32},{9270,10,0,32},{0,4,0,
288},{9270,4,0,32},{0,4,0,288},{9358,10,0,32},{0,4,0,288},{9358,4,0,32},{0,4,0,
288},{9373,10,0,32},{0,4,0,288},{9712,10,0,32},{0,4,0,288},{9712,4,0,32},{0,4,0,
288},{9778,10,0,32},{0,4,0,289},{9778,4,0,32},{0,4,0,289},{9821,10,0,32},{0,4,0,
288},{9821,4,0,32},{0,4,0,288},{9196,10,0,32},{0,4,0,43},{9196,4,0,32},{0,4,0,
43},{9624,10,0,32},{0,4,0,43},{9624,4,0,32},{0,4,0,43},{9856,10,0,32},{0,4,0,
43},{9856,4,0,32},{0,4,0,43},{9373,10,0,32},{0,4,0,53},{9373,4,0,32},{0,4,0,53},
{9492,10,0,32},{0,4,0,53},{9492,4,0,32},{0,4,0,53},{9585,10,0,32},{0,4,0,53},
{9585,4,0,32},{0,4,0,53},{9712,10,0,32},{0,4,0,53},{9712,4,0,32},{0,4,0,53},
{9778,10,0,32},{0,4,0,53},{9778,4,0,32},{0,4,0,53},{9196,10,0,32},{0,4,0,49},
{9196,4,0,32},{0,4,0,49},{9922,10,0,32},{0,4,0,287},{9922,4,0,32},{0,4,0,287},
{9778,10,0,32},{0,4,0,290},{9778,4,0,32},{0,4,0,290},{9412,20,0,32},{0,20,0,57},
{9624,20,0,32},{0,20,0,287},{9299,20,0,32},{14266,2,0,32},{14319,2,0,32},{14267,
2,0,32},{14319,2,0,32},{14268,2,0,32},{14319,2,0,32},{14269,2,0,32},{14319,2,0,
32},{14270,2,0,32},{14319,2,0,32},{14271,2,0,32},{14319,2,0,32},{14272,2,0,32},
{14319,2,0,32},{14273,2,0,32},{14319,2,0,32},{14274,2,0,32},{14319,2,0,32},
{14275,2,0,32},{14319,2,0,32},{14276,2,0,32},{14319,2,0,32},{14277,2,0,32},
{14319,2,0,32},{14278,2,0,32},{14319,2,0,32},{14279,2,0,32},{14319,2,0,32},
{14280,2,0,32},{14319,2,0,32},{14281,2,0,32},{14319,2,0,32},{14282,2,0,32},
{14319,2,0,32},{14283,2,0,32},{14319,2,0,32},{14284,2,0,32},{14319,2,0,32},
{14285,2,0,32},{14319,2,0,32},{14286,2,0,32},{14319,2,0,32},{14287,2,0,32},
{14319,2,0,32},{14288,2,0,32},{14319,2,0,32},{14289,2,0,32},{14319,2,0,32},
{14290,2,0,32},{14319,2,0,32},{14291,2,0,32},{14319,2,0,32},{14292,2,0,32},
{14319,2,0,32},{14293,2,0,32},{14319,2,0,32},{14294,2,0,32},{14319,2,0,32},
{14295,2,0,32},{14319,2,0,32},{14296,2,0,32},{14319,2,0,32},{14297,2,0,32},
{14319,2,0,32},{14298,2,0,32},{14319,2,0,32},{14299,2,0,32},{14319,2,0,32},
{14300,2,0,32},{14319,2,0,32},{14301,2,0,32},{14319,2,0,32},{14302,2,0,32},
{14319,2,0,32},{14303,2,0,32},{14319,2,0,32},{14304,2,0,32},{14319,2,0,32},
{14305,2,0,32},{14319,2,0,32},{14306,2,0,32},{14319,2,0,32},{14307,2,0,32},
{14319,2,0,32},{14308,2,0,32},{14319,2,0,32},{14309,2,0,32},{14319,2,0,32},
{14310,2,0,32},{14319,2,0,32},{14311,2,0,32},{14319,2,0,32},{14312,2,0,32},
{14319,2,0,32},{14313,2,0,32},{14319,2,0,32},{14266,2,0,32},{14320,2,0,32},
{14267,2,0,32},{14320,2,0,32},{14268,2,0,32},{14320,2,0,32},{14269,2,0,32},
{14320,2,0,32},{14270,2,0,32},{14320,2,0,32},{14271,2,0,32},{14320,2,0,32},
{14272,2,0,32},{14320,2,0,32},{14273,2,0,32},{14320,2,0,32},{14274,2,0,32},
{14320,2,0,32},{14275,2,0,32},{14320,2,0,32},{14276,2,0,32},{14320,2,0,32},
{14277,2,0,32},{14320,2,0,32},{14278,2,0,32},{14320,2,0,32},{14279,2,0,32},
{14320,2,0,32},{14280,2,0,32},{14320,2,0,32},{14281,2,0,32},{14320,2,0,32},
{14282,2,0,32},{14320,2,0,32},{14283,2,0,32},{14320,2,0,32},{14284,2,0,32},
{14320,2,0,32},{14285,2,0,32},{14320,2,0,32},{14286,2,0,32},{14320,2,0,32},
{14287,2,0,32},{14320,2,0,32},{14288,2,0,32},{14320,2,0,32},{14289,2,0,32},
{14320,2,0,32},{14290,2,0,32},{14320,2,0,32},{14291,2,0,32},{14320,2,0,32},
{14292,2,0,32},{14320,2,0,32},{14293,2,0,32},{14320,2,0,32},{14294,2,0,32},
{14320,2,0,32},{14295,2,0,32},{14320,2,0,32},{14296,2,0,32},{14320,2,0,32},
{14297,2,0,32},{14320,2,0,32},{14298,2,0,32},{14320,2,0,32},{14299,2,0,32},
{14320,2,0,32},{14300,2,0,32},{14320,2,0,32},{14301,2,0,32},{14320,2,0,32},
{14302,2,0,32},{14320,2,0,32},{14303,2,0,32},{14320,2,0,32},{14304,2,0,32},
{14320,2,0,32},{14305,2,0,32},{14320,2,0,32},{14306,2,0,32},{14320,2,0,32},
{14307,2,0,32},{14320,2,0,32},{14308,2,0,32},{14320,2,0,32},{14309,2,0,32},
{14320,2,0,32},{14310,2,0,32},{14320,2,0,32},{14311,2,0,32},{14320,2,0,32},
{14312,2,0,32},{14320,2,0,32},{14313,2,0,32},{14320,2,0,32},{14266,2,0,32},
{14323,2,0,32},{14267,2,0,32},{14323,2,0,32},{14268,2,0,32},{14323,2,0,32},
{14269,2,0,32},{14323,2,0,32},{14270,2,0,32},{14323,2,0,32},{14271,2,0,32},
{14323,2,0,32},{14272,2,0,32},{14323,2,0,32},{14273,2,0,32},{14323,2,0,32},
{14274,2,0,32},{14323,2,0,32},{14275,2,0,32},{14323,2,0,32},{14276,2,0,32},
{14323,2,0,32},{14277,2,0,32},{14323,2,0,32},{14278,2,0,32},{14323,2,0,32},
{14279,2,0,32},{14323,2,0,32},{14280,2,0,32},{14323,2,0,32},{14281,2,0,32},
{14323,2,0,32},{14282,2,0,32},{14323,2,0,32},{14283,2,0,32},{14323,2,0,32},
{14284,2,0,32},{14323,2,0,32},{14285,2,0,32},{14323,2,0,32},{14286,2,0,32},
{14323,2,0,32},{14287,2,0,32},{14323,2,0,32},{14288,2,0,32},{14323,2,0,32},
{14289,2,0,32},{14323,2,0,32},{14290,2,0,32},{14323,2,0,32},{14291,2,0,32},
{14323,2,0,32},{14292,2,0,32},{14323,2,0,32},{14293,2,0,32},{14323,2,0,32},
{14294,2,0,32},{14323,2,0,32},{14295,2,0,32},{14323,2,0,32},{14296,2,0,32},
{14323,2,0,32},{14297,2,0,32},{14323,2,0,32},{14298,2,0,32},{14323,2,0,32},
{14299,2,0,32},{14323,2,0,32},{14300,2,0,32},{14323,2,0,32},{14301,2,0,32},
{14323,2,0,32},{14302,2,0,32},{14323,2,0,32},{14303,2,0,32},{14323,2,0,32},
{14304,2,0,32},{14323,2,0,32},{14305,2,0,32},{14323,2,0,32},{14306,2,0,32},
{14323,2,0,32},{14307,2,0,32},{14323,2,0,32},{14308,2,0,32},{14323,2,0,32},
{14309,2,0,32},{14323,2,0,32},{14310,2,0,32},{14323,2,0,32},{14311,2,0,32},
{14323,2,0,32},{14312,2,0,32},{14323,2,0,32},{14313,2,0,32},{14323,2,0,32},
{14266,2,0,32},{14325,2,0,32},{14267,2,0,32},{14325,2,0,32},{14268,2,0,32},
{14325,2,0,32},{14269,2,0,32},{14325,2,0,32},{14270,2,0,32},{14325,2,0,32},
{14271,2,0,32},{14325,2,0,32},{14272,2,0,32},{14325,2,0,32},{14273,2,0,32},
{14325,2,0,32},{14274,2,0,32},{14325,2,0,32},{14275,2,0,32},{14325,2,0,32},
{14276,2,0,32},{14325,2,0,32},{14277,2,0,32},{14325,2,0,32},{14278,2,0,32},
{14325,2,0,32},{14279,2,0,32},{14325,2,0,32},{14280,2,0,32},{14325,2,0,32},
{14281,2,0,32},{14325,2,0,32},{14282,2,0,32},{14325,2,0,32},{14283,2,0,32},
{14325,2,0,32},{14284,2,0,32},{14325,2,0,32},{14285,2,0,32},{14325,2,0,32},
{14286,2,0,32},{14325,2,0,32},{14287,2,0,32},{14325,2,0,32},{14288,2,0,32},
{14325,2,0,32},{14289,2,0,32},{14325,2,0,32},{14290,2,0,32},{14325,2,0,32},
{14291,2,0,32},{14325,2,0,32},{14292,2,0,32},{14325,2,0,32},{14293,2,0,32},
{14325,2,0,32},{14294,2,0,32},{14325,2,0,32},{14295,2,0,32},{14325,2,0,32},
{14296,2,0,32},{14325,2,0,32},{14297,2,0,32},{14325,2,0,32},{14298,2,0,32},
{14325,2,0,32},{14299,2,0,32},{14325,2,0,32},{14300,2,0,32},{14325,2,0,32},
{14301,2,0,32},{14325,2,0,32},{14302,2,0,32},{14325,2,0,32},{14303,2,0,32},
{14325,2,0,32},{14304,2,0,32},{14325,2,0,32},{14305,2,0,32},{14325,2,0,32},
{14306,2,0,32},{14325,2,0,32},{14307,2,0,32},{14325,2,0,32},{14308,2,0,32},
{14325,2,0,32},{14309,2,0,32},{14325,2,0,32},{14310,2,0,32},{14325,2,0,32},
{14311,2,0,32},{14325,2,0,32},{14312,2,0,32},{14325,2,0,32},{14313,2,0,32},
{14325,2,0,32},{14266,2,0,32},{14326,2,0,32},{14267,2,0,32},{14326,2,0,32},
{14268,2,0,32},{14326,2,0,32},{14269,2,0,32},{14326,2,0,32},{14270,2,0,32},
{14326,2,0,32},{14271,2,0,32},{14326,2,0,32},{14272,2,0,32},{14326,2,0,32},
{14273,2,0,32},{14326,2,0,32},{14274,2,0,32},{14326,2,0,32},{14275,2,0,32},
{14326,2,0,32},{14276,2,0,32},{14326,2,0,32},{14277,2,0,32},{14326,2,0,32},
{14278,2,0,32},{14326,2,0,32},{14279,2,0,32},{14326,2,0,32},{14280,2,0,32},
{14326,2,0,32},{14281,2,0,32},{14326,2,0,32},{14282,2,0,32},{14326,2,0,32},
{14283,2,0,32},{14326,2,0,32},{14284,2,0,32},{14326,2,0,32},{14285,2,0,32},
{14326,2,0,32},{14286,2,0,32},{14326,2,0,32},{14287,2,0,32},{14326,2,0,32},
{14288,2,0,32},{14326,2,0,32},{14289,2,0,32},{14326,2,0,32},{14290,2,0,32},
{14326,2,0,32},{14291,2,0,32},{14326,2,0,32},{14292,2,0,32},{14326,2,0,32},
{14293,2,0,32},{14326,2,0,32},{14294,2,0,32},{14326,2,0,32},{14295,2,0,32},
{14326,2,0,32},{14296,2,0,32},{14326,2,0,32},{14297,2,0,32},{14326,2,0,32},
{14298,2,0,32},{14326,2,0,32},{14299,2,0,32},{14326,2,0,32},{14300,2,0,32},
{14326,2,0,32},{14301,2,0,32},{14326,2,0,32},{14302,2,0,32},{14326,2,0,32},
{14303,2,0,32},{14326,2,0,32},{14304,2,0,32},{14326,2,0,32},{14305,2,0,32},
{14326,2,0,32},{14306,2,0,32},{14326,2,0,32},{14307,2,0,32},{14326,2,0,32},
{14308,2,0,32},{14326,2,0,32},{14309,2,0,32},{14326,2,0,32},{14310,2,0,32},
{14326,2,0,32},{14311,2,0,32},{14326,2,0,32},{14312,2,0,32},{14326,2,0,32},
{14313,2,0,32},{14326,2,0,32},{9270,4,0,32},{9981,4,0,32},{9821,4,0,32},{9787,4,
0,32},{64321,2,0,32},{64014,0,0,0},{64321,2,0,32},{64015,0,0,0},{64321,2,0,32},
{64017,0,0,0},{64321,2,0,32},{64019,0,0,0},{64321,2,0,32},{64020,0,0,0},{64321,
2,0,32},{64031,0,0,0},{64321,2,0,32},{64033,0,0,0},{64321,2,0,32},{64035,0,0,0},
{64321,2,0,32},{64036,0,0,0},{64321,2,0,32},{64039,0,0,0},{64321,2,0,32},{64040,
0,0,0},{64321,2,0,32},{64041,0,0,0},{9358,4,0,32},{9358,4,0,32},{9358,4,0,32},
{9439,4,0,32},{9358,4,0,32},{9512,4,0,32},{9358,4,0,32},{9358,4,0,32},{9439,4,0,
32},{9358,4,0,32},{9358,4,0,32},{9512,4,0,32},{9778,4,0,32},{0,4,0,288},{9821,4,
0,32},{9778,4,0,32},{9821,4,0,32},{10874,4,0,32},{10877,4,0,32},{10874,4,0,32},
{10859,4,0,32},{10874,4,0,32},{10865,4,0,32},{10885,4,0,32},{10877,4,0,32},
{10874,4,0,32},{10867,4,0,32},{10895,4,0,32},{10906,4,0,32},{11171,26,0,32},{0,
26,0,131},{11171,25,0,32},{0,25,0,131},{11202,26,0,32},{0,26,0,131},{11202,25,0,
32},{0,25,0,131},{10965,26,0,32},{11176,26,0,32},{10975,26,0,32},{10979,26,0,
32},{10975,25,0,32},{10979,25,0,32},{10975,26,0,32},{11171,26,0,32},{10975,25,0,
32},{11171,25,0,32},{10975,26,0,32},{11172,26,0,32},{10975,25,0,32},{11172,25,0,
32},{10975,26,0,32},{11176,26,0,32},{10975,25,0,32},{11176,25,0,32},{10975,26,0,
32},{11175,26,0,32},{10975,25,0,32},{11175,25,0,32},{10975,26,0,32},{11177,26,0,
32},{10975,25,0,32},{11177,25,0,32},{10975,26,0,32},{11191,26,0,32},{10975,25,0,
32},{11191,25,0,32},{10975,23,0,32},{11191,23,0,32},{10975,26,0,32},{11186,26,0,
32},{10975,25,0,32},{11186,25,0,32},{10975,23,0,32},{11186,23,0,32},{10975,26,0,
32},{11008,26,0,32},{10975,26,0,32},{11019,26,0,32},{10975,26,0,32},{11150,26,0,
32},{10975,26,0,32},{11186,26,0,32},{10975,26,0,32},{11187,26,0,32},{10981,26,0,
32},{11008,26,0,32},{10981,26,0,32},{11019,26,0,32},{10981,26,0,32},{11020,26,0,
32},{10981,26,0,32},{11150,26,0,32},{10981,26,0,32},{11186,26,0,32},{10981,26,0,
32},{11187,26,0,32},{10998,26,0,32},{11008,26,0,32},{10998,26,0,32},{11019,26,0,
32},{10998,26,0,32},{11020,26,0,32},{10998,26,0,32},{11150,26,0,32},{10998,26,0,
32},{11186,26,0,32},{10998,26,0,32},{11187,26,0,32},{10999,26,0,32},{11008,26,0,
32},{10999,26,0,32},{11150,26,0,32},{10999,26,0,32},{11186,26,0,32},{10999,26,0,
32},{11187,26,0,32},{11008,26,0,32},{11019,26,0,32},{11008,26,0,32},{11150,26,0,
32},{11019,26,0,32},{11008,26,0,32},{11019,26,0,32},{11150,26,0,32},{11020,26,0,
32},{11008,26,0,32},{11020,26,0,32},{11019,26,0,32},{11020,26,0,32},{11150,26,0,
32},{11065,26,0,32},{11008,26,0,32},{11065,26,0,32},{11019,26,0,32},{11065,26,0,
32},{11020,26,0,32},{11065,26,0,32},{11150,26,0,32},{11076,26,0,32},{11019,26,0,
32},{11076,26,0,32},{11150,26,0,32},{11077,26,0,32},{11008,26,0,32},{11077,26,0,
32},{11019,26,0,32},{11077,26,0,32},{11020,26,0,32},{11077,26,0,32},{11150,26,0,
32},{11082,26,0,32},{11019,26,0,32},{11082,26,0,32},{11150,26,0,32},{11083,26,0,
32},{11150,26,0,32},{11089,26,0,32},{11008,26,0,32},{11089,26,0,32},{11150,26,0,
32},{11090,26,0,32},{11008,26,0,32},{11090,26,0,32},{11150,26,0,32},{11098,26,0,
32},{11008,26,0,32},{11098,26,0,32},{11019,26,0,32},{11098,26,0,32},{11020,26,0,
32},{11098,26,0,32},{11150,26,0,32},{11098,26,0,32},{11186,26,0,32},{11098,26,0,
32},{11187,26,0,32},{11110,26,0,32},{11019,26,0,32},{11110,26,0,32},{11150,26,0,
32},{11110,26,0,32},{11186,26,0,32},{11110,26,0,32},{11187,26,0,32},{11117,26,0,
32},{10979,26,0,32},{11117,26,0,32},{11008,26,0,32},{11117,26,0,32},{11019,26,0,
32},{11117,26,0,32},{11020,26,0,32},{11117,26,0,32},{11142,26,0,32},{11117,26,0,
32},{11150,26,0,32},{11117,26,0,32},{11186,26,0,32},{11117,26,0,32},{11187,26,0,
32},{11142,26,0,32},{11008,26,0,32},{11142,26,0,32},{11019,26,0,32},{11142,26,0,
32},{11020,26,0,32},{11142,26,0,32},{11150,26,0,32},{11142,26,0,32},{11186,26,0,
32},{11142,26,0,32},{11187,26,0,32},{11150,26,0,32},{11008,26,0,32},{11150,26,0,
32},{11019,26,0,32},{11150,26,0,32},{11020,26,0,32},{11150,26,0,32},{11150,26,0,
32},{11150,26,0,32},{11186,26,0,32},{11150,26,0,32},{11187,26,0,32},{11154,26,0,
32},{11008,26,0,32},{11154,26,0,32},{11019,26,0,32},{11154,26,0,32},{11020,26,0,
32},{11154,26,0,32},{11150,26,0,32},{11154,26,0,32},{11186,26,0,32},{11154,26,0,
32},{11187,26,0,32},{11166,26,0,32},{11008,26,0,32},{11166,26,0,32},{11150,26,0,
32},{11166,26,0,32},{11186,26,0,32},{11166,26,0,32},{11187,26,0,32},{11187,26,0,
32},{11008,26,0,32},{11187,26,0,32},{11019,26,0,32},{11187,26,0,32},{11020,26,0,
32},{11187,26,0,32},{11150,26,0,32},{11187,26,0,32},{11186,26,0,32},{11187,26,0,
32},{11187,26,0,32},{11031,26,0,32},{0,26,0,152},{11046,26,0,32},{0,26,0,152},
{11186,26,0,32},{0,26,0,152},{0,26,0,112},{0,26,0,128},{0,26,0,115},{0,26,0,
128},{0,26,0,118},{0,26,0,128},{0,26,0,122},{0,26,0,128},{0,26,0,125},{0,26,0,
128},{0,26,0,128},{0,26,0,152},{10975,25,0,32},{11046,25,0,32},{10975,25,0,32},
{11047,25,0,32},{10975,25,0,32},{11150,25,0,32},{10975,25,0,32},{11154,25,0,32},
{10975,25,0,32},{11186,25,0,32},{10975,25,0,32},{11187,25,0,32},{10981,25,0,32},
{11046,25,0,32},{10981,25,0,32},{11047,25,0,32},{10981,25,0,32},{11150,25,0,32},
{10981,25,0,32},{11154,25,0,32},{10981,25,0,32},{11186,25,0,32},{10981,25,0,32},
{11187,25,0,32},{10998,25,0,32},{11046,25,0,32},{10998,25,0,32},{11047,25,0,32},
{10998,25,0,32},{11150,25,0,32},{10998,25,0,32},{11154,25,0,32},{10998,25,0,32},
{11186,25,0,32},{10998,25,0,32},{11187,25,0,32},{10999,25,0,32},{11046,25,0,32},
{10999,25,0,32},{11047,25,0,32},{10999,25,0,32},{11150,25,0,32},{10999,25,0,32},
{11154,25,0,32},{10999,25,0,32},{11186,25,0,32},{10999,25,0,32},{11187,25,0,32},
{11098,25,0,32},{11186,25,0,32},{11098,25,0,32},{11187,25,0,32},{11110,25,0,32},
{11186,25,0,32},{11110,25,0,32},{11187,25,0,32},{11117,25,0,32},{10979,25,0,32},
{11117,25,0,32},{11142,25,0,32},{11117,25,0,32},{11150,25,0,32},{11117,25,0,32},
{11186,25,0,32},{11117,25,0,32},{11187,25,0,32},{11142,25,0,32},{11150,25,0,32},
{11142,25,0,32},{11186,25,0,32},{11142,25,0,32},{11187,25,0,32},{11150,25,0,32},
{10979,25,0,32},{11150,25,0,32},{11150,25,0,32},{11154,25,0,32},{11046,25,0,32},
{11154,25,0,32},{11047,25,0,32},{11154,25,0,32},{11150,25,0,32},{11154,25,0,32},
{11154,25,0,32},{11154,25,0,32},{11186,25,0,32},{11154,25,0,32},{11187,25,0,32},
{11186,25,0,32},{0,25,0,152},{11187,25,0,32},{11046,25,0,32},{11187,25,0,32},
{11047,25,0,32},{11187,25,0,32},{11150,25,0,32},{11187,25,0,32},{11154,25,0,32},
{11187,25,0,32},{11186,25,0,32},{11187,25,0,32},{11187,25,0,32},{10975,23,0,32},
{11008,23,0,32},{10975,23,0,32},{11019,23,0,32},{10975,23,0,32},{11020,23,0,32},
{10975,23,0,32},{11150,23,0,32},{10975,23,0,32},{11166,23,0,32},{10981,23,0,32},
{11008,23,0,32},{10981,23,0,32},{11019,23,0,32},{10981,23,0,32},{11020,23,0,32},
{10981,23,0,32},{11150,23,0,32},{10981,23,0,32},{11166,23,0,32},{10998,23,0,32},
{11008,23,0,32},{10998,23,0,32},{11019,23,0,32},{10998,23,0,32},{11020,23,0,32},
{10998,23,0,32},{11150,23,0,32},{10998,23,0,32},{11166,23,0,32},{10999,23,0,32},
{11150,23,0,32},{11008,23,0,32},{11019,23,0,32},{11008,23,0,32},{11150,23,0,32},
{11019,23,0,32},{11008,23,0,32},{11019,23,0,32},{11150,23,0,32},{11020,23,0,32},
{11008,23,0,32},{11020,23,0,32},{11150,23,0,32},{11065,23,0,32},{11008,23,0,32},
{11065,23,0,32},{11019,23,0,32},{11065,23,0,32},{11020,23,0,32},{11065,23,0,32},
{11150,23,0,32},{11076,23,0,32},{11019,23,0,32},{11076,23,0,32},{11020,23,0,32},
{11076,23,0,32},{11150,23,0,32},{11077,23,0,32},{11008,23,0,32},{11077,23,0,32},
{11019,23,0,32},{11077,23,0,32},{11020,23,0,32},{11077,23,0,32},{11150,23,0,32},
{11082,23,0,32},{11019,23,0,32},{11083,23,0,32},{11150,23,0,32},{11089,23,0,32},
{11008,23,0,32},{11089,23,0,32},{11150,23,0,32},{11090,23,0,32},{11008,23,0,32},
{11090,23,0,32},{11150,23,0,32},{11098,23,0,32},{11008,23,0,32},{11098,23,0,32},
{11019,23,0,32},{11098,23,0,32},{11020,23,0,32},{11098,23,0,32},{11150,23,0,32},
{11110,23,0,32},{11019,23,0,32},{11110,23,0,32},{11150,23,0,32},{11117,23,0,32},
{11008,23,0,32},{11117,23,0,32},{11019,23,0,32},{11117,23,0,32},{11020,23,0,32},
{11117,23,0,32},{11142,23,0,32},{11117,23,0,32},{11150,23,0,32},{11142,23,0,32},
{11008,23,0,32},{11142,23,0,32},{11019,23,0,32},{11142,23,0,32},{11020,23,0,32},
{11142,23,0,32},{11150,23,0,32},{11142,23,0,32},{11166,23,0,32},{11150,23,0,32},
{11008,23,0,32},{11150,23,0,32},{11019,23,0,32},{11150,23,0,32},{11020,23,0,32},
{11150,23,0,32},{11150,23,0,32},{11154,23,0,32},{11008,23,0,32},{11154,23,0,32},
{11019,23,0,32},{11154,23,0,32},{11020,23,0,32},{11154,23,0,32},{11150,23,0,32},
{11154,23,0,32},{11166,23,0,32},{11166,23,0,32},{11008,23,0,32},{11166,23,0,32},
{11150,23,0,32},{11166,23,0,32},{0,23,0,152},{11187,23,0,32},{11008,23,0,32},
{11187,23,0,32},{11019,23,0,32},{11187,23,0,32},{11020,23,0,32},{11187,23,0,32},
{11150,23,0,32},{11187,23,0,32},{11166,23,0,32},{10975,24,0,32},{11150,24,0,32},
{10975,24,0,32},{11166,24,0,32},{10981,24,0,32},{11150,24,0,32},{10981,24,0,32},
{11166,24,0,32},{10998,24,0,32},{11150,24,0,32},{10998,24,0,32},{11166,24,0,32},
{10999,24,0,32},{11150,24,0,32},{10999,24,0,32},{11166,24,0,32},{11065,24,0,32},
{11150,24,0,32},{11065,24,0,32},{11166,24,0,32},{11066,24,0,32},{11150,24,0,32},
{11066,24,0,32},{11166,24,0,32},{11117,24,0,32},{11142,24,0,32},{11117,24,0,32},
{11150,24,0,32},{11142,24,0,32},{11150,24,0,32},{11154,24,0,32},{11150,24,0,32},
{11154,24,0,32},{11166,24,0,32},{11187,24,0,32},{11150,24,0,32},{11187,24,0,32},
{11166,24,0,32},{0,24,0,118},{0,24,0,128},{0,24,0,122},{0,24,0,128},{0,24,0,
125},{0,24,0,128},{11082,26,0,32},{11186,26,0,32},{11082,26,0,32},{11187,26,0,
32},{11089,26,0,32},{11186,26,0,32},{11089,26,0,32},{11187,26,0,32},{11090,26,0,
32},{11186,26,0,32},{11090,26,0,32},{11187,26,0,32},{11065,26,0,32},{11186,26,0,
32},{11065,26,0,32},{11187,26,0,32},{11066,26,0,32},{11186,26,0,32},{11066,26,0,
32},{11187,26,0,32},{11019,26,0,32},{11186,26,0,32},{11019,26,0,32},{11187,26,0,
32},{11008,26,0,32},{11186,26,0,32},{11008,26,0,32},{11187,26,0,32},{11020,26,0,
32},{11186,26,0,32},{11020,26,0,32},{11187,26,0,32},{11076,26,0,32},{11186,26,0,
32},{11076,26,0,32},{11187,26,0,32},{11077,26,0,32},{11186,26,0,32},{11077,26,0,
32},{11187,26,0,32},{11066,26,0,32},{11008,26,0,32},{11066,26,0,32},{11019,26,0,
32},{11066,26,0,32},{11020,26,0,32},{11066,26,0,32},{11150,26,0,32},{11066,26,0,
32},{11046,26,0,32},{11065,26,0,32},{11046,26,0,32},{11076,26,0,32},{11046,26,0,
32},{11077,26,0,32},{11046,26,0,32},{11082,25,0,32},{11186,25,0,32},{11082,25,0,
32},{11187,25,0,32},{11089,25,0,32},{11186,25,0,32},{11089,25,0,32},{11187,25,0,
32},{11090,25,0,32},{11186,25,0,32},{11090,25,0,32},{11187,25,0,32},{11065,25,0,
32},{11186,25,0,32},{11065,25,0,32},{11187,25,0,32},{11066,25,0,32},{11186,25,0,
32},{11066,25,0,32},{11187,25,0,32},{11019,25,0,32},{11186,25,0,32},{11019,25,0,
32},{11187,25,0,32},{11008,25,0,32},{11186,25,0,32},{11008,25,0,32},{11187,25,0,
32},{11020,25,0,32},{11186,25,0,32},{11020,25,0,32},{11187,25,0,32},{11076,25,0,
32},{11186,25,0,32},{11076,25,0,32},{11187,25,0,32},{11077,25,0,32},{11186,25,0,
32},{11077,25,0,32},{11187,25,0,32},{11066,25,0,32},{11008,25,0,32},{11066,25,0,
32},{11019,25,0,32},{11066,25,0,32},{11020,25,0,32},{11066,25,0,32},{11150,25,0,
32},{11066,25,0,32},{11046,25,0,32},{11065,25,0,32},{11046,25,0,32},{11076,25,0,
32},{11046,25,0,32},{11077,25,0,32},{11046,25,0,32},{11066,23,0,32},{11008,23,0,
32},{11066,23,0,32},{11019,23,0,32},{11066,23,0,32},{11020,23,0,32},{11066,23,0,
32},{11150,23,0,32},{11065,23,0,32},{11166,23,0,32},{11066,23,0,32},{11166,23,0,
32},{11082,23,0,32},{11150,23,0,32},{11065,24,0,32},{11008,24,0,32},{11065,24,0,
32},{11019,24,0,32},{11065,24,0,32},{11020,24,0,32},{11066,24,0,32},{11008,24,0,
32},{11066,24,0,32},{11019,24,0,32},{11066,24,0,32},{11020,24,0,32},{11082,24,0,
32},{11150,24,0,32},{11083,24,0,32},{11150,24,0,32},{10979,25,0,32},{0,25,0,
109},{10979,26,0,32},{0,26,0,109},{10998,23,0,32},{11008,23,0,32},{11150,23,0,
32},{10998,25,0,32},{11019,25,0,32},{11008,25,0,32},{10998,23,0,32},{11019,23,0,
32},{11008,23,0,32},{10998,23,0,32},{11019,23,0,32},{11150,23,0,32},{10998,23,0,
32},{11020,23,0,32},{11150,23,0,32},{10998,23,0,32},{11150,23,0,32},{11008,23,0,
32},{10998,23,0,32},{11150,23,0,32},{11019,23,0,32},{10998,23,0,32},{11150,23,0,
32},{11020,23,0,32},{11008,25,0,32},{11150,25,0,32},{11019,25,0,32},{11008,23,0,
32},{11150,23,0,32},{11019,23,0,32},{11019,25,0,32},{11150,25,0,32},{11187,25,0,
32},{11019,25,0,32},{11150,25,0,32},{11186,25,0,32},{11065,23,0,32},{11019,23,0,
32},{11008,23,0,32},{11065,23,0,32},{11008,23,0,32},{11019,23,0,32},{11065,25,0,
32},{11008,25,0,32},{11186,25,0,32},{11065,25,0,32},{11150,25,0,32},{11019,25,0,
32},{11065,23,0,32},{11150,23,0,32},{11019,23,0,32},{11065,23,0,32},{11150,23,0,
32},{11008,23,0,32},{11065,25,0,32},{11150,25,0,32},{11150,25,0,32},{11065,23,0,
32},{11150,23,0,32},{11150,23,0,32},{11076,25,0,32},{11019,25,0,32},{11019,25,0,
32},{11076,23,0,32},{11019,23,0,32},{11019,23,0,32},{11076,25,0,32},{11150,25,0,
32},{11150,25,0,32},{11066,25,0,32},{11019,25,0,32},{11150,25,0,32},{11066,23,0,
32},{11019,23,0,32},{11150,23,0,32},{11066,25,0,32},{11008,25,0,32},{11187,25,0,
32},{11066,25,0,32},{11150,25,0,32},{11020,25,0,32},{11066,23,0,32},{11150,23,0,
32},{11020,23,0,32},{11066,25,0,32},{11150,25,0,32},{11150,25,0,32},{11066,23,0,
32},{11150,23,0,32},{11150,23,0,32},{11077,25,0,32},{11019,25,0,32},{11186,25,0,
32},{11077,25,0,32},{11020,25,0,32},{11150,25,0,32},{11077,23,0,32},{11020,23,0,
32},{11150,23,0,32},{11082,25,0,32},{11150,25,0,32},{11019,25,0,32},{11082,23,0,
32},{11150,23,0,32},{11019,23,0,32},{11082,23,0,32},{11150,23,0,32},{11150,23,0,
32},{11082,25,0,32},{11150,25,0,32},{11187,25,0,32},{11089,25,0,32},{11008,25,0,
32},{11150,25,0,32},{11089,25,0,32},{11150,25,0,32},{11150,25,0,32},{11089,23,0,
32},{11150,23,0,32},{11150,23,0,32},{11089,25,0,32},{11150,25,0,32},{11186,25,0,
32},{11090,25,0,32},{11150,25,0,32},{11150,25,0,32},{11090,25,0,32},{11150,25,0,
32},{11187,25,0,32},{11090,25,0,32},{11150,25,0,32},{11186,25,0,32},{11098,25,0,
32},{11020,25,0,32},{11150,25,0,32},{11098,23,0,32},{11020,23,0,32},{11150,23,0,
32},{11110,25,0,32},{11150,25,0,32},{11019,25,0,32},{11110,25,0,32},{11150,25,0,
32},{11150,25,0,32},{11142,25,0,32},{11019,25,0,32},{11150,25,0,32},{11142,25,0,
32},{11019,25,0,32},{11187,25,0,32},{11142,25,0,32},{11019,25,0,32},{11186,25,0,
32},{11142,23,0,32},{11008,23,0,32},{11008,23,0,32},{11142,25,0,32},{11008,25,0,
32},{11008,25,0,32},{11142,25,0,32},{11020,25,0,32},{11150,25,0,32},{11142,23,0,
32},{11020,23,0,32},{11150,23,0,32},{11142,25,0,32},{11150,25,0,32},{11019,25,0,
32},{11142,23,0,32},{11150,23,0,32},{11019,23,0,32},{11150,23,0,32},{11019,23,0,
32},{11008,23,0,32},{11150,23,0,32},{11019,23,0,32},{11150,23,0,32},{11150,25,0,
32},{11019,25,0,32},{11187,25,0,32},{11150,23,0,32},{11008,23,0,32},{11019,23,0,
32},{11150,23,0,32},{11008,23,0,32},{11150,23,0,32},{11150,23,0,32},{11020,23,0,
32},{11008,23,0,32},{11150,23,0,32},{11020,23,0,32},{11150,23,0,32},{11150,23,0,
32},{11008,23,0,32},{11020,23,0,32},{11166,23,0,32},{11150,23,0,32},{11008,23,0,
32},{11166,23,0,32},{11150,23,0,32},{11150,23,0,32},{11154,23,0,32},{11019,23,0,
32},{11150,23,0,32},{11154,25,0,32},{11019,25,0,32},{11186,25,0,32},{11154,25,0,
32},{11008,25,0,32},{11150,25,0,32},{11154,23,0,32},{11008,23,0,32},{11150,23,0,
32},{11154,25,0,32},{11008,25,0,32},{11186,25,0,32},{11154,25,0,32},{11150,25,0,
32},{11187,25,0,32},{11154,25,0,32},{11150,25,0,32},{11186,25,0,32},{11187,25,0,
32},{11150,25,0,32},{11150,25,0,32},{11187,23,0,32},{11150,23,0,32},{11150,23,0,
32},{10981,25,0,32},{11020,25,0,32},{11187,25,0,32},{10998,25,0,32},{11008,25,0,
32},{11187,25,0,32},{10998,25,0,32},{11008,25,0,32},{11186,25,0,32},{10998,25,0,
32},{11020,25,0,32},{11187,25,0,32},{10998,25,0,32},{11020,25,0,32},{11186,25,0,
32},{10998,25,0,32},{11150,25,0,32},{11187,25,0,32},{10998,25,0,32},{11150,25,0,
32},{11186,25,0,32},{11008,25,0,32},{11150,25,0,32},{11187,25,0,32},{11008,25,0,
32},{11019,25,0,32},{11186,25,0,32},{11008,25,0,32},{11150,25,0,32},{11186,25,0,
32},{11065,25,0,32},{11020,25,0,32},{11186,25,0,32},{11076,25,0,32},{11019,25,0,
32},{11187,25,0,32},{11066,25,0,32},{11019,25,0,32},{11187,25,0,32},{11077,25,0,
32},{11019,25,0,32},{11187,25,0,32},{11142,25,0,32},{11008,25,0,32},{11187,25,0,
32},{11142,25,0,32},{11150,25,0,32},{11187,25,0,32},{11187,25,0,32},{11019,25,0,
32},{11187,25,0,32},{11187,25,0,32},{11008,25,0,32},{11187,25,0,32},{11187,25,0,
32},{11150,25,0,32},{11187,25,0,32},{11150,25,0,32},{11150,25,0,32},{11187,25,0,
32},{11110,25,0,32},{11150,25,0,32},{11187,25,0,32},{11154,25,0,32},{11019,25,0,
32},{11187,25,0,32},{11110,23,0,32},{11150,23,0,32},{11019,23,0,32},{11142,23,0,
32},{11019,23,0,32},{11150,23,0,32},{11089,25,0,32},{11150,25,0,32},{11187,25,0,
32},{11117,25,0,32},{11150,25,0,32},{11187,25,0,32},{11154,23,0,32},{11008,23,0,
32},{11019,23,0,32},{11150,25,0,32},{11020,25,0,32},{11187,25,0,32},{11142,23,0,
32},{11008,23,0,32},{11150,23,0,32},{11117,25,0,32},{11150,25,0,32},{11150,25,0,
32},{11142,25,0,32},{11008,25,0,32},{11150,25,0,32},{11154,25,0,32},{11008,25,0,
32},{11019,25,0,32},{11008,25,0,32},{11019,25,0,32},{11187,25,0,32},{11019,25,0,
32},{11008,25,0,32},{11187,25,0,32},{11150,25,0,32},{11008,25,0,32},{11187,25,0,
32},{11098,25,0,32},{11150,25,0,32},{11187,25,0,32},{10981,25,0,32},{11019,25,0,
32},{11187,25,0,32},{11117,23,0,32},{11150,23,0,32},{11150,23,0,32},{11089,23,0,
32},{11008,23,0,32},{11150,23,0,32},{11076,23,0,32},{11150,23,0,32},{11150,23,0,
32},{11065,25,0,32},{11020,25,0,32},{11187,25,0,32},{11154,25,0,32},{11008,25,0,
32},{11187,25,0,32},{11076,26,0,32},{11142,26,0,32},{11202,26,0,32},{11110,26,0,
32},{11142,26,0,32},{11202,26,0,32},{10979,26,0,32},{11142,26,0,32},{11142,26,0,
32},{11166,26,0,32},{10979,26,0,32},{11117,26,0,32},{10981,26,0,32},{11046,26,0,
32},{11150,26,0,32},{11019,26,0,32},{11150,26,0,32},{11030,26,0,32},{11076,26,0,
32},{11142,26,0,32},{11089,26,0,32},{11150,26,0,32},{11046,26,0,32},{11065,26,0,
32},{11172,26,0,32},{11142,26,0,32},{11089,26,0,32},{11142,26,0,32},{11187,26,0,
32},{11166,26,0,32},{11172,26,0,32},{11065,26,0,32},{11142,26,0,32},{11150,26,0,
32},{11076,26,0,32},{11142,26,0,32},{11186,26,0,32},{11076,26,0,32},{11142,26,0,
32},{11186,26,0,32},{521,26,1,32},{10979,26,0,32},{11142,26,0,32},{11142,26,0,
32},{11166,26,0,32},{521,26,1,32},{11089,26,0,32},{11142,26,0,32},{11187,26,0,
32},{11166,26,0,32},{521,26,1,32},{11172,26,0,32},{11065,26,0,32},{11142,26,0,
32},{11150,26,0,32},{11008,26,0,32},{11142,26,0,32},{521,26,1,32},{11008,26,0,
32},{11142,26,0,32},{10979,26,0,32},{11142,26,0,32},{11166,26,0,32},{11046,26,0,
32},{11188,26,0,32},{10979,26,0,32},{11142,26,0,32},{642,22,1,32},{642,22,1,32},
{642,22,1,32},{642,22,1,32},{642,22,1,32},{11142,26,0,32},{10966,26,0,32},
{11142,25,0,32},{10966,25,0,32},{11142,26,0,32},{10967,26,0,32},{11142,25,0,32},
{10967,25,0,32},{11142,26,0,32},{10971,26,0,32},{11142,25,0,32},{10971,25,0,32},
{11142,26,0,32},{10979,26,0,32},{11142,25,0,32},{10979,25,0,32},{9196,20,0,32},
{9196,20,0,32},{9196,20,0,32},{0,20,0,287},{9299,20,0,32},{9270,20,0,32},{9966,
20,0,32},{9270,20,0,32},{9981,20,0,32},{9270,20,0,32},{9985,20,0,32},{9270,20,0,
32},{9995,20,0,32},{9358,20,0,32},{9617,20,0,32},{9412,20,0,32},{0,20,0,57},
{9512,20,0,32},{9778,20,0,32},{9512,20,0,32},{9966,20,0,32},{9624,20,0,32},{0,
20,0,47},{9821,20,0,32},{9264,20,0,32},{9821,20,0,32},{9778,20,0,32},{9821,20,0,
32},{9787,20,0,32},{9821,20,0,32},{9800,20,0,32},{29025,4,0,32},{0,4,0,287},
{29026,4,0,32},{0,4,0,287},{29027,4,0,32},{0,4,0,287},{29028,4,0,32},{0,4,0,
287},{29029,4,0,32},{0,4,0,287},{29030,4,0,32},{0,4,0,287},{29031,4,0,32},{0,4,
0,287},{29031,4,0,32},{0,4,0,288},{29032,4,0,32},{0,4,0,287},{29033,4,0,32},{0,
4,0,287},{29034,4,0,32},{0,4,0,287},{29034,4,0,32},{0,4,0,288},{29035,4,0,32},
{0,4,0,287},{29035,4,0,32},{0,4,0,288},{29036,4,0,32},{0,4,0,287},{29036,4,0,
32},{0,4,0,288},{29037,4,0,32},{0,4,0,287},{29038,4,0,32},{0,4,0,287},{29039,4,
0,32},{0,4,0,287},{29040,4,0,32},{0,4,0,288},{29040,4,0,32},{0,4,0,289},{29041,
4,0,32},{0,4,0,287},{29042,4,0,32},{0,4,0,287},{29043,4,0,32},{0,4,0,287},
{29044,4,0,32},{0,4,0,287},{29044,4,0,32},{0,4,0,288},{29045,4,0,32},{0,4,0,
287},{29045,4,0,32},{0,4,0,288},{29046,4,0,32},{0,4,0,287},{29047,4,0,32},{0,4,
0,287},{29040,4,0,32},{0,4,0,287},{22608,4,0,32},{0,4,0,288},{22425,4,0,32},{0,
4,0,287},{16980,4,0,32},{0,4,0,287},{16982,4,0,32},{0,4,0,287},{16985,4,0,32},
{0,4,0,287},{16986,4,0,32},{0,4,0,287},{16987,4,0,32},{0,4,0,287},{16988,4,0,
32},{0,4,0,287},{16989,4,0,32},{0,4,0,287},{16990,4,0,32},{0,4,0,287},{16992,4,
0,32},{0,4,0,287},{16993,4,0,32},{0,4,0,287},{16994,4,0,32},{0,4,0,287},{16995,
4,0,32},{0,4,0,287},{16996,4,0,32},{0,4,0,287},{16997,4,0,32},{0,4,0,287},
{17002,4,0,32},{0,4,0,287},{17003,4,0,32},{0,4,0,287},{17004,4,0,32},{0,4,0,
287},{17005,4,0,32},{0,4,0,287},{17007,4,0,32},{0,4,0,287},{17011,4,0,32},{0,4,
0,287},{17012,4,0,32},{0,4,0,287},{17013,4,0,32},{0,4,0,287},{17014,4,0,32},{0,
4,0,287},{17015,4,0,32},{0,4,0,287},{17019,4,0,32},{0,4,0,287},{17020,4,0,32},
{0,4,0,287},{17021,4,0,32},{0,4,0,287},{17022,4,0,32},{0,4,0,287},{16939,10,0,
32},{0,4,0,287},{16947,10,0,32},{0,4,0,287},{16947,10,0,32},{0,4,0,288},{16952,
10,0,32},{0,4,0,287},{16962,10,0,32},{0,4,0,287},{16963,10,0,32},{0,4,0,287},
{16963,10,0,32},{0,4,0,288},{16966,10,0,32},{0,4,0,287},{16973,10,0,32},{0,4,0,
287},{16974,10,0,32},{0,4,0,287},{16939,4,0,32},{0,4,0,287},{16947,4,0,32},{0,4,
0,287},{16947,4,0,32},{0,4,0,288},{16952,4,0,32},{0,4,0,287},{16962,4,0,32},{0,
4,0,287},{16963,4,0,32},{0,4,0,287},{16963,4,0,32},{0,4,0,288},{16966,4,0,32},
{0,4,0,287},{16973,4,0,32},{0,4,0,287},{16974,4,0,32},{0,4,0,287},{11154,4,0,
32},{0,4,0,288},{22648,4,0,32},{0,4,0,288},{22650,4,0,32},{0,4,0,288},{22652,4,
0,32},{0,4,0,288},{22655,4,0,32},{0,4,0,288},{22650,4,0,32},{22653,4,0,32},
{22673,4,0,32},{0,4,0,288},{22585,4,0,32},{22588,4,0,32},{12791,2,0,32},{0,2,0,
195},{12792,2,0,32},{0,2,0,195},{12801,2,0,32},{0,2,0,195},{13364,4,0,32},{0,4,
0,287},{13364,4,0,32},{0,4,0,288},{13365,4,0,32},{0,4,0,287},{13366,4,0,32},{0,
4,0,287},{13412,4,0,32},{0,4,0,287},{13413,4,0,32},{0,4,0,287},{13716,4,0,32},
{0,4,0,287},{13732,4,0,32},{0,4,0,287},{13719,4,0,32},{0,4,0,287},{8679,4,0,32},
{0,4,0,287},{8680,4,0,32},{0,4,0,287},{8681,2,0,32},{0,2,0,287},{64320,4,0,32},
{53567,0,0,0},{64320,4,0,32},{53586,0,0,0},{5687,2,1,32},{0,0,0,0},{5688,2,1,
32},{0,0,0,0},{5688,2,1,32},{0,0,0,0},{0,0,0,0},{5688,2,1,32},{0,0,0,0},{0,0,0,
0},{5688,2,1,32},{0,0,0,0},{0,0,0,0},{5688,2,1,32},{0,0,0,0},{0,0,0,0},{5688,2,
1,32},{0,0,0,0},{0,0,0,0},{5740,2,1,32},{0,0,0,0},{5740,2,1,32},{0,0,0,0},{0,0,
0,0},{5740,2,1,32},{0,0,0,0},{0,0,0,0},{5741,2,1,32},{0,0,0,0},{5741,2,1,32},{0,
0,0,0},{0,0,0,0},{5741,2,1,32},{0,0,0,0},{0,0,0,0},{9358,4,0,32},{0,4,0,289},
{9617,4,0,32},{9270,4,0,32},{10004,4,0,32},{9821,4,0,32},{9805,4,0,32},{9270,4,
0,32},{10005,4,0,32},{9821,4,0,32},{9806,4,0,32},{10250,2,0,32},{0,2,0,288},
{8679,4,0,32},{0,4,0,287},{8680,4,0,32},{0,4,0,287},{8680,4,0,32},{0,4,0,287},
{8681,4,0,32},{0,4,0,287},{8682,4,0,32},{0,4,0,287},{8683,4,0,32},{0,4,0,287},
{8684,4,0,32},{0,4,0,287},{8685,4,0,32},{0,4,0,287},{8686,4,0,32},{0,4,0,287},
{8687,4,0,32},{0,4,0,287},{8678,4,0,32},{642,4,1,32},{8678,4,0,32},{549,4,1,32},
{8679,4,0,32},{549,4,1,32},{8680,4,0,32},{549,4,1,32},{8681,4,0,32},{549,4,1,
32},{8682,4,0,32},{549,4,1,32},{8683,4,0,32},{549,4,1,32},{8684,4,0,32},{549,4,
1,32},{8685,4,0,32},{549,4,1,32},{8686,4,0,32},{549,4,1,32},{8687,4,0,32},{549,
4,1,32},{830,4,1,32},{9196,10,0,32},{831,4,1,32},{830,4,1,32},{9222,10,0,32},
{831,4,1,32},{830,4,1,32},{9248,10,0,32},{831,4,1,32},{830,4,1,32},{9270,10,0,
32},{831,4,1,32},{830,4,1,32},{9299,10,0,32},{831,4,1,32},{830,4,1,32},{9358,10,
0,32},{831,4,1,32},{830,4,1,32},{9373,10,0,32},{831,4,1,32},{830,4,1,32},{9412,
10,0,32},{831,4,1,32},{830,4,1,32},{9439,10,0,32},{831,4,1,32},{830,4,1,32},
{9467,10,0,32},{831,4,1,32},{830,4,1,32},{9492,10,0,32},{831,4,1,32},{830,4,1,
32},{9512,10,0,32},{831,4,1,32},{830,4,1,32},{9570,10,0,32},{831,4,1,32},{830,4,
1,32},{9585,10,0,32},{831,4,1,32},{830,4,1,32},{9624,10,0,32},{831,4,1,32},{830,
4,1,32},{9672,10,0,32},{831,4,1,32},{830,4,1,32},{9693,10,0,32},{831,4,1,32},
{830,4,1,32},{9712,10,0,32},{831,4,1,32},{830,4,1,32},{9778,10,0,32},{831,4,1,
32},{830,4,1,32},{9821,10,0,32},{831,4,1,32},{830,4,1,32},{9856,10,0,32},{831,4,
1,32},{830,4,1,32},{9904,10,0,32},{831,4,1,32},{830,4,1,32},{9922,10,0,32},{831,
4,1,32},{830,4,1,32},{9932,10,0,32},{831,4,1,32},{830,4,1,32},{9944,10,0,32},
{831,4,1,32},{830,4,1,32},{9966,10,0,32},{831,4,1,32},{936,4,1,32},{9778,10,0,
32},{937,4,1,32},{9248,12,0,32},{9270,12,0,32},{9922,12,0,32},{9966,12,0,32},
{9412,29,0,32},{9904,29,0,32},{9570,29,0,32},{9904,29,0,32},{9778,29,0,32},
{9270,29,0,32},{9778,29,0,32},{9778,29,0,32},{9672,29,0,32},{9672,29,0,32},
{9904,29,0,32},{9922,29,0,32},{9248,29,0,32},{9570,20,0,32},{9248,20,0,32},
{9570,20,0,32},{9270,20,0,32},{9570,20,0,32},{9712,20,0,32},{9439,29,0,32},
{9248,29,0,32},{9672,29,0,32},{9196,29,0,32},{9778,29,0,32},{9196,29,0,32},
{9196,29,0,32},{9222,29,0,32},{9922,29,0,32},{9248,29,0,32},{9270,29,0,32},
{9467,29,0,32},{9248,29,0,32},{9512,29,0,32},{9248,29,0,32},{9624,29,0,32},
{9624,29,0,32},{9512,29,0,32},{9358,29,0,32},{9712,29,0,32},{9299,29,0,32},
{9299,29,0,32},{9439,29,0,32},{9270,29,0,32},{9585,29,0,32},{9299,29,0,32},
{9922,29,0,32},{9585,29,0,32},{9373,29,0,32},{9624,29,0,32},{9492,29,0,32},
{9778,29,0,32},{9624,29,0,32},{9778,29,0,32},{9856,29,0,32},{9672,29,0,32},{617,
28,1,32},{9904,29,0,32},{9778,29,0,32},{8681,28,0,32},{9270,29,0,32},{8680,28,0,
32},{9585,28,0,32},{9270,28,0,32},{521,28,1,32},{9778,29,0,32},{9248,28,0,32},
{9712,28,0,32},{8680,28,0,32},{9492,29,0,32},{8682,28,0,32},{9492,29,0,32},
{8686,28,0,32},{9492,29,0,32},{8683,28,0,32},{642,28,1,32},{8679,28,0,32},{8685,
28,0,32},{642,28,1,32},{8679,28,0,32},{8680,28,0,32},{8680,28,0,32},{642,28,1,
32},{8680,28,0,32},{8684,28,0,32},{8678,28,0,32},{9672,29,0,32},{8679,28,0,32},
{8680,28,0,32},{8678,28,0,32},{9672,29,0,32},{9412,29,0,32},{9248,28,0,32},
{9412,29,0,32},{9270,28,0,32},{9712,29,0,32},{9412,29,0,32},{9439,28,0,32},{521,
28,1,32},{9712,29,0,32},{9299,28,0,32},{9778,28,0,32},{9512,29,0,32},{9624,28,0,
32},{9778,28,0,32},{9778,28,0,32},{9512,28,0,32},{9299,28,0,32},{9778,28,0,32},
{9778,28,0,32},{9778,29,0,32},{9412,29,0,32},{9904,29,0,32},{9856,29,0,32},
{9412,29,0,32},{9270,29,0,32},{9904,29,0,32},{9624,29,0,32},{9270,29,0,32},
{18676,28,0,32},{18652,28,0,32},{18656,28,0,32},{18656,28,0,32},{64320,28,0,32},
{57931,0,0,0},{64320,28,0,32},{56151,0,0,0},{64320,28,0,32},{54220,0,0,0},
{18665,28,0,32},{0,28,0,55},{64320,28,0,32},{52876,0,0,0},{64320,28,0,32},
{55578,0,0,0},{64321,28,0,32},{35299,0,0,0},{64320,28,0,32},{55593,0,0,0},
{64320,28,0,32},{52900,0,0,0},{64320,28,0,32},{58912,0,0,0},{64320,28,0,32},
{61729,0,0,0},{64320,28,0,32},{58777,0,0,0},{64320,28,0,32},{53837,0,0,0},
{64320,28,0,32},{57228,0,0,0},{64320,28,0,32},{53645,0,0,0},{64320,28,0,32},
{58800,0,0,0},{64320,28,0,32},{53789,0,0,0},{64320,28,0,32},{64834,0,0,0},
{64320,28,0,32},{62751,0,0,0},{64321,28,0,32},{36009,0,0,0},{64320,28,0,32},
{55536,0,0,0},{64320,28,0,32},{54329,0,0,0},{64320,28,0,32},{61204,0,0,0},
{64320,28,0,32},{58005,0,0,0},{64320,28,0,32},{58197,0,0,0},{64320,28,0,32},
{52736,0,0,0},{64320,28,0,32},{52745,0,0,0},{64321,28,0,32},{36938,0,0,0},
{64320,28,0,32},{56806,0,0,0},{64320,28,0,32},{52781,0,0,0},{64320,28,0,32},
{54259,0,0,0},{64320,28,0,32},{58119,0,0,0},{64321,28,0,32},{36208,0,0,0},
{64320,28,0,32},{57939,0,0,0},{64320,28,0,32},{63873,0,0,0},{64320,28,0,32},
{64122,0,0,0},{64320,28,0,32},{54280,0,0,0},{64320,28,0,32},{61056,0,0,0},
{64320,28,0,32},{59145,0,0,0},{64320,28,0,32},{59144,0,0,0},{64320,28,0,32},
{62771,0,0,0},{64320,28,0,32},{53874,0,0,0},{64320,28,0,32},{54710,0,0,0},
{64321,28,0,32},{37197,0,0,0},{936,4,1,32},{64320,4,0,32},{59180,0,0,0},{937,4,
1,32},{936,4,1,32},{64320,4,0,32},{52745,0,0,0},{937,4,1,32},{936,4,1,32},
{64320,4,0,32},{52876,0,0,0},{937,4,1,32},{936,4,1,32},{64320,4,0,32},{56201,0,
0,0},{937,4,1,32},{936,4,1,32},{64320,4,0,32},{61625,0,0,0},{937,4,1,32},{936,4,
1,32},{64320,4,0,32},{57939,0,0,0},{937,4,1,32},{936,4,1,32},{64320,4,0,32},
{63191,0,0,0},{937,4,1,32},{936,4,1,32},{64320,4,0,32},{53981,0,0,0},{937,4,1,
32},{936,4,1,32},{64320,4,0,32},{58711,0,0,0},{937,4,1,32},{64320,6,0,32},
{57239,0,0,0},{64320,6,0,32},{54255,0,0,0},{64388,2,0,32},{33058,0,0,0},{64388,
2,0,32},{34076,0,0,0},{64388,2,0,32},{34085,0,0,0},{64388,2,0,32},{34123,0,0,0},
{64388,2,0,32},{34362,0,0,0},{64388,2,0,32},{34820,0,0,0},{64388,2,0,32},{35038,
0,0,0},{64388,2,0,32},{35372,0,0,0},{64388,2,0,32},{35683,0,0,0},{64388,2,0,32},
{38116,0,0,0},{64388,2,0,32},{38568,0,0,0},{64388,2,0,32},{38634,0,0,0},{64388,
2,0,32},{39368,0,0,0},{64388,2,0,32},{39704,0,0,0},{64388,2,0,32},{40203,0,0,0},
{64388,2,0,32},{40420,0,0,0},{64388,2,0,32},{40422,0,0,0},{64388,2,0,32},{41347,
0,0,0},{64388,2,0,32},{41375,0,0,0},{64388,2,0,32},{41777,0,0,0},{64388,2,0,32},
{42708,0,0,0},{64388,2,0,32},{43076,0,0,0},{64388,2,0,32},{43082,0,0,0},{64388,
2,0,32},{43788,0,0,0},{64388,2,0,32},{44017,0,0,0},{64388,2,0,32},{45066,0,0,0},
{64388,2,0,32},{45752,0,0,0},{64388,2,0,32},{45919,0,0,0},{64388,2,0,32},{45971,
0,0,0},{64388,2,0,32},{45980,0,0,0},{64388,2,0,32},{46019,0,0,0},{64388,2,0,32},
{46037,0,0,0},{64388,2,0,32},{46189,0,0,0},{64388,2,0,32},{46755,0,0,0},{64388,
2,0,32},{47271,0,0,0},{64388,2,0,32},{47757,0,0,0},{64388,2,0,32},{47866,0,0,0},
{64388,2,0,32},{48316,0,0,0},{64388,2,0,32},{48414,0,0,0},{64388,2,0,32},{48849,
0,0,0},{64388,2,0,32},{48990,0,0,0},{64388,2,0,32},{49038,0,0,0},{64388,2,0,32},
{49763,0,0,0},{64388,2,0,32},{49902,0,0,0},{64388,2,0,32},{50091,0,0,0},{64388,
2,0,32},{50696,0,0,0},{64388,2,0,32},{50997,0,0,0},{64388,2,0,32},{51220,0,0,0},
{64388,2,0,32},{52278,0,0,0},{64388,2,0,32},{52370,0,0,0},{64388,2,0,32},{53153,
0,0,0},{64388,2,0,32},{53176,0,0,0},{64388,2,0,32},{53316,0,0,0},{64388,2,0,32},
{53490,0,0,0},{64388,2,0,32},{53491,0,0,0},{64388,2,0,32},{53529,0,0,0},{64388,
2,0,32},{53555,0,0,0},{64388,2,0,32},{53833,0,0,0},{64388,2,0,32},{54301,0,0,0},
{64388,2,0,32},{54822,0,0,0},{64388,2,0,32},{54938,0,0,0},{64388,2,0,32},{54981,
0,0,0},{64388,2,0,32},{55676,0,0,0},{64388,2,0,32},{55975,0,0,0},{64388,2,0,32},
{56235,0,0,0},{64388,2,0,32},{56448,0,0,0},{64388,2,0,32},{56528,0,0,0},{64388,
2,0,32},{57222,0,0,0},{64388,2,0,32},{57818,0,0,0},{64388,2,0,32},{57896,0,0,0},
{64388,2,0,32},{57927,0,0,0},{64388,2,0,32},{58073,0,0,0},{64388,2,0,32},{58174,
0,0,0},{64388,2,0,32},{58586,0,0,0},{64388,2,0,32},{58659,0,0,0},{64388,2,0,32},
{58792,0,0,0},{64388,2,0,32},{59303,0,0,0},{64388,2,0,32},{59317,0,0,0},{64388,
2,0,32},{60220,0,0,0},{64388,2,0,32},{60470,0,0,0},{64388,2,0,32},{60629,0,0,0},
{64388,2,0,32},{60779,0,0,0},{64388,2,0,32},{61228,0,0,0},{64388,2,0,32},{61361,
0,0,0},{64388,2,0,32},{61650,0,0,0},{64388,2,0,32},{62410,0,0,0},{64388,2,0,32},
{63079,0,0,0},{64388,2,0,32},{63662,0,0,0},{64388,2,0,32},{63846,0,0,0},{64388,
2,0,32},{64680,0,0,0},{64388,2,0,32},{65235,0,0,0},{64388,2,0,32},{65327,0,0,0},
{64389,2,0,32},{34258,0,0,0},{64389,2,0,32},{34285,0,0,0},{64389,2,0,32},{34606,
0,0,0},{64389,2,0,32},{35834,0,0,0},{64389,2,0,32},{36215,0,0,0},{64389,2,0,32},
{37189,0,0,0},{64389,2,0,32},{37343,0,0,0},{64389,2,0,32},{37402,0,0,0},{64389,
2,0,32},{37898,0,0,0},{64389,2,0,32},{38038,0,0,0},{64389,2,0,32},{38326,0,0,0},
{64389,2,0,32},{39728,0,0,0},{64389,2,0,32},{41166,0,0,0},{64389,2,0,32},{41221,
0,0,0},{64389,2,0,32},{41486,0,0,0},{64389,2,0,32},{41617,0,0,0},{64389,2,0,32},
{41874,0,0,0},{64389,2,0,32},{42496,0,0,0}};
